//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 8 lights, 18 textures and 235 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 10/01/1996    (01.10.1996)
//



//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera StdCam
  location  <0.100, -110.619, 2.121>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
 up        <0.0,     0.0,  1.0>  // Where Z is up
 right     <1.3333,  0.0,  0.0>
  look_at   <0.000, -0.879, -9.664>
}

// *******  L I G H T S *******
light_source {   // Light004
  <0.000, -185.187, 255.257>
  color rgb <1.000, 1.000, 1.000>
}

/*light_source {   // Light003
  <-16.244, 4.296, -13.916>
  color rgb <1.000, 1.000, 1.000>
}*/

/*light_source {   // Light002
  <0.000, -23.721, -17.571>
  color rgb <1.000, 1.000, 1.000>
}*/

light_source {   // Light001
  <24.014, 50.234, -10.740> //<24.014, 20.234, -10.740> //
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <1.254, -59.272, 11.195>
  color rgb <1.000, 1.000, 1.000>
}




// ********  TEXTURES  *******
//
global_settings { assumed_gamma 2.2 }




#include "colors.inc"
#include "C:wbntex.inc"
#include "C:planet1.inc"
#include "C:star.inc"
#include "C:shoe.inc"
#include "C:cast1.inc"
#include "C:nebula.inc"
#include "C:Rain.inc"
#include "C:\achilds\cloud9.inc"

// ********  REFERENCED OBJECTS  *******
#declare DBHalo =  halo {  //Dragons breath halo
      emitting //attenuating//glowing  //emitting
      spherical_mapping
      linear
       turbulence 2.5 //2 //0.7 //1.5
       color_map {
         [0 color rgbt<1,1,0,1>]

           [1 color rgbt<1,.5,0,-1>]
   }
      samples 10
      scale 2
  }


// ********  OBJECTS  *******
//background

background { color Cyan } //SkyBlue


sky_sphere{

 pigment {
     gradient z

  color_map {
            [(1-cos(radians( 80)))/2 color NeonPink] //SpicyPink
           [(1-cos(radians(150)))/2 color Cyan]


  }
  scale 2
  translate -1

   }
}




#declare SeaScape = union{
#declare DragEar2 = difference {
  cone { // Cone7
    <0,0,0>, 0.0, <0,0,1>, 1.0

    texture {
      DragEyeColor //DragColor
    }
    scale <0.2, 0.3, 0.5>
    rotate 180.0*x
    translate  <-0.3, -1.5, 0.9>
  }
  cone { // Cone8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      DragEyeColor //DragColor
    }

    scale <0.2, 0.3, 0.5>
    rotate 180.0*x
    translate  <-0.3, -1.4, 0.85>
  }
  translate  0.6*x
}

#declare DragEar1 = difference {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      DragEyeColor //DragColor
    }
    scale <0.2, 0.3, 0.5>
    rotate 180.0*x
    translate  <-0.3, -1.5, 0.9>
  }
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      DragEyeColor //DragColor
    }
    scale <0.2, 0.3, 0.5>
    rotate 180.0*x
    translate  <-0.3, -1.4, 0.85>
  }
}

#declare DragNose = difference {
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      DragColor1
    }
    scale <0.2, 0.2, 0.3>
    translate  <-0.3, 1.1, 0.2>
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      DragColor1
    }
    scale <0.2, 0.2, 0.3>
    translate  <-0.3, 1.2, 0.2>
  }
}
#declare DragNose1 = difference {
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      DragColor1
    }
    scale <0.2, 0.2, 0.3>
    translate  <-0.3, 1.1, 0.2>
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      DragColor1
    }
    scale <0.2, 0.2, 0.3>
    translate  <-0.3, 1.2, 0.2>
  }
  translate  0.6*x
}
#declare TheDragHead = union {
  sphere { // DragMouth
    <0,0,0>,1
    scale <0.7, 1.7, 0.3>
  }
  sphere { // DragHd
    <0,0,0>,1
    scale <0.7, 1.1, 0.5>
    translate  <0.0, -1.0, 0.1>
  }
  object { DragEar2 }
  object { DragEar1 }
  object { DragNose }
  object { DragNose1 }
}
#declare DragThrost = difference {
  torus { // Torus4
    1.5, 0.5  rotate -x*90
    scale 0.9
    rotate <-90.0, 0.0, 90.0>
    translate  <0.0, -1.3, -1.0>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale 1.6
    translate  <0.0, 0.1, -1.3>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.1, -2.3, -2.0>
  }
}
#declare DragNeck = union {
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.45
    rotate -20.0*x
    translate  <0.0, -4.3, -5.6>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 4.9>
    rotate -20.0*x
    translate  <0.0, -4.3, -5.6>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.45
    translate  <0.0, -2.657, -1.0>
  }
  object { DragThrost }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.5, 1.5, 8.0>
    rotate 160.0*x
    translate  <0.0, -2.028803, 0.591734>
  }
}
#declare CSG001 = difference {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.527513, 0.527513>
    rotate 14.37652*x
    translate  <0.0, -2.599671, -0.098101>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    rotate -29.349667*x
    translate  <0.0, -1.618663, -0.833857>
  }
}
#declare CSG2 = difference {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.527513, 0.527513>
    rotate 14.37652*x
    translate  <0.0, -2.599671, -0.098101>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    rotate -29.349667*x
    translate  <0.0, -1.618663, -0.833857>
  }
  rotate 4.048514*x
  translate  <0.0, -0.612246, -0.937875>
}
#declare DragSpines = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.527513, 0.527513>
    rotate -28.151222*x
    translate  <0.0, -1.765814, 0.490504>
  }
  object { CSG001 }
  object { CSG2 }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.54, 0.54>
    rotate 12.042116*x
    translate  <0.0, -3.836996, -2.484846>
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.56, 0.56>
    rotate 12.042116*x
    translate  <0.0, -4.659255, -3.855276>
  }
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.58, 0.58>
    rotate 13.867803*x
    translate  <0.0, -5.481513, -5.225707>
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.58, 0.58>
    rotate 13.867803*x
    translate  <0.0, -6.320361, -6.51194>
  }
}
#declare DragFront1 = union {
  object { TheDragHead }
  object { DragNeck }
  object { DragSpines }
  scale 1.5
  rotate <-5.451102, -2.4234, 140.483673>
  translate  <-14.274045, -6.347729, -30.190961>
}
#declare DragBreath = sphere { // DBreath2
    <0,0,0>,3
    pigment { color rgbt <1, 1, 1,1>}
  halo {DBHalo}
    //scale 3
    translate <-10.9, -50.29, -15> //-20.9> //<-10.960261, 5.596476, -40.432514> //<-15.080426, -9.191462, -30.003294>
  }
#declare DragFront = union {
  object {DragFront1}
  object {DragBreath}
translate <-2.5,9,0>
  }
#declare BidMBody = difference {
  torus { // Torus33
    1.5, 0.5  rotate -x*90
    scale <1.8, 3.6, 2.4>
    rotate <0.0, -90.0, 0.0>
    translate  <0.0, -12.435349, -11.60244>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 9.659527, 3.359143>
    translate  <0.0, -12.887148, -14.032672>
  }
  translate  <0.0, 6.261453, 0.73091>
}
#declare BidMSpines = union {
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate -21.199686*x
    translate  <0.0, 0.367269, -10.090409>
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate 19.490042*x
    translate  <0.0, -1.275307, -8.330506>
  }
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate 36.384819*x
    translate  <0.0, -3.621844, -7.567882>
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate 45.99268*x
    translate  <0.0, -6.144371, -7.391892>
  }
  box { // Cube43
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate 56.192303*x
    translate  <0.0, -8.666898, -7.626545>
  }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate 72.997086*x
    translate  <0.0, -11.013435, -8.330506>
  }
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.9, 0.9>
    rotate 103.316734*x
    translate  <0.0, -12.813735, -10.002946>
  }
}
#declare DBigMidBody = union {
  object { BidMBody }
  object { BidMSpines }
  scale 1.35 //1.3
  rotate <0.0, 0.0, 147.99765>
  translate  <-8.453619, 11.629896, -24.968285> //<-5.453619, 6.629896, -24.968285>
}
#declare upptorus = difference {
  torus { // Torus3
    4.0, 0.5  rotate -x*90
    scale 0.9
    rotate <-90.0, 0.0, 90.0>
  }
  box { // Cube53
    <-1, -1, -1>, <1, 1, 1>
    scale 4.803958
    translate  <0.0, 2.165302, -4.8157>
  }
  rotate 15.0*z
  translate  <0.030304, 0.009232, 0.000994>
}
#declare lowTorus = difference {
  torus { // Torus35
    4.0, 0.5  rotate -x*90
    scale 0.9
    rotate <-90.0, 0.0, 90.0>
  }
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    scale 4.803958
    translate  <0.0, 0.139447, 4.807112>
  }
  rotate -15.0*z
  translate  <-1.836403, 0.021367, 0.02356>
}
#declare BigFluke = union {
  cylinder { // fluke2
    <0,0,1>, <0,0,0>, 1
    scale <0.817946, 1.44646, 0.03>
    rotate <90.0, 75.0, -90.0>
    translate  <0.0, -1.350781, -0.100058>
  }
  cylinder { // fluke
    <0,0,1>, <0,0,0>, 1
    scale <0.817946, 1.44646, 0.03>
    rotate <-90.0, 75.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  rotate 11.63581*x
  translate  <-2.6969, -4.930717, 6.694295>
}
#declare DragFluke = difference {
  object { BigFluke }
  box { // Cube55
    <-1, -1, -1>, <1, 1, 1>
    scale 1.347327
    rotate <56.451591, 0.0, 0.0>
    translate  <-2.256256, -5.727561, 7.53607>
  }
}
#declare TailSpines = union {
  box { // Cube56
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.54, 0.527513>
    rotate <-9.118491, 8.60432, 0.272771>
    translate  <0.0, -21.437776, -10.894522>
  }
  box { // Cube57
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.54, 0.54>
    rotate <-9.335746, 4.35428, 0.261934>
    translate  <0.118033, -22.210377, -9.888712>
  }
  box { // Cube86
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.52, 0.52>
    rotate <-9.335746, 4.35428, 0.261934>
    translate  <0.196722, -22.982978, -8.755565>
  }
  box { // Cube87
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.48, 0.48>
    rotate <-9.335746, 4.35428, 0.261934>
    translate  <0.275411, -23.704072, -7.776937>
  }
  box { // Cube88
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.44, 0.44>
    rotate <-9.335746, 4.35428, 0.261934>
    translate  <0.432788, -24.476673, -6.813329>
  }
  box { // Cube89
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.4>
    rotate <-9.335746, 4.35428, 0.261934>
    translate  <0.590166, -25.197767, -5.768175>
  }
  scale 2.0
  rotate 0.0*y
  translate  <-1.232975, 52.560958, 1.225798>
}
#declare DragonTail = union {
  object { upptorus }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 1.5>
    rotate <153.35672, -12.235515, 170.408066>
    translate  <0.833478, -2.991979, -1.797513>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 20.0>
    rotate <153.35672, -12.235515, 170.408066>
    translate  <0.664796, -2.310474, -3.113155>
  }
  sphere { // Sphere15
    <0,0,0>,1
    scale 0.45
    translate  <0.666774, -2.320205, -3.063812>
  }
  object { lowTorus }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 1.5>
    rotate <17.742664, 0.0, 0.0>
    translate  <-2.747949, -3.449387, -0.047574>
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale 0.45
    translate  <-2.766609, -3.462829, 0.028317>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 4.0>
    rotate <17.742664, 0.0, 0.0>
    translate  <-2.747949, -3.903869, 1.383004>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <0.45, 0.45, 4.0>
    rotate <17.742664, 0.0, 0.0>
    translate  <-2.747949, -3.903869, 1.383004>
  }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.45, 0.45, 2.0>
    rotate <-161.360291, 0.580678, 1.011688>
    translate  <-2.717506, -5.755912, 7.078324>
  }
  object { DragFluke }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.4, 2.4, 16.0>
    rotate <-149.945129, 6.171109, 7.345155>
    translate  <0.556745, 0.186008, -7.925938>
  }
  object { TailSpines }
  texture {
    DragColor
  }
  scale 0.5
  rotate <0.0, 0.0, 79.083176>
  translate <8.384803, 29.969869, -29.004719> //<10.384803, 30.969869, -28.004719>
}
union { // TheDragon
  object { DragFront }
  object { DBigMidBody }
  object { DragonTail }

/*sphere { // DBreath2
    <0,0,0>,3
    pigment { color rgbt <1, 1, 1,1>}
  halo {DBHalo}
    //scale 3
    translate <-10.9, -50.29, -15> //-20.9> //<-10.960261, 5.596476, -40.432514> //<-15.080426, -9.191462, -30.003294>
  }*/
  texture {
    DragColor
  }
hollow
}


box { // silverSea
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SeaColor
  }
  scale <200.0, 100.0, 0.1>
  translate  <-1.171404, -67.976988, -38.322209>
hollow
}


#declare StationClear = difference {
  sphere { // Sphere7
    <0,0,0>,1
    scale <1.011714, 1.0, 0.367442>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05857, 1.046856, 0.613437>
    translate  -0.60913*z
  }
  texture {
  DomeColor  //  StationColor //
  }
no_shadow
}
#declare StationBottom = difference {
  sphere { // Sphere8
    <0,0,0>,1
    scale <1.011714, 1.0, 0.367442>
  }
  box { // Cube51
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05857, 1.046856, 0.613437>
    translate  0.60913*z
  }
  texture {
    StationColor
  }
no_shadow
}
#declare StationStand = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.13, 0.13, 5.0>
    translate  -5.344742*z
  }
  torus { // Torus003
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -4.5*z
  }
  torus { // Torus34
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -4.0*z
  }
  torus { // Torus36
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -3.5*z
  }
  torus { // Torus37
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -3.0*z
  }
  torus { // Torus38
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -2.5*z
  }
  torus { // Torus39
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -2.0*z
  }
  torus { // Torus40
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -1.5*z
  }
  torus { // Torus41
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -1.0*z
  }
  torus { // Torus42
    1.85, 0.15  rotate -x*90
    texture {
      shoecolor
    }
    scale <0.317575, 0.283046, 0.234247>
    translate  -0.5*z
  }
  texture {
    StationColor
  }
  scale 0.4
}
union { // Station
  torus { // Torus001
    1.9, 0.1  rotate -x*90
    texture {
      StationColor
    }
no_shadow
    scale 0.563444
  }
  object { StationClear }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      StationColor
    }
    scale <0.1, 0.105438, 0.416632>
    rotate 180.0*x
    translate  0.279381*z
  }
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BldgColor
    }
    scale <0.087354, 0.031478, 0.14323>
    translate  <0.151669, -0.073577, 0.009313>
  }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    texture {
      StationColor
    }
    scale <0.276136, 0.031478, 0.09132>
    rotate <0.0, -18.101303, 0.0>
    translate  <-0.248778, -0.073577, 0.018625>
  }
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BldgColor
    }
    scale <0.087354, 0.031478, 0.14323>
    translate  <-0.442781, -0.196207, 0.074502>
  }
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DragColor//BldgColor
    }
    scale <0.087354, 0.031478, 0.14323>
    rotate -24.876431*z
    translate  <0.421738, -0.343646, 0.121065>
  }
  object { StationBottom }
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      StationColor
    }
    scale 0.068729
    translate  <0.710307, 0.116834, 0.186254>
  }
  cone { // Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      StationColor
    }
    scale <0.059416, 0.10598, 0.124605>
    rotate 180.0*x
    translate  <-0.745017, 0.0, 0.130378>
  }
  //object { StationStand }
  scale 13//12.0
translate <-2,120,-25.0>//<-30.090754, 25.89273, -2.957355> //<-28.090754, 25.89273, -13.957355> <-30.090754, 25.89273, -13.957355>
hollow}


object {   // HgtFld001
  height_field {
    tga "C:TR2.TGA"
    water_level 0.6
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    RockColor
  }
hollow
  scale 50.0
  translate  <-16.551344, 7.442821, -60.0>
}
object {   // HgtFld002
  height_field {
    tga "C:TR1.TGA"
    water_level 0.555
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    RockColor2
  }
hollow
  scale 30.0
  translate  <-24.348481, 49.279239, -50> //<-24.348481, 51.279239, -50>
 }
translate <0,0,-1.2>
}

SeaScape
