#declare ShoeColor3 = texture {
   pigment {
     color rgb<0.303, 0.214, 0.052>
   }
   finish {
     diffuse 0.370
     ambient 0.000
     phong_size 1.000
     specular 0.400
     roughness 0.0480
     brilliance 0.430
     metallic
   }

}

#declare CrowsNest = union {
  cylinder { // CrowPlat
    <0,0,1>, <0,0,0>, 1
    scale <0.95, 0.95, 0.1>
  }
  torus { // CrowRail
    1.8, 0.2  rotate -x*90
    scale 0.5
    translate  <0.0, -0.008786, 0.966408>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    translate  <-0.847378, -0.021342, 0.031798>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate -45.0*z
    translate  <-0.614278, 0.584096, 0.031798>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate -90.0*z
    translate  <-0.021342, 0.847378, 0.031798>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate -135.0*z
    translate  <0.584096, 0.614278, 0.031798>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate 180.0*z
    translate  <0.847378, 0.021342, 0.031798>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate 135.0*z
    translate  <0.614278, -0.584096, 0.031798>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate 90.0*z
    translate  <0.021342, -0.847378, 0.031798>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.923926>
    rotate 45.0*z
    translate  <-0.584096, -0.614278, 0.031798>
  }
  texture {
    MastColor1
  }
  rotate <0.0, 0.0, -179.739746>
  translate  <-1.245269, 0.572354, 6.238104>
}
#declare TheMast = union {
  cone { // Mast
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      MastColor1
    }
    scale <0.265254, 0.234967, 17.0>
    rotate <180.0, 0.0, 90.260246>
    translate  <-1.309539, 0.542023, 10.161837>
  }
  object { CrowsNest }
  rotate <0.0, 0.0, -90.260254>
  translate  <-0.622613, 1.914493, 2.967767>
}
#declare ShipWheel = union {
  sphere { // Sphere6
    <0,0,0>,1
    texture {
    RopeColor
    }
    scale 0.245889
  }
  sphere { // Sphere16
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate 45.0*x
    translate  <0.0, -1.498142, 1.498142>
  }
  sphere { // Sphere17
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate 90.0*x
    translate  <0.0, -2.118693, 0.0>
  }
  sphere { // Sphere18
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate 135.0*x
    translate  <0.0, -1.498142, -1.498142>
  }
  sphere { // Sphere19
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate 180.0*x
    translate  <0.0, 0.0, -2.118693>
  }
  sphere { // Sphere20
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate -135.0*x
    translate  <0.0, 1.498142, -1.498142>
  }
  sphere { // Sphere21
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate -90.0*x
    translate  <0.0, 2.118693, 0.0>
  }
  sphere { // Sphere22
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    rotate -45.0*x
    translate  <0.0, 1.498142, 1.498142>
  }
  sphere { // Sphere23
    <0,0,0>,1
    texture {
      RopeColor
    }
    scale <0.162573, 0.136346, 0.240646>
    translate  2.118693*z
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate 45.0*x
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate 90.0*x
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate 135.0*x
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate 180.0*x
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate -135.0*x
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate -90.0*x
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
    rotate -45.0*x
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.8>
  }
  torus { // Torus5
    1.85, 0.15  rotate -x*90
    rotate <-90.0, 0.0, -90.0>
  }
  texture {
    MastColor1
  }
  scale 0.8
  rotate <0.0, 0.0, -90.0>
  translate  <0.01359, -2.701302, -0.221075>
}
#declare baseShoe = union {
  sphere { // shoeToe
    <0,0,0>,1
    translate  2.0*y
  }
  cylinder { // shoemiddle
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 4.0>
    rotate 90.0*x
    translate  2.0*y
  }
  sphere { // shoeHeel
    <0,0,0>,1
    translate  -2.0*y
  }
  scale <1.0, 1.0, 1.5>
}
#declare theShoe = difference {
  object { baseShoe }
  cylinder { // ArchMaker
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 2.3>
    rotate <90.0, 0.0, -90.0>
    translate  <1.1, -0.6, -1.8>
  }
  cylinder { // shoeopen
    <0,0,1>, <0,0,0>, 1
    scale <1.8, 1.2, 3.1>
    rotate <90.0, 0.0, -90.0>
    translate  <1.3, -2.9, 0.9>
  }
  box { // shoeToeSole1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.8, 2.8>
    rotate -30.0*x
    translate  <0.0, 2.5, -1.0>
  }
  cylinder { // shoeToeShape
    <0,0,1>, <0,0,0>, 1
    scale <2.2, 1.6, 3.5>
    rotate <-90.0, 40.0, 90.0>
    translate  <1.6, 0.3, 2.1>
  }
  cylinder { // shofooopen3
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 1.3, 0.64>
    rotate 90.0*x
    translate  <-0.02, -1.28, 0.0>
  }
  sphere { // shoefootopen2
    <0,0,0>,1
    scale <0.8, 0.8, 1.3>
    translate  <-0.1, -2.0, 0.0>
  }
  cone { // shoefootopen1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      ShoeColor3 //shoecolor
    }
    scale <0.819556, 1.2, 0.930734>
    rotate 90.0*x
    translate  <0.0, -0.4, 0.1>
  }
  texture {
    shoecolor
  }
  scale 2.0
  rotate 0.0*z
  translate  <0.0, 0.050931, -3.106805>
}
#declare CSG002 = difference {
  torus { // Torus002
    0.6, 0.1  rotate -x*90
    scale 0.8
    rotate -90.0*y
    translate  <0.092176, 0.0, -0.030496>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.58579, 2.617043, -3.63843>
}
#declare CSG3 = difference {
  torus { // Torus6
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.499363, 1.616554, -3.668926>
}
#declare CSG4 = difference {
  torus { // Torus7
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.412936, 1.740256, -3.010241>
}
#declare CSG5 = difference {
  torus { // Torus8
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.437629, 2.653416, -2.982767>
}
#declare CSG6 = difference {
  torus { // Torus9
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.363549, 2.702597, -2.366805>
}
#declare CSG7 = difference {
  torus { // Torus10
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.65, 0.790049, 0.436592>
  translate  <-1.351202, 1.836704, -2.348931>
}
#declare CSG8 = difference {
  torus { // Torus11
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.65, 0.790049, 0.436592>
  translate  <-1.289469, 2.690786, -1.766091>
}
#declare CSG9 = difference {
  torus { // Torus12
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.6, 0.790049, 0.436592>
  translate  <-1.264775, 1.883023, -1.717185>
}
#declare CSG10 = difference {
  torus { // Torus13
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.6, 0.790049, 0.436592>
  translate  <-1.190695, 2.711618, -1.086364>
}
#declare CSG11 = difference {
  torus { // Torus14
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.55, 0.790049, 0.436592>
  translate  <-1.166002, 2.009525, -1.074322>
}
#declare CSG12 = difference {
  torus { // Torus15
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.55, 0.790049, 0.436592>
  translate  <-1.091921, 2.763457, -0.349943>
}
#declare CSG13 = difference {
  torus { // Torus16
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.5, 0.790049, 0.436592>
  translate  <-1.005494, 2.79834, 0.285958>
}
#declare CSG14 = difference {
  torus { // Torus17
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.5, 0.790049, 0.436592>
  translate  <-1.104268, 2.108305, -0.300281>
}
#declare CSG15 = difference {
  torus { // Torus18
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.4, 0.790049, 0.436592>
  translate  <-1.005494, 2.233319, 0.354056>
}
#declare CSG16 = difference {
  torus { // Torus19
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.35, 0.691293, 0.382018>
  translate  <-0.993148, 2.831511, 1.071554>
}
#declare CSG17 = difference {
  torus { // Torus20
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.35, 0.691293, 0.382018>
  translate  <-0.943761, 2.280384, 1.118524>
}
#declare CSG18 = difference {
  torus { // Torus21
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.3, 0.592537, 0.327444>
  translate  <-0.931414, 2.852345, 1.790252>
}
#declare CSG19 = difference {
  torus { // Torus22
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.395024, 0.218296>
  translate  <-0.807947, 2.437078, 2.500073>
}
#declare CSG20 = difference {
  torus { // Torus23
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.395024, 0.218296>
  translate  <-0.943761, 2.310728, 1.780132>
}
#declare CSG21 = difference {
  torus { // Torus24
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.395024, 0.218296>
  translate  <-0.869681, 2.881004, 2.477829>
}
#declare CSG22 = difference {
  torus { // Torus25
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.38, 0.750546, 0.414763>
  translate  <-0.736369, 2.748598, 3.125525>
}
#declare CSG23 = difference {
  torus { // Torus26
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.35, 0.661617, 0.379234>
  translate  <-0.664791, 2.790403, 3.767744>
}
#declare CSG24 = difference {
  torus { // Torus27
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.33, 0.62381, 0.357564>
  translate  <-0.617907, 2.86222, 4.297691>
}
#declare CSG25 = difference {
  torus { // Torus28
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.3, 0.5671, 0.325058>
  translate  <-0.528207, 2.900009, 4.721489>
}
#declare CSG26 = difference {
  torus { // Torus29
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.25, 0.472584, 0.270882>
  translate  <-0.474679, 2.930655, 5.21834>
}
#declare CSG27 = difference {
  torus { // Torus30
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.22, 0.415874, 0.238376>
  translate  <-0.400005, 2.970477, 5.551185>
}
#declare CSG28 = difference {
  torus { // Torus31
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.378067, 0.216705>
  translate  <-0.37548, 3.003438, 5.953789>
}
#declare CSG29 = difference {
  torus { // Torus32
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.378067, 0.216705>
  translate  <-0.32464, 3.02372, 6.356451>
}
#declare Ladder = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 13.0>
    rotate <-9.69349, 7.332418, -1.216335>
    translate  <-1.635089, 0.985538, -4.923035>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 12.0>
    rotate <-0.32565, 6.968247, -0.768679>
    translate  <-1.708344, 3.10855, -4.798794>
  }
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 12.0>
    rotate <-4.658183, 6.660882, -0.724344>
    translate  <-1.640027, 2.030137, -4.729005>
  }
  object { CSG002 }
  object { CSG3 }
  object { CSG4 }
  object { CSG5 }
  object { CSG6 }
  object { CSG7 }
  object { CSG8 }
  object { CSG9 }
  object { CSG10 }
  object { CSG11 }
  object { CSG12 }
  object { CSG13 }
  object { CSG14 }
  object { CSG15 }
  object { CSG16 }
  object { CSG17 }
  object { CSG18 }
  object { CSG19 }
  object { CSG20 }
  object { CSG21 }
  object { CSG22 }
  object { CSG23 }
  object { CSG24 }
  object { CSG25 }
  object { CSG26 }
  object { CSG27 }
  object { CSG28 }
  object { CSG29 }
  texture {
    shoecolor
  }
  //no_shadow
  rotate <-8.0, 0.0, 0.0>
  translate  <0.035512, -0.818813, 2.499556>
}
#declare CSG58 = difference {
  torus { // Torus58
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
    translate  <0.092176, 0.0, -0.030496>
  }
  box { // Cube58
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.58579, 2.617043, -3.63843>
}
#declare CSG59 = difference {
  torus { // Torus59
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube59
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.499363, 1.616554, -3.668926>
}
#declare CSG60 = difference {
  torus { // Torus60
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube60
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.412936, 1.740256, -3.010241>
}
#declare CSG61 = difference {
  torus { // Torus61
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube61
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.437629, 2.653416, -2.982767>
}
#declare CSG62 = difference {
  torus { // Torus62
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube62
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.7, 0.850822, 0.470176>
  translate  <-1.363549, 2.702597, -2.366805>
}
#declare CSG63 = difference {
  torus { // Torus63
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube63
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.65, 0.790049, 0.436592>
  translate  <-1.351202, 1.836704, -2.348931>
}
#declare CSG64 = difference {
  torus { // Torus64
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube64
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.65, 0.790049, 0.436592>
  translate  <-1.289469, 2.690786, -1.766091>
}
#declare CSG65 = difference {
  torus { // Torus65
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube65
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.6, 0.790049, 0.436592>
  translate  <-1.264775, 1.883023, -1.717185>
}
#declare CSG66 = difference {
  torus { // Torus66
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube66
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.6, 0.790049, 0.436592>
  translate  <-1.190695, 2.711618, -1.086364>
}
#declare CSG67 = difference {
  torus { // Torus67
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube67
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.55, 0.790049, 0.436592>
  translate  <-1.166002, 2.009525, -1.074322>
}
#declare CSG68 = difference {
  torus { // Torus68
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube68
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.55, 0.790049, 0.436592>
  translate  <-1.091921, 2.763457, -0.349943>
}
#declare CSG69 = difference {
  torus { // Torus69
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube69
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.5, 0.790049, 0.436592>
  translate  <-1.005494, 2.79834, 0.285958>
}
#declare CSG70 = difference {
  torus { // Torus70
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube70
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.5, 0.790049, 0.436592>
  translate  <-1.104268, 2.108305, -0.300281>
}
#declare CSG71 = difference {
  torus { // Torus71
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube71
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.4, 0.790049, 0.436592>
  translate  <-1.005494, 2.233319, 0.354056>
}
#declare CSG72 = difference {
  torus { // Torus72
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube72
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.35, 0.691293, 0.382018>
  translate  <-0.993148, 2.831511, 1.071554>
}
#declare CSG73 = difference {
  torus { // Torus73
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube73
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.35, 0.691293, 0.382018>
  translate  <-0.943761, 2.280384, 1.118524>
}
#declare CSG74 = difference {
  torus { // Torus74
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube74
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.3, 0.592537, 0.327444>
  translate  <-0.931414, 2.852345, 1.790252>
}
#declare CSG75 = difference {
  torus { // Torus75
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube75
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.395024, 0.218296>
  translate  <-0.807947, 2.437078, 2.500073>
}
#declare CSG76 = difference {
  torus { // Torus76
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube76
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.395024, 0.218296>
  translate  <-0.943761, 2.310728, 1.780132>
}
#declare CSG77 = difference {
  torus { // Torus77
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube77
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.395024, 0.218296>
  translate  <-0.869681, 2.881004, 2.477829>
}
#declare CSG78 = difference {
  torus { // Torus78
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube78
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.38, 0.750546, 0.414763>
  translate  <-0.736369, 2.748598, 3.125525>
}
#declare CSG79 = difference {
  torus { // Torus79
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube79
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.35, 0.661617, 0.379234>
  translate  <-0.664791, 2.790403, 3.767744>
}
#declare CSG80 = difference {
  torus { // Torus80
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube80
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.33, 0.62381, 0.357564>
  translate  <-0.617907, 2.86222, 4.297691>
}
#declare CSG81 = difference {
  torus { // Torus81
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube81
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.3, 0.5671, 0.325058>
  translate  <-0.528207, 2.900009, 4.721489>
}
#declare CSG82 = difference {
  torus { // Torus82
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube82
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.25, 0.472584, 0.270882>
  translate  <-0.474679, 2.930655, 5.21834>
}
#declare CSG83 = difference {
  torus { // Torus83
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube83
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.22, 0.415874, 0.238376>
  translate  <-0.400005, 2.970477, 5.551185>
}
#declare CSG84 = difference {
  torus { // Torus84
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube84
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.378067, 0.216705>
  translate  <-0.37548, 3.003438, 5.953789>
}
#declare CSG85 = difference {
  torus { // Torus85
    0.6, 0.1  rotate -x*90
    texture {
      RopeColor
    }
    scale 0.8
    rotate -90.0*y
  }
  box { // Cube85
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RopeColor
    }
    translate  <0.0, -0.040135, 1.003368>
  }
  scale <0.2, 0.378067, 0.216705>
  translate  <-0.32464, 3.02372, 6.356451>
}
#declare Ladder2 = union {
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 13.0>
    rotate <-9.69349, 7.332418, -1.216335>
    translate  <-1.635089, 0.985538, -4.923035>
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 12.0>
    rotate <-0.32565, 6.968247, -0.768679>
    translate  <-1.708344, 3.10855, -4.798794>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 12.0>
    rotate <-4.658183, 6.660882, -0.724344>
    translate  <-1.640027, 2.030137, -4.729005>
  }
  object { CSG58 }
  object { CSG59 }
  object { CSG60 }
  object { CSG61 }
  object { CSG62 }
  object { CSG63 }
  object { CSG64 }
  object { CSG65 }
  object { CSG66 }
  object { CSG67 }
  object { CSG68 }
  object { CSG69 }
  object { CSG70 }
  object { CSG71 }
  object { CSG72 }
  object { CSG73 }
  object { CSG74 }
  object { CSG75 }
  object { CSG76 }
  object { CSG77 }
  object { CSG78 }
  object { CSG79 }
  object { CSG80 }
  object { CSG81 }
  object { CSG82 }
  object { CSG83 }
  object { CSG84 }
  object { CSG85 }
  texture {
    shoecolor
  }
no_shadow
  rotate <-8.0, -15.0, 0.0>
  translate  <1.962094, -0.912932, 2.906203>
}
#declare Arms = union {
  cylinder { // upperArm
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 8.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <0.029266, -3.758099, 0.028304>
  }
  cylinder { // LowerArm
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 8.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <-0.00289, -3.722987, -3.667649>
  }
  texture {
    MastColor1
  }
  //no_shadow
  scale <0.278828, 1.313081, 1.505826>
  rotate <0.0, 0.0, -90.260254>
  translate  <-0.756776, 3.352576, 5.570956>
}
#declare Sail = difference {
  cylinder { // Sal
    <0,0,1>, <0,0,0>, 1
    scale <3.1, 3.1, 10.0>
    rotate -90.0*y
    translate  <4.785101, 1.913118, 4.882618>
  }
  cylinder { // Sal1
    <0,0,1>, <0,0,0>, 1
    scale <3.1, 3.1, 20.0>
    rotate -90.0*y
    translate  <9.462735, 1.752583, 4.888482>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale 6.181371
    translate  <0.0, -2.861362, 3.953326>
  }
  texture {
    SailColor
  }
  no_shadow
  rotate <0.0, 0.0, 0.0>
  translate  <-0.175711, 0.07241, -2.025985>
}
#declare TheSailGroup = union {
  object { Arms }
  object { Sail }
  no_shadow
  rotate <0.0, 0.0, 0.0>
  translate  <0.184351, -0.018813, 2.099227>
}
union { // ShoeGroup
  object { TheMast }
  object { ShipWheel }
  object { theShoe }
  object { Ladder }
  object { Ladder2 }
  object { TheSailGroup }
  scale 2.0
  rotate <0.0, 0.0, 24.0>
  translate  <15.724744, -41.0, -8.5>
hollow
}








#declare HgtFld2 = object {
  height_field {
    tga "C:TR1.TGA"
    water_level 0.432
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    RockColor
  }
  scale <104.837433, 104.0, 103.697189>
  rotate <180.0, 0.0, -109.021637>
  translate  <-1.380069, -46.262047, -4.175747>
}
difference { // Cliff
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RockColor1
    }
    scale <40.321815, 75.328102, 31.327173>
    rotate <0.0, 0.0, 0.0>
    translate  <47.606283, -77.43301, -56.429941>
  }
  object { HgtFld2 }
  translate  <0.0, -30.0, 6.0>
hollow
}
