// YT-2400 by Bob Hayes
// I have included the map files for the ship, the landing bay file where huge TGAs and
// not included in this zip file.

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "glass.inc"
#include "metals.inc"
#include "textures.inc"

camera {
   location  <11,4,10>   //use this location
//   location  <-9,4.5,8>
   direction <0, 0,  1.5>
   up        <0,  1,  0>
   right     <4/3, 0,  0>
   look_at   <3.5, 0.20, 0>  //use this look at
//   rotate <0,clock*3.6,0>
   }

light_source {<100, 800, 300> colour rgb <0.7,0.7,0.7>}
light_source {<102, 800, 302> colour rgb <0.7,0.7,0.7>}  //two suns does not look good when far apart
//light_source {<100, 800, 300> colour White}
//light_source {<104, 800, 310> colour White}
//light_source {<0, 1, 30> colour White}
//light_source {<4, -0.5, 13> colour <0.3,0.3,0.3>}


// A cloud texture by Jussi Kantola that I modified.
#declare CloudColors = color_map {
    [0.0 0.5 color SkyBlue color SkyBlue]
   [0.90 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
}

#declare CloudTexture = texture {
   pigment{
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map { CloudColors }
   }
   finish { ambient 1 diffuse 0 }
   scale 1/6
}

sphere {
   <0, 0, 0>, 1
   texture { CloudTexture }
   scale <100000, 10000, 100000>
   hollow
}

fog {
  fog_type 1
    distance 90000
    colour rgb <0.99,0.85,0.9>
  }


#declare shiptexture = texture {
  pigment { color Black}
  finish { reflection 0.5 diffuse 0.5 metallic }
}


#declare smallfrontpane = object {
  intersection {
    difference {
      cylinder {<0,0,0>,<0,0,1>, 0.27}
      cylinder {<0,0,0>,<0,0,1>, 0.14}
    }

    box {<0,0,0>, <2,2,2>
      translate <0,0.01,0>
      rotate <0,0,-46>
    }

    box {<0,0,0>, <2,2,2>
    //  translate <-2,0,1.5>
      rotate <0,0,0>
    }
  } // end intersetion
}



#declare bigcockpitpane = object {
  intersection {
    box {<0,0,0.2>, <2,2,0.58>
      translate <0,0.01,0>
      rotate <0,0,-46>
    }

    box {<0,0,0.1>, <2,2,0.58>
    //  translate <-2,0,1.5>
      rotate <0,0,0>
    }
  } // end intersetion
}

#declare cockpitframe = object {
  difference {
    cone {<0,0,0>, 0.5, <0,0,0.6>, 0.28}
    cone {<0,0,-0.1>, 0.48, <0,0,0.58>, 0.26}

    object {bigcockpitpane rotate <0,0,-2>}
    object {bigcockpitpane rotate <0,0,44>}
    object {bigcockpitpane rotate <0,0,91>}
    object {bigcockpitpane rotate <0,0,137>}

    object {smallfrontpane rotate <0,0,-2>}
    object {smallfrontpane rotate <0,0,44>}
    object {smallfrontpane rotate <0,0,91>}
    object {smallfrontpane rotate <0,0,137>}

    cylinder {<0,0,0>,<0,0,1> 0.13}
    texture { shiptexture}
  }
}

#declare cockpitglass = object {
  difference {
    cone {<0,0,0>, 0.49, <0,0,0.59>, 0.27}
    cone {<0,0,-0.1>, 0.485, <0,0,0.585>, 0.265}
    texture {T_Glass1}
  }
}

#declare cockpittexture = texture { shiptexture}



#declare cockpittube = object {
union {
  cylinder {<0,0,-1.85>,<0,0,0>, 0.5}
  cylinder {<0,0,-0.5>,<0,0,-0.2>, 0.51}
  cone {<0,0,-1.95>, 0.4, <0,0,-1.85>, 0.5}
  cylinder {<0,0,-0.8>,<0,0,-1.1>, 0.51}
  cylinder {<0,0,-2.75>,<0,0,-1.9>, 0.4}
  cone {<0,0,-2.85>, 0.5, <0,0,-2.75>, 0.4}
  box {<0,-0.1,-2.66>,<0.46,0.1,-2.1>}
  cylinder {<0.43,0.07,-2.2>,<0.43,0.07,-1.2>, 0.01}
  cylinder {<0,0,-3.2>,<0,0,-2.85>, 0.5}
  cylinder {<0,0,-3.3>,<0,0,-3.1>, 0.45}
  cylinder {<0,0,-4.2>,<0,0,-3.3>, 0.5}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,0>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,30>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,60>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,90>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,120>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,150>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,180>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,210>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,240>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,270>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,300>}
  box {<0.2,-0.05,-3.32>,<0.51,0.05,-3.18> rotate <0,0,330>}
  torus {0.3, 0.2 rotate <90,0,0> translate <0,0,-4.2>}
  cylinder {<0,0,-4.41>,<0,0,-4>, 0.3 }
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,0>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,30>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,60>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,90>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,120>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,150>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,180>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,210>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,240>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,270>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,300>}
  box {<0.2,-0.05,-4.3>,<0.51,0.05,-3.98> rotate <0,0,330>}

  texture {cockpittexture}
}
}


#declare cockpit = object{
union
{
  object {cockpitframe}
  object {cockpitglass}
  object {cockpittube}
}
}



#declare outerring = object{
difference {
  torus {
     3.7, 0.3
   //  [ sturm ]
  }
  box { <-5,-0.1,-5>, <5, 0.1, 5>}
  texture { shiptexture
      normal {
      bump_map {
        gif "ringbump.gif"
        bump_size 3 //was 1  //was 5
      }
      rotate <90,0,0>
      scale <8,1,8>
      translate <-4,0,-4>
    }
  }
}
}



#declare innerring = object{
union {
  cylinder {<0,-0.12,0>, <0,0.12,0>, 3.9}
  cylinder {<1,0,3.5>, <5.8,0,1.8>, 0.25}
    texture { pigment { color rgb <0.4, 0.4, 0.4>}
      normal {
        bump_map {
          gif "detaila.gif"
          bump_size 2
        }
      scale <4,0.25,1>
      translate <0,-0.12,0>
      }
    }
}
}


#declare smalllip = object {
cylinder {<0,-0.32,0>, <0,0.32,0>, 3.7
  texture {shiptexture}
}
}

#declare accesspanel = object {
  intersection {
    difference {
      cylinder {<0,0,0>,<0,1,0>, 3.2}
      cylinder {<0,-1,0>,<0,2,0>, 2.2}
    }

    box {<0,0,0>, <2,2,2>
      translate <0,0,1.5>
      rotate <0,-10,0>
    }

    box {<0,0,0>, <2,2,2>
      translate <-2,0,1.5>
      rotate <0,10,0>
    }
  } // end intersetion
}

#declare saucertop = object{
difference {
  cone {<0,0.32,0>, 3.7, <0,1.0,0>, 1}

  object {accesspanel rotate <0,45,0>}
  object {accesspanel rotate <0,-45,0>}
  cylinder {<0,0,0>, <0,2,0>, 0.3 translate <0,0,3> rotate <0,-110,0>}
  cylinder {<0,0,0>, <0,2,0>, 0.2 translate <0,0,3> rotate <0,60,0>}
  texture {  shiptexture
      normal {
      bump_map {
        gif "mainbump.gif"
        bump_size 3 //was 1  //was 5
      }
      rotate <90,0,0>
      scale <7.4,1,7.4>
      translate <-3.7,0,-3.7>
      rotate<0,0.5,0>   //added to correct fo shift in bump map
    }
  }

} // end difference
}

#declare accessdetail = object {
  union {
    sphere {<0,0.42,2.9>,0.18 translate <-0.2,0,0>}
    cylinder{<0,0.42,1><0,0.42,2.9>,0.18 translate <-0.2,0,0>}
    sphere {<0,0.42,2.9>,0.18 translate <0.2,0,0> }
    sphere {<0,0.42,2.5>,0.18 translate <0.2,0,0> }
   texture { pigment { color rgb <0.3, 0.3, 0.3>}}
  }
}



#declare topgunbase=object{
union{
  difference{
    cone {<0,1.0,0>, 1, <0,1.1,0>, 0.9}
    cylinder{<0,0.9,0.2>,<0,1.11,0.2>,0.3 }
    texture {shiptexture}
  }
  difference{
    cylinder{<0,1,0>,<0,1.13,0>,0.8 }
    cylinder{<0,1,0>,<0,1.15,0>,0.7 }
    texture {shiptexture}
  }
  intersection{
    box{<-1,0,-1>,<1,1,1>}
    difference {
      sphere{<0,0,0>0.7}
      sphere{<0,0,0>0.69}
    }
    texture {T_Glass1} translate<0,0.5,0.2>
  }
}
}


#declare saucerbottom=object{
//bottom
difference {
cone {<0,-0.32,0>, 3.7, <0,-0.73,0>, 1}
box {<2,-1,-2><2.5,0,-1.2> }
box {<2,-1,1.2><2.5,0,2> }
box {<-2.5,-1,-2><-2,0,-1.2> }
box {<-2.5,-1,1.2><-2,0,2> }
texture { shiptexture}   //no bump map yet
}
}


#declare bottomgunbase = object{
cone {<0,-0.73,0>, 1, <0,-0.83,0>, 0.9
  texture { shiptexture}
}
}





#declare airlocktube = object{
//left side airlock tube
union{
  box {<-4.05,-0.71,-0.3>, <0,0.71,0.3>}
  box {<-4.05,-0.71,-0.3>, <0,0.71,0.3> rotate <45,0,0>}
  box {<-4.05,-0.71,-0.3>, <0,0.71,0.3> rotate <-45,0,0>}
  box {<-4.05,-0.71,-0.3>, <0,0.71,0.3> rotate <90,0,0>}
  texture { shiptexture
      normal {
      bump_map {
        gif "panlbump.gif"
        bump_size 2 //was 1  //was 5
      }
      rotate <90,0,0>
      scale <0.75,1,1.5>
    }
  }
}
}


#declare airlock = object{
cylinder {<-4.1,0,0>, <0,0,0>, 0.7
  texture { shiptexture }
}
}


#declare frontarm = object{
union {
  difference {
    cylinder {<1,0,3.5>, <5.8,0,1.8>, 0.3}
    box { <0,-0.1,0>, <7, 0.1, 5>}
  }
  box {<2,-0.3,0.6>,<5.8,0.3,1.8>}
  box {<3.6,-0.3,-0.6>,<4.1,0.3,1.9>}
  triangle {<2,0.3,1.7>, <5.8,0.3,1.8>, <1,0.3,3.5>}
  triangle {<2,-0.3,1.7>, <5.8,-0.3,1.8>, <1,-0.3,3.5>}
  cylinder {<2,0,0>, <5.8,0,0>, 0.3
    scale <1,1,2>
    translate <0,0,-1.35>
  }
  box {<2,-0.3,-1.35>,<5.8,0.3,-0.6>}
  texture { shiptexture
      normal {
      bump_map {
        gif "panlbump.gif"
        bump_size 2 //was 1  //was 5
      }
      rotate <90,0,0>
      scale <0.75,1,1.5>
      translate <0,0,0.5>
    }
}
}
}


#declare armdetail = object{
  union{
    box {<2,-0.27,-1.35>,<5.8,0.27,-0.58>}
    box {<4,0.15,-1.35>,<5.8,0.25,-0.57>}
    box {<4,0.16,-1.35>,<5.8,0.21,-0.47>}

    box {<4,0.06,-1.35>,<5.8,0.11,-0.47>}
    box {<4,-0.04,-1.35>,<5.8,-0.09,-0.47>}
    box {<4,-0.14,-1.35>,<5.8,-0.19,-0.47>}

    box {<3.6,-0.27,-0.6>,<4.15,0.27,1>}
    box {<2,-0.27,0.57>,<5.8,0.27,1.8>}
    cylinder{<3.6,0,0>,<4.2,0,0>,0.1}
  texture { pigment { color rgb <0.4, 0.4, 0.4>}}
  }
}




#declare enginearea = object{
union{
//engine top
intersection {
  cone {<0,0.18,0>, 4.5, <0,1.10,0>, 0.9}
  box {<0,0,0>, <5,2,5> rotate <0,135,0>}
  cylinder {<0,0,0>, <0,2,0>, 1.2 inverse }
  texture { shiptexture
      normal {
      bump_map {
        gif "engbump.gif"
        bump_size 3 //was 1  //was 5
      }
      rotate <90,0,0>
      scale <9,1,9>
      translate <-4.5,0,-4.5>
    }
}
}

//engine middle
intersection {
  cylinder {<0,-0.181,0>, <0,0.181,0>, 4.5}
  box {<0,-2,0>, <5,2,5> rotate <0,135,0>}
  box {<0.05,-0.15,0.05>,<4.95,0.15,4.95> rotate <0,135,0> inverse}
  texture { pigment { color rgb <0.4, 0.4, 0.4>}}
}

//engine bottom
intersection {
  cone {<0,-0.18,0>, 4.5, <0,-0.78,0>, 0.9}
  box {<0,0,0>, <5,-2,5> rotate <0,135,0>}
  cylinder {<0,0,0>, <0,-2,0>, 1.2 inverse }
  texture { shiptexture
      normal {
      bump_map {
        gif "engbump.gif"
        bump_size 3 //was 1  //was 5
      }
      rotate <-90,0,0>
      scale <9,1,9>
      translate <-4.5,0,-4.5>
    }
}
}
}
}




//aluvial dampeners
#declare dampener = object {
  union {
    cylinder {<-0.2,0.01,0>, <0.2,0.01,0>,0.02 }
    cylinder {<-0.2,0.02,0.22>, <0.2,0.02,0.22>,0.01 }
    box {<-0.02,0,0.02>,<0.02,0.05,0.22>}
    box {<-0.2,0,0>,<0.2,0.02,0.25>}
    texture { shiptexture}
    translate <0,0.18,-4.7>
  } //end union
} //object dampener


#declare dampeners = object{
union{
object {dampener}
object {dampener rotate <0,5.2,0>}
object {dampener rotate <0,5.2*2,0>}
object {dampener rotate <0,5.2*3,0>}
object {dampener rotate <0,5.2*4,0>}
object {dampener rotate <0,5.2*5,0>}
object {dampener rotate <0,5.2*6,0>}
object {dampener rotate <0,5.2*7,0>}
object {dampener rotate <0,5.2*8,0>}

object {dampener rotate <0,-5.2,0>}
object {dampener rotate <0,-5.2*2,0>}
object {dampener rotate <0,-5.2*3,0>}
object {dampener rotate <0,-5.2*4,0>}
object {dampener rotate <0,-5.2*5,0>}
object {dampener rotate <0,-5.2*6,0>}
object {dampener rotate <0,-5.2*7,0>}
object {dampener rotate <0,-5.2*8,0>}

object {dampener rotate <0,0,180>}
object {dampener rotate <0,5.2,180>}
object {dampener rotate <0,5.2*2,180>}
object {dampener rotate <0,5.2*3,180>}
object {dampener rotate <0,5.2*4,180>}
object {dampener rotate <0,5.2*5,180>}
object {dampener rotate <0,5.2*6,180>}
object {dampener rotate <0,5.2*7,180>}
object {dampener rotate <0,5.2*8,180>}

object {dampener rotate <0,-5.2,180>}
object {dampener rotate <0,-5.2*2,180>}
object {dampener rotate <0,-5.2*3,180>}
object {dampener rotate <0,-5.2*4,180>}
object {dampener rotate <0,-5.2*5,180>}
object {dampener rotate <0,-5.2*6,180>}
object {dampener rotate <0,-5.2*7,180>}
object {dampener rotate <0,-5.2*8,180>}
}
}



#declare engvent = object {
  union {
    difference {
      cylinder {<0,0,0>, <0,0.45,0>, 0.5}
      cylinder {<0,0,0>, <0,0.5,0>, 0.45}
      texture {shiptexture}
    }
    intersection {
      cylinder {<0,0,0>, <0,0.5,0>, 0.48}
      union {
        box {<-1,0,-0.01>,<1,0.43,0.01>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*2>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*3>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*4>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*5>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*6>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*7>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*8>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*9>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*10>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*11>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*12>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,0.04*13>}

        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*2>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*3>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*4>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*5>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*6>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*7>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*8>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*9>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*10>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*11>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*12>}
        box {<-1,0,-0.01>,<1,0.43,0.01> translate <0,0,-0.04*13>}

        cylinder {<0,0.41,-1>, <0,0.41,1>, 0.03 translate <0,0,0>}
        cylinder {<0,0.41,-1>, <0,0.41,1>, 0.03 translate <0.25,0,0>}
        cylinder {<0,0.41,-1>, <0,0.41,1>, 0.03 translate <-0.25,0,0>}

        texture { shiptexture}
      }
    } //end intersection
  } //end union
}





#declare leg = union {
  box{<-0.25,0.01,-0.4>,<0.25,0.05,0.4> texture { pigment { color White}}}
  box{<-0.2,0,-0.35>,<0.2,0.02,-0.25> texture { pigment { color White}}}
  box{<-0.2,0,-0.15>,<0.2,0.02,-0.05> texture { pigment { color White}}}
  box{<-0.2,0,0.05>,<0.2,0.052,0.15> texture { pigment { color White}}}
  box{<-0.2,0,0.25>,<0.2,0.02,0.35> texture { pigment { color White}}}
  box{<-0.20,0.02,-0.35>,<0.20,0.055,0.35> texture { pigment { color White}}}
  cone {<0,0.05,0>, 0.2, <0,0.2,0>, 0.1  texture { pigment { color White}}}
  intersection {
    box{<-0.25,0.01,-0.4>,<0.25,0.2,0.4>}
    box{<-0.025,0.01,0>,<0.025,0.2,0.35> rotate <22,25,0>}
    texture { pigment { color White}}
  }
  intersection {
    box{<-0.25,0.01,-0.4>,<0.25,0.2,0.4>}
    box{<-0.025,0.01,0>,<0.025,0.2,0.35> rotate <22,-25,0>}
    texture { pigment { color White}}
  }
  intersection {
    box{<-0.25,0.01,-0.4>,<0.25,0.2,0.4>}
    box{<-0.025,0.01,0>,<0.025,0.2,0.35> rotate <22,155,0>}
    texture { pigment { color White}}
  }
  intersection {
    box{<-0.25,0.01,-0.4>,<0.25,0.2,0.4>}
    box{<-0.025,0.01,0>,<0.025,0.2,0.35> rotate <22,-155,0>}
    texture { pigment { color White}}
  }
  cylinder {<0,0,0>, <0,0.25,0>, 0.1 texture { pigment { color White}}}
  cylinder {<0,0,0>, <0,1,0>, 0.07 texture { T_Chrome_2A }}
  cylinder {<0,0.28,0>, <0,0.42,0>, 0.1 texture { pigment { color White}}}
  cylinder {<0,0.28,-0.15>, <0,0.42,-0.15>, 0.1 texture { pigment { color White}}}
  box{<-0.10,0.28,-0.15>,<0.1,0.42,0> texture { pigment { color White}}}
  cylinder {<0,0.3,-0.15>, <0,1,-0.15>, 0.07 texture { T_Chrome_2A }}
  cylinder {<0,0.6,0>, <0,0.75,0>, 0.1 texture { pigment { color White}}}
  cylinder {<0,0.6,0.15>, <0,0.75,0.15>, 0.1 texture { pigment { color White}}}
  box{<-0.10,0.6,0>,<0.1,0.75,0.15> texture { pigment { color White}}}
  cylinder {<0,0.7,0.15>, <0,1,0.15>, 0.07 texture { T_Chrome_2A }}
}


declare gun1 = union {
  box{ <0,-0.5,-1>,<1.5,0.5,1> pigment {color Grey}}
  cylinder { <0,0,-1>, <0,0,1>, 0.5 pigment {color Grey}}
  cylinder { <0,0,-1.5>, <0,0,-1.2>, 0.4 pigment {color White}}
  cylinder { <0,0,1.2>, <0,0,1.5>, 0.4 pigment {color White}}
  cylinder { <0,0,-1.25>, <0,0,1.25>, 0.3 texture{Chrome_Metal}}
  box{ <-0.4,-0.75,-1.5>,<0.4,0,-1.25> pigment {color White} rotate <0,0,-60>}
  box{ <-0.4,-0.75,1.25>,<0.4,0,1.5> pigment {color White} rotate <0,0,-60>}
  box{ <-0.4,-1,-1.5>,<0.4,-0.75,1.5> pigment {color White} rotate <0,0,-60>}
  cylinder{ <0,-1,0>, <0,-4,0>, 0.4  pigment {color White} rotate <0,0,-60>}
  box{ <-0.4,-1.2,-0.4>,<0.4,-4,0.4> pigment {color White} rotate <0,0,-60>}

  cone{<1.5,0,-0.5>, 0.5, <2,0,-0.5>, 0.25 pigment {color Grey} finish{Metal}}
  cone{<1.5,0,0.5>, 0.5, <2,0,0.5>, 0.25 pigment {color Grey} finish{Metal}}
  intersection {
    cylinder { <1.5,0,-0.5>, <4,0,-0.5>, 0.25}
    cylinder { <1.5,0,-0.5>, <4.1,0,-0.5>, 0.20 inverse}
    pigment {color White} finish{Metal}
  }
  intersection {
    cylinder { <1.5,0,0.5>, <4,0,0.5>, 0.25}
    cylinder { <1.5,0,0.5>, <4.1,0,0.5>, 0.20 inverse}
    pigment {color White} finish{Metal}
  }
//  cylinder { <0,-1,0>, <0,-0.75,0>, 1.55 pigment {color White}}
  scale 0.25
}





#declare yt2400 = object{
  union {
    object {cockpit translate <5.8,0,2.4>}
    object {outerring}
    object {innerring}
    object {smalllip}
    object {saucertop }
    object {accessdetail rotate<0,45,0>}
    object {accessdetail rotate<0,-45,0>}
    object {saucerbottom}
    object {topgunbase}
    object {bottomgunbase}
    object {airlocktube}
    object {airlock}
    object {frontarm}
    object {armdetail}
    object {enginearea}
    object {dampeners}
    object {engvent rotate <-15,0,0> translate <0,0.1,-3.2>}
    object {engvent rotate <-15,0,0> translate <0,0.1,-3.2> rotate<0,27,0>}
    object {engvent rotate <-15,0,0> translate <0,0.1,-3.2> rotate<0,-27,0>}
    object {leg translate <2.25,-1.3,1.6>}
    object {leg translate <-2.25,-1.3,1.6>}
    object {leg translate <2.25,-1.3,-1.6>}
    object {leg translate <-2.25,-1.3,-1.6>}
    object {gun1 translate <0,1.4,0> rotate<0,-90,0>}
    object {gun1 rotate <0,0,180> translate <0,-1.0,0> rotate<0,90,0>}
  }
}

object {yt2400 rotate<0,-18,0> translate<2,0,0>}



//landing bay
difference {
height_field {
  tga "landbhf2.tga"
  smooth
  texture {
    pigment {
      image_map {
        gif "lbwallim.gif"
        }
      scale <1,1,1> rotate <0,180,0> translate<-0.1,0,0>
    }
    finish {ambient 0.35}
  }
  scale <30,4,30> translate <-10,-1.3,-15>
}

box{<-5,-1.3,-3.5>,<-10,1.2,1.5> pigment{color White}}
}  //end difference



difference {
  box{<-6.5,-1.3,-5>,<-6.7,1.3,3>}
  box{<-5,-1.3,-3.3>,<-10,1.0,1.3>}
  pigment{color White}
}



//landing bay floor, use of plane caused a fog horizon
box { <-15,-2,-15>,<15, -1.299, 15>
  texture {
    pigment {
      image_map {
        tga "lbimap.tga"
        once
      }
    rotate <90,0,0>
    scale <20,1,20> translate <-7,0,-11>
    }
    finish {ambient 0.35}
  }
}


//hanger door
difference {
  box{<-0.2,-1.4,-3.4>,<-0.4,1.1,1.4>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,0>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,0.8>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,1.6>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,2.4>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,-0.8>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,-1.6>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,-2.4>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,-3.2>}
  box{<-0.2,-2,-0.2>,<0.2,2,0.2> rotate <0,45,0> rotate <45,0,0> translate<0.05,0,-4.0>}
  pigment{image_map{ tga "doormap.tga"} rotate <0,90,0> scale <1,2.5,4.8> translate <0,-1.4,-3.4>}
  finish {ambient 0.35}
  translate <-6.3,0,0>
}

