/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */


#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "metals.inc"
#include "stones.inc"

#include "13flyshp.col"

// PRIMARY CAMERA INDICATORS

#declare Locatx = 2000
#declare Locaty = 4000
#declare Locatz = -12000

#declare Lokatx = 0
#declare Lokaty = 1000
#declare Lokatz = 0

// IMAGE DEBUGGING

#declare Qimage = on

#declare Scenery = on
#declare Foreground = on
#declare Ship = on
#declare Temples = on
#declare Temple1 = on
#declare Temple2 = on
#declare Temple3 = on
#declare Land = on
#declare Lens = on

// QUICK IMAGE DECLARATIONS

#if (Qimage = on)
#include "Qimage.inc"
#end

camera {
   location < Locatx , Locaty , Locatz >
   look_at  < Lokatx , Lokaty , Lokatz >
}

light_source {< Locatx + 1000, Locaty + 2000, Locatz + 1000> color White}


// VARIABLES FOR STEPS CONTROL

#declare D1 = vlength (<Locatx,0,Locatz>-<Lokatx,0,Lokatz>)
#declare D2 = (Locaty-Lokaty)
#declare A1 = atan2 (D2,D1)
#declare A1 = degrees (A1)

#if (Locatx > 0)
#declare Xfactor = 1
#else
#declare Xfactor = 0
#end

#if (Locatz > 0)
#declare Zfactor = 1
#else
#declare Zfactor = 0
#end

#declare A2 = atan2(Locatz,Locatx)
#declare A2 = degrees (A2)
#declare A2 = abs (A2)

#if (Xfactor = 1)
	#if (Zfactor = 0)
		#declare A3 = (360 - A2)
	#else
		#declare A3 = A2
	#end
#else
	#if (Zfactor = 0)
		#declare A3 = (180 + A2)
	#else
		#declare A3 = (180 - A2)
	#end
#end

#if (Foreground = on)
		#include "Fsteps.inc"
		object {Steps
		rotate <0,(335 - A3),0>
		translate <0,(-150 * A1),1200>
		translate < Locatx , Locaty , Locatz >}
#end

#if (Scenery = on)
#include "Qscene.inc"
#end


#if (Land = on)
#declare World =
union {
height_field {gif "mountain.gif" translate <0,-1,0> texture{Land_texture1}}
light_source {<-1,3,-1> color White}
}

sky_sphere {S_Cloud1}

object {World translate <-.5,0,-.5> scale <800000,100000,800000>
translate <-700000,-200000,500000>}

plane { y, -1.0 translate <0,-250000,0>
texture { pigment {
	bozo
	color_map {
		[0.0 rgbf <1,1,1,1>]
		[0.3 rgbf <1,1,1,.5>]
		[0.4 rgbf <1,1,1,.2>]
		[0.5 rgbf <1,1,1,.5>]
		[0.6 rgbf <1,1,1,1>]
		[0.7 rgbf <1,1,1,1>]
	}
	turbulence .5
	scale <30000,30000,500000>
}}
finish {ambient .45 phong 1}
}

#end

#if (Lens = on)
#declare cam_loc = <2000,4000,-12000>
#declare light_loc = <0,10000,30000>
#declare lookat = <0,1000,0>

#include "lnsflare.inc"
#end

#if (Ship = on)
#include "fship.inc"
object {Flyship scale .45 rotate <0,120,0> translate <-1483.51,4500,-3400>}
#end

