//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 9 textures and 103 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 11/27/1996    (27.11.1996)
//

#max_trace_level 9

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//

sky_sphere{
 pigment{
  gradient z
  color_map{
    //[0.5 color rgb <0.9, 0.6, 0.6>*0.6]

    [0.5 color rgb <0.6, 0.6, 1>*1]

    [1 color rgb <0.2, 0.2, 0.6>*0.5]
    }
  scale 2
  translate z*-1
 }
}



camera {  //  Camera StdCam
  location  <2.000, -9.600, 0.600>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.5,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>

   aperture 0.2
   focal_point <0, -6.5, 0>

   blur_samples 37
   confidence 0.975           // default is 0.9
   variance 1/255             // default is 1/128 (0.0078125)

}

// *******  L I G H T S *******

light_source { // AreaL001
  <355.295, -213.355, 40.000>
  color  rgb<1.000, 1.000, 0.796>
  area_light <1.382, 0.000, -1.446>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 2
  jitter
}


// ********  TEXTURES  *******
//

#include "baddog.inc"
#include "clouds.inc"


// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#include "superel.inc"

#declare shape_Ref = object {
  shape
  scale <0.8, 2.0, 0.5>
  translate  <0.0, 0.6, -0.5>
}
#declare WingCsg = union {
  cone { // Wing1
    <0,0,0>, 1.0, <0,0,1>, 0.4
    texture {
      RedFinColor
    }
    scale <0.2, 0.7, 1.0>
    rotate <0.0, 15.0, 20.0>
    translate  <8.4, 3.1, 0.3>
  }
  cone { // Wing
    <0,0,0>, 1.0, <0,0,1>, 0.4
    scale <0.3, 1.7, 9.0>
    rotate <-20.0, 85.0, 0.0>
    translate  -0.5*z
  }
  sphere { // WingS1
    <0,0,0>,1
    texture {
      RedFinColor
    }
    scale <0.1, 0.286, 0.05>
    rotate 20.0*z
    translate  <8.65295, 3.189901, 1.258954>
  }
  sphere { // WingS
    <0,0,0>,1
    texture {
      RedFinColor
    }
    scale <0.2, 0.7, 0.2>
    rotate 20.0*z
    translate  <8.4, 3.1, 0.3>
  }
  texture {
    WingColor
  }
  translate  -1.2*y
}
#declare WingCsg1 = union {
  cone { // Wing2
    <0,0,0>, 1.0, <0,0,1>, 0.4
    texture {
      RedFinColor
    }
    scale <0.2, 0.7, 1.0>
    rotate <0.0, 15.0, 20.0>
    translate  <8.4, 3.1, 0.3>
  }
  cone { // Wing3
    <0,0,0>, 1.0, <0,0,1>, 0.4
    scale <0.3, 1.7, 9.0>
    rotate <-20.0, 85.0, 0.0>
    translate  -0.5*z
  }
  sphere { // WingS2
    <0,0,0>,1
    texture {
      RedFinColor
    }
    scale <0.1, 0.286, 0.05>
    rotate 20.0*z
    translate  <8.65295, 3.189901, 1.258954>
  }
  sphere { // WingS3
    <0,0,0>,1
    texture {
      RedFinColor
    }
    scale <0.2, 0.7, 0.2>
    rotate 20.0*z
    translate  <8.4, 3.1, 0.3>
  }
  texture {
    WingColor
  }
  rotate 140.0*z
  translate  -1.2*y
}
#declare flangCsg = union {
  sphere { // Flang
    <0,0,0>,1
  }
  cone { // FlangEnd
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
  }
  scale <0.1, 0.3, 0.2>
  translate  <3.4, -0.6, -0.4>
}
#declare flangCsg1 = union {
  sphere { // Flang1
    <0,0,0>,1
  }
  cone { // FlangEnd1
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
  }
  scale <0.1, 0.2, 0.2>
  translate  <6.3, 0.8, -0.1>
}
#declare flangCsg2 = union {
  sphere { // Flang2
    <0,0,0>,1
  }
  cone { // FlangEnd2
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
  }
  scale <0.1, 0.2, 0.2>
  translate  <-6.3, 0.8, -0.1>
}
#declare flangCsg3 = union {
  sphere { // Flang3
    <0,0,0>,1
  }
  cone { // FlangEnd3
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
  }
  scale <0.1, 0.3, 0.2>
  translate  <-3.4, -0.6, -0.4>
}
#declare EngineCsg3 = intersection {
  sphere { // Engine6
    <0,0,0>,1
    scale <1.0, 5.0, 1.0>
  }
  cylinder { // EngineCut3
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 4.0>
    rotate -90.0*x
    translate  -1.0*y
  }
}
#declare EngineCutCsg3 = difference {
  object { EngineCsg3 }
  sphere { // Engine7
    <0,0,0>,1
    scale <0.8, 4.0, 0.8>
  }
}
#declare OneBlade24 = union {
  cylinder { // Blade24
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 45.0*y
}
#declare OneBlade25 = union {
  cylinder { // Blade25
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 90.0*y
}
#declare OneBlade26 = union {
  cylinder { // Blade26
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
}
#declare OneBlade27 = union {
  cylinder { // Blade27
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -45.0*y
}
#declare OneBlade28 = union {
  cylinder { // Blade28
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -90.0*y
}
#declare OneBlade29 = union {
  cylinder { // Blade29
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, -45.0, 180.0>
}
#declare OneBlade30 = union {
  cylinder { // Blade30
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 0.0, 180.0>
}
#declare OneBlade31 = union {
  cylinder { // Blade31
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 45.0, 180.0>
}
#declare BladesCsg3 = union {
  sphere { // BladeEnd3
    <0,0,0>,1
    scale <0.3, 0.6, 0.3>
    translate  -1.0*y
  }
  object { OneBlade24 }
  object { OneBlade25 }
  object { OneBlade26 }
  object { OneBlade27 }
  object { OneBlade28 }
  object { OneBlade29 }
  object { OneBlade30 }
  object { OneBlade31 }
  texture {
    Chrome_Metal1
  }
}
#declare Turbine3 = union {
  torus { // EngineFront6
    0.85, 0.15  rotate -x*90
    rotate -90.0*x
    translate  -1.0*y
  }
  torus { // EngineFront7
    0.65, 0.15  rotate -x*90
    rotate -90.0*x
    translate  3.0*y
  }
  object { EngineCutCsg3 }
  object { BladesCsg3 }
  cylinder { // EngineJoin3
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 1.0, 1.666667>
    rotate <-23.0, 60.0, 4.0>
    translate  <0.0, 1.166667, 0.333333>
  }
  texture {
    JetColor
    scale <1.0, 2.8, 1.0>
  translate <0.000000, 0.500000, 0.000000>
  }
  scale 0.6
  translate  <-5.0, -0.9, -0.9>
}
#declare EngineCsg2 = intersection {
  sphere { // Engine4
    <0,0,0>,1
    scale <1.0, 5.0, 1.0>
  }
  cylinder { // EngineCut2
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 4.0>
    rotate -90.0*x
    translate  -1.0*y
  }
}
#declare EngineCutCsg2 = difference {
  object { EngineCsg2 }
  sphere { // Engine5
    <0,0,0>,1
    scale <0.8, 4.0, 0.8>
  }
}
#declare OneBlade16 = union {
  cylinder { // Blade16
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 45.0*y
}
#declare OneBlade17 = union {
  cylinder { // Blade17
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 90.0*y
}
#declare OneBlade18 = union {
  cylinder { // Blade18
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
}
#declare OneBlade19 = union {
  cylinder { // Blade19
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -45.0*y
}
#declare OneBlade20 = union {
  cylinder { // Blade20
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -90.0*y
}
#declare OneBlade21 = union {
  cylinder { // Blade21
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, -45.0, 180.0>
}
#declare OneBlade22 = union {
  cylinder { // Blade22
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 0.0, 180.0>
}
#declare OneBlade23 = union {
  cylinder { // Blade23
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 45.0, 180.0>
}
#declare BladesCsg2 = union {
  sphere { // BladeEnd2
    <0,0,0>,1
    scale <0.3, 0.6, 0.3>
    translate  -1.0*y
  }
  object { OneBlade16 }
  object { OneBlade17 }
  object { OneBlade18 }
  object { OneBlade19 }
  object { OneBlade20 }
  object { OneBlade21 }
  object { OneBlade22 }
  object { OneBlade23 }
  texture {
    Chrome_Metal1
  }
}
#declare Turbine2 = union {
  torus { // EngineFront4
    0.85, 0.15  rotate -x*90
    rotate -90.0*x
    translate  -1.0*y
  }
  torus { // EngineFront5
    0.65, 0.15  rotate -x*90
    rotate -90.0*x
    translate  3.0*y
  }
  object { EngineCutCsg2 }
  object { BladesCsg2 }
  cylinder { // EngineJoin2
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 1.0, 1.666667>
    rotate <-23.0, 60.0, 4.0>
    translate  <0.0, 1.166667, 0.333333>
  }
  texture {
    JetColor
    scale <1.0, 2.8, 1.0>
  translate <0.000000, 0.500000, 0.000000>
  }
  scale 0.6
  translate  <-2.4, -2.2, -1.1>
}
#declare EngineCsg1 = intersection {
  sphere { // Engine2
    <0,0,0>,1
    scale <1.0, 5.0, 1.0>
  }
  cylinder { // EngineCut1
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 4.0>
    rotate -90.0*x
    translate  -1.0*y
  }
}
#declare EngineCutCsg1 = difference {
  object { EngineCsg1 }
  sphere { // Engine3
    <0,0,0>,1
    scale <0.8, 4.0, 0.8>
  }
}
#declare OneBlade8 = union {
  cylinder { // Blade8
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 45.0*y
}
#declare OneBlade9 = union {
  cylinder { // Blade9
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 90.0*y
}
#declare OneBlade10 = union {
  cylinder { // Blade10
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
}
#declare OneBlade11 = union {
  cylinder { // Blade11
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -45.0*y
}
#declare OneBlade12 = union {
  cylinder { // Blade12
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -90.0*y
}
#declare OneBlade13 = union {
  cylinder { // Blade13
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, -45.0, 180.0>
}
#declare OneBlade14 = union {
  cylinder { // Blade14
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 0.0, 180.0>
}
#declare OneBlade15 = union {
  cylinder { // Blade15
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 45.0, 180.0>
}
#declare BladesCsg1 = union {
  sphere { // BladeEnd1
    <0,0,0>,1
    scale <0.3, 0.6, 0.3>
    translate  -1.0*y
  }
  object { OneBlade8 }
  object { OneBlade9 }
  object { OneBlade10 }
  object { OneBlade11 }
  object { OneBlade12 }
  object { OneBlade13 }
  object { OneBlade14 }
  object { OneBlade15 }
  texture {
    Chrome_Metal1
  }
}
#declare Turbine1 = union {
  torus { // EngineFront2
    0.85, 0.15  rotate -x*90
    rotate -90.0*x
    translate  -1.0*y
  }
  torus { // EngineFront3
    0.65, 0.15  rotate -x*90
    rotate -90.0*x
    translate  3.0*y
  }
  object { EngineCutCsg1 }
  object { BladesCsg1 }
  cylinder { // EngineJoin1
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 1.0, 1.666667>
    rotate <-23.0, -60.0, -4.0>
    translate  <0.0, 1.166667, 0.333333>
  }
  texture {
    JetColor
    scale <1.0, 2.8, 1.0>
  translate <0.000000, 0.500000, 0.000000>
  }
  scale 0.6
  translate  <5.0, -0.9, -0.9>
}
#declare EngineCsg = intersection {
  sphere { // Engine
    <0,0,0>,1
    scale <1.0, 5.0, 1.0>
  }
  cylinder { // EngineCut
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 4.0>
    rotate -90.0*x
    translate  -1.0*y
  }
}
#declare EngineCutCsg = difference {
  object { EngineCsg }
  sphere { // Engine1
    <0,0,0>,1
    scale <0.8, 4.0, 0.8>
  }
}
#declare OneBlade7 = union {
  cylinder { // Blade7
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 45.0*y
}
#declare OneBlade6 = union {
  cylinder { // Blade6
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate 90.0*y
}
#declare OneBlade = union {
  cylinder { // Blade
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
}
#declare OneBlade1 = union {
  cylinder { // Blade1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -45.0*y
}
#declare OneBlade2 = union {
  cylinder { // Blade2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate -90.0*y
}
#declare OneBlade3 = union {
  cylinder { // Blade3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, -45.0, 180.0>
}
#declare OneBlade4 = union {
  cylinder { // Blade4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 0.0, 180.0>
}
#declare OneBlade5 = union {
  cylinder { // Blade5
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.02, 0.8>
    rotate -20.0*z
    translate  -1.0*y
  }
  rotate <180.0, 45.0, 180.0>
}
#declare BladesCsg = union {
  sphere { // BladeEnd
    <0,0,0>,1
    scale <0.3, 0.6, 0.3>
    translate  -1.0*y
  }
  object { OneBlade7 }
  object { OneBlade6 }
  object { OneBlade }
  object { OneBlade1 }
  object { OneBlade2 }
  object { OneBlade3 }
  object { OneBlade4 }
  object { OneBlade5 }
  texture {
    Chrome_Metal1
  }
}
#declare Turbine = union {
  torus { // EngineFront
    0.85, 0.15  rotate -x*90
    rotate -90.0*x
    translate  -1.0*y
  }
  torus { // EngineFront1
    0.65, 0.15  rotate -x*90
    rotate -90.0*x
    translate  3.0*y
  }
  object { EngineCutCsg }
  object { BladesCsg }
  cylinder { // EngineJoin
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 1.0, 1.666667>
    rotate <-23.0, -60.0, -4.0>
    translate  <0.0, 1.166667, 0.333333>
  }
  texture {
    JetColor
    scale <1.0, 2.8, 1.0>
  translate <0.000000, 0.500000, 0.000000>
  }
  scale 0.6
  translate  <2.4, -2.2, -1.1>
}
#declare TailBulk = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.333333, 0.000000>, <1.000000, -1.333333, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-0.985929, 0.016257, 2.000000>, <-0.985929, -1.311037, 2.000000>, <0.985929, -1.311037, 2.000000>, <0.985929, 0.016257, 2.000000>, 
      <-0.572403, 0.281733, 4.000000>, <-0.572403, -0.779467, 4.000000>, <0.572403, -0.779467, 4.000000>, <0.572403, 0.281733, 4.000000>, 
      <-0.171782, 0.789678, 6.000000>, <-0.171782, 0.450116, 6.000000>, <0.171782, 0.450116, 6.000000>, <0.171782, 0.789678, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.333333, 0.000000>, <-1.000000, 1.333333, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <0.985929, 0.016257, 2.000000>, <0.985929, 1.343551, 2.000000>, <-0.985929, 1.343551, 2.000000>, <-0.985929, 0.016257, 2.000000>, 
      <0.572403, 0.281733, 4.000000>, <0.572403, 1.342933, 4.000000>, <-0.572403, 1.342933, 4.000000>, <-0.572403, 0.281733, 4.000000>, 
      <0.171782, 0.789678, 6.000000>, <0.171782, 1.129239, 6.000000>, <-0.171782, 1.129239, 6.000000>, <-0.171782, 0.789678, 6.000000>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  4.0*y
}
#declare WingCsg2 = union {
  cone { // Wing5
    <0,0,0>, 0.9, <0,0,1>, 0.4
    scale <0.2, 1.0, 2.0>
  }
  sphere { // WingS5
    <0,0,0>,1
    scale <0.08, 0.4, 0.09>
    translate  2.0*z
  }
  scale 1.2
  rotate <-15.0, -85.0, 0.0>
  translate  <-0.2, 8.3, 0.7>
}
#declare TailCurveCsg = intersection {
  torus { // TailCurve
    1.5, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.2>
    rotate -90.0*y
    translate  -1.4*y
  }
  box { // TailCurveCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 0.2>
    translate  <0.0, 0.1, -0.2>
  }
}
#declare WingCsg4 = union {
  cone { // Wing7
    <0,0,0>, 1.0, <0,0,1>, 0.4
    scale <0.2, 1.0, 2.3>
    translate  0.1*y
  }
  sphere { // WingS7
    <0,0,0>,1
    scale <0.1, 0.4, 0.09>
    translate  <0.0, 0.1, 2.3>
  }
  object { TailCurveCsg }
  texture {
    TailColor1
    scale <1.6, 1.6, 1.0>
    rotate <90.0, -15.0, 90.0>
  translate <0.000000, -0.500000, -0.300000>
  }
  scale 1.2
  rotate -15.0*x
  translate  <0.0, 8.5, 1.1>
}
#declare WingCsg3 = union {
  cone { // Wing6
    <0,0,0>, 0.9, <0,0,1>, 0.4
    scale <0.2, 1.0, 2.0>
  }
  sphere { // WingS6
    <0,0,0>,1
    scale <0.08, 0.4, 0.09>
    translate  2.0*z
  }
  scale 1.2
  rotate <-15.0, 85.0, 0.0>
  translate  <0.2, 8.3, 0.7>
}
#declare TheTailCsg = union {
  object { TailBulk }
  sphere { // EndBit
    <0,0,0>,1
    scale <0.17, 0.1, 0.263>
    translate  <0.0, 10.0, 0.8>
  }
  object { WingCsg2 }
  object { WingCsg4 }
  object { WingCsg3 }
  texture {
    TailColor
    scale <2.2, 2.8, 6.5>
    rotate 55.0*x
  translate <0.000000, 8.900001, -1.000000>
  }
}
#declare TopBit = union {
  sphere { // Nose2
    <0,0,0>,1
    scale <1.0, 3.0, 1.0>
    translate  <0.0, -2.3, 0.2>
  }
  cylinder { // Neck1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <0.0, -5.3, 0.2>
  }
  scale 0.9
  translate  -1.5*y
}
#declare NoseChunk = union {
  sphere { // Nose1
    <0,0,0>,1
    scale <0.9, 1.35, 0.9>
    translate  <0.0, -6.27, 0.18>
  }
  sphere { // Nose
    <0,0,0>,1
    scale <1.0, 2.0, 1.0>
    translate  -6.0*y
  }
}
#declare CockPitCutCsg = difference {
  object { NoseChunk }
  box { // CockpitCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
    translate  <0.0, -7.5, 0.5>
  }
  sphere { // Nose4
    <0,0,0>,1
    scale <0.9, 1.8, 0.9>
    translate  -6.0*y
  }
}
#declare CockPitScreen = intersection {
  sphere { // Nose3
    <0,0,0>,1
    scale <1.0, 2.0, 1.0>
    translate  -6.0*y
  }
  box { // CockpitCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
    translate  <0.0, -8.0, 0.5>
  }
  texture {
    FrontWindowColor
  }
}
#declare RimClumpCsg = union {
  torus { // CockpitRim3
    1.0, 0.005  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale 0.87
    rotate -90.0*x
    translate  -7.0*y
  }
  torus { // CockpitRim2
    1.0, 0.005  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale 0.98
    rotate -90.0*x
    translate  -6.5*y
  }
  torus { // CockpitRim1
    1.0, 0.005  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.77, 1.44, 0.72>
    translate  <0.0, -6.0, 0.7>
  }
  torus { // CockpitRim
    1.0, 0.005  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.95, 1.9, 0.95>
    translate  <0.0, -6.0, 0.3>
  }
}
#declare RimCsgCut = intersection {
  box { // CockpitCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.01, 1.01, 0.202>
    translate  <0.0, -7.5, 0.5>
  }
  object { RimClumpCsg }
}
union { // PlaneNose
  cylinder { // Neck
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  -6.0*y
  }
  object { shape_Ref }
  object { WingCsg }
  object { WingCsg1 }
  object { flangCsg }
  object { flangCsg1 }
  object { flangCsg2 }
  object { flangCsg3 }
  object { Turbine3 }
  object { Turbine2 }
  object { Turbine1 }
  object { Turbine }
  object { TheTailCsg }
  object { TopBit }
  object { CockPitCutCsg }
  object { CockPitScreen }
  cylinder { // BackWall
    <0,0,1>, <0,0,0>, 1 
    texture {
      DarkNessColor
    }
    scale <0.95, 0.95, 0.1>
    rotate -90.0*x
    translate  -6.3*y
  }
  object { RimCsgCut }
  texture {
    PlaneWhite
  }
}

#include "dog.inc"

plane { // Ocean
  z,0
  texture {
    WaterColor
  }
  translate  -200.0*z
}


object{
 sphere{
  <0,0,0> ,1
  pigment { color rgbt <1,1,1,1>}
  halo {
   dust
   spherical_mapping
   linear
   turbulence 0.8
    color_map{
     [0.3 color rgbt <1,1,1,1>]
     [1 color rgbt <1,1,1,0>]
     }
   }
  scale 2
  scale <500.0, 333.3, 40>
  rotate <0.0, 0.0, -59.684364>
  translate  <-13.263426, 347.501753, -111.861266>
 }
hollow
}


