/****************************************************************/
/*                                                              */
/* Title:  Ocean Journey                                        */
/* Author: Kelly Thibodeau                                      */
/* Date:   Dec. 10,1996                                         */
/* Notes:  Only the second picture i've done so the code is a   */
/*         little sloppy. I could probably condence it but i'll */
/*         figure out what I can cut later.                     */
/****************************************************************/


#include "colors.inc"    
#include "shapes.inc"    
#include "finish.inc"

camera {
        location <0.0, 15.0, -25.0>
        look_at <0.0, 20.0, 1.0>
       }


light_source { <0.00, 35.00, -30.00>
               color White
               //shadowless
             }
light_source { <0.00, 10.00, -30.00>
               color White
               shadowless
             }

/***************************** Start of the making of each balloon ************************/


#declare Basket =
union {
    difference {
                superellipsoid { <0.1,0.4>
                                 scale <0.7,0.8,0.7>
                               }

                superellipsoid { <0.1,0.4>
                                 scale <0.6,0.8,0.6>
                                 translate <0,0.1,0>
                               }
               }

    box { <-0.4,0,-0.4>, <0.4,0.05,0.4>
          pigment { Silver }
          translate <0,2.2,0>
        }

    cylinder { <0,2.2,0>, <0,2.5,0>,0.25
               pigment { Silver }
             }

union {
/********  the next 4 are the ropes from the basket up to the plate ***************/

       cylinder { <-0.55,0.70,-0.6>, <-0.35,2.2,-0.35>, 0.02 }
       cylinder { <0.55,0.70,-0.6>, <0.35,2.2,-0.35>, 0.02 }
       cylinder { <-0.55,0.70,0.6>, <-0.35,2.2,0.35>, 0.02 }
       cylinder { <0.55,0.70,0.6>, <0.35,2.2,0.35>, 0.02 }


/********  the next 4 are the ropes from the plate up to the balloon ***************/

       cylinder { <-0.35,2.2,-0.35>, <-1.0,4.5,-1.0>, 0.02 }
       cylinder { <-0.35,2.2,0.35>, <-1.0,4.5,1.0>, 0.02 }
       cylinder { <0.35,2.2,0.35>, <1.0,4.5,1.0>, 0.02 }
       cylinder { <0.35,2.2,-0.35>, <1.0,4.5,-1.0>, 0.02 }

       pigment { White }
       }
 translate <0,-9.8,0>
}


#declare BalloonBag =
difference {
            blob {
                threshold 0.1

                sphere { <0,0,0>, 5, 1
                         scale <1,0.7,1,>
                       }
                sphere { <0,-0.5,0>, 4.5, 1 }
                sphere { <0,-1,0>, 4, 1 }
                sphere { <0,-1.5,0>, 3.6, 1 }
                sphere { <0,-2.2,0>, 3, 1 }
                sphere { <0,-3.2,0>, 3, 1 }
                sphere { <0,-4.5,0>, 2, 1 }
                 }
            box { <-3,-5.5,-3>, <3,-6.5,3> }
           }

#declare BalloonPiece =
difference {
            object { BalloonBag
                     scale <0.5,1,1>
                   }

            box { <-5,-7,-7>, <-0.8,7,7> }
            box { <5,-7,-7>, <0.8,7,7> }
           }


#declare Balloon1 =
union {
#declare Angle=0
#while (Angle<=360)
     object { BalloonPiece
              pigment { NeonPink}
              finish { ambient 0.1 }
              rotate y*Angle
             }
     object { BalloonPiece
              pigment { NeonBlue }
              finish { ambient 0.1 }
              rotate y*(Angle+18)
            }

     #declare Angle=Angle+36
#end

    cone { <0, -4.5, 0>, 2, <0,-6, 0>,1.3
           open
           pigment { NeonPink }
        }

    }

#declare Balloon2 =
union {
       #declare Angle=0
       #while (Angle<=360)
          object { BalloonPiece
                   rotate y*Angle
                 }
          object { BalloonPiece
                   rotate y*(Angle+18)
                 }

          #declare Angle=Angle+36
       #end

       cone { <0, -4.5, 0>, 2, <0,-6, 0>,1.3
              open
            }


     }
     
#declare Man=
union {
       sphere { <0,0,0>,1
                pigment { Black }
                finish { Shiny }
              }
       difference {
                   sphere { <0,0,0>,1.2
                            pigment { White }
                            finish { Shiny }       
                          }
                          
                   superellipsoid { <0.2,0.5>
                                    scale <0.8,1,1>
                                    translate <0,-0.5,-1>
                                  }
                  }               
      }
      
/**************************** End of making the balloons **************************/
sky_sphere {
           pigment {
                    gradient y
                    color_map {
                               [0 color SummerSky]
                               [0.5 color Blue]
                               [1 color MidnightBlue]
                              }
                   }
           pigment {
                    bozo
                    turbulence 0.85
                    omega 0.8
                    color_map {
                               [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                                        color rgb <0.75, 0.75, 0.75> ]
                               [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                                        color rgbt <1, 1, 1, 1> ]
                               [0.5 0.8 color rgbt <1, 1, 1, 1>
                                        color rgbt <1, 1, 1, 1> ]
                              }
                     scale <0.4 , 0.3, 0.2>
                   }



           }  // end of sky_sphere

plane { y,-15
        pigment { SummerSky }

        normal { waves 0.08
                 scale <2,1,1>
               }
        finish { reflection 0.2 ambient 0.1 }
      }



#declare Balloon1Basket =
union {
        object { Balloon1 }
        object { Basket
                 texture{
                         pigment{ DarkTan }
                         normal{
                                quilted 0.4
                                control0 1 control1 1
                                scale 0.2
                               }
                        }
                }
        object { Man
                 scale 0.3
                 translate <0,-8.8,0>
               }           

      }


#declare Balloon2Basket =
union {
       object { Balloon2 }
       object { Basket
                 texture{
                         pigment{ DarkTan }
                         normal{
                                quilted 0.4
                                control0 1 control1 1
                                scale 0.2
                               }
                        }
                }
        object { Man
                 scale 0.3
                 translate <0,-8.8,0>
               }           

      }

object { Balloon1Basket
         translate <0,27,30>
       }


object { Balloon2Basket
        pigment {
                 gradient y
                 color_map {
                            [0.00 color Red]
                            [0.33 color Blue]
                            [0.66 color Yellow]
                            [1.00 color Red]
                           }
                }
        finish { ambient 0.1 }
        translate <-6,29,5>
       }

object { Balloon2Basket
         pigment{image_map{gif "c:\pov-ray\images\pattern2.gif"}  scale 3}
         finish { ambient 0.1 }
         translate <-10,25,-3>
       }


object { Balloon2Basket
         pigment{image_map{gif "c:\pov-ray\images\pattern2.gif"}  scale 3}
         finish { ambient 0.01 }
         translate <20,30,30>
       }


object { Balloon2Basket
         pigment {
                 average
                 pigment_map {
                            [ gradient y
                             color_map {
                                        [0.00 color HuntersGreen]
                                        [0.33 color Blue]
                                        [0.66 color Yellow]
                                        [1.00 color HuntersGreen]
                                      } ]

                            [ gradient x
                             color_map {
                                        [0.00 color HuntersGreen]
                                        [0.33 color Blue]
                                        [0.66 color Yellow]
                                        [1.00 color HuntersGreen]
                                       } ]
                                }
                }

         finish { ambient 0.1 }
         translate <9,25,-8>
       }


#declare dolphin=
union {
blob {
      threshold 0.3
      sphere { <0,0,0>, 1,1
               scale <3,1,0.8>
             }

      sphere { <2.5,1,0>, 2,1
                scale <1, 0.3,0.3>
                rotate z*-15
              }
      sphere { <-2.3,1,0>, 1,1
                scale <1, 0.3,0.3>
                rotate z*15
              }
      sphere { <-1.9,0,0>, 0.6,1
                
                scale <1, 1,0.8>
              }
     }
union {
       difference {
                   sphere { <-0.3,0.7,0>,0.6
                            scale <1,1,0.2>
                          }
                   sphere { <0.1,0.85,0>,0.4 }
                  }

      }

}


object { dolphin
         pigment { Grey }
         scale 1.5
         translate <6,-13,150>
         rotate z*-15
       }

object { dolphin
         pigment { Grey }
         scale 1.5     
         translate <-10,-15,130>
         rotate z*-20
       }

object { dolphin
         pigment { Grey }
         scale 1.5     
         translate <-10,-14,180>
         rotate z*-20
       }       

object { dolphin
         pigment { Grey }
         scale 1.5     
         translate <15,-10,130>
         rotate z*-15
       }
       
 sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 1, 1,  1> ]
        [ 1 color rgbt <1, 1, 1, -1> ]
      }
      samples 10
    }
    hollow
    scale <2.5,2.2.5>
    translate <-10,-15,130>

  }       
sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 1, 1,  1> ]
        [ 1 color rgbt <1, 1, 1, -1> ]
      }
      samples 10
    }
    hollow
    scale <2.5,2.2.5>
    translate <-10,-15,180>

  }       

sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 1, 1,  1> ]
        [ 1 color rgbt <1, 1, 1, -1> ]
      }
      samples 10
    }
    hollow
    scale <2.5,2.2.5>
    translate <14,-15,130>

  }       

sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 1, 1,  1> ]
        [ 1 color rgbt <1, 1, 1, -1> ]
      }
      samples 10
    }
    hollow
    scale <2.5,2.2.5>
    translate <4,-15,150>

  }       
