fog {
color rgb < .6,.5,.5>
distance 50000
//turbulence .2
scale 100000
}

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
/*  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }*/
}

//background { color <0,.7,.4> }

camera {  //  Camera Camera01
  location  <35, -30, 2113>
  direction <0.0,     0.0,  1.27>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-2, 40, 2107>
}

light_source {   // Light001
  <1500,1900,3000>
  color rgb <1.200, 1.200, 1.1000>
}

sphere { <0,0,-6400000>,6400000
texture {
  pigment {
    color rgb < .2,.3,.75>
  }
  normal {
      waves 0.05
      frequency 5000
      turbulence 1.0
      scale 3000
  }
  finish {
    reflection .7
  }
}
}


sphere { <0,0,-6400000>,6402500
texture { //wolken
  pigment {
    marble
    turbulence 1.4
    color_map {
      [ 0.0 color rgbf <.9,.8,.8,.1> ]
      [ 0.1 color rgbf <.9,.8,.8,.2> ]
      [ 0.4 color rgbf <.9,.8,.8,.9> ]
      [ 0.6 color rgbf <1,1,1,1>  ]
      [ 1.0 color rgbf <1,1,1,1> ]
    }
  }
  finish {
    ambient .65
  }
  scale <10000,13000,20000>
  rotate <0,40,50>
}
no_shadow
hollow
}

sphere { <0,0,-6400000>,6404000
texture { //hemel
  pigment {
//    color rgb < .3,.2,.9>
    marble
//    turbulence .2
    color_map {
    [0.0 color rgb <0,0,.6>]
    [0.9999 color rgb <.5,.2,.7>]
    [1.0 color rgb <.7,.4,.7>]
    }
  } 
  finish {
    ambient .7
  } 
  scale 6404000
}
hollow
no_shadow
}


//  $MRY$: 'Gold_Texture1'
#declare Gold_Texture1 = texture {
   pigment {
     color rgb<0.850, 0.850, 0.100>
   }
   finish {
     diffuse 0.700
     ambient 0.200
     phong 0.750
     phong_size 80.000
     reflection 0.250
     brilliance 6.000
   }

}



#declare Coppermirror = texture {
   pigment {
     color rgb<0.850, 0.530, 0.000>
   }
   finish {
     diffuse 0.400
     ambient 0.200
     reflection .7
     specular 0.400
     roughness 0.0200
     metallic
   }

}



//  $MRY$: 'Copper_Textur1'
#declare Copper_Textur1 = texture {
   pigment {
     color rgb<0.720, 0.450, 0.200>
   }
   finish {
     diffuse 0.700
     ambient 0.200
     phong 0.750
     phong_size 80.000
     reflection 0.250
     brilliance 6.000
   }

}



//  $MRY$: 'BB'
#declare BB = texture {
   pigment {
     color rgb<0.194, 0.195, 0.208>
   }
   finish {
     diffuse 0.500
     specular 0.400
     roughness 0.0200
     metallic
   }

}
texture {
pigment {
image_map {
gif "usaflogo.gif"
once
filter 14,1
map_type 0
}
scale <2,2,-1>
translate <-1,-1,0>
scale <4,3,1>
rotate <0,0,45>
translate <23,67,0>
}
}

texture {
pigment {
image_map {
gif "usaflogo.gif"
once
filter 14,1
map_type 0
}
scale <2,2,-1>
translate <-1,-1,0>
scale <4,3,1>
rotate <0,0,-45>
translate <-23,67,0>
}
}

texture {
pigment {
image_map {
gif "usaflogo.gif"
once
filter 14,1
map_type 0
}
scale <2,2,-1>
translate <-1,-1,0>
scale <4,.5,1>
rotate <0,0,90>
translate <1.35,50,0>
}
}

texture {
pigment {
image_map {
gif "usaflogo.gif"
once
filter 14,1
map_type 0
}
scale <2,2,-1>
translate <-1,-1,0>
scale <4,.5,1>
rotate <0,0,90>
translate <-1.35,50,0>
}
}

texture {
pigment {
image_map {
gif "usaftext.gif"
once
filter 14,1
map_type 0
interpolate 2
}
scale <2,2,-1>
translate <-1,-1,0>
scale <6,.3,1>
rotate <0,0,90>
translate <1.35,32,0>
}
}

texture {
pigment {
image_map {
gif "usaftext.gif"
once
filter 14,1
map_type 0
interpolate 2
}
scale <2,2,-1>
translate <-1,-1,0>
scale <6,.3,1>
rotate <0,0,-90>
translate <-1.35,32,0>
}
}
#declare Cone1 =
cone { 
  <0,0,0>, 0.0, <0,0,1>, 1.0
  texture {
    BB
  }
  scale <2.5, 2.5, 6.0>
  rotate -90.0*x
  translate  <16.0, 37.0, 0.0>
}

#declare Cone2 =
cone { 
  <0,0,0>, 0.0, <0,0,1>, 1.0
  texture {
    BB
  }
  scale <2.5, 2.5, 6.0>
  rotate -90.0*x
  translate  <-16.0, 37.0, 0.0>
}

