
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: YONI GROPPER & NILI IFERGAN


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"
#include "GLASS.INC"

light_source{
<2,7,0>
color White
}
//light_source{
//<29,7,0.7>
//color White
//}
//light_source{
//<17.5,3.7,0>
//color White
//}
//light_source{
//<17.5,3.7,0>
//color White
//}
#declare tree_texture_1=
texture{
	pigment{
		gradient y
		color_map{
			[0.0, 0.4 color ForestGreen color LimeGreen]
			[0.4, 0.8 color LimeGreen color Clear]
			[0.8, 1.0 color Clear color ForestGreen]
		}
		turbulence 2.0
	}
	normal{
		bumps .5 scale .4
	}
}

#declare tree_texture_2=
texture{
	pigment{
		gradient y
		color_map{
			[0.0, 0.4 color Clear color DarkGreen]
			[0.4, 0.8 color DarkGreen color HuntersGreen]
			[0.8, 1.0 color HuntersGreen color Clear]
		}
		turbulence 2.0
	}
	normal{
		bumps .5 scale .4
	}
}

#declare tree_texture_3=
texture{
	pigment{
		gradient y
		color_map{
			[0.0, 0.4 color Clear color White]
			[0.4, 0.8 color White color HuntersGreen]
			[0.8, 1.0 color HuntersGreen color Clear]
		}
		turbulence 2.0
	}
	normal{
		bumps .5 scale .4
	}
}
// *******  T E X T U R E S  *******

//  $MRY$: 'Flame_Tex'
#declare Flame_Tex = texture {
   pigment {
   gradient < 0.0 0.0 1.0 >
   turbulence 0.15
   colour_map {
      [0.0 0.2  colour White
      colour red .8 green .4 blue 0]
      [0.20 0.6 colour red .8 green 0.4 blue 0
      colour red 1.0 green 1.0 blue 1.0 filter 1]
      [0.6 1.0 colour Clear
      color Clear]
        }
      }
   finish {
   ambient 1
   phong 0 }

}

#declare SolarWind =
pigment
{ bozo
  turbulence 10
  octaves -2
  lambda -6
  omega -2
color_map
{ [-1.2, 0.8 color Firebrick color Orange]
  [0.0, 1.0 color Orange color Orange ]
  [0.2, 1.2 color Firebrick color  Orange]
  }
  }


#declare sampletexture = texture {
  pigment { SolarWind }
  finish { specular 1.0
           roughness 0.002
           metallic
           brilliance 3.0
         }
}





camera{
location<-20,12,-21>
look_at<-6,3,-9>
}
//**********************************
sky_sphere{S_Cloud1}

//************************************
#declare p = union {



//***nose of craft
cone{
<-5.5,2,0>0.2
<0,2,0>1.3
texture{T_Silver_1A}
finish{metallic} //brilliance 0.5}
}

//***nose nose
cylinder{
<-5,2,0>
<-8,2,0>
0.09
texture{T_Silver_1A}
finish{metallic}
}
cone{
<-8,2,0>0.05
<-9,2,0>0.0001
texture{T_Gold_1A}
}

//***main body of craft
cylinder{
<0,2,0>
<19,2,0>
1.3
texture{T_Silver_1A}
finish{metallic} //brilliance 0.5}
}

//*******aero strip
cone{
<14,3,0>0.8
<17,3,0>0.001
texture{T_Silver_1A}
}
//**afterburner (fire)
//cone{
//<19,2,0>1.6
//<25,2,0>1
//pigment{SolarWind}
//finish{ brilliance 0.5}
//}

//glasssssssssssssssss
cone{
<-0.5,3,0>0.5
<3,3.5,0>1
texture{T_Glass1}
finish{reflection 0.6 brilliance 0.5}
}
 //^^^^^^^^^^^^^^^^^^^aero dynamic piece at begining of craft^^^^^^^^^^^^^
 cone{
 <-0.5,3,0>0.5
 <-2.1,2.5,0>0.1
 texture{T_Silver_3A}
 }
cylinder{
<3,3.5,0>
<6,3.5,0>
1
texture{T_Glass1}
finish{reflection 0.6}
}
cone{
<6,3.5,0>1
<9,3.5,0>0.3
texture{T_Glass1}
finish{reflection 0.6}
}
//**end of tail wing

//FIRRRRREEEE!

//******box at end cockpit****
 box{
<6,3,-2>
<17,3,2>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
//***down box
 box{
<6,1.7,-2>
<17,1.7,2>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
//**left box
 box{
<6,3,-2>
<17,1.7,-2>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
 box{
<6,3,2>
<17,1.7,2>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}

//*****experimental******
box{
<6,3.5,-3>
<19.5,1.7,3>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
//**end of plane
box{
<17,3.5,-3>
<26,2.9,-2.5>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
box{
<17,3.5,3>
<25,2.9,2.5>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
//**end of plane
box{
<17,3.5,3>
<23,2.9,2.5>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
//******upright wing at end
triangle{
<17,3.4,-3>
<23,3.4,-3>
<23,7,-3>
texture{T_Silver_1A}
}
box{
<23,3.5,-3>
<25,7,-3>
texture{T_Gold_1A}
}
box{
<23,3.5,3>
<25,7,3>
texture{T_Gold_1A}
}
triangle{
<17,3.4,3>
<23,3.4,3>
<23,7,3>
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
//*****aero stripes at end of tail wing
cylinder{
<22,7,3>
<25,7,3>
0.1
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
cone{
<22,7,3>0.1
<21.5,7,3>0.01
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}

cylinder{
<22,7,-3>
<25,7,-3>
0.1
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
cone{
<22,7,-3>0.1
<21.5,7,-3>0.01
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}

//***burners
cone{
<18,2.5,-1>1.1
<22,2.5,-1>0.5
texture{SolarWind}
}


//********next burner
cone{
<18,2.5,1>1.1
<22,2.5,1>0.5
texture{SolarWind}
}
//**near triangle vec
triangle{
<6,3,-3>
<6,1.8,-3>
<3,3.2,-3>
texture{T_Gold_3A}
finish{metallic brilliance 0.5}
}
//******top triangle vec
box{
<3,3.2,-3> //                       qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
<6,3.2,0>
pigment{SolarWind}
}
//######################@hoods of vectors@
#declare temp = 0.1
#while (temp < 2.2)
triangle{
<2.5,3,-1-temp>
<6,3.5,-1-temp>
<6,3,-1-temp>
texture{T_Silver_1A}
}
#declare temp = temp+0.1
#end
//@@@@far hood on vector
#declare temp = 0.1
#while (temp < 2.2)
triangle{
<2.5,3,1+temp>
<6,3.5,1+temp>
<6,3,1+temp>
texture{T_Silver_1A}
}
#declare temp = temp+0.1
#end
###############
//***far triangle vec
triangle{
<6,3,3>
<6,1.8,3>
<3,3.2,-3>
texture{SolarWind}
finish{metallic brilliance 0.5}
}
//**far top triangle vec
box{
<3,3.2,3>
<6,3,0>
pigment{SolarWind} //                 qqqqqqqqqqqqqqqqqqq//
}
//*****************main upper body&&&&&&&&&&&&&*****
cone{
<6,3.4,0>0.7
<17,3.4,0>0.001

texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
// ****main triangle <3,2.3,0><17.5,2.3,-9><17.5,2.3,9>
triangle{
<2,3,0>
<15.5,3.5,-10.5>
<15.5,3.5,10.5>
texture{T_Silver_1A}
finish{metallic brilliance 0.6}
}
//******flipers on main wings
box{
<15.5,3.5,-10.5>
<16.9,3.5,10.5>
texture{T_Gold_3A}
}
//silver piece at middle
box{
<15.5,3.5,4.5>
<16.9,3.5,-4.5>
texture{T_Silver_1A}
}
//##########################################missiles
//forward (near missile)
cylinder{
<14.5,3.5,-10.5>
<17.5,3.5,-10.5>
0.15

texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
cone{
<14.5,3.5,-10.5>0.15
<12.5,3.5,-10.5>0.0001
pigment {color Red}
}

//###far  missile ##
cylinder{
<14.5,3.5,10.5>
<17.5,3.5,10.5>
0.15
texture{T_Silver_1A}
finish{metallic brilliance 0.5}
}
triangle{
<15.5,3.5,10.5>
<17.5,4,10.5>
<17.5,2,10.5>
texture{T_Silver_1A}
}
cone{
<14.5,3.5,10.5>0.15
<12.5,3.5,10.5>0.0001
pigment {color Red}
}
triangle{
<15.5,3.5,-10.5>
<17.5,4,-10.5>
<17.5,2.9,-10.5>
texture{T_Silver_1A}
}

//############drop tanks
cylinder{
<5,-0.3,0>
<12,-0.3,0>
0.4
texture{SolarWind}
}

cone{
<5,-0.3,0>0.4
<3.5,-0.3,0>0.01
texture{SolarWind}
}
cone{
<12,-0.3,0>0.4
<13.5,-0.3,0>0.01
texture{SolarWind}
}
//###mountment of drop tank
box{
<6.5,-0.5,0>
<9.5,2,0>
texture{T_Silver_1A}
}
//#####mountment of flying rocket
box{
<12.3,3,-6>
<18,2.3,-6>
texture{T_Silver_1A}
}
//opossite mountment on far wing
box{
<12,3,6>
<18,2.3,6>
texture{T_Silver_1A}
}

//*****end wings
//***near wing
triangle{
<19,3.4,-3.5>
<22,3.4,-3.5>
<22,3.4,-6.5>
texture{T_Silver_3A}
}

//**far wing
triangle{
<19,3.4,3.5>
<22,3.4,3.5>
<22,3.4,6.5>
texture{T_Silver_3A}
}

box{
<22,3.4,6.5>
<24,3.4,3.5>
texture{T_Gold_3A}
}
box{
<22,3.4,-6.5>
<24,3.4,-3.5>
texture{T_Gold_3A}
}

//***fliper of
box{
<17.5,3.5,-8.5>
<19.5,3.5,-8.5>
texture{T_Gold_1A}
}
box{
<17.5,3.5,8.5>
<19.5,3.5,8.5>
texture{T_Gold_1A}
}




}



//plane{
//<0,0.01,0>0.0001
//texture{tree_texture_1}
//}
height_field {
  tga "image.tga"
 smooth
 texture{
 material_map{
 tga "image.tga"
 texture{T_Wood1}

 }
 scale 0.5
 }

 //finish{crackle 1 scale 0.8 }
    translate <-.7, -2.7,-.5>
    scale <1235,21.6, 1525>
}
  /*
  fog {
    distance 150
    colour rgb<0.3, 0.5, 0.3>
    fog_type 2
    fog_offset 25
    fog_alt 1
    turbulence 0.5
    turb_depth 0.2
  }

  fog {
    distance 150
    colour rgb<0.4, 0.1, 0.4>
    fog_type 2
    fog_offset 15
    fog_alt 4
    turbulence 0.2
    turb_depth 0.2
  }
*/
#declare rocket = union{
//#########fire
#declare temp=-1
#while (temp<5)
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
     spherical_mapping
    linear
    turbulence 2
  color_map {
[ 0.0 color rgbt <1, 0, 0,  1> ]
[ 0.5 color rgbt <1, 1, 0, -1> ]
[ 1.0 color rgbt <1, 0, 0, 1> ]
}
frequency 1
 samples 20
 scale 0.5
}
hollow

  translate <-5.2+temp,0.28,-2.9>}
  #declare temp=temp+7
    #end

//@@@@@@@fire for rocket
#declare temp=2.5
#while (temp<10)
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
     spherical_mapping
    linear
   turbulence 2.5
  color_map {
  [0.0 color rgbt<1,0,0,1>]
  [0.5 color rgbt<1,1,0,-1>]
  [1.0 color rgbt<1,0,0,1>]
  //[0 color rgbt <1,0,0,1>]
  // [ 0.0 color rgbt <1, 0, 1,  1> ]
//[ 0.5 color rgbt <1, 1, 1, 1> ]
//[ 1.0 color rgbt <9, 2, 0, -2> ]
//[1 color rgbt <9,9,9,-2>]


}
 samples 20
 scale 0.5
}
hollow
scale 1.5

  translate <-7.2+temp,0.28,-2.7>}
  #declare temp=temp+2
    #end
//////////    //smoke for rocket
//smoke black
    #declare temp=2.6
#while (temp<75)
 sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1.3> }
 halo {
  emitting
 spherical_mapping
 linear
 turbulence 1.8
 color_map {
  [0 color rgbt <1,1,0,1>]
///// //  [ 0.0 color rgbt <1, 1, 0,1> ]
[ 0.5 color rgbt <3, 1, 1, 1> ]
////[ 1.0 color rgbt <9, 9, 0, 9> ]//
[1 color rgbt <9,9,9,-2>]

}
samples 20
 scale 0.5
}
hollow

 translate <-3.5+temp,0.58,-2.9>}
 #declare temp=temp+2
    #end
 cylinder{
 <-5.2,0.58,-2.3>
 <40,0.58,-2.3>
  0.47
 texture{T_Glass1}
finish{reflection 0.9}
  }

//smoke,,,,,,,,,
    #declare temp=2.6
#while (temp<75)
 sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
 halo {
  emitting
 spherical_mapping
 linear
 turbulence (0.2+(temp/5))
 color_map {
 [0.5 color Gray60]
//  [0 color rgbt <1,1,0,1>]
///// //  [ 0.0 color rgbt <1, 1, 0,1> ]
//[ 0.5 color rgbt <3, 1, 1, 1> ]
////[ 1.0 color rgbt <9, 9, 0, 9> ]//
//[1 color rgbt <9,9,9,-2>]

}
samples 20
 scale 0.5
}
hollow

 translate <-4.5+temp,0.58,-2.9>}
 #declare temp=temp+2
    #end


/*light_source{      //      kkkkkkkkkkkkkkkkkk
<17.5,3.7,0>
color White
}
light_source{
<17.5,3.7,0>
color White
}*/
//light_source{
//<17.5,3.7,0>
//color White
//}
//light_source{
//<17.5,3.7,0>
//color White
//}
//light_source{
//<17.5,3.7,0>
//color White
//}
//light_source{
//<17.5,3.7,0>
//color White
//}
//light_source{
//<17.5,3.7,0>
//color White
//}
// light_source{
//<-1,2,-1.5>
// color White
// }


//light_source{
//<-19,3,9>
//color White       //TTTTTTTTTTTTTTTTTTTTTTTTT
//}
//light_source{
//<19,3,9>
// color White
//}


//light_source{
//<19,3,-9>
// color White
// }
 //***light for burner
//light_source{
//<26,3,1>
//color White
//}
//light_source{
//<26,3,1>
//color White
//}
//light_source{
//<26,3,1>
//color White
//}
//light_source{
//<2,3.5,-3>
//color White
//}
//light_source{
//<22,4.5,-3>              kkkkkkkkkkkkkkkkk
//color White
//}
light_source{
<-12,3,-7.3>
color White
}
/*light_source{
<-4,2.3,0>
color White
}

//light_source{
//<3,2,-1>
//color White
//}*/
//light_source{
//<14.5,4,-10.5>
//color White
//}
//light_source{
//<14.5,4,10.5>
//color White
//}
//light_source{
//<22,4.5,-3>
//color White      kkkkkkkkkkkkkkkkkkkkkkk
//}

//flying rocket
cylinder{
<-12,3,-7>
<-10,3,-7>
0.1
texture{T_Silver_1A}
}
triangle{
<-11,3,-7>
<-10,2.7,-7>
<-10,3.3,-7>
texture{T_Silver_1A}
}
triangle{
<-11,3,-7>
<-10,2.6,-7.3>
<-10,3.4,-6.7>
texture{T_Silver_5A}
}

cone{
<-12,3,-7>0.1
<-12.4,3,-7>0.02
pigment {color Red}
}

}

object{p
translate<0,-6,30>
rotate<3,0,10>
}
object{p
translate<-2,-6,-17>
rotate<3,0,10>
}
//object{p
//translate<0,0,0>
//rotate<0,70,0>
//}
//light_source{
//<0,9,0>
//color White
//}
/*
light_source{
<17.5,9,0>
color White
}
*/
//object{p
//translate<1,5,1>
//rotate<7,290,0>
//}

object{p
translate<30,4,3>
rotate<-10
,0,0>
}
object{rocket
translate<2,3,-3>
}

light_source{
<30,6,1>
color White
}
light_source{
<20,7,30>
color White
}
light_source{
<50,5,50>
color White
}

