
// PAJARO

// Texturas

#declare tPajaro3 = texture {
   pigment {
     gradient x
     color_map {
       [ 0  rgb<0.000, 0.000, 0.000> ]
       [ 0.115  rgb<1.000, 0.273, 0.000> ]
       [ 0.144  rgb<1.000, 0.314, 0.000> ]
       [ 0.230  rgb<0.000, 0.000, 0.000> ]
       [ 0.397  rgb<0.000, 0.000, 0.000> ]
       [ 0.414  rgb<1.000, 1.000, 1.000> ]
       [ 0.79  rgb<1.000, 1.000, 1.000> ]
       [ 0.81  rgb<0.000, 0.000, 0.000> ]
       [ 1.  rgb<0.000, 0.000, 0.000> ]
     }
   }
   normal { bumps 1 }
   finish { diffuse .7 }
}

#declare tPajaro1 = texture {
   pigment { rgb 0 }
   finish { diffuse .7 }
}

#declare tOjo = texture {
   pigment { rgb 0 }
   finish {
     diffuse 1
     ambient .2
     specular 1 roughness .01
     }
}

#declare tPico = texture {
   pigment { rgb 0 }
   finish {
     diffuse 1
     ambient .2
     phong .2 phong_size 40
     }
}

#declare tPajaro2 = texture {
   pigment {
     gradient x
     color_map {
       [ 0.000 rgb<0.000, 0.000, 0.000> ]
       [ 0.716 rgb<0.000, 0.000, 0.000> ]
       [ 0.824 rgb<0.750, 0.157, 0.000> ]
       [ 1.000 rgb<0.875, 0.421, 0.000> ]
     }
   }
   finish { diffuse .8 }
}

#declare tPlumas = texture {
   pigment {
     image_map {
       gif "plumas2.gif"
       map_type 0
       transmit 53, 1
       interpolate 2
     }
     scale 2
     translate -1
   }
   finish { diffuse .5 ambient .15 }
}

#declare tAgua2 = texture {
   pigment { rgbt<0, .1, .2, 1> }
     finish {
    reflection 0.6
    refraction 1
    ior 1.5
    specular 1 roughness .005 }
}

#declare tCola = texture {
   pigment {
     image_map {
       gif "cola.gif"
       map_type 0
       transmit 5, 1
       interpolate 2
     }
   }
   finish { diffuse .7 }
}

// Objetos

#declare Pa1 = union {
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 2.0>
    rotate <0.0, 90.0, 0.0>
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.6>
    rotate <10.0, 65.0, 0.0>
    translate  <1.51, 0.1, -0.24>
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.6>
    rotate <-10.0, 65.0, 0.0>
    translate  <1.51, -0.11, -0.24>
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.6>
    rotate <-5.0, -65.0, 0.0>
    translate  <1.59, -0.11, -0.24>
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.6>
    rotate <5.0, -65.0, 0.0>
    translate  <1.59, 0.09, -0.24>
  }
  texture { tPajaro1 }
  rotate <0.0, 15.0, -5.0>
  translate  <-7.36, -0.52, -0.43>
}

#declare CsgBoca = difference {
  sphere { 0, 1
    texture { tPajaro2
      scale <1.570421, 1.0, 0.871072>
      rotate 49.045986*y
  translate <-0.474655, 0, 0.619330>
    }
    scale <1.5, 1, 1>
    translate  -.3*x
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tPajaro1 }
    rotate -9.516129*y
    translate  <1.260122, 0.0, -1.260734>
  }
}

#declare Tronco = union {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.776625, 0.000000, -1.053577>, <-1.776625, -1.416309, -1.053577>, <-1.735736, -1.416309, 1.051611>, <-1.735736, 0.000000, 1.051611>,
      <-3.048485, 0.000000, -0.959986>, <-3.048485, -1.494587, -0.959986>, <-3.027384, -1.494587, 1.062334>, <-3.027384, 0.000000, 1.062334>,
      <-7.383203, 0.000000, -2.181452>, <-7.383203, -1.322831, -2.181452>, <-4.658667, -1.322831, 1.686780>, <-4.658667, 0.000000, 1.686780>,
      <-11.456050, 0.000000, 1.455734>, <-11.456050, -1.129481, 1.455734>, <-11.451481, -1.129481, 1.452425>, <-11.451481, 0.000000, 1.452425>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.735736, 0.000000, 1.051611>, <-1.735736, 1.416309, 1.051611>, <-1.776625, 1.416309, -1.053577>, <-1.776625, 0.000000, -1.053577>,
      <-3.027384, 0.000000, 1.062334>, <-3.027384, 1.494587, 1.062334>, <-3.048485, 1.494587, -0.959986>, <-3.048485, 0.000000, -0.959986>,
      <-4.658667, 0.000000, 1.686780>, <-4.658667, 1.322831, 1.686780>, <-7.383203, 1.322831, -2.181452>, <-7.383203, 0.000000, -2.181452>,
      <-11.451481, 0.000000, 1.452425>, <-11.451481, 1.129481, 1.452425>, <-11.456050, 1.129481, 1.455734>, <-11.456050, 0.000000, 1.455734>
    }
  texture { tPajaro3
    scale <8.737592, 1, .768557>
    rotate 29*y
  translate <-10.188283, 0, 1.137388>
  }
}

#declare Cuerpo = union {
  object { CsgBoca }
  object { Tronco }
}
#declare BzPtch2 = bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.130761, 0.922476, -0.406552>, <0.181411, 0.858357, -0.662437>, <0.462730, 0.610746, -0.788002>, <0.750092, 0.277463, -1.129267>,
      <-0.476264, 0.617266, -1.204360>, <0.305076, 0.616570, -1.213792>, <0.593243, 0.292964, -1.314179>, <1.089495, 0.039447, -1.550632>,
      <-0.478826, -0.689015, -1.199431>, <0.302515, -0.689711, -1.208863>, <0.591979, -0.305013, -1.314657>, <1.089325, -0.041230, -1.550697>,
      <0.127360, -0.889558, -0.395205>, <0.178010, -0.828126, -0.629654>, <0.460176, -0.641532, -0.754487>, <0.749296, -0.188569, -1.129956>
  texture { tPajaro2
    scale <1.85219, 1.0, 0.872457>
    rotate -41.658958*y
  translate <1.066827, 0, 0.208458>
  }
}
#declare BzPtch001 = bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.041540, -0.821503, -0.555446>, <0.662246, -0.884201, -0.401051>, <1.239690, -0.568330, -0.485921>, <1.404365, -0.014519, -0.505968>,
      <1.570197, -0.572295, 0.297840>, <1.462754, -0.330324, -0.132023>, <1.691887, -0.194647, -0.218857>, <1.956572, -0.035842, -0.652902>,
      <1.570197, 0.568635, 0.297840>, <1.462754, 0.328211, -0.132023>, <1.691887, 0.193402, -0.218857>, <1.956572, 0.025556, -0.652902>,
      <-0.041540, 0.850618, -0.555446>, <0.662246, 0.886119, -0.401051>, <1.239690, 0.569563, -0.485921>, <1.404365, 0.014277, -0.505968>
  texture { tPico }
}

#declare BzPtch002 = bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-20.575934, -2.934315, 2.899965>, <-10.187625, -1.109742, 1.292969>, <-7.552117, -1.173640, 1.041061>, <-4.521037, -1.033975, 0.876413>,
      <-20.554974, -0.846270, 2.895405>, <-10.179559, -0.380446, 1.309468>, <-7.552117, -0.900947, 2.431232>, <-4.521037, -0.847470, 1.571592>,
      <-20.554974, 0.806344, 2.895405>, <-10.179559, 0.320858, 1.309468>, <-7.552117, 0.922413, 2.431232>, <-4.521037, 0.844462, 1.571592>,
      <-20.575934, 2.838291, 2.899965>, <-10.187625, 0.994168, 1.292969>, <-7.552117, 1.132800, 1.041061>, <-4.521037, 1.052224, 0.876413>
    texture { tCola
    scale <16.137598, 5.885028, 1.0>
  translate <-20.577026, -3.020391, 0>
  }
}

#declare Ala1 = union {
     bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.367894, -0.744931, 0.177870>, <-4.138892, -1.033202, -0.227324>, <0.859812, -1.748623, -0.002953>, <-1.066416, -0.097682, 1.001014>,
      <-5.338257, -1.194549, 1.640585>, <-4.055085, -1.208371, 1.317597>, <-1.331134, -1.029251, 1.952141>, <-2.421838, -1.102846, 2.207881>,
      <-5.028892, -3.717104, 1.261858>, <-3.389994, -3.747657, 1.073672>, <-0.582236, -3.688722, 1.436676>, <-1.714843, -3.637428, 1.752616>,
      <-1.859226, -5.894546, 1.928083>, <-1.858771, -5.894561, 1.927997>, <-1.857934, -5.894533, 1.928163>, <-1.858272, -5.894508, 1.928307>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.066416, -0.097682, 1.001014>, <-2.992643, 1.553258, 2.004982>, <-6.596896, -0.456660, 0.583064>, <-5.367894, -0.744931, 0.177870>,
      <-2.421838, -1.102846, 2.207881>, <-3.512542, -1.176440, 2.463621>, <-6.621428, -1.180726, 1.963572>, <-5.338257, -1.194549, 1.640585>,
      <-1.714843, -3.637428, 1.752616>, <-2.847451, -3.586133, 2.068555>, <-6.667790, -3.686551, 1.450044>, <-5.028892, -3.717104, 1.261858>,
      <-1.858272, -5.894508, 1.928307>, <-1.858609, -5.894483, 1.928451>, <-1.859682, -5.894532, 1.928169>, <-1.859226, -5.894546, 1.928083>
    }
  texture { tPajaro1 }
}

#declare Ala1B = bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.982407, -14.324981, 3.889364>, <-4.608186, -14.053395, 3.886381>, <-2.837670, -13.845856, 3.889364>, <0.337191, -13.466907, 3.889364>,
      <-8.017997, -5.865142, 0.628662>, <-4.940588, -5.807167, 0.628662>, <-2.666890, -5.807167, 0.628662>, <-0.630627, -5.807167, 0.628662>,
      <-8.017997, -5.426406, 3.034562>, <-4.940588, -5.368432, 3.034562>, <-2.727092, -5.368432, 2.853955>, <-0.630627, -5.368432, 3.034562>,
      <-8.505481, -0.510528, 1.001707>, <-4.621552, -0.510528, 1.691384>, <-3.046582, -0.547017, 1.436533>, <-1.811670, -0.557651, 1.188090>
    texture { tPlumas
    scale <3.8, 7.0, 1.0>
    rotate <180.0, 0.0, 6.5>
  translate <-4.121666, -7.036898, 0.093745>
  }
}
#declare Ala2 = union {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.921079, -0.344017, 1.221732>, <-3.245262, -0.996122, 1.985039>, <0.934495, 1.122492, 0.004536>, <-1.304226, 1.042657, -0.108558>,
      <-5.338257, 1.092369, 2.248022>, <-4.055085, 0.986841, 2.528867>, <-1.682599, 1.496946, 1.978798>, <-2.597571, 1.368626, 1.621482>,
      <-5.028892, 3.488551, 1.822882>, <-3.389994, 3.493149, 2.013477>, <-0.582236, 3.484279, 1.645827>, <-1.714843, 3.476558, 1.325843>,
      <-1.859226, 5.950281, 1.798117>, <-1.858771, 5.950284, 1.798204>, <-1.857934, 5.950278, 1.798037>, <-1.858272, 5.950273, 1.797891>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.304226, 1.042657, -0.108558>, <-3.542948, 0.962821, -0.221651>, <-6.596896, 0.308087, 0.458426>, <-4.921079, -0.344017, 1.221732>,
      <-2.597571, 1.368626, 1.621482>, <-3.512542, 1.240306, 1.264166>, <-6.621428, 1.197898, 1.967177>, <-5.338257, 1.092369, 2.248022>,
      <-1.714843, 3.476558, 1.325843>, <-2.847451, 3.468838, 1.005860>, <-6.667790, 3.483952, 1.632287>, <-5.028892, 3.488551, 1.822882>,
      <-1.858272, 5.950273, 1.797891>, <-1.858609, 5.950268, 1.797745>, <-1.859682, 5.950278, 1.798030>, <-1.859226, 5.950281, 1.798117>
    }
  texture { tPajaro1 }
}

#declare Ala1B1 = bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.616301, 0.393489, 1.000303>, <-5.300424, 0.368425, 1.720779>, <-3.054664, 0.409780, 1.437464>, <-1.863726, 0.386269, 0.934488>,
      <-8.147885, 4.596900, 3.208864>, <-5.219465, 4.581988, 3.203504>, <-2.730305, 4.581988, 3.203504>, <-0.747136, 4.466147, 3.203504>,
      <-7.933173, 6.475296, 0.118203>, <-5.219465, 6.502135, 0.118203>, <-2.661229, 6.486851, 0.121006>, <-0.407803, 7.595381, 0.118203>,
      <-7.002537, 14.178883, 3.885316>, <-5.282730, 14.024834, 3.885124>, <-1.933451, 13.588048, 3.883800>, <0.312535, 13.242640, 4.494401>

  texture { tPlumas
    scale <3.8, 7.0, 1.0>
    rotate <0.0, 0.0, -6.5>
  translate <-4.143225, 6.900541, 2> }
}

#declare GotasA = blob {
  threshold 0.6
  component 1.0, 0.711875, <-0.379747, 0.092827, 0.0>
  component 1.0, 0.327749, <0.177215, -0.025316, 0.0>
  component 1.0, 0.319944, <0.616034, -0.413502, 0.0>
  component 1.0, 0.303734, <0.278481, -0.616034, 0.0>
  component 1.0, 0.224834, <0.666667, 0.379747, 0.0>
  component 1.0, 0.258803, <1.172996, -0.447257, 0.0>
sturm
  texture { tAgua2 }
  scale <1, .8, 1>
  rotate <90, 10, 0>
  translate  <1, 0, -1.2>
}

#declare PatasP = union {
  object { Pa1 }
  object { Pa1 rotate 10*z translate  <-0.2, 2.31, 0.0> }
}

#declare Pajaro = union {
  object { Cuerpo }
  object { BzPtch2 }

// error
  sphere { 0,1
  pigment  { rgb 0 }
  scale <.4,.4,.1>
  translate  <-2, 0, 1.1>
   }

  object { BzPtch001 }
  cone { <0,0,0>, 1.0, <0,0,1>, 1.05
    texture { tPajaro2
      scale <1.802061, 1.0, 0.941662>
      rotate -22.726168*y
  translate <0.595763, 0, 0.775740>
    }
    scale <1.0, 1.0, 1.5>
    rotate -90.0*y
    translate  -0.3*x
  }
  object { BzPtch002 }
  object { Ala1 }
  object { Ala1B }
  object { Ala2 }
  object { Ala1B1 }
  object { GotasA }
  sphere { 0,1 texture { tOjo } scale .21 translate  <.1, .91, .1> }
  object { PatasP }
  rotate -19*x
  translate  <0.5, 0.3, 3.2>
}

#declare GotasB = blob { threshold 0.6
  component 1.0, 0.891573, <-0.244726, -0.008439, -0.008439>
  component 1.0, 0.392655, <0.379747, 0.481013, -0.025316>
  component 1.0, 0.293147, <0.531646, 0.78481, 0.0>
  component 1.0, 0.5438, <0.548523, -0.092827, -0.008439>
  component 1.0, 0.537959, <-1.021097, -0.092827, 0.0>
  component 1.0, 0.216238, <0.953587, 0.818565, 0.0>
sturm
  texture { tAgua2 }
  scale <2, 1, 1>
  rotate 90*x
  translate  <-0.254588, 0.0, 0.093801>
}

#declare Gotas = union {
  torus { 2.0, 0.2  rotate -x*90
    texture { tAgua2 }
    scale <20.0, 1.0, 1.0>
    rotate -0.15*y
    translate  <-42.2, 0, -0.116679>
  }
  object { GotasB }
}

#declare Golon = union {
  object { Pajaro }
  object { Gotas }
  rotate -90*x
}
