//**************************************************************************
// Title                : Stranded
// Author               : Gautam N. Lad
// E-Mail Address       : gautam@interlog.com
// Website              : http://www.interlog.com/~gautam
// Date Rendered        : December 30, 1996
// Total Rendering Time : 1 hours  8 minutes  12.0 seconds (4092 seconds)
// Renderer             : POV-Ray v3.0.msdos.wat-cwa
//**************************************************************************

#include "colors.inc"
#include "textures.inc"

global_settings { assumed_gamma 1.5 }

camera {
    location <-4, 8.4, -43>
   direction <0, 0, 1.37374>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <-3.56765, 3.25, -3.95>
}

#declare BLACK = texture {
    pigment { color rgbf<0.2, 0.2, 0.2, 0>
    }
    finish {
        diffuse 0.6
        ambient 0.25
        reflection 0.1
        phong 1  phong_size 200
        specular 0.7  roughness 0.001
        metallic
    }
}

#declare SHINY_RED = texture {
    pigment { color rgbf<1, 0, 0, 0>
    }
    finish {
        diffuse 0.6
        ambient 0.25
        reflection 0.1
        phong 1  phong_size 200
        specular 0.7  roughness 0.001
        metallic
    }
}

#declare WET = texture {
    pigment { color rgbf<.9 .8 .6>
    }
    normal {
        bumps 0.8 scale 4.125
        }
    finish {
        reflection .07525
        ambient .055
        phong 1 phong_size 250
        specular .9
        brilliance .7
    }
}

#declare SILVER = texture {
    pigment { brick color rgb<.3 .01 .01>, color rgbf<0.7, 0.7, 0.7, 0>
    scale 1.8
    turbulence .8
    }
    finish {
        ambient 0.24
        phong 1  phong_size 250
        specular 0.75  roughness 0.05
        metallic
    }
    normal { bumps .25 scale .1 }
}

#declare GNL_FireSky =
texture {
	pigment { bozo
	color_map
	{
    [0.100 color rgbf<1.0 0.09090909 0.0 0.0>]
    [0.200 color rgbf<1.0 0.18181819 0.0 0.0>]
    [0.301 color rgbf<1.0 0.27272728 0.0 0.0>]
    [0.401 color rgbf<1.0 0.36363637 0.0 0.0>]
    [0.500 color rgbf<1.0 0.45454547 0.0 0.0>]
    [0.602 color rgbf<1.0 0.54545456 0.0 0.0>]
    [0.705 color rgbf<1.0 0.63636363 0.0 0.0>]
    [0.807 color rgbf<1.0 0.72727275 0.0 0.0>]
    [0.910 color rgbf<1.0 0.81818187 0.0 0.0>]
    [1.012 color rgbf<1.0 0.90909100 0.0 0.0>]
	}
    turbulence .65
	}
    finish { ambient .9 }
}

    plane { y, 0.0
        texture { GNL_FireSky scale 800 finish { ambient 1  }}
        translate <0, 1000, 0>
        no_shadow
        hollow
    }

    fog {
    distance 95
    fog_type 2
    fog_offset -2
    fog_alt 1
    color rgbf<.43 .1 .1 .375>
    turbulence .5
    }

    fog {
    distance 70
    fog_type 2
    fog_offset -2
    fog_alt 1
    color rgbf<.6 .2 .05 .285>
    turbulence .45
    }

    fog {
    distance 45
    fog_type 2
    fog_offset -2
    fog_alt 1
    color rgbf<.675 .4 0 .285>
    turbulence .45
    }

difference {  // Layer name: CUTBIG
    sphere { <0.0, 0.0, 0.0>, 12.5 
        scale <1, 0.03, 1>
        rotate <.0, 35.3112, .0>
        translate <-9.43403, 0, -0.652616>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 14 
        scale <1, 0.135, 1>
        rotate <.0, 35.3112, .0>
        translate <-13.5142, 0, 2.23747>
        // no_shadow
    }
    
    texture { SILVER scale 3.125 finish { ambient .25 } }
}

difference {  // Layer name: CUTBIG
    sphere { <0.0, 0.0, 0.0>, 12.5 
        scale <1, 0.03, 1>
        rotate <.0, 35.3112, .0>
        translate <-9.43403, .25, -0.652616>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 14 
        scale <1, 0.135, 1>
        rotate <.0, 35.3112, .0>
        translate <-13.5142, 0, 2.23747>
        // no_shadow
    }
    
    texture { SILVER scale .5 finish { ambient .5 } }
}

difference {  // Layer name: CUTBIG
    sphere { <0.0, 0.0, 0.0>, 12.5 
        scale <1, 0.03, 1>
        rotate <.0, 35.3112, .0>
        translate <-9.43403, .25, -0.652616>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 14 
        scale <1, 0.135, 1>
        rotate <.0, 35.3112, .0>
        translate <-13.5142, 0, 2.23747>
        // no_shadow
    }   
    texture { BLACK }
}

    height_field { tga "HFMAP.TGA"
        texture { GNL_FireSky scale .1125 finish { ambient .285 } }
        scale <650, 195, 75>
        translate <-177, -48, 160>
        // no_shadow     
    }
    light_source { <0,1000,150> color rgb <.3 .3 .3> shadowless }

union {  // Layer name: LIGHTS
    sphere { <0.0, 0.0, 0.0>, 0.25 
        texture { SHINY_RED }
        rotate <.0, 35.3112, .0>
        translate <6.47185, 0, -11.9333>
        // no_shadow
    }
    box { <0.0, 0.0, 0.0>, <1, 2, 1> 
        rotate <.0, 35.3112, .0>
        translate <-0.6849129, -3, -7.33149>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 1, 0.0>, 1.5  
        texture { Silver1 }
        scale <1, 0.5, 1>
        rotate <.0, .0, -270>
        rotate <.0, 35.3112, .0>
        translate <-1.61994, -3.5, -6.05646>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0.4  
        texture { BLACK }
        rotate <.0, .0, -90>
        rotate <.0, 35.3112, .0>
        translate <1.64416, -3.5, -8.36852>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 5, 0.0>, 0.65  
        texture { SILVER }
        rotate <.0, .0, -90>
        rotate <.0, 35.3112, .0>
        translate <-1.61994, -3.5, -6.05646>
        // no_shadow
    }
    torus { 1.5, 0.25 sturm 
        texture { BLACK }
        rotate <.0, .0, -257.125>
        rotate <.0, 35.3112, .0>
        translate <-0.6643121, 2.06245, -6.8645>
        // no_shadow
    }
    torus { 1.5, 0.25 sturm 
        texture { BLACK }
        rotate <.0, .0, -257.125>
        rotate <.0, 35.3112, .0>
        translate <-2.86134, 2.1362, -5.30827>
        // no_shadow
    }
    torus { 4, 0.25 sturm 
        texture { BLACK }
        scale <1, 1, 0.5>
        rotate <270, .0, .0>
        rotate <.0, .0, -355.815>
        rotate <.0, 35.3112, .0>
        translate <-2.09139, 1.62221, -5.85365>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 4 
        texture { Silver3 }
        scale <1, 0.5, 0.4>
        rotate <.0, .0, -355.815>
        rotate <.0, 35.3112, .0>
        translate <-2.10222, 1.51603, -5.84598>
        // no_shadow
    }
    torus { 2, 0.25 sturm 
        texture { SHINY_RED }
        rotate <.0, 35.3112, .0>
        translate <-1.17178, -7.5, -2.82868>
        // no_shadow
    }
    torus { 2, 0.25 sturm 
        texture { SHINY_RED }
        rotate <.0, 35.3112, .0>
        translate <-4.35088, -7.5, -7.31682>
        // no_shadow
    }
    box { <0.0, 0.0, 0.0>, <0.5, 2, 1> 
        texture { BLACK }
        rotate <.0, .0, 45>
        rotate <.0, 35.3112, .0>
        translate <-1.56458, -6.5, -2.5182>
        // no_shadow
    }
    box { <0.0, 0.0, 0.0>, <0.5, 2, 1> 
        texture { SHINY_RED }
        rotate <.0, .0, 45>
        rotate <.0, 35.3112, .0>
        translate <-5.3217, -6.5, -7.82236>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-3.11879, -8.5, -5.5774>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-4.3765, -8.5, -5.18539>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-5.62443, -8.5, -5.60752>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-6.3859, -8.5, -6.68254>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-6.37006, -8.5, -7.99983>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-5.58297, -8.5, -9.05624>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-4.32525, -8.5, -9.44824>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-3.07733, -8.5, -9.02611>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-2.31585, -8.5, -7.95109>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-2.33169, -8.5, -6.6338>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <0.8474061, -8.5, -2.14566>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <0.8632428, -8.5, -3.46296>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <0.1017696, -8.5, -4.53798>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-1.14616, -8.5, -4.96011>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-2.40387, -8.5, -4.5681>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-3.19097, -8.5, -3.5117>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-3.20681, -8.5, -2.19441>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-2.44533, -8.5, -1.11938>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <-1.19741, -8.5, -0.6972564>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0.5  
        texture { BLACK }
        rotate <.0, 35.3112, .0>
        translate <0.0603085, -8.5, -1.08926>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 3, 0.0>, 0.25  
        texture { BLACK }
        rotate <.0, .0, -90>
        rotate <.0, 35.3112, .0>
        translate <4.03037, 0, -10.1899>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.5 
        texture { SHINY_RED }
        rotate <.0, 35.3112, .0>
        translate <-10.2501, 0, -0.0745987>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2.5, 0.0>, 0.25  
        rotate <.0, .0, -270>
        rotate <.0, 35.3112, .0>
        translate <-8.20999, 0, -1.51964>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 0.5, 0.0>, 1.5  
        texture { SHINY_RED }
        scale <0.729, 0.729, 0.729>
        rotate <.0, .0, -270>
        rotate <.0, 35.3112, .0>
        translate <-10.0975, 0, -0.1826879>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 0.5, 0.0>, 1.5  
        texture { SHINY_RED }
        scale <0.81, 0.81, 0.81>
        rotate <.0, .0, -270>
        rotate <.0, 35.3112, .0>
        translate <-9.49115, 0, -0.6121548>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 0.5, 0.0>, 1.5  
        texture { SHINY_RED }
        scale <0.9, 0.9, 0.9>
        rotate <.0, .0, -270>
        rotate <.0, 35.3112, .0>
        translate <-8.86281, 0, -1.05723>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 0.5, 0.0>, 1.5  
        texture { SHINY_RED }
        rotate <.0, .0, -270>
        rotate <.0, 35.3112, .0>
        translate <-8.20999, 0, -1.51964>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 1, 0.0>, 1  
        texture { BLACK }
        rotate <90, .0, .0>
        rotate <.0, 35.3112, .0>
        translate <-3.33085, -3.5, -0.6866171>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 1, 0.0>, 1  
        texture { BLACK }
        rotate <90, .0, .0>
        rotate <.0, 35.3112, .0>
        translate <-7.66598, -3.5, -6.8068>
        // no_shadow
    }
    light_source {  <21.3029, 100, -144.97>
        color rgb<1, 1, 1>
    
        spotlight
        point_at <-1.56279, 0, -6.8408>
        radius 250
        falloff 300
        tightness 25
    }
    
    texture { SILVER }
}

difference {  // Layer name: CUT
    sphere { <0.0, 0.0, 0.0>, 4.5 
        scale <1, 0.1, 1>
        rotate <.0, 35.3112, .0>
        translate <-11.4741, 0, 0.7924273>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 4 
        rotate <.0, 35.3112, .0>
        translate <-13.9222, 0, 2.52648>
        // no_shadow
    }
    
    texture { SILVER }
}

merge {  // Layer name: MAIN
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 0.5, 0.0>, 1.5  
        rotate <270, .0, .0>
        rotate <.0, 35.3112, .0>
        translate <-0.1857515, 0, -2.30167>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        rotate <.0, 35.3112, .0>
        translate <-0.4747602, 0, -2.70968>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        rotate <.0, .0, 315>
        rotate <.0, 35.3112, .0>
        translate <-3.71617, -3.73607, -1.0264>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 5, 0.0>, 0.5  
        rotate <.0, .0, 45>
        rotate <.0, 35.3112, .0>
        translate <-0.8600875, -6.73607, -3.04946>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 2, 0.0>, 1.5  
        texture { Silver1 }
        rotate <270, .0, .0>
        rotate <.0, 35.3112, .0>
        translate <-3.04184, -3.5, -0.2786048>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 1, 0.0>, 2  
        rotate <.0, 35.3112, .0>
        translate <-1.17178, -8.5, -2.82868>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 2 
        rotate <.0, 35.3112, .0>
        translate <-1.17178, -7.5, -2.82868>
        // no_shadow
    }
    plane { y, 0.0 
        texture { WET }
        scale <200, 200, 200>
        translate <0, -8.5, 0>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 2 
        rotate <.0, 35.3112, .0>
        translate <-4.35088, -7.5, -7.31682>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 1, 0.0>, 2  
        rotate <.0, 35.3112, .0>
        translate <-4.35088, -8.5, -7.31682>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 2, 0.0>, 1.5  
        texture { Silver1 }
        rotate <270, .0, .0>
        rotate <.0, 35.3112, .0>
        translate <-6.22093, -3.5, -4.76674>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 5, 0.0>, 0.5  
        rotate <.0, .0, 45>
        rotate <.0, 35.3112, .0>
        translate <-4.03918, -6.73607, -7.5376>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        rotate <.0, .0, 315>
        rotate <.0, 35.3112, .0>
        translate <-6.89527, -3.73607, -5.51454>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        rotate <.0, 35.3112, .0>
        translate <-4.23187, 0, -8.01384>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 0.5, 0.0>, 1.5  
        rotate <270, .0, .0>
        rotate <.0, 35.3112, .0>
        translate <-4.23187, 0, -8.01384>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        rotate <.0, 35.3112, .0>
        translate <4.03037, 0, -10.1899>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 3, 0.0>, 1  
        rotate <.0, .0, -90>
        rotate <.0, 35.3112, .0>
        translate <1.5823, 0, -8.45585>
        // no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 12, 0.0>, 2  
        rotate <.0, .0, -90>
        rotate <.0, 35.3112, .0>
        translate <-8.20999, 0, -1.51964>
        // no_shadow
    }
    
    texture { SILVER }
}

/*---------------------------------------------------------------------------
Stranded -- Copyright (C) 1996, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/
