#declare T_Length = 5
#declare Height = .32
#declare Thickness = 0.1
#declare R_Height = (Height-2*Thickness)
#declare NoWaves = 5
#declare NoSegments = 18
#declare SAngle = pi/2
#declare B = (T_Length/(NoWaves*NoSegments))
#declare Angle = ((2*pi)/NoSegments)
#declare X1 = 0
#declare Y0 = (R_Height*sin(SAngle))
#declare Y1 = 0
#declare Z = 0
#declare Count = NoSegments*NoWaves
#declare TONGUE=
blob{threshold 0.6
     #while (Count>=1)
     #declare X2 = (X1 + B)
     #declare SAngle = (SAngle + Angle)
     #declare Y2 = (R_Height*sin(SAngle))-Y0
     cylinder {<X1,Y1,Z>,<X2,Y2,Z>,Thickness,100}
     #declare X1 = X2
     #declare Y1 = Y2
     #declare Count=Count-1
     #end
     }

#declare HEAD01=
union{
blob{threshold 0.6
   sphere { <0,0,0>,2,4 scale <1.5,1,1>
           texture {finish{Fin01}
		   normal {bumps 0.7 scale <.2,.2,.2>}
                      pigment { rgb <1, .9, .8> }
                      }
   }
   sphere { <0,0,0>,1,-1.5 scale <2,.7,1.5> translate <-2,-.5,0> pigment {rgb <1,0,0>}
           texture {finish{Fin01}
                      pigment { rgb <1, 0, 0> }
                      }
   }
   sphere { <0,0,0>,.7,-1 scale <1,1,1.5> translate <-1.5,-.3,0> pigment {rgb <1,0,0>}
           texture {finish{Fin01}
                      pigment { rgb <1, 0, 0> }
                      }
   }
   cylinder {<-2,0,0>,<.0,0,0>,.5,1 rotate y*45 rotate x*-65 rotate z*-15 translate <0,.5,1>
           texture {finish{Fin01}
		    normal {bumps 0.7 scale <.2,.2,.2>}
                      pigment { rgb <1, .9, .8> }
                      }
   }
   sphere { <-2,0,0>,1.2,1 rotate y*45 rotate x*-70 rotate z*-15 translate <0,.5,1>
           texture {finish{Fin02}
                      pigment { rgb <.8, .82, 1> }
                      }
   }  
   sphere { <0,1,-1.6>,1,1
           texture {finish{Fin02}
                      pigment { rgb <.8, .82, 1> }
                      }
   }
   #declare XS=-1.8
   #declare YS=1
   #declare X0=0
   #declare Y0=0
   #declare R=1
   #declare r=3
   #declare RC=5
   #declare A0=(pi/4)
   #declare n=.9
   #declare LX0=(RC*cos(A0))
   #declare LY0=(RC*sin(A0))
   #declare Count=19
   sphere {<0,0,0>,R,2 scale<.5,1,.7> rotate<0,0,A0> translate<XS,YS,0>
           texture {finish{Fin01}
                      pigment { rgb <1, .9, .8> }
                      }
   }
        #while (Count>=1)
           #declare R=(R*n)
           #declare A=(A0+(2*asin(R/(RC*r))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere {<0,0,0>,R,2 scale<.5,1,.7> rotate<0,0,AA> translate<X1,Y1,0>
           texture {finish{Fin01}
		    normal {bumps 0.7 scale <.15,.15,.15>}
                      pigment { rgb <1, .9, .8> }
                      }
           }
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
           #end
   rotate z*45
}

object {TONGUE rotate y*180 rotate z*55
	texture {finish{Fin01}
		    normal {bumps 0.8 scale <.1,.1,.1>}
                      pigment { rgb <1, 0.6, 0.4> }
                      }
       }
}