// POV-Ray 3.0 scene file by Ian Armstrong   -  Nov 1996
//
// Subject: Hangar & Hut
// Entry for IRTC competition Nov/Dec 1996
//
// (c)1996 Ian Armstrong (iarmstrong@cix.compulink.co.uk)
//

#declare Door =
union {
  box { <-9,0,0>,<9,34,0.5> }
  cylinder { <-9,0,0>,<9,16,0>,0.15 }
  cylinder { <9,0,0>,<-9,16,0>,0.15 }
  cylinder { <-9,18,0>,<9,34,0>,0.15 }
  cylinder { <9,18,0>,<-9,34,0>,0.15 }
  cylinder { <-9,17,0>,<9,17,0>,0.15 }
  pigment { checker Gray80, Gray75 scale <2,100,10> }
}
#declare Shed =
union {
  difference {
    box { <-50,0,0>,<50,50,200> }
    plane { -y,0 rotate 16.7*z translate 50*y }
    plane { -y,0 rotate -16.7*z translate 50*y }
    box { <-49,-1,-1>,<49,35,199> /* pigment { LightGrey } */ }
    box { <-49,-1,1>,<49,55,199> /* pigment { LightGrey } */ }
  }
  box { <-60,34,-1.5>,<60,36,0> pigment { Khaki } }
  union {
    box { <-54,0,-1>,<0,1,201> rotate 16.7*z translate 50*y }
    box { <0,0,-1>,<54,1,201> rotate -16.7*z translate 50*y }
    pigment { Khaki }
    normal { gradient z,5 triangle_wave scale 20 }
  }
  object { Door translate <-50,0,-1> }
  object { Door translate <50,0,-1> }
  object { Door translate <-45,0,-0.5> }
  object { Door translate <45,0,-0.5> }
  object { Door translate <-40,0,0> }
  object { Door translate <40,0,0> }
//  light_source { <0,45,100> color Gray50 fade_distance 20 fade_power 2 }
  pigment { checker Khaki, 0.9*Khaki scale <2,100,300> }
  normal { gradient z,5 triangle_wave scale 5 }
}

#declare Z = 0
#declare Hut =
union {
  difference {
    box { <-18,3,0>,<18,36,100> }
    plane { -y,0 rotate 33.7*z translate 36*y }
    plane { -y,0 rotate -33.7*z translate 36*y }
    box { <-17,1,3>,<17,24,99> pigment { Gray } }    // inside
    box { <-3,4,-1>,<3,22,10> pigment { Gray } }    // doorway
    box { <-5,0,-1>,<5,3,101> }
    #declare Z = 10
    #while (Z < 100)
      box { <-20,8,-3>,<20,22,3> translate Z*z pigment { Gray } }  // windows
      #declare Z = Z + 20
    #end
  }
  box { <-16,0,2>,<16,3,98> pigment { DimGray } }   // floor supports
  union {
    box { <-22.5,0,-1>,<0,1,101> rotate 33.7*z translate 36*y }   // roof
    box { <0,0,-1>,<22.5,1,101> rotate -33.7*z translate 36*y }
    pigment { Gray }
    normal { gradient z,5 sine_wave scale 5 }
  }
  #declare Z = 10
  #while (Z < 100)
    box { <-18.5,8,-4>,<18.5,9,4> translate Z*z pigment { VLightGray } } // window sills
    #declare Z = Z + 20
  #end

  box { <-3.5,0,-8>,<3.5,2,0> pigment { VLightGray } }    // doorstep
  box { <-3.5,0,-4>,<3.5,4,0> pigment { VLightGray } }    // doorstep
  cylinder { <15,25,40>,<15,34,40>,1 pigment { White } finish { ambient 0.3 } } // chimney
  pigment { White } finish { ambient 0.3 }
  normal { gradient -y,5 slope_map {[0,<0,3>][0.3,<1,3>][0.3,<1,-1>][1,<0,-1>]} scale 3 }
}

