// POV-Ray 3.0 scene file by Ian Armstrong   -  Nov 1996
//
// Subject: Lewis Gun & mount
// Entry for IRTC competition Nov/Dec 1996
//
// (c)1996 Ian Armstrong (iarmstrong@cix.compulink.co.uk)
//

#declare Lewis_Gun =
union {
  sphere { <0,0,0>,0.6 scale <0.25,1,0.25> texture { T_Wood10 } }
  difference {
    cylinder { <0,0,-0.1>,<0,0,0.1>,0.6 }
    cylinder { <0,0,-0.2>,<0,0,0.2>,0.53 }
    plane { x,0 }
  }
  superellipsoid { <0.2, 0.2> scale <1.65,0.4,0.3> translate <1.65+0.6,0,0> }
  box { <0.6,0.4,-0.25>,<1.6,0.5,0.25> }
  box { <0.6,-0.55,-0.25>,<1.2,-0.3,0.25> }
  box { <0.6,-0.55,-0.3>,<0.9,0.5,0.3> }
  cylinder { <0.7,0.1,-0.3>,<3.6,0.1,-0.3>,0.05 }   // ribs
  cylinder { <0.7,-0.1,-0.3>,<2,-0.1,-0.3>,0.05 }
  cylinder { <0.6,0.14,0>,<9,0.14,0>,0.12 }   // barrel
  cylinder { <3,0.14,0>,<4.3,0.14,0>,0.17 }
  cylinder { <0.6,-0.16,0>,<8,-0.16,0>,0.09 }
  cylinder { <3,-0.16,0>,<4.3,-0.16,0>,0.13 }
  difference {
    cylinder { <0,0,0>,<0,0.4,0>,0.8 }  // ammo drum
    #declare T = 0.0
    #while (T < 360)
      cylinder { <0.8,-0.1,0>,<0.8,0.5,0>,0.1 rotate T*y }
      #declare T = T + 15
    #end
    translate <3,0.35,0>
  }
  box { <-0.4,0,-0.1>,<0.4,0.1,0.1> rotate 45*y translate <3,0.75,0> }
  superellipsoid { <0.3, 0.3> scale <0.25,0.5,0.1> rotate -20*z translate <1.4,-0.8,0> texture { T_Wood10 } }  // handle
  difference {    // trigger
    cylinder { <0,0,-0.1>,<0,0,0.1>,0.2 }
    cylinder { <0,0,-0.2>,<0,0,0.2>,0.13 }
    translate <2,-0.57,0>
  }
  difference {    // rear sight
    cylinder { <-0.05,0,0>,<0.05,0,0>,0.2 }
    cylinder { <-0.1,0,0>,<0.1,0,0>,0.15 }
    translate <4,0.9,0>
  }
  cylinder { <4,0.2,0>,<4,0.7,0>,0.05 }

  difference {    // front sight
    cylinder { <0,0,0>,<0.1,0,0>,0.2 }
    cylinder { <-0.1,0,0>,<0.2,0,0>,0.15 }
    translate <4,0.9,0>
  }
  cylinder { <7.95,0,0>,<8.05,0,0>,0.3 scale <1,1,0.5> }
  cylinder { <8,0,0>,<8,0.9,0>,0.03 }
  cylinder { <7.95,0.9,0>,<8.05,0.9,0>,0.05 }

  cylinder { <3,-0.95,-0.1>,<3,-0.95,0.1>,0.2 }   // mount
  box { <2.8,-0.95,-0.1>,<3.2,0,0.1> }

  translate <-3,0.95,0>   // datum now at mount
  scale 0.5               // convert to same scale as plane
  texture { pigment { Black } finish { Dull } }
}

#declare Gun_Mount =
union {
  cylinder { <0,0,-0.7>,<0,0,-0.8>,0.2 }
  cylinder { <0,0,0.7>,<0,0,0.8>,0.2 }
  difference {
    torus { 0.75,0.05 }
    plane { x,0 }
    translate <0.3,0.1,0>
  }
  cylinder { <0,0.1,-0.75>,<0.3,0.1,-0.75>,0.05 }
  cylinder { <0,0.1,0.75>,<0.3,0.1,0.75>,0.05 }
  object { Lewis_Gun translate <1.05,0.1,0> }
  texture { Silver_Texture }
}

