// POV-Ray 3.0 scene file by Ian Armstrong   -  Nov 1996
//
// Subject: Hawker Hart Biplane
// Entry for IRTC competition Nov/Dec 1996
//
// (c)1996 Ian Armstrong (iarmstrong@cix.compulink.co.uk)
//

/* ==== Propellers ==== */

#include "prop.inc"

/* ==== Lewis gun & mount ==== */

#include "gun.inc"

/* ==== Textures Etc. ==== */

#declare Metal_Col = pigment { Silver }
#declare Metal_Fin = finish { Metal }
#declare Metal_Tex = texture { pigment { Metal_Col } finish { Metal_Fin } }
#declare Fabric_Col = pigment { Silver }
#declare Fabric_Fin = finish { specular 0.5 roughness 0.15 }
#declare Fabric_Tex = texture { pigment { Fabric_Col } finish { Fabric_Fin } }
#declare Fabric_Wave =
slope_map {
  [ 0.0,  <0,0> ]
  [ 0.25,  <0,0> ]
  [ 0.5,  <1,3> ]
  [ 0.5,  <1,-3> ]
  [ 0.75,  <0,0> ]
  [ 1.0,  <0,0> ]
}
#declare Wing_Fabric_Tex = texture { pigment { Fabric_Col } finish { Fabric_Fin } normal { gradient z slope_map { Fabric_Wave } bump_size 0.14 scale 1.5 } }
#declare Wing_Fabric_Tex2 = texture { pigment { Fabric_Col } finish { Fabric_Fin } normal { gradient z slope_map { Fabric_Wave } bump_size -0.14 scale 1.5 } }

/* ==== Detail Bits ==== */

#declare Wire_T = 0.03

#declare WT = 0.05
#declare Windscreen_Half =
union {
  cylinder { <0,0,0>,<0,0,0.4>,WT }
  cylinder { <0.5,0.7,0>,<0.5,0.7,0.5>,WT }
  cylinder { <0,0,0.4>,<0.5,0.7,0.5>,WT }
  cylinder { <0,0,0.4>,<0.5,-0.3,1.2>,WT }
  cylinder { <0.5,0.7,0.5>,<0.6,0.1,1>,WT }
  cylinder { <0.6,0.1,1>,<0.5,-0.3,1.2>,WT }
  pigment { DarkTan }
}

#declare Engine_Detail =    // Right-side
union {
  sphere { <0,0,0>,0.6 scale <1,0.5,0.5> translate <4.2,1.4,1.4> }
  cylinder { <5.7,2.5,0.5>,<6.3,2.5,0.5>,0.15 }
  sphere { <6.3,2.5,0.5>,0.15 }
  cylinder { <6.3,2.6,0.5>,<6.3,2,0.5>,0.15 }
  #declare X = 4
  #while (X < 8)
    box { <0,0,-0.5>,<0.45,0.25,0.5> translate <X,0.5,2> pigment { Black } }
    #declare X = X + 0.667
  #end
  texture { Metal_Tex }
}
#declare Cooler_Fin =
union {
  cylinder { <-0.9,0,0>,<-0.9,0.075,0>,0.5 }
  box { <-0.9,0,-0.5>,<0.9,0.075,0.5> }
  cylinder { <0.9,0,0>,<0.9,0.02,0>,0.5 }
  texture { Brass_Texture }
}
#declare Cooler =
union {
  object { Cooler_Fin translate -0.8*y }
  object { Cooler_Fin translate -0.65*y }
  object { Cooler_Fin translate -0.5*y }
  object { Cooler_Fin translate -0.35*y }
  object { Cooler_Fin translate -0.2*y }
  cylinder { <-0.9,0,0>,<-0.9,-1,0>,0.2 }
  cylinder { <0.9,0,0>,<0.9,-1,0>,0.2 }
  texture { Brass_Texture }
}
#declare Gun_Sight =
union {
  cylinder { <0,0,0>,<5.7,0,0>,0.05 }
  cylinder { <0,0,0>,<0,0.3,0>,0.02 }
  cylinder { <3.5,-1,0>,<3.5,0.1,0>,0.02 }
  difference {
    cylinder { <3.49,0.3,0>,<3.51,0.3,0>,0.2 }
    cylinder { <3.4,0.3,0>,<3.6,0.3,0>,0.15 }
  }
  cylinder { <1,-1,0>,<1,0,0>,0.02 }
  cylinder { <5.7,-1,0>,<5.7,0.3,0>,0.02 }
  pigment { Gray35 } finish { Dull }
}

/* ==== Fuselage ==== */

#declare Fuselage =
union {
  cone { <0,0,0>,0,<1,0,0>,0.5 }
  cone { <1,0,0>,0.5,<2.1,0,0>,1.2 pigment { Orange } finish { Dull } }
  cone { <2.1,0,0>,1.2,<3.2,0,0>,1.75 }
  cone { <3.2,0,0>,1.75,<4,0,0>,2 }
  difference {
    cylinder { <4,0,0>,<5,0,0>,2 }
    cone { <4,0,-2>,0,<5,0,-2>,0.2 }  // gun channel
  }

  cylinder { <9.5,0.8,0>,<15,1.2,0>,2 } // rear nose
  torus { 1.5,.5 rotate 89.2*z translate <15,1.2,0> }   // filler

  difference {    // Cockpit area
    union {
      cylinder { <15,1.2,0>,<22,1.1,0>,2 }  // front cockpit
      cone { <22,1.1,0>,2,<26,1,0>,1.8 }    // rear cockpit
      cylinder { <17,0,0>,<17,4,0>,1.5 texture { T_Wood10 } }
    }
    cylinder { <17,0,0>,<17,5,0>,1.3 texture { T_Wood10 } }     // front cockpit
    cylinder { <17,4.6,-3>,<17,4.6,3>,2 texture { T_Wood10 } }  //
    cylinder { <15,1.2,0>,<22,1.1,0>,1.8 }
    cylinder { <20.5,4,-3>,<20.5,4,3>,2 }                       // rear cockpit
    cylinder { <20.5,0,0>,<20.5,3,0>,1.6 }
    box { <21,2.45,-3>,<23.5,4,3> }
  }
  difference {    // instrument panel
    cylinder { <15,1.2,0>,<15.5,1.1,0>,1.8 pigment { Gray90 } }
    cylinder { <15.4,2.7,0>,<16,2.7,0>,0.2 pigment { Gray20 } }
    cylinder { <15.4,2.65,0.45>,<16,2.65,0.45>,0.1 pigment { Gray20 } }
    cylinder { <15.4,2.65,-0.45>,<16,2.65,-0.45>,0.1 pigment { Gray20 } }
    cylinder { <15.4,2.5,0.8>,<16,2.5,0.8>,0.15 pigment { Gray20 } }
    cylinder { <15.4,2.5,-0.8>,<16,2.5,-0.8>,0.15 pigment { Gray20 } }
  }
  difference {    // rear ring
    union {
      cylinder { <20.5,2.5,0>,<20.5,2.7,0>,1.65 texture { T_Wood10 } }
      cylinder { <20.5,0,0>,<20.5,2.6,0>,1.6 }
    }
    cylinder { <20.5,0,0>,<20.5,3,0>,1.5 }
  }
  object { Gun_Mount translate <22,2.7,0> }

  union {
    cone { <26,1,0>,1.8,<36,1,0>,1 }      // rear deck
    cone { <36,1,0>,1,<39,1,0>,0.3 }
    texture { Metal_Tex }
  }
  union {
    cylinder { <39,-0.75,0>,<39,1,0>,0.27 }   // tail post
    sphere { <39,1,0>,0.27 }
    texture { Fabric_Tex }
  }

  difference {
    union {
      box { <9.5,-3.2,-2>,<17,3,2> texture { Metal_Tex } }
      box { <17,-3.2,-2>,<26,3,2> }
    }
    plane { -y,0 rotate 4.1596*z translate <9.5,0.8,0> }    // top deck
    plane { -y,0 rotate -0.81846*z translate <15,1.2,0> }
    plane { -y,0 rotate -1.4321*z translate <22,1.1,0> }
    plane { -z,0 rotate 2.862405*y translate <22,0,2> }     // sides
    plane { z,0 rotate -2.862405*y translate <22,0,-2> }
    plane { y,0 rotate 1.636577*z translate <15,-3.3,0> }   // bottom
    plane { y,0 rotate 4.289153*z translate <22,-3.1,0> }
    plane { y,0 rotate -20*z translate <15,-3.2,0> }
    cylinder { <5,0,-2>,<14,0,-2>,0.2 }  // gun channel
    box { <-0.25,-0.2,-0.1>,<0.25,0.2,0.2> rotate 16*z translate <18.5,0.3,-2> pigment { Gray } finish { Dull } }  // cutouts
    box { <-0.25,-0.2,-0.11>,<0.25,0.2,0.2> rotate 16*z translate <21,-2,-2> pigment { Gray } finish { Dull } }
    box { <-0.25,-0.2,-0.11>,<0.25,0.2,0.2> scale <1,2,1> translate <23,-2.5,-2> pigment { Gray } finish { Dull } }
    box { <-0.25,-0.2,-0.11>,<0.25,0.2,0.2> scale <2,0.5,1> translate <15.5,-0.3,-2> pigment { Black } }
    texture { pigment { Fabric_Col } finish { Fabric_Fin } normal { gradient y slope_map { Fabric_Wave } bump_size 0.05 scale 0.5 } }
    texture { pigment { image_map { png "57.png" once interpolate 2 filter 15,1 } scale <4,3,1> translate <19,-2,0> } }
    texture { pigment { image_map { png "roundel.png" once interpolate 2 filter 11,1 } scale <3,3,1> translate <24,-2.8,0> } finish { ambient 0.2 } }
  }
  difference {
    box { <26,-3.2,-2>,<39,1,2> }
    plane { -z,0 rotate 4.573921*y translate <26,0,1.8> }   // sides
    plane { z,0 rotate -4.573921*y translate <26,0,-1.8> }
    plane { -z,0 rotate 13.134*y translate <36,0,1> }   // sides
    plane { z,0 rotate -13.134*y translate <36,0,-1> }
    plane { y,0 rotate 9.090277*z translate <26,-2.8,0> }   // bottom
    cylinder { <0,0,-2>,<0,0,2>,0.3 scale <1,0.5,1> translate <32,0.5,0> pigment { Gray45 } } // elevator wire cutouts
    texture { pigment { Fabric_Col } finish { Fabric_Fin } normal { gradient y slope_map { Fabric_Wave } bump_size 0.05 scale 0.5 } }
    texture { pigment { image_map { png "roundel.png" once interpolate 2 filter 11,1 } scale <3,3,1> translate <24,-2.8,0> } finish { ambient 0.2 } }
    texture { pigment { image_map { png "j9941a.png" once interpolate 2 filter 15,1 } scale <4,1,1> translate <30,-0.8,0> } }
  }

  bicubic_patch {   // Top nose
    type 1
    flatness 0.01
    u_steps 3
    v_steps 3
    <4,0,-2>,<4,2.6667,-2>,<4,2.6667,2>,<4,0,2>,
    <5.8333,0.2667,-2>,<5.8333,3.0222,-2>,<5.8333,3.0222,2>,<5.8333,0.2667,2>,
    <7.6667,0.5333,-2>,<7.6667,3.3777,-2>,<7.6667,3.3777,2>,<7.6667,0.5333,2>,
    <9.5,0.8,-2>,<9.5,3.4667,-2>,<9.5,3.4667,2>,<9.5,0.8,2>
  }
  bicubic_patch {   // Bottom nose
    type 1
    flatness 0.01
    u_steps 3
    v_steps 3
    <4,0,-2>,<4,-2.6667,-2>,<4,-2.6667,2>,<4,0,2>,
    <5.8333,-0.4,-2>,<5.8333,-3.4667,-2>,<5.8333,-3.4667,2>,<5.8333,-0.4,2>,
    <7.6667,-0.8,-2>,<7.6667,-3.6667,-2>,<7.6667,-3.6667,2>,<7.6667,-0.8,2>,
    <9.5,-1.2,-2>,<9.5,-3.8667,-2>,<9.5,-3.8667,2>,<9.5,-1.2,2>
  }
  bicubic_patch {   // Bottom nose rear
    type 1
    flatness 0.01
    u_steps 3
    v_steps 3
    <9.5,-1.2,-2>,       <9.5,-3.8667,-2>,      <9.5,-3.8667,2>,      <9.5,-1.2,2>
    <11.3333,-1.8667,-2>,<11.3333,-3.6444,-2>,<11.3333,-3.6444,2>,<11.3333,-1.8667,2>
    <13.1667,-2.5333,-2>,<13.1667,-3.6222,-2>,<13.1667,-3.4222,2>,<13.1667,-2.5333,2>
    <15,-3.2,-2>,        <15,-3.2,-2>,     <15,-3.2,2>,     <15,-3.2,2>
  }
  difference {
    prism {                               // nose side fillers
      linear_sweep
      linear_spline
      -2,2,4
      <4,0>,<9.5,0.8>,<9.5,-1.2>,<4,0>
      rotate -90*x
    }
    cylinder { <5,0,-2>,<14,0,-2>,0.2 }  // gun channel
    cone { <4,0,-2>,0,<5,0,-2>,0.2 }
  }
// ** Detail **
      // Tail skid
  cylinder { <36,-1.3,0>,<38,-2.2,0>,0.1 }
  sphere { <0,0,0>,0.2 scale <1,0.7,1> translate <38,-2.2,0> }
      // Gun
  cylinder { <0,0,0>,<3,0,0>,0.18 translate <11,0,-2> pigment { Black } finish { Metal } }
      // Windscreen
  object { Windscreen_Half translate <15.2,3.2,0> }
  object { Windscreen_Half scale <1,1,-1> translate <15.2,3.2,0> }
      // Engine bits
  object { Engine_Detail }
  object { Engine_Detail scale <1,1,-1> }
      // Step
  union {
    cylinder { <20.5,-3.1,-2>,<20.75,-4.1,-2>,0.05 }
    cylinder { <21.5,-3.1,-2>,<21.25,-4.0,-2>,0.05 }
    cylinder { <20.75,-4.1,-2>,<21.25,-4.0,-2>,0.05 }
    pigment { Gray40 }
  }
      // Oil Cooler
  object { Cooler rotate <0,-5,-10> translate <8.5,-3.1,0> }
      // Gun Sight
  object { Gun_Sight rotate 1*z translate <9,3.2,0> }
      // Radiator
  difference {
    box { <11,-4.5,-1.7>,<13,-3.2,1.7> }
    box { <10,-4.4,-1.6>,<11.5,-3.3,1.6> pigment { Black } }
  }
  box { <13,-3.7,-1.2>,<13.5,-3.2,1.2> }

  texture { Metal_Tex }

}  // End Fuselage

/* ==== Wings & Tail ==== */

#declare TMap =     // Colour map for tail
color_map {
  [ 0.0   color Silver ]
  [ 0.5   color Silver ]
  [ 0.5   color Red ]
  [ 0.667 color Red ]
  [ 0.667 color White ]
  [ 0.833 color White ]
  [ 0.833 color Blue ]
  [ 1.0   color Blue ]
}
#declare Tail =
union {
  difference {
    intersection {
      sphere { <-3,1,0>,7 scale <1,1,0.02> }
      sphere { <-1,8,0>,10 scale <1,1,0.02> }
      sphere { <5,-5,0>,11 scale <1,1,0.02> }
      union {
        sphere { <0,-2.5,0>,8 /* scale <1,1,0.02> */ }
        cylinder { <1.7,4.25,-1>,<1.7,4.25,1>,1.25 }
      }
      texture {
        pigment { gradient x color_map { TMap } scale 7.5 translate -3.5*x } finish { Fabric_Fin }
        normal { gradient y slope_map { Fabric_Wave } bump_size 0.07 scale 1 }
      }
      texture { pigment { image_map { png "j9941b.png" once interpolate 2 filter 15,1 } scale <3,1.8,1> translate <0.5,2.5,0> } }
    }
    box { <-5,3.4,-1>,<0.3,3.45,1> pigment { Black } }    // rudder cutouts
    box { <0.3,3.45,-1>,<0.35,-3,1> pigment { Black } }
  }
  box { <0.3,3,-0.2>,<0.6,3.3,0.2> pigment { Gray45 } }   // rudder hinges
  box { <0.3,1,-0.2>,<0.6,1.3,0.2> pigment { Gray45 } }
  box { <0.3,-1.5,-0.2>,<0.6,-1.2,0.2> pigment { Gray45 } }
}
#declare TailPlane_Half =
union {
  difference {
    cone { <0,0,0>,3.3,<0,0,9>,2 scale <1,0.05,1> }
    plane { z,0 rotate -30*y translate 1*x }
    difference {
      box { <-5,-1,7.5>,<5,1,10> }
      box { <0,-1.5,7>,<6,1.5,8> }
      cylinder { <0,-2,0>,<0,2,0>,2 scale <1.48,1,0.75> rotate -30*y translate <-0.6,0,7> }
    }
    box { <-0.5,-1,7>,<-0.45,1,9> pigment { Black } }   // tail/elevator gap
    box { <-0.5,-1,7>,<0.5,1,7.05> pigment { Black } }
    box { <0.45,-1,0>,<0.5,1,7.05> pigment { Black } }
  }
  cylinder { <0,0,0>,<0,-3.842,0>,0.15 scale <1,1,0.5> rotate 50*x translate <-2.5,0,4> texture { Metal_Tex } }    // struts
  cylinder { <0,0,0>,<0,-4.472,0>,0.15 scale <1,1,0.5> rotate 60*x translate <-0.2,0,4> texture { Metal_Tex } }

  cylinder { <0,0.15,4>,<0,3,0>,Wire_T pigment { Gray35 } }  // bracing wire
  box { <-0.1,2.6,0>,<0.1,3.0,0.3> pigment { Gray35 } }
  box { <-0.1,0,3.8>,<0.1,0.17,4.2> pigment { Gray35 } }
  union {                                       // elevator wires
    cylinder { <-7,-1,1.4>,<-2,0,1.8>,Wire_T }
    cylinder { <-2,0,1.8>,<1,0.6,1.8>,Wire_T }
    cylinder { <1.3,0,1.8>,<1,0.6,1.8>,0.1 }
    cylinder { <-2,0,1.8>,<1,-0.6,1.8>,Wire_T }
    cylinder { <1.3,0,1.8>,<1,-0.6,1.8>,0.1 }
    pigment { Gray35 } finish { Dull }
  }
  texture { pigment { Fabric_Col } finish { Fabric_Fin } normal { gradient z slope_map { Fabric_Wave } bump_size 0.14 scale 1 } }
}
#declare TailPlane =
union {
  object { TailPlane_Half }
  object { TailPlane_Half scale <1,1,-1> }
}
#declare Bomb =
union {
  sphere { <0,0,0>,0.6 scale <1.5,1,1> }
  cylinder { <0,0,0>,<1.5,0,0>,0.6 }
  cone { <1.5,0,0>,0.6,<4,0,0>,0.1 }
  difference {
    union {
      cylinder { <4,0,-0.05>,<4,0,0.05>,0.6 }
      cylinder { <4,-0.05,0>,<4,0.05,0>,0.6 }
      cylinder { <4,0,0>,<5.3,0,0>,0.6 }
    }
    sphere { <4,0,0>,0.4 }
    cylinder { <3.99,0,0>,<6,0,0>,0.5 }
  }
  cylinder { <0,0,0>,<0,1,0>,0.1 scale <1,1,2> pigment { Tan } }   // bomb rail
  cylinder { <2,0,0>,<2,1,0>,0.1 scale <1,1,2> pigment { Tan } }
  box { <-0.6,0.6,-0.1>,<4.5,1,0.1> texture { Metal_Tex } }
  pigment { Gray15 } finish { Dull }
}
#declare Wing_Skin =
union {
  bicubic_patch {   // inner wing & cutout
    type 1
    flatness 0.0
    u_steps 4
    v_steps 4
    <0,0,0>,<0,1,0>,<7,0.5,0>,<7,0,0>,
    <0,0,4>,<0,1,4>,<7,0.5,4>,<7,0,4>,
    <0,0,3>,<0,1,3>,<9,0.3,3>,<9,0,3>,
    <0,0,5>,<0,1,5>,<9,0.3,5>,<9,0,5>
  }
  bicubic_patch {   // main wing
    type 1
    flatness 0.0
    u_steps 2
    v_steps 4
    <0,0,5>,<0,1,5>,<9,0.3,5>,<9,0,5>,
    <0,0,11>,<0,1,11>,<9,0.3,11>,<9,0,11>,
    <0,0,17>,<0,1,17>,<9,0.3,17>,<9,0,17>,
    <0,0,24.5>,<0,1,24.1667>,<9,0.3,23.8333>,<9,0,23.5>
  }
  bicubic_patch {   // tip
    type 1
    flatness 0.0
    u_steps 4
    v_steps 4
    <0,0,24.5>,<0,1,24.1667>,<9,0.3,23.8333>,<9,0,23.5>,
    <0,0,24.5>,<0,1,29>,<9,0.3,28>,<9,0,23.5>,
    <0,0,24.5>,<0,0.5,30>,<9,0.15,29>,<9,0,23.5>,
    <0,0,24.5>,<0,0,30>,<9,0,29>,<9,0,23.5>
  }
  texture { Wing_Fabric_Tex }
  scale <1,1.3,1>
}

#declare Right_Upper_Wing =
union {
  object { Wing_Skin
    texture { pigment { image_map { png "roundel.png" once interpolate 2 filter 11,1 } scale <8,8,1> rotate 90*x translate <0.5,0,18> } finish { ambient 0.2 } }
    texture { pigment { image_map { png "aileron.png" once interpolate 2 filter 1,1 } scale <16,3,1> rotate <90,-90,0> translate <9,0,12> } finish { ambient 0.2 } }
  }
  object { Wing_Skin scale <1,-0.3,1> texture { Wing_Fabric_Tex2 } }
  rotate <-1,4.67,-2> translate <8,4.8,0>
}
#declare Left_Upper_Wing =
union {
  object { Wing_Skin scale <1,1,-1>
    texture { Wing_Fabric_Tex2 }
    texture { pigment { image_map { png "roundel.png" once interpolate 2 filter 11,1 } scale <8,8,1> rotate -90*x translate <0.5,0,-18> } finish { ambient 0.2 } }
    texture { pigment { image_map { png "aileron.png" once interpolate 2 filter 1,1 } scale <16,3,1> rotate <-90,90,0> translate <9,0,-12> } finish { ambient 0.2 } }
  }
  object { Wing_Skin scale <1,-0.3,-1> texture { Wing_Fabric_Tex } }
  rotate <1,-4.67,-2> translate <8,4.8,0>
}

#declare Right_Lower_Wing =
union {
  object { Wing_Skin texture { Wing_Fabric_Tex } }
  object { Wing_Skin scale <1,-0.3,1>
    texture { Wing_Fabric_Tex2 }
    texture { pigment { image_map { png "roundel.png" once interpolate 2 filter 11,1 } scale <8,8,1> rotate 90*x translate <0.5,0,18> } finish { ambient 0.2 } }
  }
  scale <0.85,0.85,0.85> rotate -3.1*x translate <13.3,-3.2,0>
}
#declare Left_Lower_Wing =
union {
  object { Wing_Skin scale <1,1,-1> texture { Wing_Fabric_Tex2 } }
  object { Wing_Skin scale <1,-0.3,-1>
    texture { Wing_Fabric_Tex }
    texture { pigment { image_map { png "roundel.png" once interpolate 2 filter 11,1 } scale <8,8,1> rotate -90*x translate <0.5,0,-18> } finish { ambient 0.2 } }
  }
  scale <0.85,0.85,0.85> rotate 3.1*x translate <13.3,-3.2,0>
}

#declare Strut1 =   // outer wing 'N' struts
union {
  cylinder { <14.3,0,0>,<11,7.75,0>0.2 scale <1,1,0.5> rotate 25.25*x translate <0,-2.1,15.7> }
  cylinder { <18.3,0,0>,<15,7.75,0>0.2 scale <1,1,0.5> rotate 25.25*x translate <0,-2.1,15.7> }
  cylinder { <14.3,0,0>,<15,7.75,0>0.2 scale <1,1,0.5> rotate 25.25*x translate <0,-2.1,15.7> }
          // bracing wires
  cylinder { <11,4.8,19>,<10,-2.9,2>,Wire_T }
  cylinder { <15,4.8,19>,<14,-2.9,2>,Wire_T }
  cylinder { <14.3,-2,15.7>,<9.5,4.8,4.5>,Wire_T }
  cylinder { <18.3,-2,15.7>,<14,4.8,4.5>,Wire_T }
  texture { Metal_Tex }
}
#declare Strut2 =   // inner wing/fuselage struts
union {
  cylinder { <0,0,0>,<-0.5,5.86,0>,0.2 scale <1,1,0.5> rotate 25.25*x translate <10,-0.5,2> }
  cylinder { <0,0,0>,<0,4.974,0>,0.2 scale <1,1,0.5> rotate 30.174*x translate <14,0.5,2> }
          // bracing wires
  cylinder { <10,-0.5,2>,<14,4.8,4.5>,Wire_T }    // between struts
  cylinder { <14,0.5,2>,<9.5,4.8,4.5>,Wire_T }

  cylinder { <14,2.5,1.3>,<14,4.8,4.5>,Wire_T }   // strut top to fuselage
  cylinder { <10,2.5,1.3>,<9.5,4.8,4.5>,Wire_T }
  texture { Metal_Tex }
}

#declare Wings =
union {
          // upper wings
  object { Right_Upper_Wing }
  object { Left_Upper_Wing }
          // lower wings
  object { Right_Lower_Wing }
  object { Left_Lower_Wing }
  object { Bomb rotate -3*z translate <15,-4,7.5> }
  object { Bomb rotate -3*z translate <15,-4,-7.5> }
          // struts
  object { Strut1 }
  object { Strut1 scale <1,1,-1> }
  object { Strut2 }
  object { Strut2 scale <1,1,-1> }
}

/* ==== Undercarriage ==== */

#declare Wheel =
union {
  torus { 1.6,0.3 scale <1,1.5,1> rotate 90*x pigment { Black } finish { Dull } }
  cylinder { <0,0,0>,<0,0,0.4>,1.4 texture { Metal_Tex } }
  cylinder { <0,0,-0.4>,<0,0,0>,1.4 pigment { Gray } finish { Dull } }
  cylinder { <0,0,0>,<0,0,0.6>,0.3 pigment { Gray } finish { Dull } }
  cone { <0,0,0.4>,1.3,<0,0,0.6>,0.2 pigment { Orange } finish { Dull } }
}
#declare UCLeg =
union {
  cylinder { <0,0,0>,<1.2,-5,0>,0.25 }
  cylinder { <-0.12,0.5,0>,<0.6,-2.5,0>,0.5 }
  cylinder { <7.5,0,0>,<1.2,-5,0>,0.25 }
  scale <1,1,0.5>
  texture { Metal_Tex }
}
#declare UnderCarriage =
union {
  object { UCLeg rotate 24*x translate -2*z }
  object { UCLeg rotate -24*x translate 2*z }
  cylinder { <1.2,-4.5,-5.5>,<1.2,-4.5,5.5>,0.15 }
  object { Wheel translate <1.2,-4.5,4.75> }
  object { Wheel scale <1,1,-1> translate <1.2,-4.5,-4.75> }
  cylinder { <1.2,-4.5,4>,<7.5,0,-2>,Wire_T }   // bracing wires
  cylinder { <1.2,-4.5,-4>,<7.5,0,2>,Wire_T }
  texture { Metal_Tex }
}

/* ==== Pilot ==== */

#declare Pilot =
union {
  blob {
    threshold 0.05
    sphere { <0,0,0>,0.55,1 } // centre head
    sphere { <0,0,0>,0.5,1 translate <0.15,0,0> } // back head
    sphere { <0,0,0>,0.5,1 scale <1.2,0.9,0.9> rotate 20*z translate <0.15,0.1,0> } // back head
    cylinder { <0,-0.5,0>,<0,-0.2,0>,0.53,0.4 translate 0.1*x pigment { White } }  // scarf / collar
    sphere { <0,0,0>,1,1 scale <0.6,1,1> translate <0.2,-1.2,0> }
    sphere { <0,0,0>,1,1 scale <0.55,0.8,0.4> translate <0.1,-1.2,0.6> }
    sphere { <0,0,0>,1,1 scale <0.55,0.8,0.4> translate <0.1,-1.2,-0.6> }
    sphere { <0,0,0>,1,1 scale <0.5,0.8,0.4> translate <0.1,-1.2,0.8> }
    sphere { <0,0,0>,1,1 scale <0.5,0.8,0.4> translate <0.1,-1.2,-0.8> }
  }
  union {
    cylinder { <0,-0.05,0>,<0,0.05,0>,0.55 scale <1,1,0.9> translate 0.08*x pigment { DarkBrown } finish { Dull } }  // goggles band
    cylinder { <0,0,0>,<0.05,0,0>,0.2 scale <1,0.7,1> rotate -25*y translate <-0.4,0,-0.25> pigment { DarkBrown } }  // goggles
    cylinder { <0,0,0>,<0.05,0,0>,0.2 scale <1,0.7,1> rotate 25*y translate <-0.4,0,0.25> pigment { DarkBrown } }
    rotate -20*z
    translate <0.03,0.1,0>
  }
  pigment { DarkTan }
}

/* ==== Assemble Planes ==== */

#declare Hart =
union {
  object { Fuselage }
  object { Wings }
  object { Tail translate <39,1.2,0> }
  object { TailPlane translate <39,1.5,0> }
  object { UnderCarriage translate <10,-3.1,0> }
}
#declare Static_Hart =
union {
  object { Hart }
  object { Static_Prop scale <-2,2,2> rotate -60*x translate 1.7*x }
  translate <-11.2,7.6,0>   // centre at wheels
  rotate -15.165*z
  translate 1.9*y           // put on the ground
}
#declare Flying_Hart =
union {
  object { Hart }
  object { Flight_Prop scale <-2,2,2> rotate (3600*clock-60)*x translate 1.7*x }
  object { Pilot translate <17.2,3.5,0> }
  object { Pilot translate <20.5,3.5,0> }
}

