#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "icarcom.inc"
#include "daedalus.inc"
#include "icarus.inc"

camera {
   location  <0, 5, -30>
   look_at   <0, 0, 40>
}

// Bright light at "sun"
light_source {<90, 60, 245> color White}

// scene light to bring out colours
light_source {<6, 20, 5> color Gray60}

// ---------------------------------------

// Sun
sphere {<0,0,0>, 300
	texture {
		pigment {
		wood
		turbulence 0.01
		color_map {
		[0.0, 0.05 color White color White]
		[0.05, 0.2 color White color rgb <1.0, 0.98, 0.4646>]
		[0.2, 0.4 color rgb <1.0, 0.98, 0.4646> color rgb <0.9648, 0.8359, 0.289>]
		[0.4, 0.9 color rgb <0.9648, 0.8359, 0.289> color rgb <0.9, 0.7, 0.5>]
		[0.9, 1.0 color rgb <0.9, 0.7, 0.5> color SkyBlue] }
		}
	scale 600
	rotate <-20, 20, 0>
	finish {ambient 1.0 diffuse 0.0}
	}
}

// Ocean
union {
plane {y, -10
	texture {
	pigment {color SeaGreen}
	normal {waves 1.0
		scale 5}
	}
}
plane {y, -9.5
	texture {Water pigment {color Gray60 filter 0.9} scale 10}
}

clipped_by {plane {z, 50}}
}

// Cliffs
height_field {gif "cliff.gif"
	water_level 0.2		// to prevent base showing through water
	texture {
		pigment {
		marble
		turbulence 0.3
		color_map {
		[0.0, 0.2 color Sienna color Sienna]
		[0.2, 0.6 color Gray color Gray30]
		[0.6, 1.0 color Gray color IndianRed] }
		scale 0.2
		rotate <0, 0, 90>
		}
	finish {crand 0.5}
	}
	scale 60
	translate <-33, -22, -27>	// off to left+link in to ripples
}

object {Daedalus
	rotate <-65, -40, 0>
	translate <-12, 23, 20>
}

object {Icarus
	rotate <90, 0, 0>
	rotate <0, -50, 0>
	translate <0, -1, 0>
}

object {Feather
	rotate <0, 0, 70>
	translate <-1, 5, -2>
}
object {Feather
	rotate <0, 45, 45>
	translate <5, 13, 4>
}
object {Feather
	rotate <30, 0, 40>
	translate <3, 15, -2>
}
object {Feather
	rotate <0, 0, -70>
	translate <3, 8, 3>
}
object {Feather
	rotate <0, 0, -170>
  translate <-8, 3, 3>
}
object {Feather
	rotate <0, 0, 160>
  translate <-4, 8, 3>
}



#declare Drip = union {
torus {1, 0.1}

blob {
	threshold 0.3
	component 1.0, 0.2, <-0.9, 0.1, 0>
	component 1.0, 0.2, <-0.8, 0.3, 0>
	component 1.0, 0.15, <-0.8, 0.5, 0>
	component 1.0, 0.25, <-1, 0.5, 0>
	component 1.0, 0.2, <-1.3, 0.4, 0>
	component 1.0, 0.15, <-1.5, 0.2, 0> 	

	component 1.0, 0.2, <0.9, 0.1, 0>
	component 1.0, 0.2, <0.8, 0.3, 0>
	component 1.0, 0.15, <0.8, 0.5, 0>
	component 1.0, 0.25, <1, 0.5, 0>
	component 1.0, 0.2, <1.3, 0.4, 0>
	component 1.0, 0.15, <1.5, 0.2, 0> 	

	component 1.0, 0.3, <0, 1.0, 0>
	component 1.0, 0.1, <0, 0.8, 0>
	component 1.0, 0.1, <0, 0.6, 0>
}


pigment {color SeaGreen filter 0.9}
}

object {Drip
	translate <8, -9.5, 2>}

object {Drip
	translate <0, -9.5, -3>}
