// ***************************
// *   Future flight model   *
// ***************************
// *   by : Dran Draggore    *
// ***************************

// **T** **T** **T** **T** **T** **T** **T** **T**
// *
// * TEXTURES

#ifndef (EXHAUST_FLAME)
#declare EXHAUST_FLAME = 0
#end

#ifndef (TEXTURE_CTRL)
#declare TEXTURE_CTRL = 1
#end

#if (TEXTURE_CTRL = 1)
// *--> metallic
#declare Iridium1 =
texture {
	pigment { color rgb <0.5, 0.6, 0.8> }
	normal { hexagon 0.3 scale 1 }
	finish {
//		irid { 0.2 thickness 1 turbulence <0.3, 0.4, 0.5> }
		ambient rgb <0.2, 0.1, 0.1>
		phong 1 phong_size 120
		reflection 0.35
	}
}
#declare Iridium2 =
texture {
	pigment { color rgb <0.5, 0.6, 0.8> }
	finish {
//		irid { 0.2 thickness 1 turbulence <0.3, 0.4, 0.5> }
		ambient rgb <0.2, 0.1, 0.1>
		phong 1 phong_size 120
		reflection 0.35
	}
}
#declare Iridium3 =
texture {
	average
	texture_map {
	[ 0.5
		pigment {
			image_map {
				gif "\povray3\working\symbol.gif"
				filter 0, 1.0
			}
			scale 10
			translate <-5, -1.4, 0>
		}
		finish {
//			irid { 0.2 thickness 1 turbulence <0.3, 0.4, 0.5> }
			ambient rgb <0.2, 0.1, 0.1>
			phong 1 phong_size 120
			reflection 0.35
		}
	]
	[ 1
		pigment { color rgb <0.5, 0.6, 0.8> }
		finish {
//			irid { 0.2 thickness 1 turbulence <0.3, 0.4, 0.5> }
			ambient rgb <0.2, 0.1, 0.1>
			phong 1 phong_size 120
			reflection 0.35
		}
	]
	}
}
#else
// *--> texture for testing (low cost)
#declare Iridium1 =
texture {
	pigment { color rgb <1, 1, 1> }
	finish {
		ambient rgb <0.2, 0.2, 0.2>
		phong 1 phong_size 120
	}
}
#declare Iridium2 =
texture { Iridium1 }
#declare Iridium3 =
texture { Iridium1 }
#end

// **1** **1** **1** **1** **1** **1** **1** **1**
// *
// * OBJECTS : level 1

// *--> one eight of sphere; choped; used for body
#declare OneEightLeft =
object {
	difference {
		sphere { <0, 0, 0>, 6 }
		union {
			box { <0.0001, -10, -10>, <10, 10, 10> }
			box { <-10, -10, 10>, <10, 10, -2.9999> }
			box { <-10, -10, -10>, <10, 3, 10> }
		}
	}
	translate <0, -3, 3>
}
#declare OneEightRght =
object {
	difference {
		sphere { <0, 0, 0>, 6 }
		union {
			box { <0.0001, -10, -10>, <10, 10, 10> }
			box { <-10, -10, -10>, <10, 10, 2.9999> }
			box { <-10, -10, -10>, <10, 3, 10> }
		}
	}
	translate <0, -3, -3>
}

// *--> engine parts
#declare Part1 =
difference {
	sphere { <0, 0, 0>, 1 }
	union {
		box { <0, -10, -10>, <10, 10, 10> }
		sphere { <0, 0, 0>, 0.9 }
	}
	scale <10, 1.5, 1.5>
}
#declare Part20 =
union {
	box { <-1, 0, -0.5>, <1, 0.5, 0.5> rotate <0, 0, -30.964> }
	box { <0, -1, -0.5>, <0.5, 1, 0.5> }
}
#declare Part2 =
difference {
	union {
		cylinder { <0, 0, 0,>, <1.5, 0, 0>, 1.5 }
		torus { 1.2, 0.3 rotate <0, 0, 90> scale <5, 1, 1> translate <1.5, 0, 0> }
	}
	union {
		cylinder { <-1, 0, 0>, <4, 0, 0>, 1.2 }
		#declare i = 0
		#while (i<6)
			object { Part20 translate <0.5, 1.2, 0> rotate <(60*i), 0, 0> }
		#declare i = i+1
		#end
		difference {
			cylinder { <-0.1, 0, 0>, <0.1, 0, 0>, 2 }
			cylinder { <-1, 0, 0>, <1, 0, 0>, 1.3 }
			translate <1.5, 0, 0>
		}
	}
}
#declare Part3 =
union {
	#declare i = 0
	#while (i<12)
		box { <0, 0, -0.2>, <1.581, 0.1, 0.2>
			rotate <0, 0, 14.036> translate <0.5, -1.2, 0> rotate <(30*i), 0, 0>
		}
	#declare i = i+1
	#end
}
#declare Flame =
union {
light_source { <4.5, 0, 0> color rgb <0.85, 0.8, 1>
	fade_distance 10 fade_power 2
}
cylinder { <-1, 0, 0>, <15, 0, 0>, 1.5
  	pigment { color rgbt <1, 1, 1, 1> }
    halo {
      	emitting
      	spherical_mapping
      	linear
      	color_map {
			[ 0 color rgbt <0.3, 0.2, 0.8, 1> ]
        	[ 0.5 color rgbt <0.6, 0.5, 1, 0.3> ]
			[ 1 color rgbt <0.3, 0.2, 0.8, 1> ]

      	}
      	samples 10
//	  	turbulence 0.2
	  	frequency 4
		rotate <0, 0, 90>
		#if (EXHAUST_FLAME=0)
			scale <12, 0.75, 0.75>
		#else
			scale <(12*(EXHAUST_FLAME/10)), 0.75, 0.75>
		#end
		translate <0, 0, 0>
    }
	    halo {
      	emitting
      	spherical_mapping
      	linear
      	color_map {
			[ 0 color rgbt <0.3, 0.2, 0.8, 1> ]
        	[ 0.5 color rgbt <0.6, 0.5, 1, -1> ]
			[ 1 color rgbt <0.3, 0.2, 0.8, 1> ]

      	}
      	samples 10
//	  	turbulence 0.2
//	  	frequency 4
		rotate <0, 0, 90>
		#if (EXHAUST_FLAME=0)
		scale <6, 0.45, 0.45>
		#else
		scale <(6*(EXHAUST_FLAME/10)), 0.45, 0.45>
		#end
		translate <0, 0, 0>
    }
   hollow
   scale <1, 1.5, 1.5>
}
}

// *--> wing parts
#declare Wing1 =
difference {
	sphere { <0, 0, 0>, 3.5 }
	union {
		box { <0.01, -10, -10>, <10, 10, 10> }
		box { <-10, -10, -10>, <10, 0, 10> }
		box { <-10, -10, -10>, <10, 10, 0> }
		cylinder { <-10, 0, 0>, <10, 0, 0>, 1 scale <1, 3, 3.75326> }
	}
	translate <0, -3, 0>
	scale <4, 1, 2.5>
}
#declare Wing2 =
difference {
	sphere { <0, 0, 0>, 3.5 }
	union {
		box { <-0.01, -10, -10>, <-10, 10, 10> }
		box { <-10, -10, -10>, <10, 0, 10> }
		box { <-10, -10, -10>, <10, 10, 0> }
		cylinder { <-10, 0, 0>, <10, 0, 0>, 1 scale <1, 3, 3.75326> }
	}
	translate <0, -3, 0>
	scale <4, 1, 2.5>
}
#declare Wing3 =
difference {
	cone { <0, 0, 0>, 4.5, <0, 6, 0>, 1 }
	box { <-10, -10, 10>, <10, 10, 0> }
	scale <1, 1, (0.2/4.5)>
}

// **2** **2** **2** **2** **2** **2** **2** **2**
// *
// * OBJECTS : level 2 ; with textures

// *--> main (largest) body part
#declare Body1 =
object {
	difference {
		union {
			object { OneEightLeft scale <6, 1, 1.821> }			// originally " scale <6, 1, 1.821> "
			object { OneEightRght scale <6, 1, 1.821> }
			object { OneEightLeft scale <4, 1, 1.821> rotate <0, 180, 0> }
			object { OneEightRght scale <4, 1, 1.821> rotate <0, 180, 0> }
			object { OneEightLeft scale <3.39, 0.5, 1> rotate <180, 0, 0> translate <-11, 0, 0> }
			object { OneEightRght scale <3.39, 0.5, 1> rotate <180, 0, 0> translate <-11, 0, 0> }
			object { OneEightLeft scale <6.59, 0.5, 1> rotate <180, 180, 0> translate <-11, 0, 0> }
			object { OneEightRght scale <6.59, 0.5, 1> rotate <180, 180, 0> translate <-11, 0, 0> }
		}
		union {
			sphere { <0, 0, 0>, 0.99 scale <10, 1.5, 1.5> translate <10, 0, -2.5> }
			sphere { <0, 0, 0>, 0.99 scale <10, 1.5, 1.5> translate <10, 0, 2.5> }
			cylinder { <10, 0, -2.5>, <20, 0, -2.5>, 1.49 }
			cylinder { <10, 0, 2.5>, <20, 0, 2.5>, 1.49 }
		}
	}
	texture { Iridium1 }
}

// *--> engines
#declare EngineLeft =
union {
	object { Part1 texture { Iridium2 } }
	object { Part2 texture { Iridium2 } }
	object { Part3 texture { Iridium2 } }
	object { Wing3 texture { Iridium3 } rotate <-30, 0, 0> translate <-3.5, 0, 0> }
	object { Wing3 texture { Iridium3 } rotate <30, 180, 0> translate <-3.5, 0, 0> }
	#if (EXHAUST_FLAME != 0)
	object { Flame translate <3, 0, 0> }
	#end
}
#declare EngineRght =
union {
	object { Part1 texture { Iridium2 } }
	object { Part2 texture { Iridium2 } }
	object { Part3 texture { Iridium2 } }
	object { Wing3 texture { Iridium3 } rotate <30, 0, 0> translate <-3.5, 0, 0> }
	object { Wing3 texture { Iridium3 } rotate <-30, 180, 0> translate <-3.5, 0, 0> }
	#if (EXHAUST_FLAME != 0)
	object { Flame translate <3, 0, 0> }
	#end
}

// *--> wings
#declare WingLeft =
union {
	object { Wing1 scale <1.2, 1, 1> }
	object { Wing2 scale <0.7, 1, 1> }
	texture { Iridium2 }
}
#declare WingRght =
union {
	object { Wing1 scale <0.7, 1, 1> rotate <0, 180, 0> }
	object { Wing2 scale <1.2, 1, 1> rotate <0, 180, 0> }
	texture { Iridium2 }
}

// **F** **F** **F** **F** **F** **F** **F** **F**
// *
// * OBJECTS : Final

#declare Flier =
object {
	union {
		object { Body1 }
		object { EngineLeft translate <10, 0, -2.5> }
		object { EngineRght translate <10, 0, 2.5> }
		object { WingLeft translate <0, 0.263, 0> }
		object { WingRght translate <0, 0.263, 0> }
	}
}
