// Matthew Buckley
// sauron@cmu.edu
// Office for Glibregibila
// Begun: 12-14-96
// Completed:
// Version: 3.0 for Windows

#include "colors.inc"
#include "skies.inc"
#include "Bloopy.pov"
#include "alien.pov"

#declare M_Floor1 =
color_map {
    [0.0, 0.1 color rgb <0.88, 0.0, 0.0>
              color rgb <0.88, 0.0, 0.0>]
    [0.1, 0.9 color rgb <0.88, 0.0, 0.0>
              color rgb <0.60, 0.0, 0.0>]
    [0.9, 1.0 color rgb <0.60, 0.0, 0.0>
              color rgb <0.60, 0.0, 0.0>]
}
#declare M_Floor2 =
color_map {
    [0.0, 0.1 color rgb <0.0, 0.32, 0.0>*2
              color rgb <0.0, 0.32, 0.0>*2]
    [0.1, 0.2 color rgb <0.0, 0.35, 0.0>*2
              color rgb <0.0, 0.60, 0.0>*2]
    [0.2, 0.3 color rgb <0.0, 0.60, 0.0>*2
              color rgb <0.0, 0.30, 0.0>*2]
    [0.3, 0.4 color rgb <0.0, 0.30, 0.0>*2
              color rgb <0.0, 0.30, 0.0>*2]
    [0.4, 0.9 color rgb <0.0, 0.30, 0.0>*2
              color rgb <0.0, 0.60, 0.0>*2]
    [0.9, 1.0 color rgb <0.0, 0.60, 0.0>*2
              color rgb <0.0, 0.32, 0.0>*2]
}


#declare M_Floor3 =
color_map {
    [0.0, 0.1 color rgb <0.0, 0, 0.16>* 4
              color rgb <0.0, 0, 0.16>* 4]
    [0.1, 0.9 color rgb <0.0, 0, 0.20>* 4
              color rgb <0.0, 0, 0.26>* 4]
    [0.9, 1.0 color rgb <0.0, 0, 0.26>* 4
              color rgb <0.0, 0, 0.16>* 4]
}

#declare Floor =
box {
  <-26,0,-26>
  <26,-1,26>
  texture {
    hexagon
    texture {
      pigment {
        wood
        turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        rotate <2,2,0>
        color_map { M_Floor1 }
      }
      rotate <0,240,0>
    }
    texture {
      pigment {
        wood
        turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        rotate <2,2,0>
        color_map { M_Floor2 }
      }
      rotate <0,120,0>
    }
    texture {
      pigment {
        wood
        turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        rotate <2,2,0>
        color_map { M_Floor3 }
      }
    }
    scale 1
  } // texture
}

#declare Switch =
union {
  difference {
    box {
      <-0.5,1,-0.1>
      <0.5,-1,0.1>
    }
    box {
      <-0.05,0.8,-0.11>
      <0.05,-0.8,0.11>
    }
    texture { pigment { color rgb 0.2 } }
  }
  difference {
    cylinder {
      <0,0.4,0.4>
      <0,0.4,-0.4> 0.4
    }
    sphere {
      <0,0.4,-1> 0.7
    }
    texture { pigment { color rgb 0.3 } }
  }
}//Switch

#declare WallsandCeiling =
union {
  box {
    <25,-1,26>
    <26,26,-26>
  }
  box {
    <-25,-1,26>
    <-26,26,-26>
  }
  box {
    <-26,26,-26>
    <26,25,26>
  }
  object {
    Switch
    translate <22.5,10,25>
  }
  difference {
    box {
      <26,-1,25>
      <-26,26,28>
    }
    box {
      <20,20,24.99>
      <-20,5,28.01>
    }
    bounded_by {
      box {
        <26,-1,25>
        <-26,26,26>
      }
    }// bounded_by
  }// difference
  box {
    <21,4,25.5>
    <-21,21,27.5>
    texture {
      pigment {
        color rgbt<1,1,1,0.8>
      }
      finish {
        ambient 0.0
        //irid {0.2 thickness 1 turbulence 2}
        ior 1.1
        fade_distance 8
        fade_power 2
        //phong 0.7
        //phong_size 50
        refraction on
        roughness 0.5
      }
    }// texture
  }// window
  texture {
    pigment { color rgb<0.6,0.4,0> }
    finish { ambient 0.3 }
    normal { bumps 0.2 scale 0.2 }
  }
}// WallsandCeiling


#declare Stool =
union {

  torus {
    3, 1
    translate <0,3,0>
    texture {
      pigment { color rgb <0.2,0.4,1> }
      normal { crackle }
      finish {
        irid {0.2 thickness 1 turbulence 2}
        phong 0.7
        phong_size 50
        roughness 0.5
      }
    }
  }

  union {
    cylinder {
      <3,3,0>
      <3,1,0>
      0.5
    }
    sphere {
      <3,0.8,0> 0.8
    }
    sphere {
      <3,0.5,0> 0.5
      texture { pigment { color rgb 0 } }
    }
    texture {
      pigment { color rgb <0.1,0.2,1> }
      finish {
        specular 1
        metallic
      }
    }
  }// one leg

  union {
    cylinder {
      <3,3,0>
      <3,1,0>
      0.5
    }
    sphere {
      <3,0.8,0> 0.8
    }
    sphere {
      <3,0.5,0> 0.5
      texture { pigment { color rgb 0 } }
    }
    texture {
      pigment { color rgb <0.1,0.2,1> }
      finish {
        specular 1
        metallic
      }
    }
    rotate <0,120,0>
  }// one leg

  union {
    cylinder {
      <3,3,0>
      <3,1,0>
      0.5
    }
    sphere {
      <3,0.8,0> 0.8
    }
    sphere {
      <3,0.5,0> 0.5
      texture { pigment { color rgb 0 } }
    }
    texture {
      pigment { color rgb <0.1,0.2,1> }
      finish {
        specular 1
        metallic
      }
    }
    rotate <0,240,0>
  }// one leg

}//Stool


#declare handle =
union {
  cylinder {
    <0.1,0,4>
    <-2,0,4>  0.2
  }
  cylinder {
    <0.1,0,-4>
    <-2,0,-4>  0.2
  }
  cylinder {
    <-2,0,-4>
    <-2,0,4>  0.2
  }
  sphere {
    <-2,0,4>  0.2
  }
  sphere {
    <-2,0,-4>  0.2
  }
  texture {
    pigment { color rgb <0,0.3,0.1> }
    finish {
      specular 1
      metallic
    }
  }
}

#declare Cabinet =
union {
  box {
    <-0,0,0>
    <-10,15,12>
  }
  box {
    <-9,1,1>
    <-10.1,7,11>
  }
  box {
    <-9,8,1>
    <-10.1,14,11>
  }
  box {
    <-9,0.98,0.98>
    <-10.05,7.02,11.02>
    texture { pigment { rgb 0 } }
  }
  box {
    <-9,7.98,0.98>
    <-10.05,14.02,11.02>
    texture { pigment { rgb 0 } }
  }
  object { handle translate <-10,4,6> }
  object { handle translate <-10,11,6> }

  texture {
    pigment { color rgb <0,0.5,0.3> }
    finish {
      specular 1
      metallic
    }
    normal { bumps 0.1 scale 0.1 }
  }
}//Cabinet

#declare Monitor =
box {
  <0.1, 0, -10>
  <-1,20,10>
  texture {
    pigment { color rgb <0,0.5,0.3> }
    finish {
      specular 1
      metallic
    }
    normal { bumps 0.1 scale 0.1 }
  }
  texture {
    pigment {
      image_map { gif "monitor.gif" once }
    }
    finish { roughness 0.001 ambient 1 diffuse 0}
    normal {bumps 0}
    translate <-0.5,-0.5,0>
    rotate <0,90,0>
    scale 19
    translate <0,10,0>
  }
}//Monitor

#declare Office =
union {
  object { Floor }
  object { WallsandCeiling }
  object { Stool scale 0.5 translate <-2,0,20> }
  object { Cabinet scale 0.7 translate <24,0,-7> }
  object { Monitor translate <25,3,11> }
} // union (END OF OFFICE)




#declare CameraLoc = <-14,10,-10>
#declare EverthingButTheGlibregibila =
union {

  object {
    Bloopy
    rotate <0,0,-10>
    translate <10,20,40>
  }
  object {
    Bloopy
    scale 0.6
    rotate <0,0,-10>
    translate <20,10,35>
  }
  object {
    Bloopy
    scale 0.8
    rotate <0,0,-10>
    translate <0,12,45>
  }
  object {
    Bloopy
    scale 0.3
    rotate <0,0,-10>
    translate <17,18,32>
  }

  object {
    Bloopy
    scale 1.3
    rotate <0,0,-10>
    translate <25,15,60>
  }

  object {
    Bloopy
    scale 2
    rotate <0,0,-10>
    translate <21,7,80>
  }

  object {
    Office
  }

  sphere { <0,0,0>, 10000
    texture {
      pigment {color rgb<0,0,0.3>}
      finish {
        ambient 1
        diffuse 0
      }
    }
    texture {
       T_Cloud1
       scale 1000
    }
    hollow
  }

  light_source {
    <23,23,0>
    color rgb<1,1,1>
  }
  light_source {
    <-23,23,0>
    color rgb<1,1,1>
  }

}


object {
  EverthingButTheGlibregibila
  translate <-16,0,-16>
  rotate <0,180,0>
}

camera {
  location CameraLoc + <-16,0,-16>
  look_at <0,10,7>
  rotate <0,180,0>
}

object { Alien translate AlienLoc}
