// Time Flies When You're Having Fun
//
// Scene by Peter R. Jones

#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "textures.inc"
#include "glass.inc"

camera {
  location <20, 20, -20>
  look_at  <0, 0, 0>
  }

light_source { <8, -8, -10> color rgb <0.3, 0.4, 0.4> }
light_source { <-8, -8, -10> color rgb <0.3, 0.4, 0.4> }
light_source { <0, 50, -50> color rgb <0.9, 0.85, 0.85> }
light_source {
  <0, 15, -5>
  color White
  spotlight
  point_at <0, 0, 0>
  radius 3
  falloff 6
  tightness 20
  }
light_source {
  <5, 10, -5>
  color White
  spotlight
  point_at <0, 0, 0>
  radius 3
  falloff 6
  tightness 20
  }
light_source {
  <-5, 10, -5>
  color White
  spotlight
  point_at <0, 0, 0>
  radius 3
  falloff 6
  tightness 20
  }

sky_sphere {
  pigment { color rgb <0.2, 0.1, 0.1> }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.75, 0.75, 0.75>]
      [0.1 0.5 color rgb <0.75, 0.75, 0.75> color rgbt <1, 1, 1, 1>]
      [0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]
      }
    scale <0.2, 0.5, 0.2>
    }
  }

box {
  <-5, -5, -5>, <5, -5.1, 5>
  texture {
    T_Gold_1D
    normal { waves 0.9 }
    }
  }

#declare Clock_Case = union {
  difference {
    cylinder { <0, 0, -0.4>, <0, 0, 2.2>, 2.52 }
    cylinder { <0, 0, -0.5>, <0, 0, 2.3>, 2.51 }
    texture {
      pigment { color Red }
      finish { Glossy }
      }
    }
  difference {
    cylinder { <0, 0, -0.4>, <0, 0, 2.2>, 2.51 }
    cylinder { <0, 0, -0.5>, <0, 0, 2.3>, 2.50 }
    texture { Aluminum }
    }
  intersection {
    cylinder { <0, 0, -1>, <0, 0, 0>, 2.5 }
    difference {
      sphere { <0, 0, 35>, 35.35 }
      sphere { <0, 0, 35>, 35.20 }
      }
    texture { T_Glass4 }
    }
  torus {
    2.51, 0.1
    rotate <90, 0, 0>
    translate <0, 0, -0.4>
    texture { T_Gold_1D }
    }
  torus {
    2.51, 0.1
    rotate <90, 0, 0>
    translate <0, 0, 2.2>
    texture { Aluminum }
    }
  }

#declare Clock_Bell = union {
  intersection {
    box { <-1, 0, -1>, <1, 1, 1> }
    difference {
      sphere { <0, 0, 0>, 0.6 }
      sphere { <0, 0, 0>, 0.5 }
      }
    }
  torus { 0.55, 0.1 }
  sphere { <0, 0.55, 0>, 0.15 }
  cylinder { <0, -0.4, 0>, <0, 0.55, 0>, 0.05 }
  translate <0, 0.2, 0>
  texture { Aluminum }
  }

#declare Clock_Hammer = union {
  cylinder { <0, -0.1, 0>, <0, 0.45, 0>, 0.05 }
  difference {
    cylinder { <-0.2, 0.45, 0>, <0.2, 0.45, 0>, 0.15 }
    torus { 0.2, 0.1 rotate <0, 0, 90> translate <0, 0.45, 0> }
    }
  texture { Aluminum }
  }

#declare Clock_Alarm = union {
  object {
    Clock_Bell
    translate <0, 2.55, 1>
    rotate <0, 0, 20>
    }
  object  {
    Clock_Bell
    translate <0, 2.55, 1>
    rotate <0, 0, -20>
    }
  object {
    Clock_Hammer
    rotate <0, 0, 18>
    translate <0, 2.5, 1>
    }
  }

#declare Clock_Face = object {
  cylinder { <0, 0, 0>, <0, 0, 1>, 2.5 }
  texture {
    pigment {
      image_map {
        gif "pj-cface.gif"
        }
      }
    translate <0.5, 0.5, 0>
    scale 5.0
    }
  }

#declare Clock_Feather = union {
  cone {
    <0, 0, 0>, 0.05
    <0, 0, 2.5>, 0.01
    }
  mesh {
    triangle { <0, -0.03, 0.5>, <-0.5, 0, 0.5>, <0, 0.05, 0.5> }
    triangle { <0, 0, 2.5>, <-0.3, 0, 2.4>, <0, 0.01, 2.5> }
    triangle { <0, 0.05, 0.5>, <0, 0.01, 2.5>, <-0.5, 0, 0.5> }
    triangle { <-0.5, 0, 0.5>, <-0.3, 0, 2.4>, <0, 0.01, 2.5> }
    triangle { <0, -0.03, 0.5>, <0, 0, 2.5>, <-0.5, 0, 0.5> }
    triangle { <-0.5, 0, 0.5>, <-0.3, 0, 2.4>, <0, 0, 2.5> }
    }
  rotate <10, 0, 15>
  }

#declare Clock_WingPart = union {
  cone { <2.45, 0, 0>, 0.3, <5, 0, 0>, 0.25 }
  object { Clock_Feather translate <2.5, 0.250, 0> scale 1.0 }
  object { Clock_Feather translate <2.7, 0.245, 0> scale 0.995 }
  object { Clock_Feather translate <2.9, 0.240, 0> scale 0.99 }
  object { Clock_Feather translate <3.1, 0.236, 0> scale 0.985 }
  object { Clock_Feather translate <3.3, 0.232, 0> scale 0.98 }
  object { Clock_Feather translate <3.5, 0.228, 0> scale 0.975 }
  object { Clock_Feather translate <3.7, 0.224, 0> scale 0.97 }
  object { Clock_Feather translate <3.9, 0.220, 0> scale 0.965 }
  object { Clock_Feather translate <4.1, 0.216, 0> scale 0.96 }
  object { Clock_Feather translate <4.3, 0.212, 0> scale 0.955 }
  object { Clock_Feather translate <4.5, 0.208, 0> scale 0.95 }
  object { Clock_Feather translate <4.7, 0.204, 0> scale 0.945 }
  object { Clock_Feather translate <4.9, 0.200, 0> scale 0.94 }
  }

#declare Clock_Wing = union {
  cone { <1, 0, 0>, 0.5, <2.45, 0, 0>, 0.3 }
  object { Clock_WingPart }
  union {
    object { Clock_WingPart }
    object { Clock_Feather scale 0.85 translate <4.92, 0.19, 0> }
    object { Clock_Feather scale 0.64 translate <4.94, 0.18, 0> }
    object { Clock_Feather scale 0.42 translate <4.96, 0.17, 0> }
    object { Clock_Feather scale 0.2 translate <4.98, 0.165, 0> }
    translate <-2.45, 0, 0>
    rotate <0, -15, -15>
    scale 0.92
    translate <4.95, 0, 0>
    }
  sphere { <5, 0, 0>, 0.35 }
  scale 0.9
  rotate <0, 15, 25>
  translate <0.3, 1, 1>
  texture { Aluminum }
  }

#declare Clock_BigHand = intersection {
  box { <1, 3, -0.005>, <-1, -1, 0.005> }
  union {
    cylinder { <0, 0, 0>, <0, 1.6, 0>, 0.05 }
    sphere { <0, 0, 0>, 0.1 }
    sphere { <0, 1.6, 0>, 0.1 }
    cone { <0, 1.6, 0>, 0.1, <0, 2.2, 0>, 0 }
    }
  translate <0, 0, -0.05>
  texture { pigment { color Black } }
  }

#declare Clock_LittleHand = intersection {
  box { <1, 3, -0.005>, <-1, -1, 0.005> }
  union {
    cylinder { <0, 0, 0>, <0, 1, 0>, 0.05 }
    sphere { <0, 0, 0>, 0.15 }
    sphere { <0, 1, 0>, 0.15 }
    cone { <0, 1, 0>, 0.15, <0, 1.4, 0>, 0 }
    }
  translate <0, 0, -0.025>
  texture { pigment { color Black } }
  }

#declare Clock_SecondHand = intersection {
  box { <1, 3, -0.005>, <-1, -1, 0.005> }
  union {
    cylinder { <0, -0.5, 0>, <0, 1.8, 0>, 0.03 }
    sphere { <0, 0, 0>, 0.12 }
    }
  translate <0, 0, -0.075>
  texture { T_Gold_1D }
  }

#declare Clock = union {
  object { Clock_Case }
  object { Clock_Face }
  object { Clock_Alarm }
  object { Clock_Wing }
  object { Clock_Wing scale <-1, 1, 1> }
  light_source { <0, 0, -1.5> color rgb <0.6, 0.6, 0.4> }
  }

union {
  object { Clock }
  object { Clock_BigHand }
  object { Clock_LittleHand }
  object { Clock_SecondHand }
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, 60> }
  object { Clock_LittleHand rotate <0, 0, 5> }
  object { Clock_SecondHand }
  translate <0, 0, -10>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, 120> }
  object { Clock_LittleHand rotate <0, 0, 10> }
  object { Clock_SecondHand }
  translate <0, 0, -20>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, 180> }
  object { Clock_LittleHand rotate <0, 0, 15> }
  object { Clock_SecondHand }
  translate <0, 0, -30>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -60> }
  object { Clock_LittleHand rotate <0, 0, -5> }
  object { Clock_SecondHand }
  translate <0, 0, 10>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -120> }
  object { Clock_LittleHand rotate <0, 0, -10> }
  object { Clock_SecondHand }
  translate <0, 0, 20>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -180> }
  object { Clock_LittleHand rotate <0, 0, -15> }
  object { Clock_SecondHand }
  translate <0, 0, 30>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -240> }
  object { Clock_LittleHand rotate <0, 0, -20> }
  object { Clock_SecondHand }
  translate <0, 0, 40>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -300> }
  object { Clock_LittleHand rotate <0, 0, -25> }
  object { Clock_SecondHand }
  translate <0, 0, 50>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, 0> }
  object { Clock_LittleHand rotate <0, 0, -30> }
  object { Clock_SecondHand }
  translate <0, 0, 60>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -60> }
  object { Clock_LittleHand rotate <0, 0, -35> }
  object { Clock_SecondHand }
  translate <0, 0, 70>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -120> }
  object { Clock_LittleHand rotate <0, 0, -40> }
  object { Clock_SecondHand }
  translate <0, 0, 80>
  }

union {
  object { Clock }
  object { Clock_BigHand rotate <0, 0, -180> }
  object { Clock_LittleHand rotate <0, 0, -45> }
  object { Clock_SecondHand }
  translate <0, 0, 90>
  }

#declare SpaceTime = union {
  cylinder { <1000, -5, -5>, <-1000, -5, -5>, 0.5 }
  cylinder { <1000, -5, -15>, <-1000, -5, -15>, 0.25 }
  cylinder { <1000, -5, -25>, <-1000, -5, -25>, 0.25 }
  cylinder { <1000, -5, -35>, <-1000, -5, -35>, 0.25 }
  cylinder { <1000, -5, -45>, <-1000, -5, -45>, 0.25 }
  cylinder { <1000, -5, 5>, <-1000, -5, 5>, 0.5 }
  cylinder { <1000, -5, 15>, <-1000, -5, 15>, 0.25 }
  cylinder { <1000, -5, 25>, <-1000, -5, 25>, 0.25 }
  cylinder { <1000, -5, 35>, <-1000, -5, 35>, 0.25 }
  cylinder { <1000, -5, 45>, <-1000, -5, 45>, 0.25 }
  cylinder { <1000, -5, 55>, <-1000, -5, 55>, 0.25 }
  cylinder { <1000, -5, 65>, <-1000, -5, 65>, 0.25 }
  cylinder { <1000, -5, 75>, <-1000, -5, 75>, 0.25 }
  cylinder { <1000, -5, 85>, <-1000, -5, 85>, 0.25 }
  cylinder { <1000, -5, 95>, <-1000, -5, 95>, 0.25 }
  cylinder { <1000, -5, 105>, <-1000, -5, 105>, 0.25 }
  cylinder { <1000, -5, 115>, <-1000, -5, 115>, 0.25 }
  cylinder { <1000, -5, 125>, <-1000, -5, 125>, 0.25 }
  cylinder { <1000, -5, 135>, <-1000, -5, 135>, 0.25 }
  cylinder { <1000, -5, 145>, <-1000, -5, 145>, 0.25 }
  cylinder { <1000, -5, 155>, <-1000, -5, 155>, 0.25 }
  cylinder { <1000, -5, 165>, <-1000, -5, 165>, 0.25 }
  cylinder { <1000, -5, 175>, <-1000, -5, 175>, 0.25 }
  cylinder { <1000, -5, 185>, <-1000, -5, 185>, 0.25 }
  cylinder { <1000, -5, 195>, <-1000, -5, 195>, 0.25 }
  texture { T_Gold_1E }
  }

object { SpaceTime }
object { SpaceTime rotate < 0, -90, 0> }
cylinder {
  <-5, -1000, 5>, <-5, 1000, 5>, 0.5
  texture { T_Gold_1E }
  }
cylinder {
  <5, -1000, 5>, <5, 1000, 5>, 0.5
  texture { T_Gold_1E }
  }

box {
  <-5, -1000, 5>, <5, 1000, 5.1>
  texture {
    T_Yellow_Glass
    normal { bumps 0.1 scale 0.8 }
    }
  }
