// Persistence of Vision Ray Tracer Scene Description File
// File: buttrfly.pov
// Vers: 3.00e Watcom Win32
// Desc: Code for butter-fly like creatures
// Date: November 30, 1996
// Auth: Sonya Roberts
// Note: Uses lots of image maps, I'm sad to say

#if (I_Butterflys=True)
	#debug "Builind butterfiles...\n"

	#declare Wing1=
	object {
		box{<0,0,0>,<1,1,.0001>}
		pigment {
			image_map {
				gif "bttrfly1.gif"
				filter 0, 1
			}
		}
		finish {ambient .4}
		translate <0,-1,0>
		scale <.4,.5,.1>
		rotate x*90
	}

	#declare Wing2=
	object {
		box{<0,0,0>,<1,1,.0001>}
		pigment {
			image_map {
				gif "bttrfly2.gif"
				filter 0, 1
			}
		}
		finish {ambient .4}
		translate <0,-1,0>
		scale <.45,.15,.1>
		rotate x*90
	}

	#declare Wing3=
	object {
		box{<0,0,0>,<1,1,.0001>}
		pigment {
			image_map {
				gif "bttrfly3.gif"
				filter 0, 1
			}
		}
		finish {ambient .4}
		translate <0,-1,0>
		scale <.375,.375,.1>
		rotate x*90
	}

	#declare Body=
	object {
		union {
			sphere {<0,0,0>,.05	scale <1,.5,1>}
			difference {
				torus {.05,.005	rotate x*90	translate <0,.05,0>}
				cylinder {<0,.1,-.02>,<0,.1,.02>,.03}
				scale <1.25,.75,1>
				rotate x*17
			}
			sphere {<-.03,.015,0.015>,.02		pigment {color Black} finish {reflection .3}}
			sphere {<.03,.015,0.015>,.02		pigment {color Black} finish {reflection .3}}
			sphere {<0,0,-.075>,.05	scale <.75,.5,1.5>}
			difference {
				union {
					torus {.05,.005	rotate x*90}
					torus {.05,.005	rotate x*90	translate <0,0,-.04>}
					torus {.05,.005	rotate x*90	translate <0,0,-.08>}
				}
				cylinder {<0,-.05,-.11>,<0,-.05,.1>,.04}
				translate <0,-.05,-.09>
			}
			union {
				cone {<0,0,0>,.025,<0,0,-.05>,.0225}
				cone {<0,0,-.04>,.0223,<0,0,-.1>,.02}
				cone {<0,0,-.09>,.018,<0,0,-.15>,.0175}
				cone {<0,0,-.14>,.0155,<0,0,-.2>,.015}
				scale <1,.8,1>
				translate <0,0,-.175>
			}
		}
		pigment {color BakersChoc}
		finish {
			phong .3
		}
	}

	#declare Butterfly1 =
	union {
		object {Body}
		object {Wing1}
		object {Wing1	rotate z*180}
	}

	#declare Butterfly2 =
	union {
		object {Body}
		object {Wing1	rotate z*30}
		object {Wing1	rotate z*(180-30)}
	}

	#declare Butterfly3 =
	union {
		object {Body}
		object {Wing1	rotate z*55}
		object {Wing1	rotate z*(180-55)}
	}

	#declare Butterfly4 =
	union {
		object {Body}
		object {Wing2	rotate z*28}
		object {Wing2	rotate z*(180-28)}
		object {Wing3	rotate z*25		translate <0,0,-.1>}
		object {Wing3	rotate z*(180-25)	translate <0,0,-.1>}
	}
#end

#if (I_Dragonfly=True)
	#debug "Drawing dragonfiles...\n"

	#declare DragWing=
	object {
		box{<0,0,0>,<1,1,.0001>}
		texture {
			pigment {
				image_map {
					gif "drgnfly2.gif"
					filter all .85
					filter 0, 1
				}
			}
		}
		texture {
			pigment {
				image_map {
					gif "drgnfly3.gif"
					filter 0, 1
				}
			}
		}
		normal {
			bump_map {
				gif "drgnfly1.gif"
				bump_size .02
			}
		}
		finish {
			phong .3
			reflection .015
		}
		translate <0,-1,0>
		scale <.6,.15,.1>
		rotate x*90
	}

	#declare DragBody=
	object {
		union {
			sphere {<0,0,0>,.05	scale <.75,.5,1>}
			difference {
				torus {.05,.005	rotate x*90	translate <0,.05,0>	pigment {color NavyBlue}}
				cylinder {<0,.1,-.02>,<0,.1,.02>,.03}
				scale <.75,1.25,1>
				rotate x*-65
			}
			union {
				sphere {<-.03,.012,0.015>,.015}
				sphere {<.03,.012,0.015>,.015}
				pigment {color DarkGreen*.5}
				finish {reflection .3}
			}
			sphere {<0,0,-.075>,.05	scale <.75,.5,1.5>}
			difference {
				union {
					torus {.05,.004	rotate x*90}
					torus {.05,.004	rotate x*90	translate <0,0,-.03>}
					torus {.05,.004	rotate x*90	translate <0,0,-.06>}
					torus {.05,.004	rotate x*90	translate <0,0,-.09>}
				}
				cylinder {<0,-.05,-.11>,<0,-.05,.1>,.04}
				translate <0,-.05,-.07>
				scale <1,.75,1>
			}
			union {
				cone {<0,0,0>,.025,<0,0,-.05>,.021}
				cone {<0,0,-.04>,.02,<0,0,-.1>,.017}
				cone {<0,0,-.09>,.015,<0,0,-.15>,.013}
				cone {<0,0,-.14>,.011,<0,0,-.2>,.009}
				scale <1,.8,1>
				translate <0,0,-.15>
			}
		}
		pigment {color NavyBlue*.5}
		finish {
			irid {
				.5
				thickness .001
				turbulence .25
			}
			phong .3
		}
	}

	#declare Dragonfly =
	union {
		object {DragBody}
		object {DragWing				translate <0,0,-.04>}
		object {DragWing	rotate z*180		translate <0,0,-.04>}
		object {DragWing	scale <.7,.7,.7>	rotate y*15	rotate z*5		translate <0,0,-.1>}
		object {DragWing	scale <.7,.7,.7>	rotate y*15	rotate z*(180-5)	translate <0,0,-.1>}
	}
#end

#if (I_Anthill=True)
	#debug "Assembling anthill and ants...\n"

	#declare AntLegLeft=
	object {
		cone {<0,0,0>,.012,<.06,-.08,0>,.005}
	}

	#declare AntLegRight=
	object {
		cone {<0,0,0>,.012,<-.06,-.08,0>,.005}
	}

	#declare AntBody=
	object {
		union {
			sphere {<0,0,0>,.05	scale <1,.8,1.1>}
			sphere {<0,0,0>,.05	scale <1,.75,1.35>	translate <0,0,.09>	pigment {color Copper*1.5} finish {phong .3}}
			sphere {<0,0,0>,.03	scale <1,.8,1.1>	translate <0,0,-.09>}
			union {
				sphere {<0,0,0>,.0075	translate <.02,.03,-.03>}
				sphere {<0,0,0>,.0075	translate <-.02,.03,-.03>}
				pigment {color Black}
				finish {phong .3}
			}
			object {AntLegLeft	rotate y*30	translate <.03,0,-.04>}
			object {AntLegLeft	rotate y*0	translate <.02,0,0>}
			object {AntLegLeft	rotate y*-20	translate <.03,0,-.04>}
			object {AntLegRight	rotate y*-30	translate <-.03,0,-.04>}
			object {AntLegRight	rotate y*0	translate <-.02,0,0>}
			object {AntLegRight	rotate y*20	translate <-.03,0,-.04>}
		}
		translate <0,.08,0>
	}

	#declare Ant1=
	object {
		AntBody
		pigment {color Flesh*.75}
		finish {phong .3}
		scale <1.25,1.25,1.25>
	}

	#declare Ant2=
	object {
		union {
			object {AntBody}
			union {
				sphere {<0,0,.04>,.04	scale <1.5,.1,4>	rotate x*-10	rotate y*20}
				sphere {<0,0,.04>,.04	scale <1.5,.1,4>	rotate x*-10	rotate y*-20}
				texture {T_Old_Glass}
				translate <0,.075,-.025>
			}
		}
		pigment {color Flesh}
		finish {phong .3}
		scale <1.5,1.5,1.5>
	}

	#declare Ant3=
	object {
		union {
			object {AntBody}
			union {
				sphere {<0,0,.04>,.04	scale <1.5,.1,4>	rotate x*-25	rotate y*40}
				sphere {<0,0,.04>,.04	scale <1.5,.1,4>	rotate x*-25	rotate y*-40}
				texture {T_Old_Glass}
				translate <0,.075,-.025>
			}
		}
		pigment {color Flesh}
		finish {phong .3}
		scale <1.5,1.5,1.5>
	}

	#declare Anthill=
	object {
		union {
			difference {
				cone {<0,0,0>,.6,<0,.25,0>,.25}
				cone {<0,.26,0>,.1,<0,.05,0>,0}
				pigment {color LightWood*1.2}
				finish {crand .35}
			}
			// Ants on Ground
			object {Ant1	rotate y*-90	translate <1.5,0,2.25>}
			object {Ant2	rotate y*45	translate <1,0,2.2>}
			object {Ant1	rotate y*-160	translate <-.4,0,1.5>}
			object {Ant1	rotate y*135	translate <-.25,.25,.25>}
			object {Ant3	rotate y*-80	rotate z*30	translate <.7,.1,-.9>}
			object {Ant1	rotate y*50	translate <-.7,0,-.1>}
			object {Ant1	rotate y*20	translate <-.9,0,-1.3>}
			object {Ant1	rotate y*52	translate <-.5,0,-1.5>}
			object {Ant2	rotate y*-37	translate <0,0,-1.4>}
			object {Ant1	rotate y*33	translate <-1.8,0,-1.75>}

			// Flying Ants
			object {Ant3	rotate x*22	rotate y*-165	translate <.3,1,.6>}
			object {Ant3	rotate x*34	rotate y*77	translate <-.7,2.1,-1>}
			object {Ant3	rotate x*29	rotate y*30	translate <-2,2.8,-2.73>}
			object {Ant3	rotate x*37	rotate y*42	translate <-3,3.67,-3.44>}
			object {Ant3	rotate x*65	rotate y*50	translate <-4,5.13,-4.86>}
			object {Ant3	rotate x*25	rotate y*35	translate <-6,4.9,-7.86>}
		}
	}
#end

