// Persistence of Vision Ray Tracer Scene Description File
// File: HAIRYCON.inc
// Vers: 3.00e Watcom Win32
// Desc: File for creation of "hairy" conical objects
// Date: December 1, 1996
// Auth: Sonya Roberts
// Note: Been experimenting with this for a while; can get some very
//       odd & interesting results using "hairy primitives".
//       Please note that all hairy objects are created in the
//       +y direction from the origin, centered around the y-axis.

#ifndef (True)		#declare True=1			#end
#ifndef (False)		#declare False=0		#end
#ifndef(Orientation)	#declare Orientation=<0,0,0>	#end
#ifndef(Position)	#declare Position=<0,0,0>	#end
#ifndef(ConRad1)	#declare ConRad1=.25		#end
#ifndef(ConRad2)	#declare ConRad2=.5		#end
#ifndef(ConLen)		#declare ConLen=1		#end
#ifndef(HairLen)	#declare HairLen=.5		#end
#ifndef(HairThick)	#declare HairThick=.015		#end
#ifndef(HairSpacing)	#declare HairSpacing=1.5	#end
#ifndef(HairComb)	#declare HairComb=False		#end

#debug "Creating hairy cone...\n"
object {
	#declare HairRows=int(ConLen/(HairThick*HairSpacing))
	#declare RS=seed(1)
	union {
		cone {<0,0,0>,ConRad1,<0,ConLen,0>,ConRad2	pigment{color NewTan}}
		#declare YCount=0
		#while (YCount<=HairRows)
			#declare ConSecRad=ConRad1+(((ConLen/HairRows)*YCount)*((ConRad2-ConRad1)/ConLen))
			#declare HairRotation=((pi*(ConSecRad*ConSecRad))/(HairThick*HairSpacing))
			#declare YRot=0
			union {					// This union is not necessary, but gives POV better bounding box options
				#while (YRot<= HairRotation)
					cone {
						<0,0,0>,HairThick,<0,0,HairLen>,(HairThick/4)
						pigment {
							gradient z
							color_map {
								[0	color White]
								[.75	color MediumWood]
								[1	color DarkBrown]
							}
							scale <HairLen*1.0001,HairLen*1.0001,HairLen*1.0001>
						}
						finish {ambient .5}
						#if (HairComb=True)
							rotate <						// Give hair individual orientation
								(rand(RS)*(40+(360/HairRotation))),
								(rand(RS)*(360/HairRotation))-((360/HairRotation)/2),
								0
							>
						#else
							rotate <						// Give hair individual orientation
								(rand(RS)*(360/HairRotation))-((360/HairRotation)/2),
								(rand(RS)*(360/HairRotation))-((360/HairRotation)/2),
								0
							>
						#end
						translate <							// Move into position for rotation
							0,
							(YCount*(HairThick*HairSpacing))+((rand(RS)*(HairThick/HairSpacing))-((HairThick/HairSpacing)/2)),
							ConSecRad
						>
						rotate y*((YRot*(360/HairRotation))+((rand(RS)*(HairRotation/HairSpacing))-((HairRotation/HairSpacing)/2)))
					}
					#declare YRot=YRot+1
				#end
			}
			#declare YCount=YCount+1
		#end
	}
	rotate Orientation
	translate Position
}
