// Persistence of Vision Ray Tracer Scene Description File
// File: plants.pov
// Vers: 3.00e Watcom Win32
// Desc: Some assorted plants to use in the scene
// Date: December 2, 1996
// Auth: Sonya Roberts
// Note:

#if (I_Cattails=True)
	#debug "Creating Cattails...\n"

	#declare CattailHead=
	object {
		union {
			sphere {<0,0,0>,.1}
			cylinder {<0,0,0>,<0,-.35,0>,.1}
			sphere {<0,-.35,0>,.1}
		}
		pigment {color Copper*1.1}
	}

	#declare CattailLeaf=
	object {
		union {
			cylinder {<0,0,0>,<0,2,0>,.1}
			cone {<0,2,0>,.1,<0,3,0>,.01}
		}
		scale <2,1.25,.001>
		pigment {color MediumForestGreen*1.25}
	}

	#declare R1=seed(1)
	#declare Cattail=
	object {
		#declare Top=5+((rand(R1)*2)-1)
		union {
			cylinder {<0,0,0>,<0,Top,0>,.05}
			cone {<0,Top,0>,.05,<0,Top+.25,0>,.015}
			object {CattailHead	translate <0,Top-.05,0>}
		}
	}

	#declare Cattails=
	union {
		#declare Count=0
		#while (Count<=125)
			union {
				object {
					Cattail
				}
				#declare Leaves=1
				#while (Leaves<=int(1+(rand(R1)*4)))
					object {
						CattailLeaf
						scale <1,1+((rand(R1)*.5)-.25),1>
						rotate x*(rand(R1)*20)
						translate <0,0,.065>
						rotate y*(rand(R1)*360)
					}
					#declare Leaves=Leaves+1
				#end
				scale <1,1+((rand(R1)*.8)-.4),1>
				rotate x*(rand(R1)*15)
				rotate y*(rand(R1)*360)
				translate <-35+(rand(R1)*10),0,0>
				rotate y*(rand(R1)*70)
			}
			#declare Count=Count+1
		#end
		pigment {color MediumForestGreen}
		finish {phong .15}
	}
#end

#if (I_Flowers=True)
	#debug "Creating flowers...\n"

	#debug "     - Dandelion\n"
	#declare DandeLeaf=
	object {
		difference {
			sphere {<0,0,.1>,.1	scale <1,.002,3>}
			sphere {<-.15,0,.1>,.08}
			sphere {<.15,0,.1>,.076}
			sphere {<-.13,0,.2>,.078}
			sphere {<.13,0,.2>,.079}
			sphere {<-.1,0,.3>,.075}
			sphere {<.1,0,.3>,.075}
		}
		translate <0,0,0>
	}

	#declare Dandelion=
	object {
		union {
			#declare R2=seed(2)
			#declare Count=1
			union {
				#while (Count<=100)
					cylinder {<0,0,0>,<0,.175,0>,.01	rotate <((rand(R2)*180)-90),(rand(R2)*360),0>}
					#declare Count=Count+1
				#end
				pigment {color Yellow}
				finish {ambient .3}
			}
			#declare Count=1
			#while (Count<=10)
				cylinder {<0,0,0>,<0,0,.12>,.03	rotate y*(36*Count)}
				#declare Count=Count+1
			#end
			cone {<0,0,0>,.03,<0,-.6,0>,.02}
			object {DandeLeaf	rotate x*-(10+(rand(R2)*15))	rotate y*30	translate <0,-.55,0>}
			object {DandeLeaf	rotate x*-(10+(rand(R2)*15))	rotate y*90	translate <0,-.55,0>}
			object {DandeLeaf	rotate x*-(10+(rand(R2)*15))	rotate y*150	translate <0,-.55,0>}
			object {DandeLeaf	rotate x*-(10+(rand(R2)*15))	rotate y*210	translate <0,-.55,0>}
			object {DandeLeaf	rotate x*-(10+(rand(R2)*15))	rotate y*270	translate <0,-.55,0>}
			object {DandeLeaf	rotate x*-(10+(rand(R2)*15))	rotate y*330	translate <0,-.55,0>}
		}
		translate <0,.6,0>
		scale <1.5,1.5,1.4>
		pigment {color PaleGreen}
	}


	#debug "     - Pinks\n"
	#declare PinksLeaf=
	object {
		union {
			cylinder {<0,0,0>,<0,0,.05>,.01}
			difference {
				sphere {<0,0,.075>,.026}
				box {<-.03,-.03,.076>,<.03,.03,.2>}
			}
			cone {<0,0,.075>,.026,<0,0,.125>,.002}
		}
		scale <1,.1,1.2>
		scale <2,2,2>
	}

	#declare PinksPetal=
	object {
		sphere {<0,0,.05>,.05}
		pigment {
			gradient z
			color_map {
				[0	color White]
				[1	color Red]
			}
			scale <1,1,.35>
		}
		finish {
			ambient .3
		}
		scale <.8,.015,1.5>
		rotate x*-20
		rotate z*12
		translate <0,0,.024>
	}

	#declare Pinks=
	object {
		union {
			union {
				sphere {
					<0,0,0>,.075
					scale <1,.015,1>
					pigment {color Yellow*.8}
					normal {
						bumps .5
						scale <.1,.1,.1>
					}
				}
				object{PinksPetal}
				object{PinksPetal	rotate y*60}
				object{PinksPetal	rotate y*120}
				object{PinksPetal	rotate y*180}
				object{PinksPetal	rotate y*240}
				object{PinksPetal	rotate y*300}
				rotate x*25
				translate <0,.5,0>
			}
			cone {<0,0,0>,.015,<0,.5,0>,.01}
			object {PinksLeaf	rotate x*-50	rotate y*15	translate <0,.1,0>}
			object {PinksLeaf	rotate x*-20	rotate y*-136	translate <0,.1,0>}
			object {PinksLeaf	rotate x*-30	rotate y*110	translate <0,.1,0>}
		}
		pigment {color PaleGreen*.7}
		scale <2,2,2>
	}


	#debug "     - Forget-me-nots\n"
	#declare ForgetPetal=
	object {
		sphere {<0,0,.02>,.02}
		pigment {
			gradient z
			color_map {
				[0	color YellowGreen]
				[.1	color Yellow]
				[.1	color White]
				[1 	color Blue*1.6]
			}
			scale <1,1,.04>
		}
		scale <1,.1,1.5>
	}

	#declare ForgetFlower=
	object {
		union {
			object {ForgetPetal	rotate x*-25}
			object {ForgetPetal	rotate x*-25	rotate y*90}
			object {ForgetPetal	rotate x*-25	rotate y*180}
			object {ForgetPetal	rotate x*-25	rotate y*270}
			cone {<0,0,0>,.004,<0,-.1,0>,.005}
		}
		translate <0,.1,0>
	}

	#declare ForgetLeaf=
	object {
		sphere {<0,0,.03>,.03	scale <1,.25,2>}
		rotate x*-27
	}

	#declare ForgetMeNot=
	union {
		union {
			#declare Count=1
			object {ForgetFlower}
			#while (Count<=5)
				object {
					ForgetFlower
					rotate x*50
					rotate y*(72*Count)
				}
				#declare Count=Count+1
			#end
			object {cone {<0,0,0>,.005,<0,-.15,0>,.006}}
			translate <0,.15,0>
		}
		object {ForgetLeaf	rotate y*45}
		object {ForgetLeaf	rotate y*135}
		object {ForgetLeaf	rotate y*225}
		object {ForgetLeaf	rotate y*315}
		pigment {color PaleGreen*1.25}
		finish {phong .2}
		scale <2.5,2.5,2.5>
	}

#end

#if (I_Forest=True)
	#debug "Planting a forest full of trees...\n"
	
	#declare R4=seed(4)
	#declare Forest=
	union {
		#declare Count=1
		#while (Count<=500)
			object {
				union {
					cone {
						<0,0,0>,1,<0,10,0>,.75
						pigment {color SemiSweetChoc*(.5+(rand(R4)*.7))}
					}
					sphere {
						#declare Size=7+(rand(R4)*6)
						<0,Size,0>,Size
						scale <1,.8+(rand(R4)*.6),1>
						translate <0,9,0>
					}
					#declare Size=.8+(rand(R4)*.4)
					scale <Size,Size*.7+(rand(R4)*.8),Size>
					pigment {color ForestGreen*(.4+(rand(R4)*1.1))}
					finish {crand .5}
				}
				translate <-400+(rand(R4)*800),0,-100+(rand(R4)*200)>
			}
			#declare Count=Count+1
		#end
	}
#end
