// Persistence of Vision Ray Tracer Scene Description File
// File: WINGS.pov
// Vers: 3.00e Watcom Win32
// Desc: Beautiful winged creatures in a shaft of sunlight flee a predator
// Date: November 30, 1996
// Auth: Sonya Roberts
// Note: Uses Chris Colefax's lens flare effects

// ==== Standard Includes ====
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "METALS.inc"
#include "SHAPES.inc"
#include "STONES.inc"
#include "STONES2.inc"
#include "WOODMAPS.inc"
#include "WOODS.inc"
#include "GLASS.inc"
#include "wings.tex"

global_settings {
	max_trace_level 7
}
#declare True = 1
#declare False = 0

// ==== Set up for scene elements ====
#declare SeaLevel=.5
#declare Landscaping=True
#declare I_Effects=True
#declare I_Tree1=True
#declare I_Tree2=True
#declare I_Tree3=True
#declare I_Forest=True
#declare I_Cattails=True
#declare I_Flowers=True
#declare I_Butterflys=True
#declare I_Dragonfly=True
#declare I_Anthill=True
#declare I_Weasel=True

#if (I_Tree1=True)#include "tree1.pov"#end
#if (I_Tree2=True)#include "tree2.pov"#end
#if (I_Tree3=True)#include "tree3.pov"#end
#if (I_Cattails=True | I_Flowers=True | I_Forest=True)#include "plants.pov"#end
#if (I_Butterflys=True | I_Dragonfly=True | I_Anthill=True)#include "buttrfly.pov"#end
#if (I_Weasel=True)#include "weasel.pov"#end

// ==== Setup camera, lights, backdrop scenery
#debug "Setting up cameras and light...\n"

// DIFFERENT CAMERA SETUPS
camera {
	location	<0,SeaLevel+5,-10>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,SeaLevel+5.5,0>
}

// LIGHT SOURCES
light_source {
	<100,175,220>,
	color Gray50
}

light_source {
	<100,100,-200>,
	color White
	#if (I_Effects=True)
		area_light <5,0,0>, <0,5,0>, 3, 3
		adaptive 2
		jitter
	#end
	atmosphere off
}

// TERRAIN
#debug "Setting up basic terrain...\n"
object {
	sphere {<0,0,0>,3000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0	color LightBlue]
				[1.0	color NavyBlue]
			}
			scale <1,3000,1>
		}
	}
	texture {MySky	scale <.5,.5,.5>}
}

// Ground
object {
	sphere {
		<0,-30,0>,30
		scale <1,.05,1.25>
		rotate y*35
	}
	pigment {
		image_map {
			tga "grass.tga"
			map_type 0
		}
		scale <5,5,1>
		rotate x*90
	}
	finish {ambient .6}
	translate <0,SeaLevel,0>
}

#if (Landscaping=True)
	#debug "Setting up special landscaping...\n"
	// Backdrop Mountains
	object {
		height_field {
			pot "mount.pot"
			translate <-.5,-.1,-.5>
			scale <2400,220,1200>
		}
		pigment {
			image_map {
				gif "mount.gif"
			}
			rotate x*90
			translate <-.5,-.1,-.5>
			scale <2400,220,1200>
		}
		translate <0,0,800>
	}

	// Rocks in ground
	object {
		height_field {
			pot "rocks.pot"
			translate <-.5,-.25,-.5>
			scale <50,10,50>
			smooth
		}
		pigment {
			color Gray70
		}
		translate <0,SeaLevel-4,0>
	}

	// Water
	object {
		plane {<0,1,0>,0}
		texture {T_Vicksbottle_Glass}
		normal {
			ripples .45
			rotate y*30
			translate <100,0,-50>
			scale <10,1,5>
		}
	}

	// Seabed
	object {
		plane {<0,1,0>,-10}
		pigment {color Tan}
	}
#end


// ==== Assemble scene elements ====
#if (I_Effects=True)
	#debug "Adding in some special effects...\n"
	// DEFINE CAMERA POSITION VECTORS
	   #declare camera_location = <0, SeaLevel+5, -10>
	   #declare camera_look_at = <0, SeaLevel+5.5, 0>
	   camera {location camera_location look_at camera_look_at}

	// DEFINE LENS FLARE OPTIONS
	   #declare flare_position = <100,175,220>
	   #declare flare_brightness = 1.5
	   #declare flare_type = 1

	// CREATE LENS FLARE
	   #include "LensFlar.inc"

	// Add a little ground fog for ambience
	fog {
		fog_type 2
		distance 250
		color White
		turbulence .75
		fog_offset .25
		fog_alt 4.5
	}

	fog {
		fog_type 2
		distance 16
		color Gray90
		turbulence .75
		fog_offset .001
		fog_alt .75
	}
#end

#debug "Positioning all objects in preparation for actual render...\n"
#if (I_Tree1=True)
	#debug "     - Tree1 object(s)\n"
	object {Tree1	translate <10,SeaLevel-1,1>}
	object {Tree1	translate <-7.75,SeaLevel-1,7>}
#end

#if (I_Tree2=True)
	#debug "     - Tree2 object(s)\n"
	object {Tree2	translate <-8,SeaLevel-1,1>}
	object {Tree2	translate <5,SeaLevel-1,5>}
#end

#if (I_Tree3=True)
	#debug "     - Tree3 object(s)\n"
	object {Tree3	translate <0,SeaLevel-1,-1>}
#end

#if (I_Forest=True)
	#debug "     - Forest\n"
	object {Forest	translate <0,0,525>}
#end

#if (I_Cattails=True)
	#debug "     - Cattails\n"
	object {Cattails	rotate y*20}
#end

#if (I_Flowers=True)
	#debug "     - Flowers\n"
	#declare R3=seed(3)
	object {Dandelion	scale 1+((rand(R3)*.1)-.05)	rotate x*((rand(R3)*10)-5)	translate <-5,SeaLevel,4>}
	object {Dandelion	scale 1+((rand(R3)*.1)-.05)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <-3,SeaLevel,5.25>}
	object {Dandelion	scale 1+((rand(R3)*.1)-.05)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <2.75,SeaLevel,8.25>}
	object {Dandelion	scale 1+((rand(R3)*.1)-.05)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <5.75,SeaLevel,12.25>}
	object {Dandelion	scale 1+((rand(R3)*.1)-.05)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <14.75,SeaLevel,15.25>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <3.14,SeaLevel,13>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <-8,SeaLevel,4.25>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <-5,SeaLevel,6>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <-3,SeaLevel,3>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <7.5,SeaLevel,4>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <13,SeaLevel,10>}
	object {Pinks		scale 1+((rand(R3)*.3)-.15)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <1.84,SeaLevel,1.5>}
	object {ForgetMeNot	scale 1+((rand(R3)*.2)-.1)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <-3.75,SeaLevel,2.25>}
	object {ForgetMeNot	scale 1+((rand(R3)*.2)-.1)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <-1.6,SeaLevel,7>}
	object {ForgetMeNot	scale 1+((rand(R3)*.2)-.1)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <13.15,SeaLevel,13.63>}
	object {ForgetMeNot	scale 1+((rand(R3)*.2)-.1)	rotate x*((rand(R3)*10)-5)	rotate y*(rand(R3)*360)	translate <3.75,SeaLevel,1.6>}
#end

#if (I_Butterflys=True)
	#debug "     - Butterfly(s)\n"
	object {Butterfly1	rotate x*-38	rotate y*20	translate <0,SeaLevel+3,-2.5>}
	object {Butterfly2	rotate x*-40	rotate y*-35	translate <1,SeaLevel+4.5,-5.1>}
	object {Butterfly3	rotate x*-15	rotate y*40	translate <-.65,SeaLevel+4.9,-7.75>}
	object {Butterfly4	rotate x*-25	rotate z*-15	rotate y*30	translate <-2.75,SeaLevel+1.9,0>}
	object {Butterfly4	rotate x*-31	rotate y*-35	translate <-1.6,SeaLevel+4,-6.8>}
#end

#if (I_Dragonfly=True)
	#debug "     - Dragonfly(s)\n"
	object {Dragonfly	rotate x*-21	rotate y*36	rotate x*-35	translate <-.02,SeaLevel+5.6,-8.5>}
	object {Dragonfly	rotate y*-80	rotate x*-22	translate <12,SeaLevel+4,11>}
	object {Dragonfly	rotate y*70	rotate x*-42	translate <7.75,SeaLevel+3.6,7>}
	object {Dragonfly	rotate x*30	rotate y*57	translate <2.75,SeaLevel+4.8,-4.25>}
#end

#if (I_Weasel=True)
	#debug "     - Weasel\n"
	object {Weasel		scale <.75,.75,.75>	rotate y*-163	translate <1.75,SeaLevel,2.75>}
#end

#if (I_Anthill=True)
	#debug "     - Anthill\n"
	object {Anthill		translate <6.5,SeaLevel,3.5>}
#end

#debug "Here we go!\n"
