// Persistence of Vision Ray Tracer Scene Description File
// File: WEASEL.pov
// Vers: 3.00e Watcom Win32
// Desc: Assemble a "furry" predator animal
// Date: December 1, 1996
// Auth: Sonya Roberts
// Note: Uses some "hairy primitive" objects I recently created
//       to achieve the furry look.  This guy is not a cute critter.

#if (I_Weasel=True)
	#declare Eye=
	union {
		object {
			difference {
				union {
					difference {
						sphere {<0,0,0>,1	pigment {color White} finish {ambient .5}}
						sphere {<0,0,0>,.999}
					}
					difference {
						sphere {<0,0,0>,.9995}
						sphere {<0,0,0>,.8}
					}
					sphere {<0,0,0>,.801		pigment {color Black}}
				}
				sphere {<0,0,1.1>,.76	pigment {color Turquoise}}
			}
		}
		object {
			sphere {<0,0,0>,1.001}
			texture {T_Glass1	finish {reflection 0}}
		}
		scale <.15,.15,.15>
	}

	#declare LeftLeg=
	object {
		union {
			sphere {<0,0,0>,.45}
			cone {<0,0,0>,.45,<.25,-.5,-.1>,.2}
			sphere {<.25,-.5,-.1>,.2}
			cone {<.25,-.5,-.1>,.2,<-.25,-1.25,-.1>,.1}
			sphere {<-.25,-1.25,-.1>,.1}
			cone {<-.25,-1.15,-.1>,.1,<-.6,-1.25,-.1>,.01}
			cone {<-.25,-1.15,-.1>,.1,<-.55,-1.25,-.2>,.01}
			cone {<-.25,-1.15,-.1>,.1,<-.55,-1.25,0>,.01}
			cone {<-.25,-1.15,-.1>,.1,<.1,-1.25,-.075>,.01}
		}
		pigment {color NewTan}
		normal {bumps .5	scale <.02,.02,.02>}
	}

	#declare RightLeg=
	object {
		union {
			sphere {<0,0,0>,.45}
			cone {<0,0,0>,.45,<.25,-.5,.1>,.2}
			sphere {<.25,-.5,.1>,.2}
			cone {<.25,-.5,.1>,.2,<-.25,-1.25,.1>,.1}
			sphere {<-.25,-1.25,.1>,.1}
			cone {<-.25,-1.15,.1>,.1,<-.6,-1.25,.1>,.01}
			cone {<-.25,-1.15,.1>,.1,<-.55,-1.25,.2>,.01}
			cone {<-.25,-1.15,.1>,.1,<-.55,-1.25,0>,.01}
			cone {<-.25,-1.15,.1>,.1,<.1,-1.25,.075>,.01}
		}
		pigment {color NewTan}
		normal {bumps .5	scale <.02,.02,.02>}
	}

	#declare Weasel=
	union {
		#declare Orientation=<0,0,90>		// Main Body
		#declare Position=<0,1.5,0>
		#declare CylRad=.75
		#declare CylLen=2
		#declare HairLen=.5
		#declare HairThick=.015
		#declare HairSpacing=1.5
		#declare HairComb=True
		#include "hairycyl.inc"

		#declare Orientation=<0,0,90>		// Tail Parts
		#declare Position=<.99,1.5,0>
		#declare ConRad1=.5
		#declare ConRad2=.75
		#declare ConLen=1
		#declare HairLen=.5
		#declare HairThick=.015
		#declare HairSpacing=1.5
		#declare HairComb=True
		#include "hairycon.inc"

		#declare Orientation=<0,0,90>
		#declare Position=<3.98,1.5,0>
		#declare ConRad1=.25
		#declare ConRad2=.5
		#declare ConLen=3
		#declare HairLen=.45
		#declare HairThick=.0125
		#declare HairSpacing=1.5
		#declare HairComb=True
		#include "hairycon.inc"

		#declare Orientation=<0,0,90>
		#declare Position=<4.97,1.5,0>
		#declare ConRad1=.1
		#declare ConRad2=.25
		#declare ConLen=1
		#declare HairLen=.4
		#declare HairThick=.008
		#declare HairSpacing=1.25
		#declare HairComb=True
		#include "hairycon.inc"

		#declare Orientation=<0,0,90>		// Neck
		#declare Position=<-1.99,1.5,0>
		#declare ConRad1=.75
		#declare ConRad2=.5
		#declare ConLen=1
		#declare HairLen=.5
		#declare HairThick=.015
		#declare HairSpacing=1.5
		#declare HairComb=True
		#include "hairycon.inc"

		object {RightLeg	scale <1.5,1.25,1.5>	rotate y*7	translate <0,1.5*1.25,.8>}
		object {LeftLeg		scale <1.5,1.25,1.5>	rotate y*-5	translate <0,1.5*1.25,-.8>}
		object {RightLeg	rotate y*5	translate <-1.5,1.5,.9>}
		object {LeftLeg		rotate y*-8	translate <-1.5,1.5,-.9>}
		object {
			union {
				blob {
					threshold 0.2
					sphere {<0,0,0>,.96,1}
					sphere {<-.4,-.25,0>,.45,1}
					sphere {<-.8,-.225,0>,.25,1}
					sphere {<-.46,.4,0>,.21,1}
					sphere {<-.2,.5,0>,.23,1}
					sphere {<.15,.55,0>,.25,1}
				}
				torus {.1,.11	rotate z*90	scale <1,1.5,1.25>	rotate <15,18,0>	translate <.1,.45,.55>}
				torus {.1,.11	rotate z*90	scale <1,1.5,1.25>	rotate <-15,-18,0>	translate <.1,.45,-.55>}
				cone {<-.8,-.225,0>,.075,<-1.5,-.5,0>,.02	pigment {color Red*.8}}
			}
			translate <-3.25,1.5,0>
			pigment {color NewTan}
			normal {bumps .5	scale <.02,.02,.02>}
		}
		object {Eye	rotate y*-135	translate <-3.75,1.65,-.5>}
		object {Eye	rotate y*-45	translate <-3.75,1.65,.5>}
	}
#end
