

#declare EngineHalo = halo {
      emitting
      cylindrical_mapping
      linear
      turbulence .8
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
      scale .6
    }

#declare OuterDustHalo = halo {
      emitting // dust
      spherical_mapping
      linear
      turbulence 2
      color_map {
        [ 0  color rgbt <1, 1, 1, 1> ]
        [ .5 color rgbt <.4, .4, .4, 0> ]
        [ 1  color rgbt <1, 1, 1, 1> ]
      }
      frequency 4
      samples 20
      scale .6
    }

 #declare MiddleDustHalo = halo {
      emitting // dust
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0  color rgbt <1, 1, 1, 1> ]
        [ .5 color rgbt <.7, .7, .7, 0> ]
        [ 1  color rgbt <1, 1, 1, 1> ]
      }
      frequency 4
      samples 20
      scale .7
    }

 #declare InnerDustHalo = halo {
      emitting // dust
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0  color rgbt <1, 1, 1, 1> ]
        [ .5 color rgbt <1, 1, 1, 0> ]
        [ 1  color rgbt <1, 1, 1, 1> ]
      }
      frequency 3
      samples 20
      scale .8
    }


#declare dPig = pigment {  color rgbt <1,1,1,1>}


/* Example for using my halos

#declare InnerDust = union {
  sphere { // Dust01
    <0,0,0>,1
    pigment { dPig }
    halo { WeakDustHalo }
    hollow
    scale <1.0, 1.53994, 1.896008>
    translate  <1.795858, 0.171159, 0.986727>
  }

    pigment { dPig }
    halo { MiddleDustHalo }
    hollow


//  ...
*/
