// Persistence Of Vision raytracer version 3.0 sample file.
// File by Dieter Bayer

#version 3.0
global_settings { assumed_gamma 1.5}

#include "colors.inc"
#include "woods.inc"
#include "skies.inc"
#include "metals.inc"
//#include "textures.inc"

camera {
   location <18, 7, -13>
   look_at <11, 7, 7>
}

light_source{ <-7, 25, -7> color <1, 1, 1> }
light_source{ <7, 24, 6> color <1, 1, 1> }

sky_sphere { S_Cloud4 }

fog{
    color Gray70
    fog_type 2
    fog_alt 0.8
    fog_offset 0
    distance 3.9
    turbulence <.15, .15, .15>
    omega 0.35
    lambda 1.25
    octaves 5
}

// Cross - consists of two intersecting boxes

box { <-1, 0, -1> <1, 22, 1>
    texture {T_Wood8 rotate x*90}
//    pigment { P_WoodGrain3A color_map { M_Wood7A } rotate x*90}
    normal {bumps 0.7 scale 0.2}
    finish { ambient 0.4}
}

box { <-7, 14, -1> <7, 16, 1>
    pigment { P_WoodGrain3A color_map { M_Wood7A } rotate y*90}
    texture {T_Wood8 rotate y*90}
    normal {bumps 0.7 scale 0.2}
    finish { ambient 0.4}
}

// Scripture Reference

// Texture Definition

#declare GlassTexture =
texture {
    finish {
       specular 1
       roughness 0.001
       ambient 0
       diffuse 0
       refraction 1
       reflection 0.1
       ior 1.5
    }
    pigment { color rgbf <.9, 1, 1, .8> }
}

text { ttf "arial.ttf", "For now we see in a mirror dimly,", 2, 0
   texture { GlassTexture }
   scale <.7, .7, .1>
   translate <8.2, 8, -9>
   rotate <0, -15, 0>
   }
text { ttf "arial.ttf", "but then face to face.", 2, 0
   texture { GlassTexture }
   scale <.7, .7, .1>
   translate <8.2, 7, -9>
   rotate <0, -15, 0>
   }

text { ttf "arial.ttf", "1 Corinthians 13:12", 2, 0
   texture { GlassTexture }
   scale <.7, .7, .1>
   translate <8.2, 6, -9>
   rotate <0, -15, 0>
   }

// Mirror - reflective box.
// Framed by a simple metal frame

    box {< -15, 0, 31> <25, 18, 31.1>
        finish { reflection 0.5}
        translate <0, 3, 0>
        rotate <3, 0, 0>
    }

#declare MirrorFrame =
union {
    box {< -15, 0, 30.5> <-14, 18, 31.5>}
    box {< -15, 18, 30.5> <25, 19, 31.5>}
    box {< -15, 0, 30.5> <25, 1, 31.5>}
    box {< 24, 0, 30.5> <25, 19, 31.5>}
    texture {T_Copper_1C}
}

object {MirrorFrame
    translate <0, 3, 0>
    rotate <3, 0, 0>
}

// Grass - wrinkled plane
plane { y, 0
    texture { pigment {color DarkGreen}}
    normal {wrinkles 0.7 scale 0.005}
    finish {specular 0.5 roughness 0.15 ambient 0.1}
}
