
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}



fog {
  fog_type 2
  fog_offset -1
  fog_alt 1
  distance    45.00
  up        <0.0,     0.0,  1.0>  // Where Z is up
  color <0.01,0.0,0.0,0.0,0.0>
}


#include "colors.inc"

#declare Green_Glass1 = texture {
   pigment {
     color rgbf<1.000, 0.779, 0.901, 0.900>
   }
   finish {
     diffuse 0.100
     phong 1.000
     phong_size 400.000
     reflection 0.130
     refraction 0
     ior 1.0
     specular 0.800
     roughness 0.0003
   }

}
#declare Green_Glass2 = texture {
   pigment {
     color rgbf<1, 1,1,1>
   }
   finish {
     diffuse 0.000
     phong 0.000
     phong_size 400.000
     reflection 0.0
     refraction 0
     ior 1.0
     specular 0.00
     roughness 0.001
   }

}



#declare Gold_Metal1 = texture {
   pigment {
     color rgb<0.850, 0.850, 0.100>
   }
   finish {
     diffuse 0.700
     ambient 0.200
     phong 0.750
     phong_size 80.000
     reflection 0.250
     brilliance 6.000
     metallic
   }

}



#declare DMFDarkOak1 = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.600, 0.300, 0.180> ]
       [ 0.100  color rgb<0.600, 0.300, 0.180> ]
       [ 0.900  color rgb<0.300, 0.150, 0.090> ]
       [ 1.000  color rgb<0.300, 0.150, 0.090> ]
     }
     turbulence 0.040
     octaves 3
     scale  5
     translate <0,-10,0>
   }
   normal {
     dents 5.0000
     turbulence 1.000
     omega 2.000
     lambda 0.500
   }
   finish {
     crand 0.300
   }

}


#declare Glass3 = texture {
   pigment {
     color rgbf<0.670, 0.871, 1.0, 1.000>
   }
   finish {
     diffuse 0.100
     ambient 0.320
     phong 1.000
     phong_size 100.000
     reflection 0.120
     refraction 1
     ior 1.041
     specular 0.810
     roughness 0.0020
   }

}



#declare Glass4 = texture {
   pigment {
     color rgbf<0.683, 0.834, 1.000, 1.000>
   }
   finish {
     diffuse 0.100
     ambient 0.320
     phong 1.000
     phong_size 100.000
     reflection 0.120
     refraction 1
     ior 1.041
     specular 0.830
     roughness 0.0020
   }

}



#declare Glass5 = texture {
   pigment {
     color rgbf<0.691, 0.993, 1.0, 1.000>
   }
   finish {
     diffuse 0.120
     ambient 0.330
     phong 1.000
     phong_size 100.000
     reflection 0.110
     refraction 1
     ior 1.041
     specular 0.810
     roughness 0.0020
   }

}



#declare Glass6 = texture {
   pigment {
     color rgbf<0.680, 0.870, 1.000, 1.000>
   }
   finish {
     diffuse 0.100
     ambient 0.320
     phong 1.000
     phong_size 100.000
     reflection 0.110
     refraction 1
     ior 1.041
     specular 0.810
     roughness 0.0020
   }

}

#declare GoldFinger =
texture{
  agate
   texture_map
    {[0.99      pigment {color rgbf<1.0, 0.75, 0.86, 0.85>}
   finish {
     diffuse 0.100
     phong 1.000
     phong_size 400.000
     reflection 0.130
     refraction 1
     ior 1.003
     specular 0.800
     roughness 0.0003
   }
]

     [0.99 Gold_Metal1]

}
scale 0.5
}
#declare SilverFinger =
texture{
  agate
   texture_map
    {[0.05
  pigment {
     color rgb<1.0, 1.0, 1.0>
   }
   finish {
     diffuse 0.700
     ambient 0.200
     phong 0.750
     phong_size 80.000
     reflection 0.550
     brilliance 6.000
     metallic

    }]

     [0.05 Gold_Metal1]

}
scale 0.5
}



sky_sphere {
  pigment {
    gradient z
    color_map {
      [0 color rgb   <1.0,1.0,1.0 >]
      [0.495 color rgb <1.6,0.1,0 >]
      [0.505 color rgb <0,0,0.15 >]
      [1 color rgb   < 0,0,0>]
    }
omega 0.9
    turbulence <0,0,-0.007>
    scale 2
rotate 30*z
    translate -1
  }
}


camera {  //  Camera Camera01
  location <6.811, -32.117, -0.257>
  direction <0.0,     0.0,  4.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  look_at  <2.91, -0.511, -1.03>
  look_at  <1.51, -0.511, -1.03>
}

// *******  L I G H T S *******
light_source {   // Light001
  <4.869, -2.718, 1.020>
  color rgb <1.0, 0.3, 0.2>
}
light_source {   // Light001
  <6.811, -32.117, -0.257>
  color rgb <1.0, 1.0, 1.0>
}

light_source {   // Light1
  <0.183, 0.010, -0.038>
  color rgb <0.824, 0.255, 0.255>
}



// ********  REFERENCED OBJECTS  *******

#declare RotSwp002 = lathe {
  quadratic_spline
  8  // control points
  <0.001932, -0.888147>,
  <0.004334, -0.888381>,
  <0.212001, -0.877373>,
  <0.382154, -0.733733>,
  <0.407351, -0.514123>,
  <0.269323, -0.260021>,
  <0.08797, 0.019908>,
  <0.001804, 0.476944>
  rotate <90,0,90>
  texture {
    Glass3
  }
  scale 0.207
  rotate <-43.191093, 54.491791, -8.87712>
  translate  <-0.430865, 0.471205, -0.027>
}
object { RotSwp002 }


#declare stub=
union{
union { // BzPtch11
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate 17.630722*z
  translate  <1.279054, +12.533397, -4.152893>
}


union { // BzPtch10
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate 107.630722*z
  translate  <1.273563, 0.683322, -5.329886>
}


union { // BzPtch9
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate -6.559502*z
  translate  <3.325437, -7.098485, -3.488552>
}

union { // BzPtch8
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate <10.192391, -2.54004, 116.834549>
  translate  <-4.45637, 9.329775, -3.488552>
}


union { // BzPtch7
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate 17.630722*z
  translate  <-3.437065, -4.62807, -4.981526>
}


union { // BzPtch6
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate 131.56105*z
  translate  <-8.656076, 9.576816, -5.081057>
}


union { // BzPtch5
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate 107.630722*z
  translate  <5.42529, -8.580733, -3.488552>
}


union { // BzPtch4
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate -48.57869*z
  translate  <3.81952, 4.635986, -3.488552>
}

union { // BzPtch3
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }
  scale <0.322998, 0.349421, 0.43546>
  rotate 66.213928*z
  translate  <-4.332849, 2.289092, -3.488552>
}



}

union { // BzPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563911, 1.393162, -0.045616>, <-4.517206, -3.388564, -0.131367>, <6.282295, -10.634970, 0.034901>, <7.707200, -3.133861, 0.039990>,
      <-0.698661, -1.448271, 1.239063>, <-2.497923, -3.919384, 1.158122>, <4.623395, -4.465414, 1.410391>, <4.927039, -1.206342, 0.745050>,
      <-0.367323, -0.616016, 3.089227>, <-1.773901, -2.247534, 3.160452>, <0.656003, -4.962693, 2.272877>, <2.586566, -1.024452, 2.766562>,
      <-1.262309, 0.214350, 5.723204>, <-2.642558, -1.632638, 5.764299>, <0.816246, -3.479919, 5.750894>, <1.956475, -0.902175, 5.701238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.707200, -3.133861, 0.039990>, <9.132105, 4.367248, 0.045080>, <-6.610616, 6.174888, 0.040135>, <-5.563911, 1.393162, -0.045616>,
      <4.927039, -1.206342, 0.745050>, <5.230683, 2.052731, 0.079710>, <1.100601, 1.022842, 1.320003>, <-0.698661, -1.448271, 1.239063>,
      <2.586566, -1.024452, 2.766562>, <4.517130, 2.913789, 3.260247>, <1.039255, 1.015502, 3.018001>, <-0.367323, -0.616016, 3.089227>,
      <1.956475, -0.902175, 5.701238>, <3.096704, 1.675568, 5.651583>, <0.117940, 2.061339, 5.682108>, <-1.262309, 0.214350, 5.723204>
    }
  }


  scale <0.322998, 0.349421, 0.43546>
  rotate 107.630722*z
  translate  <-0.133144, -0.304844, -3.488552>
texture{SilverFinger}
}
//texture{Gold_Metal1}




// ********  OBJECTS  *******
union{

object{
stub
}

object{
stub
rotate 20*z
translate <-10,35,0>
}

object{
stub
rotate -10*z
translate <-14,65,0>
}

object{
stub
rotate 180*z
translate <-25,125,0>
}


object{
stub
rotate -90*z
translate <-25,95,0>
}

object{
stub
translate <-35,150,0>
}

plane { // Plane001
  z,0
  translate  <0.135964, 0.0, -3.450823>
}



  texture {
    DMFDarkOak1
  translate  <3.1, 9.1, 0>
scale 0.5
finish{
ambient 0
//crand 0.3
}

}

}


object { RotSwp002
  translate  <5.42529, -8.580733, 0>

}



object { // RotSwp16->RotSwp002
  RotSwp002
  texture {
    Glass3
  }
  scale 1.393237
  rotate <55.442017, -43.802494, -104.378563>
  translate  <-0.98408, -0.529072, 0.304311>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp15->RotSwp002
  RotSwp002
  texture {
    Glass5
  }
  scale 1.452637
  rotate <52.413116, -52.619869, -32.927155>
  translate  <0.820999, -0.316011, 0.784914>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp14->RotSwp002
  RotSwp002
  texture {
    Glass5
  }
  scale 1.452637
  rotate <53.413116, -51.619869, -31.927153>
  translate  <1.022273, -0.760506, 0.77307>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp13->RotSwp002
  RotSwp002
  texture {
    Glass6
  }
  scale 1.4
  rotate <0.0, 0.0, 0.0>
  translate  <0.655812, -1.045877, -0.378925>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp12->RotSwp002
  RotSwp002
  texture {
    Glass5
  }
  scale 1.452637
  rotate <54.413116, -50.619869, -30.927153>
  translate  <0.48929, -0.760506, 0.678317>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp11->RotSwp002
  RotSwp002
  texture {
    Glass3
  }
  scale 1.390489
  rotate <0.0, 0.0, 36.151443>
  translate  <0.526161, -0.247899, -0.424529>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp10->RotSwp002
  RotSwp002
  texture {
    Glass3
  }
  scale 1.393237
  rotate <56.442017, -42.802494, -103.378563>
  translate  <-1.101642, -0.433823, 0.64732>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp9->RotSwp002
  RotSwp002
  texture {
    Glass3
  }
  scale 1.4
  rotate <-78.464081, 55.206387, 116.14843>
  translate  <-0.730422, 0.67029, -0.969013>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp8->RotSwp002
  RotSwp002
  texture {
    Glass4
  }
  scale 1.4
  rotate <-3.967225, -34.671841, -4.623178>
  translate  <0.713595, -0.868331, -0.284258>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp7->RotSwp002
  RotSwp002
  texture {
    Glass4
  }
  scale 1.4
  rotate <0.0, 0.0, 0.0>
  translate  <0.925013, -0.220868, -0.627777>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp6->RotSwp002
  RotSwp002
  texture {
    Glass5
  }
  scale 1.4
  rotate <180.0, 3.676556, -180.0>
  translate  <-1.530228, -0.203306, -0.270947>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp5->RotSwp002
  RotSwp002
  texture {
    Glass5
  }
  scale 1.4
  rotate <9.398411, 73.71804, 0.0>
  translate  <0.814527, -0.641666, -1.207545>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp4->RotSwp002
  RotSwp002
  texture {
    Glass6
  }
  scale 1.4
  rotate <0.0, -49.134792, 0.0>
  translate  <0.128757, -0.267898, -0.118441>
  translate  <5.42529, -8.580733, 0>
}


object { // RotSwp3->RotSwp002
  RotSwp002
  texture {
    Glass6
  }
  scale 1.4
  rotate <-180.0, -30.653767, 180.0>
  translate  <-0.654368, -0.895884, -0.556671>
  translate  <5.42529, -8.580733, 0>
}



lathe {
  cubic_spline
  15  // control points
  <0.001861, -0.989744>,
  <0.002016, -0.997052>,
  <0.135103, -0.98375>,
  <0.357032, -0.900797>,
  <0.56703, -0.741294>,
  <0.77879, -0.51408>,
  <0.907308, -0.310745>,
  <1.024229, -0.042471>,
  <1.084951, 0.312158>,
  <0.981979, 0.58869>,
  <0.710246, 0.752204>,
  <0.4052, 0.74939>,
  <0.143157, 0.636376>,
  <0.001724, 0.613749>,
  <0.000807, 0.610501>
  rotate <90,0,90>
  texture {
    Green_Glass1
  }

  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1
    colour_map {
      [ 0 color rgbt <0.5, 0, 0,   1> ]
      [ 1 color rgbt <0.6, 0.3, 0,   -0.8> ]
    }
    samples 15
  }
  translate  <5.42529, -8.580733, 0>
  hollow
}


lathe {
  cubic_spline
  15  // control points
  <0.001861, -0.989744>,
  <0.002016, -0.997052>,
  <0.135103, -0.98375>,
  <0.357032, -0.900797>,
  <0.56703, -0.741294>,
  <0.77879, -0.51408>,
  <0.907308, -0.310745>,
  <1.024229, -0.042471>,
  <1.084951, 0.312158>,
  <0.981979, 0.58869>,
  <0.710246, 0.752204>,
  <0.4052, 0.74939>,
  <0.143157, 0.636376>,
  <0.001724, 0.613749>,
  <0.000807, 0.610501>
  rotate <90,0,90>
  texture {
    GoldFinger
  }
  rotate -38.610775*y
  translate  <-1.466254, -7.753157, -2.55158>
}

lathe {
  cubic_spline
  15  // control points
  <0.001861, -0.989744>,
  <0.002016, -0.997052>,
  <0.135103, -0.98375>,
  <0.357032, -0.900797>,
  <0.56703, -0.741294>,
  <0.77879, -0.51408>,
  <0.907308, -0.310745>,
  <1.024229, -0.042471>,
  <1.084951, 0.312158>,
  <0.981979, 0.58869>,
  <0.710246, 0.752204>,
  <0.4052, 0.74939>,
  <0.143157, 0.636376>,
  <0.001724, 0.613749>,
  <0.000807, 0.610501>
  rotate <90,0,90>
  texture {
    GoldFinger
  }
  rotate <159.04393, -14.657374, 55.615772>
  translate  <-1.801176, 14.908963, -2.770782>
}


lathe {
  cubic_spline
  15  // control points
  <0.001861, -0.989744>,
  <0.002016, -0.997052>,
  <0.135103, -0.98375>,
  <0.357032, -0.900797>,
  <0.56703, -0.741294>,
  <0.77879, -0.51408>,
  <0.907308, -0.310745>,
  <1.024229, -0.042471>,
  <1.084951, 0.312158>,
  <0.981979, 0.58869>,
  <0.710246, 0.752204>,
  <0.4052, 0.74939>,
  <0.143157, 0.636376>,
  <0.001724, 0.613749>,
  <0.000807, 0.610501>
  rotate <90,0,90>
  texture {
    GoldFinger
  }
  translate  0.003625*x


//  rotate <-180.0, -87.654213, 180.0>
//  translate  <-6.3197, 14.21672, -2.48829>
}


lathe {
  cubic_spline
  15  // control points
  <0.001861, -0.989744>,
  <0.002016, -0.997052>,
  <0.135103, -0.98375>,
  <0.357032, -0.900797>,
  <0.56703, -0.741294>,
  <0.77879, -0.51408>,
  <0.907308, -0.310745>,
  <1.024229, -0.042471>,
  <1.084951, 0.312158>,
  <0.981979, 0.58869>,
  <0.710246, 0.752204>,
  <0.4052, 0.74939>,
  <0.143157, 0.636376>,
  <0.001724, 0.613749>,
  <0.000807, 0.610501>
  rotate <90,0,90>
  texture {
    GoldFinger
  }
  rotate -63.615871*y
  translate  <-0.175024, -3.705622, -2.438524>
}


lathe {
  cubic_spline
  15  // control points
  <0.001861, -0.989744>,
  <0.002016, -0.997052>,
  <0.135103, -0.98375>,
  <0.357032, -0.900797>,
  <0.56703, -0.741294>,
  <0.77879, -0.51408>,
  <0.907308, -0.310745>,
  <1.024229, -0.042471>,
  <1.084951, 0.312158>,
  <0.981979, 0.58869>,
  <0.710246, 0.752204>,
  <0.4052, 0.74939>,
  <0.143157, 0.636376>,
  <0.001724, 0.613749>,
  <0.000807, 0.610501>
  rotate <90,0,90>
  texture {
    GoldFinger
  }
  rotate 51.106697*y
  translate  <2.490127, -2.470415, -2.637587>
}
