#include "colors.inc"

/********** The declarations description file. ********

If all values are 0, you'll get a male standing straight
with height of 94 units. Origin is between the leg joints
(y values from -42 to 52)

Angles are in degrees.
Larger value means larger, bigger, higher, etc.

Length multipliers are added to 1, so if you put -.5 to
rleg_length, the right leg will become half as long. 
Value of 1 gives double length. -.3 - .3 work fine.

Other values are just added to the default value.
Suggested values are in comments

*/

#declare LEGS = 1
#declare BODY = 1
#declare HANDS = 1
#declare HEAD = 1

/*******************************************************
********************* Textures *************************
*******************************************************/

/** Overall color **/
#declare Body_color = Tan

#declare Hair_texture = 
 texture {pigment {Yellow}}

#declare Lipcolor = rgb<.8,.3,.2>

/** Eye colors **/
#declare Eyecolor1 = Green     /* Outer circle */
#declare Eyecolor2 = Black     /* Inner circle */
#declare Eyecolor3 = White     /* Eyeballs */
#declare EBColor = Black       /* Eyebrows */
#declare Eyelashcolor = Black  /* Eyelashes */

/*******************************************************
********************** Body ****************************
*******************************************************/

/** Body dimensions. Body is made of a blob so don't 
 ask me how it works, it just does. **/

#declare waist = 0   /* -3 - 5 */
#declare middle = 0   /* -3 - 5 */
#declare chest = 0    /* -3 - 5 */
#declare stomach = 0  /* 0 or 7 - 13 */
#declare breasts = 0  /* 0 - 10 */
#declare butt = 0     /* -1 - 4 */

/** height of shoulders. Use -3 to 2 **/ 

#declare left_shoulder = 0
#declare right_shoulder = 0

/*******************************************************
*********************** Head ***************************
*******************************************************/

/** The size of the head **/

#declare head_size = 0      /* Head size multiplier -.3 - .3 */
#declare face_fatness = 0   /* -0.1 - 1 */
#declare neck_thickness = 0 /* 0 - 3 */

/** Head angle (If you're making a long hair, don't alter these)**/

#declare sideways = 0       /* Tilts to the side (+right, -left) */
#declare updown = 0         /* +back, -forward */
#declare head_rotate = 0    /* +right, -left */

/** Nose modifiers **/

#declare nose_size = 0    /* nose size multiplier */
#declare nose_width = 0   /* -1 - 1 */
#declare nosetip = 0      /* Try something */

/** Mouth + Lips **/

#declare lipsize = 0        /*Lips size multiplier*/
#declare Mouth_width = 0    /*Mouth widht multiplier*/
#declare Upper_smile = 0    /*Lower lip curve (+down, -up)*/
#declare Lower_smile = 0    /*Upper, use between -5 and 8*/

/** Cheeks & eyes **/

#declare cheeks = 0     /* cheeks 0 - 1*/
#declare eye_size = 0     /* eye size multiplier */     

/** Eye position (Rotated around center point) **/

#declare reyex = 0     /* x-position -25 - 25 */
#declare leyex = 0
#declare reyey = 0     /* y-position -20 - 20 */
#declare leyey = 0

/** Eyelid angle **/

#declare rel = 0     /* 50 means closed eye */
#declare lel = 0

/** Use this to create different expressions **/

#declare tilt = 0  /* Rotates the eyes */

/** Eyebrows **/

#declare eyebrow_size = 0    /* -.1 - .2 (multiplier)*/
#declare eyebrow_height = 0  /* -.1 - .1 */

/*******************************************************
*********************** Hair ***************************
********************************************************
** Hair is very simple, it's better to make a new one */

#declare Hair_type = 0      /*Use anything but 0 to remove hair*/

#declare Fore = 0    /* Use 4-6 to remove hair from forehead*/

#declare Hair_length = 0   /*40 goes under feet*/

/*******************************************************
*********************** Legs ***************************
*******************************************************/

/** Leg thickness (added to default) **/

#declare lleg_thickness = 0   /*If you use values over 3.5, the*/
#declare rleg_thickness = 0   /*knee sphere will become too small*/

/** Leg length & foot size (multiplied) **/

#declare lleg_length = 0      /* -.3 - .3 */
#declare rleg_length = 0
#declare lfootsize = 0   
#declare rfootsize = 0

/** Angles for both legs (rotated around hip joint)**/

#declare rlegy = 0   /* Rotates along the axis */
#declare llegy = 0   /* - inward, + outward */
#declare rlegx = 0   /* Raises the leg towards front */
#declare llegx = 0   /* 90 means sitting position */
#declare rlegz = 0   /* Raises towards the side (0 - 90) */
#declare llegz = 0 

/** Angles for knees. Try 0-160 **/

#declare rkneeangle = 0  
#declare lkneeangle = 0

/** Angles for ankles. **/

#declare ranklex = 0  /* - inwards, + outwards (not much) */
#declare lanklex = 0 
#declare rankley = 0   /* Along the leg axis */
#declare lankley = 0   /* + outwards, - inwards */
#declare ranklez = 0   /* -15 (toes up) to 70 (down) */
#declare lanklez = 0

/** Toes. Use values between .5 (down) and -1 (up) **/

#declare rtoes = 0   /* If you use smaller or larger values*/
#declare ltoes = 0   /* you'll get a "floating toe" */

/****************************************************
******************** Arms + hands *******************
****************************************************/

/** Size of the hand, thickness of arm (added to default) **/

#declare lhandsize = 0   /* affect fingers too. (0 - 2) */
#declare rhandsize = 0   
#declare larm_thickness = 0   /* 0 - 5 */
#declare rarm_thickness = 0

/** Arm length (multiplied) **/

#declare larm_length = 0      /* -.3 - .3 */
#declare rarm_length = 0

/** Angles for both arms (Rotated around the shoulder joint) **/

#declare larmy = 0   /*Rotates the arm along the axis*/
#declare rarmy = 0
#declare larmx = 0   /*Raises the arm towards front (-60-180)*/
#declare rarmx = 0
#declare larmz = 0   /*Raises the arm towards side (0-180)*/
#declare rarmz = 0

/** Elbowangle (0 - 160) **/

#declare lelbowangle = 0
#declare relbowangle = 0

/** Angles for wrists **/

#declare lwristx = 0   /*Rotates along the axis*/
#declare rwristx = 0
#declare lwristy = 0   /*Rotates sideways (not much)*/
#declare rwristy = 0    /* + rotates towards thumb */
#declare lwristz = 0   /*Rotates up and down (-90 - 90)*/
#declare rwristz = 0

/******************************************************
*********************** Fingers ***********************
*******************************************************/

/** Finger sizing. Use -.3 to .3 **/

#declare lfinger_thickness = 0
#declare lfinger_length = 0
#declare rfinger_thickness = 0
#declare rfinger_length = 0

#declare FIST = 0  /* If you want a fist use 1 and*/
#if (FIST = 0)     /* forget the rest of fingers section*/

/** Angles between fingers **/
 
#declare lfinger_spread = 0  /*60 means that little finger*/ 
#declare rfinger_spread = 0  /*rotates 90 degrees outward. */

/** Joint angles. Examine your fingers, they have 3 joints each.
 number 1 is closest to your hand etc. Thumb has 2 joints + the
joint that works in 2 directions. Joints 1 and 3 use values from 
0 to about 100. Joint 2 works up to 120. (At least in my hand) **/

/* Left thumb */
#declare lthumby = 0   /* rotates away from the hand (0 - 90) */
#declare lthumbz = 0   /* rotates towards the palm (0 - 45) */
#declare lt1 = 0       /* 0 - 90 */
#declare lt2 = 0       /* 0 -90 */
/*index*/
#declare li1 = 0 
#declare li2 = 0
#declare li3 = 0
/*middle*/
#declare lm1 = 0
#declare lm2 = 0
#declare lm3 = 0
/*3rd*/
#declare ln1 = 0  
#declare ln2 = 0
#declare ln3 = 0
/*little*/
#declare lp1 = 0 
#declare lp2 = 0
#declare lp3 = 0

/* Right thumb */
#declare rthumby = 0      
#declare rthumbz = 0
#declare rt1 = 0
#declare rt2 = 0
/*index*/
#declare ri1 = 0
#declare ri2 = 0
#declare ri3 = 0
/*middle*/
#declare rm1 = 0
#declare rm2 = 0
#declare rm3 = 0
/*3rd*/
#declare rn1 = 0
#declare rn2 = 0
#declare rn3 = 0
/*fourth*/
#declare rp1 = 0 
#declare rp2 = 0
#declare rp3 = 0
#end

/*****************************************************
******************** Build the human *****************
*****************************************************/

#include "collect.inc"

camera { location <0,50,-120> look_at <0,20,0>}

light_source { <-30,50,-200> White}
light_source { <30,50,-200> White}

object {human rotate y*0}
