#include "colors.inc"
#include "shapes.inc"
#include "finish.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"

#declare FINAL = 1
#declare INC_GLASSES = 1
#declare INC_LAMP = 1
#declare INC_DESK = 1

#include "staingl.inc"
#include "wineglss.inc"
#include "desk.inc"

light_source { 
   <-4,180,-140>
   color White
   area_light <3,0,0>, <0,0,3>, 3, 3
   adaptive 1
   jitter
}

#if (INC_LAMP)
light_source {
   <-9.5,15.2,-6>
   color White
   looks_like { object { LIGHT_BULB scale 2 } }
   #if (1)
   area_light <1.2,0,0>, <0,0,1.2>, 3, 3
   adaptive 1
   jitter
   #end
}
#else
light_source {
   <-9.5,15.2,-6> color White
}
#end

#declare Long_Lens =
   camera {
      location -z*40
      angle 60
   }

camera {
   Long_Lens
   location <8,10,-44>
   look_at <8,4,0>
   translate <0,2,0>
}

#declare WT = texture { T_Wood10 }

#if (INC_DESK)
union {
   box {
      <-22,-1,-40>, <40,0,10>
      texture { WT }
   }
   object { SHELF }
}
#end

#if (INC_LAMP)
object {
   LAMP
   rotate 127.5*y
   translate <-9.5,0,-6>
}
#end

#if (INC_GLASSES)
object {
   Filled_Glass
   scale 0.5
   translate <2.4,0,-20>  /* was <11,0,-1> */
}

object {
   Empty_Glass
   scale 0.5
   translate <24,0,0>
}

#declare ZP = 18.5
#declare XOFS = 2.5
#declare ZOFS = 2.4

object {
   Empty_Glass
   scale 0.5
   translate <34+XOFS,12.75,ZP+ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <24+XOFS,12.75,ZP+ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <14+XOFS,12.75,ZP+ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <4+XOFS,12.75,ZP+ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <-6+XOFS,12.75,ZP+ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <-16+XOFS,12.75,ZP+ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <34-XOFS,12.75,ZP-ZOFS>
}

//object {
//   Empty_Glass
//   scale 0.5
//   translate <24-XOFS,12.75,ZP-ZOFS>
//}

//object {
//   Empty_Glass
//   scale 0.5
//   translate <14-XOFS,12.75,ZP-ZOFS>
//}

object {
   Empty_Glass
   scale 0.5
   translate <4-XOFS,12.75,ZP-ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <-6-XOFS,12.75,ZP-ZOFS>
}

object {
   Empty_Glass
   scale 0.5
   translate <-16-XOFS,12.75,ZP-ZOFS>
}
#end

