#declare KNOB = difference {
   union {
      cylinder { <0,0,0>, <0,2,0>, 0.5 }
      cone {
         <0,3,0>, 4.5
         <0,1,0>, 0.5
      }
   }
   cone {
      <0,3.3,0>, 4.5
      <0,1.5,0>, 0.5
   }
   texture { T_Brass_3A }
}

#declare DCRAD = 2.4
#declare DOOR_CUTOUT = intersection {
   box { <0,0,-0.1>, <19,12,0.1> }
   union {
      cylinder { <0,0,-0.1>, <0,0,0.1>, DCRAD }
      cylinder { <19,0,-0.1>, <19,0,0.1>, DCRAD }
      cylinder { <19,12,-0.1>, <19,12,0.1>, DCRAD }
      cylinder { <0,12,-0.1>, <0,12,0.1>, DCRAD }
      box { <0,0,-0.1>, <19,1,0.1> }
      box { <0,11,-0.1>, <19,12.0,0.1> }
      box { <0,0,-0.1>, <1,12,0.1> }
      box { <18,0,-0.1>, <19.0,12.0,0.1> }
   }
}

#declare CRACK = 0.0
#declare DS_LDOOR = union {
   difference { 
      box { <CRACK,CRACK,0>, <19-CRACK,12-CRACK,1> }
      object {
         DOOR_CUTOUT 
         texture { T_Wood10 pigment { color rgbf <0.4,0.15,0.14,0.5> } }
      }
      texture { T_Wood10 }
   }
   object { KNOB scale 0.25 rotate -90*x translate <16.5,6,0> }
}

#declare DS_RDOOR = union { 
   difference {
      box { <CRACK,CRACK,0>, <19-CRACK,12-CRACK,1> }
      object {
         DOOR_CUTOUT
         texture { T_Wood10 pigment { color rgbf <0.4,0.15,0.14,0.5> } }
      }
      texture { T_Wood10 }
   }
   object { KNOB scale 0.25 rotate -90*x translate <2.5,6,0> }
}

#declare SHELF_SLATS = 
union {
   /* bottom */
   box { <-22,-1,10>, <40,0,25> }
   /* left side */
   box { <-22,0,10>, <-21,35,25> }
   /* right side */
   box { <39,0,10>, <40,35,25> }
   /* back */
   box { <-22,0,25>, <40,35,26> }
   /* top shelf */
   box { <-21,34,12>, <39,34.75,25> }
   /* next shelf down */
   box { <-21,25,12>, <39,25.75,25> }
   /* bottom shelf */
   box { <-21,12,12>, <39,12.75,25> }

   /* compartments in bottom shelf */
   box { <-2,0,12>, <-1,12,25> }
   box { <19,0,12>, <20,12,25> }
   texture { T_Wood10 }
}

#declare SHELF = union {
   object { SHELF_SLATS }
   object { DS_LDOOR translate <-21,0,12.2> }
   object { DS_RDOOR translate <20,0,12.2> }
}
