#declare TSCO = 0.2
#declare TMCO = 0.7

// pigments
#declare P_Dull_Lead = pigment { color rgb < 0.66, 0.65, 0.63 > }
#declare P_Blue_SG = pigment { color rgbft < 0.3, 0.3, 0.85, TSCO, TMCO > }
#declare P_Red_SG = pigment { color rgbft < 0.85, 0.2, 0.2, TSCO, TMCO > }
#declare P_White_SG = pigment { color rgbft < 1.0, 1.0, 1.0, TSCO, TMCO > }
#declare P_Green_SG = pigment { color rgbft < 0.3, 0.85, 0.3, TSCO, TMCO > }
#declare P_DkGray_SG = pigment { color rgbft <0.2, 0.2, 0.2, TSCO, TMCO > }
#declare P_Yellow_SG = pigment { color rgbft <0.2, 0.85, 0.85, TSCO, TMCO > }

// finishes
#declare F_Dull_Lead = finish {
   ambient 0.10
   brilliance 4.0
   //specular 0.20
   roughness 0.05
   reflection 0.001
}


#declare F_SG =
   finish {
      roughness 0.1
      ambient 0.7
      specular 0.2
      diffuse 0.5
      //reflection rgb < 0.6, 0.6, 0.6 >
      reflection rgb <0.3, 0.3, 0.3>
   }

// textures
#declare T_Dull_Lead = texture {
   finish { F_Dull_Lead }
   pigment { P_Dull_Lead }
}

#declare T_Blue_SG = texture {
   finish { F_SG }
   pigment { P_Blue_SG }
}

#declare T_DkGray_SG = texture {
   finish { F_SG }
   pigment { P_DkGray_SG }
}

#declare T_Red_SG = texture {
   finish { F_SG }
   pigment { P_Red_SG }
}

#declare T_White_SG = texture {
   finish { F_SG }
   pigment { P_White_SG }
}

#declare T_Green_SG = texture {
   finish { F_SG }
   pigment { P_Green_SG }
}

#declare T_Yellow_SG = texture {
   finish { F_SG }
   pigment { P_Yellow_SG }
}


/* the dartboard!!! */
#ifdef (FINAL)
#declare WHITE_GLASS = texture { T_White_SG }
#declare BLUE_GLASS = texture { T_Blue_SG }
#declare RED_GLASS = texture { T_Red_SG }
#declare GREEN_GLASS = texture { T_Green_SG }
#declare YELLOW_GLASS = texture { T_Yellow_SG }
#else
#declare WHITE_GLASS = texture { pigment { color White } }
#declare BLUE_GLASS = texture { pigment { color Blue } }
#declare RED_GLASS = texture { pigment { color Red } }
#declare GREEN_GLASS = texture { pigment { color Green } }
#declare YELLOW_GLASS = texture { pigment { color Yellow } }
#end

#declare SG_THICK = 0.2
#declare PB_THICK = 0.205

/* used as a cutout only */
#declare WEDGE = intersection {
   box { <-0.05,0,-0.01>, <3,8,PB_THICK+0.01> rotate 9*z }
   box { <-3,0,-0.01>, <0.05,8,PB_THICK+0.01> rotate -9*z }
}

#declare LEAD_BOX = box { <0.6,-0.05,0>, <6.58,0.05,PB_THICK> }

#declare FAT_SKINNY = union {
   difference {
      cylinder { <0,0,0>, <0,0,SG_THICK>, 3.70 }
      cylinder { <0,0,-0.01>, <0,0,SG_THICK+0.01>, 0.675 }
   }
   difference {
      cylinder { <0,0,0>, <0,0,SG_THICK>, 6.20 }
      cylinder { <0,0,-0.01>, <0,0,SG_THICK+0.01>, 4.175 }
   }
}

#declare DOUBLE_TRIPLE = union {
   difference {
      cylinder { <0,0,0>, <0,0,SG_THICK>, 6.575 }
      cylinder { <0,0,-0.01>, <0,0,SG_THICK+0.01>, 6.30 }
   }
   difference {
      cylinder { <0,0,0>, <0,0,SG_THICK>, 4.075 }
      cylinder { <0,0,-0.01>, <0,0,SG_THICK+0.01>, 3.80 }
   }
}

#declare WHITES = difference {
   object { FAT_SKINNY }
   union {
      object { WEDGE }
      object { WEDGE rotate 36*z }
      object { WEDGE rotate 72*z }
      object { WEDGE rotate 108*z }
      object { WEDGE rotate 144*z }
      object { WEDGE rotate 180*z }
      object { WEDGE rotate 216*z }
      object { WEDGE rotate 252*z }
      object { WEDGE rotate 288*z }
      object { WEDGE rotate 324*z }
   }
}

#declare GREENS = difference {
   object { DOUBLE_TRIPLE }
   union {
      object { WEDGE }
      object { WEDGE rotate 36*z }
      object { WEDGE rotate 72*z }
      object { WEDGE rotate 108*z }
      object { WEDGE rotate 144*z }
      object { WEDGE rotate 180*z }
      object { WEDGE rotate 216*z }
      object { WEDGE rotate 252*z }
      object { WEDGE rotate 288*z }
      object { WEDGE rotate 324*z }
   }
}

#declare DARKS = difference {
   object { FAT_SKINNY }
   union {
      object { WEDGE rotate -18*z }
      object { WEDGE rotate 18*z }
      object { WEDGE rotate 54*z }
      object { WEDGE rotate 90*z }
      object { WEDGE rotate 126*z }
      object { WEDGE rotate 162*z }
      object { WEDGE rotate 198*z }
      object { WEDGE rotate 234*z }
      object { WEDGE rotate 270*z }
      object { WEDGE rotate 306*z }
   }
}

#declare REDS = difference {
   object { DOUBLE_TRIPLE }
   union {
      object { WEDGE rotate -18*z }
      object { WEDGE rotate 18*z }
      object { WEDGE rotate 54*z }
      object { WEDGE rotate 90*z }
      object { WEDGE rotate 126*z }
      object { WEDGE rotate 162*z }
      object { WEDGE rotate 198*z }
      object { WEDGE rotate 234*z }
      object { WEDGE rotate 270*z }
      object { WEDGE rotate 306*z }
   }
}

#declare REDEYE = difference {
   cylinder { <0,0,0>, <0,0,SG_THICK>, 0.575 }
   cylinder { <0,0,-0.1>, <0,0,SG_THICK+0.1>, 0.30 }
}

#declare REDEYE_PB = difference {
   cylinder { <0,0,0>, <0,0,PB_THICK+0.005>, 0.625 }
   union {
      cylinder { <0,0,-0.1>, <0,0,PB_THICK+0.1>, 0.20 }
      object { REDEYE scale <1,1,1.4> translate <0,0,-0.01> }
   }
}

#declare LEADS = union {
   object { REDEYE_PB }
   difference {
      cylinder { <0,0,0>, <0,0,PB_THICK>, 3.80 }
      cylinder { <0,0,-0.01>, <0,0,PB_THICK+0.01>, 3.70 }
   }
   difference {
      cylinder { <0,0,0>, <0,0,PB_THICK>, 4.175 }
      cylinder { <0,0,-0.01>, <0,0,PB_THICK+0.01>, 4.075 }
   }
   difference {
      cylinder { <0,0,0>, <0,0,PB_THICK>, 6.30 }
      cylinder { <0,0,-0.01>, <0,0,PB_THICK+0.01>, 6.20 }
   }
   difference {
      cylinder { <0,0,0>, <0,0,PB_THICK>, 6.675 }
      cylinder { <0,0,-0.01>, <0,0,PB_THICK+0.01>, 6.575 }
   }
   object { LEAD_BOX rotate 9*z }
   object { LEAD_BOX rotate 27*z }
   object { LEAD_BOX rotate 45*z }
   object { LEAD_BOX rotate 63*z }
   object { LEAD_BOX rotate 81*z }
   object { LEAD_BOX rotate 99*z }
   object { LEAD_BOX rotate 117*z }
   object { LEAD_BOX rotate 135*z }
   object { LEAD_BOX rotate 153*z }
   object { LEAD_BOX rotate 171*z }
   object { LEAD_BOX rotate 189*z }
   object { LEAD_BOX rotate 207*z }
   object { LEAD_BOX rotate 225*z }
   object { LEAD_BOX rotate 243*z }
   object { LEAD_BOX rotate 261*z }
   object { LEAD_BOX rotate 279*z }
   object { LEAD_BOX rotate 297*z }
   object { LEAD_BOX rotate 315*z }
   object { LEAD_BOX rotate 333*z }
   object { LEAD_BOX rotate 351*z }
}

#declare BLACKEYE = cylinder { <0,0,0>, <0,0,SG_THICK>, 0.20 }

#declare DARTBOARD = union {
object { WHITES texture { WHITE_GLASS } }
object { DARKS texture { BLUE_GLASS } }
object { REDEYE texture { RED_GLASS } }
object { LEADS texture { T_Dull_Lead } }
object { BLACKEYE texture { BLUE_GLASS } }
object { GREENS texture { GREEN_GLASS } }
object { REDS texture { RED_GLASS } }
}

#declare LAMP_SHADE_FRAME = difference {
   box { <-9,-7,0>, <9,7,PB_THICK> }
   union {
      box {
         <0,0,-0.01>, <7,20,PB_THICK+0.01>
         rotate z * 14.03
         translate <9,-7,0>
      }
      box {
         <-7,0,-0.01>, <0,20,PB_THICK+0.01>
         rotate z * -14.03
         translate <-9,-7,0>
      }
      difference {
         box { <-8.627,-6.7,-0.01>, <8.627,6.7,PB_THICK+0.01> }
         union {
            box { 
               <0,0,-0.01>, <7,20,PB_THICK+0.01>
               rotate z * 14.03
               translate <8.627,-6.8,0>
            }
            box { 
               <-7,0,-0.01>, <0,20,PB_THICK+0.01>
               rotate z * -14.03
               translate <-8.627,-6.8,0>
            }
         }
      }
   }
   bounded_by { box { <-9,-7,0>, <9,7,PB_THICK> } }
   texture { T_Brass_3C }
}

#declare LIGHT_BULB = union {
   merge {
      sphere { <0,0,0>, 1 }
      cylinder { <0,0,1>, <0,0,0>, 1
         scale <0.3, 0.3, 1>
         translate 0.5*z
      }
      texture {
         pigment { color White }
         finish { ambient 0.8 diffuse 0.6 }
      }
   }
   cylinder {
      <0,0,1>, <0,0,0>, 1
      scale <0.4, 0.4, 0.5>
      texture { Brass_Texture }
      translate 1.5*z
   }
   rotate 90*x
   //scale .5
}

#ifdef (FINAL)
#declare LAMP_PANE = union {
   object { LAMP_SHADE_FRAME }
   object { DARTBOARD }
   translate <9,7,0>
   rotate <14.4775,0,0>
}
#else
#declare LAMP_PANE = object {
   LAMP_SHADE_FRAME
   translate <9,7,0>
   rotate <14.4775,0,0>
}
#end


#declare LAMPSHADE =
   union {
      object {
         LAMP_PANE
      }
      object {
         LAMP_PANE
         rotate y * 90
         translate <0,0,18>
      }
      object {
         LAMP_PANE
         rotate y * 180
         translate <18,0,18>
      }
      object {
         LAMP_PANE
         rotate y * 270
         translate <18,0,0>
      }
      box { 
         <0.05,-0.3,-0.15>, <15.5,0,0.15>
         translate <4.95,13.5,0>
         rotate <0,-45,0>
         texture { T_Brass_3C }
      }
      box { 
         <0.05,-0.3,-0.15>, <15.5,0,0.15>
         translate <4.95,13.5,0>
         rotate <0,45,0>
         translate <0,0,18>
         texture { T_Brass_3C }
      }
      cylinder {
         <0,-0.4,0>, <0,0.1,0>, 1.6
         translate <9,13.5,9>
         texture { T_Brass_3C }
      }
   }

#declare BASE_RAD = 6.5
#declare LAMP_BASE = cylinder {
   <0,0,0>, <0,2,0>, BASE_RAD
}

#declare KNOB_RAD = 0.4
#declare KB_SIZE = KNOB_RAD * sqrt( 0.5 ) * 1.02
#declare KNOB_BOX =
   box {
      <-KB_SIZE,-KB_SIZE,0>, <KB_SIZE,KB_SIZE,0.4>
   }

#declare KNOB_RIDGES = union {
   object { KNOB_BOX rotate z * 0 }
   object { KNOB_BOX rotate z * 4.5 }
   object { KNOB_BOX rotate z * 9.0 }
   object { KNOB_BOX rotate z * 13.5 }
   object { KNOB_BOX rotate z * 18.0 }
   object { KNOB_BOX rotate z * 22.5 }
   object { KNOB_BOX rotate z * 27.0 }
   object { KNOB_BOX rotate z * 31.5 }
   object { KNOB_BOX rotate z * 36.0 }
   object { KNOB_BOX rotate z * 40.5 }
   object { KNOB_BOX rotate z * 45.0 }
   object { KNOB_BOX rotate z * 49.5 }
   object { KNOB_BOX rotate z * 54.0 }
   object { KNOB_BOX rotate z * 58.5 }
   object { KNOB_BOX rotate z * 63.0 }
   object { KNOB_BOX rotate z * 67.5 }
   object { KNOB_BOX rotate z * 72.0 }
   object { KNOB_BOX rotate z * 76.5 }
   object { KNOB_BOX rotate z * 81.0 }
   object { KNOB_BOX rotate z * 85.5 }
}

#declare KNOB = union {
   object { KNOB_RIDGES translate <0,0,0.2> texture { T_Brass_3C finish { reflection 0.3 } } }
   cylinder { <0,0,0>, <0,0,0.2>, KNOB_RAD texture { T_Brass_3C } }
   cylinder { <0,0,0.4>, <0,0,0.45>, KNOB_RAD texture { T_Brass_3C } }
   //texture { T_Brass_3C }
}

#declare LAMP = union {
   object { KNOB translate <0,1,BASE_RAD+0.02> rotate -15*y }
   difference {
      object { LAMP_BASE }
      cylinder { <0,1.95,0>, <0,2.05,0>, 1.05 }
      texture { T_Brass_3C }
   }
   cylinder { <0,1.95,0>, <0,2.5,0>, 1.05 pigment { color Black } }
   cylinder { <0,2.5,0>, <0,12,0>, 1.0 texture { T_Brass_3C } }
   object { LAMPSHADE translate <-9,-7,-9> scale 0.9 translate <0,16,0> }
}
