// Include file for wineglass.pov

#declare F_RedWine1 = finish {
   ambient 0.5
   diffuse 0.3
   reflection 0.3
   refraction 1.0
   ior 1.33
   specular 1
   roughness 0.001
}


#declare WG_CHAMBER = difference {
      sphere {
         <0,0,0>, 4.2
         scale <1,1.75,1>
      }
   box { <-6,2.4,-6>, <6,8,6> }
   scale <1.04,1,1.04>
}

#declare WG_CHAMBER_CUTOUT = 
   sphere {
      <0,0,0>, 3.95
      scale <1.04,1.8,1.04>
   }

#declare WG_BASE =
   intersection {
      cone {
         <0,0.75,0>, 1.25
         <0,0,0>, 4.0
      }
      cylinder {
         <0,-0.1,0>,<0,1.1,0>,3.6
      }
   }


#declare WG_CUTOUT = union {
   cylinder { <-2,0.5,0>, <2,0.5,0>, 0.5 }
   box { <-2,0.5,-0.5>, <2,6.0,0.5> }
   cylinder { <-2,6.0,0>, <2,6.0,0>, 0.5 }
}

#declare WG_CUTOUTOFS = 1.2
#declare WG_CUTOUTROT = -1.4

#declare WG_STEM = difference {
   cone {
      <0,7.25,0>, 1.0
      <0,0,0>, 1.25
   }
   union {
      object {
         WG_CUTOUT
         rotate <WG_CUTOUTROT,0,0>
         translate <0,0.3,WG_CUTOUTOFS>
         rotate <0,90,0>
      }
      object {
         WG_CUTOUT
         rotate <WG_CUTOUTROT,0,0>
         translate <0,0.3,WG_CUTOUTOFS>
         rotate <0,270,0>
      }
      object {
         WG_CUTOUT
         rotate <WG_CUTOUTROT,0,0>
         translate <0,0.3,WG_CUTOUTOFS>
         rotate <0,30,0>
      }
      object {
         WG_CUTOUT
         rotate <WG_CUTOUTROT,0,0>
         translate <0,0.3,WG_CUTOUTOFS>
         rotate <0,300,0>
      }
      object {
         WG_CUTOUT
         rotate <WG_CUTOUTROT,0,0>
         translate <0,0.3,WG_CUTOUTOFS>
         rotate <0,150,0>
      }
      object {
         WG_CUTOUT
         rotate <WG_CUTOUTROT,0,0>
         translate <0,0.3,WG_CUTOUTOFS>
         rotate <0,210,0>
      }
   }
}

#declare WG_CHAMBER_Y_OFS = 15.0

#declare WINEGLASS_1 = difference {
   union {
      object {
         WG_STEM
         translate <0,0.75,0>
      }
      object { WG_BASE }
      object {
         WG_CHAMBER
         translate <0,WG_CHAMBER_Y_OFS,0>
      }
   }
   // cut-out for the chamber
   object {
      WG_CHAMBER_CUTOUT
      translate <0,WG_CHAMBER_Y_OFS,0>
   }
   bounded_by { cylinder { <0,-0.01,0>, <0,17.5,0>, 5.0 } }
}

#declare Filled_Glass =
union {
   difference {
      object {
         WG_CHAMBER_CUTOUT
      }
      box { <-6,0.1,-6>, <6,8,6> }
      texture {
         finish { F_RedWine1 ambient 0.4 }
         pigment { rgbft < 0.85, 0.2, 0.2, 0.4, 0.4 > } 
      }
      scale 0.999
      translate <0,WG_CHAMBER_Y_OFS,0>
   }
   object {
      WINEGLASS_1
      texture { T_Glass3 }
   }
}

#declare Empty_Glass = 
object {
   WINEGLASS_1
   texture { T_Glass3 }
}
