// Adam Parrish
// Winter's Window -- POV Source file
// ----------------------------------
// Please look this over and see what you think.  I've tried to put some
// useful comments in here, though you povray pundits will likely not
// need them to decipher my simplistic code. :)  If you have any major
// complaints or minor praise, send e-mail to myth@alinc.com.  Thanks!

// Please note that this scene is best rendered at a resolution where the
// width is 60% of the height (the final image I rendered was 360x600).
// This prevents a lot of ugly open space from interfering with the scene.

// Note the abscence of include files.  This is probably the first
// Povray scene I've done that didn't use one.  I'm flying on my own
// now. :)

#declare Thickness = 0.4        // the thickness of the window-lines
#declare GlassTrans = 0.15      // the amount of light glass will transfer
#declare GlassFilter = 0.42     // the amount of light glass will filter

global_settings { ambient_light <.8, .8, .8> }

// colors/textures for window segments
#declare BlueWhite1 = rgbft<.98, .98, 1, GlassFilter, GlassTrans>
#declare BlueWhite2 = rgbft<.9, .9, 1, GlassFilter, GlassTrans>
#declare BlueWhite3 = rgbft<.8, .8, 1, GlassFilter, GlassTrans>
#declare BlueWhite4 = rgbft<.7, .7, 1, GlassFilter, GlassTrans>
#declare BlueWhite5 = rgbft<.6, .6, 1, GlassFilter, GlassTrans>
#declare YellowSun42 = rgbft<.94, .94, .1, GlassFilter, GlassTrans>
#declare TreeBrown1 = rgbft<.46, .33, .072, GlassFilter, GlassTrans>
#declare TreeBrown2 = rgbft<.44, .31, .042, GlassFilter, GlassTrans>
#declare TreeBrown3 = rgbft<.42, .29, .092, GlassFilter, GlassTrans>

// #declares for finishes, textures, etc.
#declare GlassFinish = /* The finish of the glass */
finish { 
  reflection .3			// This glass is definitely not the  
  refraction 1 ior 1.42         // perfect "stained glass" finish.
  caustics 1                    // It does, however, do rather well in
  fade_distance 25              // this scene.
  fade_power 2                  // The highlight, I think, is the key here.
  ambient .4                    // In combination with the normal,
  diffuse .9                    // it gives the glass a bumpy/shiny look.
  specular 0.42			// (though in the actual scene, it looks
  roughness 0.09		// more flat when placed in an atmosphere)
}
#declare GlassNormal =
normal { bumps .32 scale .74 } // simple, but effective

// These window textures follow a "gradient" or sorts.
// The bottom of the window is textured with BlueWhite1Window, and the
// top with BlueWhite5Window, with the intermediary values inbetween.
// There are three TreeBrownXWindow textures, all of which look basically
// the same, but at least add a little variety.
#declare BlueWhite1Window =
texture {
  pigment { color BlueWhite1 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare BlueWhite2Window =
texture {
  pigment { color BlueWhite2 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare BlueWhite3Window =
texture {
  pigment { color BlueWhite3 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare BlueWhite4Window =
texture {
  pigment { color BlueWhite4 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare BlueWhite5Window =
texture {
  pigment { color BlueWhite5 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare YellowSun42Window =
texture {
  pigment { color YellowSun42 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare TreeBrown1Window =
texture {
  pigment { color TreeBrown1 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare TreeBrown2Window =
texture {
  pigment { color TreeBrown2 }
  normal { GlassNormal }
  finish { GlassFinish }
}
#declare TreeBrown3Window =
texture {
  pigment { color TreeBrown3 }
  normal { GlassNormal }
  finish { GlassFinish }
}
// The StoneTexture here is one thing I am not satisfied with.  It should
// be slightly deeper-looking, I think.
#declare StoneTexture = 
texture {
  pigment { color rgb<.8, .8, .8> transmit 0 }
  normal { bumps .6 scale 2 }
  normal { bumps .8 scale .6 }
  normal { ripples .5 scale .9 }
  normal { wrinkles .4 scale .4 }
  finish { reflection .01 diffuse .24 }
}
// StoneTexutre2 is a lighter version of StoneTexture1.
// It is used to color the arch around the window.
#declare StoneTexture2 =
texture {
  pigment { color rgb<.87, .87, .87> }
  normal { bumps .5 scale .6 }
  normal { ripples .8 scale .6 }
  normal { wrinkles .4 scale .4 }
  finish { roughness 0.5 reflection .05 diffuse .25 }
}

// The #default texture is the texture of the cylinders between the
// window segments.  Nothing special, it just keeps the light out.
#default {
  pigment { color <.2, .2, .2> }
  finish { reflection 0.01 }
}

camera {
   location  <25, 80, -180>
   right     <.6, 0, 0>         // notice the right vector.
   look_at   <25, 30, 0> 
}

// "ambient" light source -- spotlight shining down on the window from
// the top.  This is the major lighting source for the scene.
light_source { 
  <25, 195, -80> 
  colour <.95, .99, 1> 
  spotlight
  atmospheric_attenuation on
  radius 142
  falloff 200
  tightness 42
  point_at <25, 90, -10>
}

// Window Light -- streams through the window.  The atmosphere scatters
// the light enough that I didn't have to use a arealight here.
light_source { <-100, 4200, 4200> colour <1, 1, 1> atmospheric_attenuation on }

// The Atmosphere.  The most aggravating part of the image, and the most
// time consuming.  The end result here could be better -- it would work
// better if it were slightly more gray, possibly a bit thicker.
atmosphere {
  color rgbft<0, 0, 0, .2, .84>
  type 1
  samples 50
  distance 500
  scattering 0.008
  jitter .5
  aa_level 4
  aa_threshold .1
}

// --------------------------------------------------------------------------
// - Begin #declare TheNeatoWindow
// --------------------------------------------------------------------------
//  TheNeatoWindow is the center of the scene.  All of it was coded by
//  hand from a piece of graph paper.  The window was designed on paper
//  in about 1 hour; it took 2 nights work to input all of the cylinders
//  and polygons (many of which are entirely superfluous).  Of course,
//  I could have done all this in a modeller, but what fun would that be?
//
#declare TheNeatoWindow =
union {

// Window Section 0
union {
  cylinder { <0, 0, 0>, <0, 7, 0>, Thickness }
  cylinder { <0, 7, 0>, <17, 11, 0>, Thickness }
  cylinder { <17, 11, 0>, <14, 0, 0>, Thickness }
  cylinder { <14, 0, 0>, <0, 0, 0>, Thickness }
  polygon { 5,
    <0, 0, 0>, <0, 7, 0>,
    <17, 11, 0>, <14, 0, 0>,
    <0, 0, 0>
    texture { BlueWhite1Window }
  }  
}

// Window Section 1
union {
  cylinder { <14, 0, 0>, <15, 4, 0>, Thickness }
  cylinder { <15, 4, 0>, <34, 4, 0>, Thickness }
  cylinder { <34, 4, 0>, <37, 0, 0>, Thickness }
  cylinder { <37, 0, 0>, <14, 0, 0>, Thickness }  
  polygon { 5,
    <14, 0, 0>, <15, 4, 0>, 
    <34, 4, 0>, <37, 0, 0>, 
    <14, 0, 0>
    texture { BlueWhite1Window }
  }
}

// Window Section 2
union {
  cylinder { <37, 0, 0>, <34, 4, 0>, Thickness }
  cylinder { <34, 4, 0>, <32, 15, 0>, Thickness }
  cylinder { <32, 15, 0>, <50, 19, 0>, Thickness }
  cylinder { <50, 19, 0>, <50, 0, 0>, Thickness }
  cylinder { <50, 0, 0>, <37, 0, 0>, Thickness }
  polygon { 6,
    <37, 0, 0>, <34, 4, 0>, <32, 15, 0>, <50, 19, 0>, <50, 0, 0>, <37, 0, 0>
    texture { BlueWhite2Window }
  }
}

// Window Section 3
union {
  cylinder { <18, 13, 0>, <22, 10, 0>, Thickness }
  cylinder { <22, 10, 0>, <23, 4, 0>, Thickness }
  cylinder { <23, 4, 0>, <15, 4, 0>, Thickness }
  cylinder { <15, 4, 0>, <17, 11, 0>, Thickness }
  cylinder { <17, 11, 0>, <18, 13, 0>, Thickness }
  polygon { 6,
    <18, 13, 0>, <22, 10, 0>, <23, 4, 0>, 
    <15, 4, 0>, <17, 11, 0>, <18, 13, 0>
    texture { TreeBrown1Window }
  }
}

// Window Section 4
union {
  cylinder { <23, 4, 0>, <22, 10, 0>, Thickness }
  cylinder { <22, 10, 0>, <28, 22, 0>, Thickness }
  cylinder { <28, 22, 0>, <31, 20, 0>, Thickness }
  cylinder { <31, 20, 0>, <34, 4, 0>, Thickness }
  cylinder { <34, 4, 0>, <23, 4, 0>, Thickness }
  polygon { 6,
    <23, 4, 0>, <22, 10, 0>, <28, 22, 0>, <31, 20, 0>, <34, 4, 0>, <23, 4, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 5
union {
  cylinder { <0, 7, 0>, <17, 11, 0>, Thickness }
  cylinder { <17, 11, 0>, <20, 20, 0>, Thickness }
  cylinder { <20, 20, 0>, <20, 25, 0>, Thickness }
  cylinder { <20, 25, 0>, <0, 27, 0>, Thickness }
  cylinder { <0, 27, 0>, <0, 7, 0>, Thickness }
  polygon { 6, 
    <0, 7, 0>, <17, 11, 0>, <20, 20, 0>, <20, 25, 0>, <0, 27, 0>, <0, 7, 0>
    texture { BlueWhite1Window }
  }
}

// Window Section 6
union {
  cylinder { <18, 13, 0>, <22, 10, 0>, Thickness }
  cylinder { <22, 10, 0>, <27, 20, 0>, Thickness }
  cylinder { <27, 20, 0>, <20, 20, 0>, Thickness }
  cylinder { <20, 20, 0>, <18, 13, 0>, Thickness }
  polygon { 5, 
    <18, 13, 0>, <22, 10, 0>, <27, 20, 0>, <20, 20, 0>, <18, 13, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 7
union {
  cylinder { <32, 15, 0>, <41, 17, 0>, Thickness }
  cylinder { <41, 17, 0>, <36, 28, 0>, Thickness }
  cylinder { <36, 28, 0>, <31, 20, 0>, Thickness }
  cylinder { <31, 20, 0>, <32, 15, 0>, Thickness }
  polygon { 5, 
    <32, 15, 0>, <41, 17, 0>, <36, 28, 0>, <31, 20, 0>, <32, 15, 0>
    texture { BlueWhite2Window }
  }
}

// Window Section 8
union {
  cylinder { <41, 17, 0>, <50, 19, 0>, Thickness }
  cylinder { <50, 19, 0>, <50, 33, 0>, Thickness }
  cylinder { <50, 33, 0>, <45, 38, 0>, Thickness }
  cylinder { <45, 38, 0>, <38, 31, 0>, Thickness }
  cylinder { <38, 31, 0>, <36, 28, 0>, Thickness }
  cylinder { <36, 28, 0>, <41, 17, 0>, Thickness }
  polygon { 7, 
    <41, 17, 0>, <50, 19, 0>, <50, 33, 0>, <45, 38, 0>, 
    <38, 31, 0>, <36, 28, 0>, <41, 17, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 9
union {
  cylinder { <0, 27, 0>, <20, 25, 0>, Thickness }
  cylinder { <20, 25, 0>, <20, 30, 0>, Thickness }
  cylinder { <20, 30, 0>, <10, 45, 0>, Thickness }
  cylinder { <10, 45, 0>, <0, 40, 0>, Thickness }
  cylinder { <0, 40, 0>, <0, 27, 0>, Thickness }
  polygon { 6, 
    <0, 27, 0>, <20, 25, 0>, <20, 30, 0>, <10, 45, 0>, <0, 40, 0>, <0, 27, 0>
    texture { BlueWhite2Window }
  }
}

// Window Section 10
union {
  cylinder { <20, 20, 0>, <27, 20, 0>, Thickness }
  cylinder { <27, 20, 0>, <28, 22, 0>, Thickness }
  cylinder { <28, 22, 0>, <31, 30, 0>, Thickness }
  cylinder { <31, 30, 0>, <31, 40, 0>, Thickness }
  cylinder { <31, 40, 0>, <25, 40, 0>, Thickness }
  cylinder { <25, 40, 0>, <20, 30, 0>, Thickness }
  cylinder { <20, 30, 0>, <20, 20, 0>, Thickness }
  polygon { 8,
    <20, 20, 0>, <27, 20, 0>, <28, 22, 0>, <31, 30, 0>
    <31, 40, 0>, <25, 40, 0>, <20, 30, 0>, <20, 20, 0> 
    texture { TreeBrown1Window }
  }
}

// Window Section 11
union {
  cylinder { <31, 20, 0>, <36, 28, 0>, Thickness }
  cylinder { <36, 28, 0>, <38, 31, 0>, Thickness }
  cylinder { <38, 31, 0>, <36, 33, 0>, Thickness }
  cylinder { <36, 33, 0>, <31, 30, 0>, Thickness }
  cylinder { <31, 30, 0>, <28, 22, 0>, Thickness }
  cylinder { <28, 22, 0>, <31, 20, 0>, Thickness }
  polygon { 7, 
    <31, 20, 0>, <36, 28, 0>, <38, 31, 0>, <36, 33, 0>, 
    <31, 30, 0>, <28, 22, 0>, <31, 20, 0>
    texture { TreeBrown3Window }
  }
}

// Window Section 12
union {
  cylinder { <20, 30, 0>, <24, 38, 0>, Thickness }
  cylinder { <24, 38, 0>, <13, 50, 0>, Thickness }
  cylinder { <13, 50, 0>, <7, 50, 0>, Thickness }
  cylinder { <7, 50, 0>, <20, 30, 0>, Thickness }
  polygon { 5, 
    <20, 30, 0>, <24, 38, 0>, <13, 50, 0>, <7, 50, 0>, <20, 30, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 13
union {
  cylinder { <31, 30, 0>, <36, 33, 0>, Thickness }
  cylinder { <36, 33, 0>, <41, 39, 0>, Thickness }
  cylinder { <41, 39, 0>, <32, 44, 0>, Thickness }
  cylinder { <32, 44, 0>, <31, 40, 0>, Thickness }
  cylinder { <31, 40, 0>, <31, 30, 0>, Thickness }
  polygon { 6, 
    <31, 30, 0>, <36, 33, 0>, <41, 39, 0>,
    <32, 44, 0>, <31, 40, 0>, <31, 30, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 14
union {
  cylinder { <38, 31, 0>, <45, 38, 0>, Thickness }
  cylinder { <45, 38, 0>, <45, 39, 0>, Thickness }
  cylinder { <45, 39, 0>, <42, 40, 0>, Thickness }
  cylinder { <42, 40, 0>, <41, 39, 0>, Thickness }
  cylinder { <41, 39, 0>, <36, 33, 0>, Thickness }
  cylinder { <36, 33, 0>, <38, 31, 0>, Thickness }
  polygon { 7, 
    <38, 31, 0>, <45, 38, 0>, <45, 39, 0>, <42, 40, 0>,
    <41, 39, 0>, <36, 33, 0>, <38, 31, 0>
    texture { TreeBrown1Window }
  }
}

// Window Section 15
union {
  cylinder { <45, 38, 0>, <50, 33, 0>, Thickness }
  cylinder { <50, 33, 0>, <50, 50, 0>, Thickness }
  cylinder { <50, 50, 0>, <45, 39, 0>, Thickness }
  cylinder { <45, 39, 0>, <45, 38, 0>, Thickness }
  polygon { 5, 
    <45, 38, 0>, <50, 33, 0>, <50, 50, 0>, <45, 39, 0>, <45, 38, 0>
    texture { BlueWhite2Window }
  }
}

// Window Section 16
union {
  cylinder { <0, 40, 0>, <10, 45, 0>, Thickness }
  cylinder { <10, 45, 0>, <7, 50, 0>, Thickness }
  cylinder { <7, 50, 0>, <0, 50, 0>, Thickness }
  cylinder { <0, 50, 0>, <0, 40, 0>, Thickness }
  polygon { 5, 
    <0, 40, 0>, <10, 45, 0>, <7, 50, 0>, <0, 50, 0>, <0, 40, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 17
union {
  cylinder { <24, 38, 0>, <25, 40, 0>, Thickness }
  cylinder { <25, 40, 0>, <28, 50, 0>, Thickness }
  cylinder { <28, 50, 0>, <13, 50, 0>, Thickness }
  cylinder { <13, 50, 0>, <24, 38, 0>, Thickness }
  polygon { 5, 
    <24, 38, 0>, <25, 40, 0>, <28, 50, 0>, <13, 50, 0>, <24, 38, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 18
union {
  cylinder { <25, 40, 0>, <31, 40, 0>, Thickness }
  cylinder { <31, 40, 0>, <32, 44, 0>, Thickness }
  cylinder { <32, 44, 0>, <34, 50, 0>, Thickness }
  cylinder { <34, 50, 0>, <28, 50, 0>, Thickness }
  cylinder { <28, 50, 0>, <25, 40, 0>, Thickness }
  polygon { 6, 
    <25, 40, 0>, <31, 40, 0>, <32, 44, 0>,
    <34, 50, 0>, <28, 50, 0>, <25, 40, 0>
    texture { TreeBrown1Window }
  }
}

// Window Section 19
union {
  cylinder { <32, 44, 0>, <41, 39, 0>, Thickness }
  cylinder { <41, 39, 0>, <42, 40, 0>, Thickness }
  cylinder { <42, 40, 0>, <43, 50, 0>, Thickness }
  cylinder { <43, 50, 0>, <34, 50, 0>, Thickness }
  cylinder { <34, 50, 0>, <32, 44, 0>, Thickness }
  polygon { 6, 
    <32, 44, 0>, <41, 39, 0>, <42, 40, 0>, 
    <43, 50, 0>, <34, 50, 0>, <32, 44, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 20
union {
  cylinder { <42, 40, 0>, <45, 39, 0>, Thickness }
  cylinder { <45, 39, 0>, <44, 43, 0>, Thickness }
  cylinder { <44, 43, 0>, <43, 50, 0>, Thickness }
  cylinder { <43, 50, 0>, <42, 40, 0>, Thickness }
  polygon { 5, 
    <42, 40, 0>, <45, 39, 0>, <44, 43, 0>, <43, 50, 0>, <42, 40, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 21
union {
  cylinder { <44, 43, 0>, <47, 50, 0>, Thickness }
  cylinder { <47, 50, 0>, <43, 50, 0>, Thickness }
  cylinder { <43, 50, 0>, <44, 43, 0>, Thickness }
  polygon { 4, 
    <44, 43, 0>, <47, 50, 0>, <43, 50, 0>, <44, 43, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 22
union {
  cylinder { <44, 43, 0>, <45, 39, 0>, Thickness }
  cylinder { <45, 39, 0>, <50, 50, 0>, Thickness }
  cylinder { <50, 50, 0>, <47, 50, 0>, Thickness }
  cylinder { <47, 50, 0>, <44, 43, 0>, Thickness }
  polygon { 5, 
    <44, 43, 0>, <45, 39, 0>, <50, 50, 0>, <47, 50, 0>, <44, 43, 0>
    texture { TreeBrown3Window }
  }
}

// Window Section 23
union {
  cylinder { <0, 50, 0>, <7, 50, 0>, Thickness }
  cylinder { <7, 50, 0>, <1, 64, 0>, Thickness }
  cylinder { <1, 64, 0>, <0, 64, 0>, Thickness }
  cylinder { <0, 64, 0>, <0, 50, 0>, Thickness }
  polygon { 5, 
    <0, 50, 0>, <7, 50, 0>, <1, 64, 0>, <0, 64, 0>, <0, 50, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 24
union {
  cylinder { <7, 50, 0>, <13, 50, 0>, Thickness }
  cylinder { <13, 50, 0>, <4, 61, 0>, Thickness }
  cylinder { <4, 61, 0>, <1, 64, 0>, Thickness }
  cylinder { <1, 64, 0>, <7, 50, 0>, Thickness }
  polygon { 5, 
    <7, 50, 0>, <13, 50, 0>, <4, 61, 0>, <1, 64, 0>, <7, 50, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 25
union {
  cylinder { <13, 50, 0>, <28, 50, 0>, Thickness }
  cylinder { <28, 50, 0>, <27, 61, 0>, Thickness }
  cylinder { <27, 61, 0>, <25, 64, 0>, Thickness }
  cylinder { <25, 64, 0>, <12, 57, 0>, Thickness }
  cylinder { <12, 57, 0>, <11, 52, 0>, Thickness }
  cylinder { <11, 52, 0>, <13, 50, 0>, Thickness }
  polygon { 7, 
    <13, 50, 0>, <28, 50, 0>, <27, 61, 0>, <25, 64, 0>, 
    <12, 57, 0>, <11, 52, 0>, <13, 50, 0>
    texture { BlueWhite4Window }
  }
}

// Window Section 26
union {
  cylinder { <28, 50, 0>, <31, 50, 0>, Thickness }
  cylinder { <31, 50, 0>, <30, 60, 0>, Thickness }
  cylinder { <30, 60, 0>, <27, 61, 0>, Thickness }
  cylinder { <27, 61, 0>, <28, 50, 0>, Thickness }
  polygon { 5, 
    <28, 50, 0>, <31, 50, 0>, <30, 60, 0>, <27, 61, 0>, <28, 50, 0>
    texture { TreeBrown1Window }
  }
}

// Window Section *27*
union {
  cylinder { <31, 50, 0>, <34, 50, 0>, Thickness }
  cylinder { <34, 50, 0>, <38, 60, 0>, Thickness }
  cylinder { <38, 60, 0>, <36, 60, 0>, Thickness }
  cylinder { <36, 60, 0>, <31, 50, 0>, Thickness }
  polygon { 5, 
    <31, 50, 0>, <34, 50, 0>, <38, 60, 0>, <36, 60, 0>, <31, 50, 0>
    texture { TreeBrown3Window }
  }
}

// Window Section 28
union {
  cylinder { <34, 50, 0>, <47, 50, 0>, Thickness }
  cylinder { <47, 50, 0>, <50, 57, 0>, Thickness }
  cylinder { <50, 57, 0>, <50, 65, 0>, Thickness }
  cylinder { <50, 65, 0>, <41, 74, 0>, Thickness }
  cylinder { <41, 74, 0>, <38, 60, 0>, Thickness }
  cylinder { <38, 60, 0>, <34, 50, 0>, Thickness }
  polygon { 7, 
    <34, 50, 0>, <47, 50, 0>, <50, 57, 0>, <50, 65, 0>,
    <41, 74, 0>, <38, 60, 0>, <34, 50, 0>
    texture { BlueWhite4Window }
  }
}

// Window Section 29
union {
  cylinder { <47, 50, 0>, <50, 50, 0>, Thickness }
  cylinder { <50, 50, 0>, <50, 57, 0>, Thickness }
  cylinder { <50, 57, 0>, <47, 50, 0>, Thickness }
  polygon { 4,
    <47, 50, 0>, <50, 50, 0>, <50, 57, 0>, <47, 50, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 30
union {
  cylinder { <4, 61, 0>, <7, 57, 0>, Thickness }
  cylinder { <7, 57, 0>, <11, 64, 0>, Thickness }
  cylinder { <11, 64, 0>, <8, 74, 0>, Thickness }
  cylinder { <8, 74, 0>, <3, 70, 0>, Thickness }
  cylinder { <3, 70, 0>, <4, 61, 0>, Thickness }
  polygon { 6, 
    <4, 61, 0>, <7, 57, 0>, <11, 64, 0>, <8, 74, 0>, <3, 70, 0>, <4, 61, 0>
    texture { BlueWhite4Window }
  }
}

// Window Section 31
union {
  cylinder { <7, 57, 0>, <11, 52, 0>, Thickness }
  cylinder { <11, 52, 0>, <12, 57, 0>, Thickness }
  cylinder { <12, 57, 0>, <13, 63, 0>, Thickness }
  cylinder { <13, 63, 0>, <13, 67, 0>, Thickness }
  cylinder { <13, 67, 0>, <11, 64, 0>, Thickness }
  cylinder { <11, 64, 0>, <7, 57, 0>, Thickness }
  polygon { 7, 
    <7, 57, 0>, <11, 52, 0>, <12, 57, 0>, <13, 63, 0>, 
    <13, 67, 0>, <11, 64, 0>, <7, 57, 0>
    texture { TreeBrown1Window }
  }
}

// Window Section 32
union {
  cylinder { <12, 57, 0>, <25, 64, 0>, Thickness }
  cylinder { <25, 64, 0>, <25, 73, 0>, Thickness }
  cylinder { <25, 73, 0>, <15, 68, 0>, Thickness }
  cylinder { <15, 68, 0>, <13, 63, 0>, Thickness }
  cylinder { <13, 63, 0>, <12, 57, 0>, Thickness }
  polygon { 6, 
    <12, 57, 0>, <25, 64, 0>, <25, 73, 0>,
    <15, 68, 0>, <13, 63, 0>, <12, 57, 0>
    texture { BlueWhite4Window }
  }
}

// Window Section 33
union {
  cylinder { <31, 50, 0>, <36, 60, 0>, Thickness }
  cylinder { <36, 60, 0>, <38, 65, 0>, Thickness }
  cylinder { <38, 65, 0>, <32, 70, 0>, Thickness }
  cylinder { <32, 70, 0>, <30, 60, 0>, Thickness }
  cylinder { <30, 60, 0>, <31, 50, 0>, Thickness }
  polygon { 6, 
    <31, 50, 0>, <36, 60, 0>, <38, 65, 0>, 
    <32, 70, 0>, <30, 60, 0>, <31, 50, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 34
union {
  cylinder { <1, 64, 0>, <4, 61, 0>, Thickness }
  cylinder { <4, 61, 0>, <3, 75, 0>, Thickness }
  cylinder { <3, 75, 0>, <1, 64, 0>, Thickness }
  polygon { 4, 
    <1, 64, 0>, <4, 61, 0>, <3, 75, 0>, <1, 64, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 35
union {
  cylinder { <25, 64, 0>, <27, 61, 0>, Thickness }
  cylinder { <27, 61, 0>, <34, 81, 0>, Thickness }
  cylinder { <34, 81, 0>, <27, 88, 0>, Thickness }
  // skip a segment to allow torus of section 42
  cylinder { <25, 87, 0>, <25, 64, 0>, Thickness }
  polygon { 6, 
    <25, 64, 0>, <27, 61, 0>, <34, 81, 0>, 
    <27, 88, 0>, <25, 87, 0>, <25, 64, 0>
    texture { BlueWhite5Window }
  }
}

// Window Section 36
union {
  cylinder { <27, 61, 0>, <30, 60, 0>, Thickness }
  cylinder { <30, 60, 0>, <34, 81, 0>, Thickness }
  cylinder { <34, 81, 0>, <27, 61, 0>, Thickness }
  polygon { 4, 
    <27, 61, 0>, <30, 60, 0>, <34, 81, 0>, <27, 61, 0>
    texture { TreeBrown3Window }
  }
}

// Window Section 37
union {
  cylinder { <36, 60, 0>, <38, 60, 0>, Thickness }
  cylinder { <38, 60, 0>, <41, 74, 0>, Thickness }
  cylinder { <41, 74, 0>, <38, 65, 0>, Thickness }
  cylinder { <38, 65, 0>, <36, 60, 0>, Thickness }
  polygon { 5, 
    <36, 60, 0>, <38, 60, 0>, <41, 74, 0>, <38, 65, 0>, <36, 60, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 38
union {
  cylinder { <0, 64, 0>, <1, 64, 0>, Thickness }
  cylinder { <1, 64, 0>, <3, 75, 0>, Thickness }
  cylinder { <3, 75, 0>, <1, 82, 0>, Thickness }
  // skip segment to allow arch torus
  cylinder { <0, 75, 0>, <0, 64, 0>, Thickness }
  polygon { 6, 
    <0, 64, 0>, <1, 64, 0>, <3, 75, 0>, 
    <1, 82, 0>, <0, 82, 0>, <0, 64, 0>
    texture { BlueWhite3Window }
  }
}

// Window Section 39
union {
  cylinder { <11, 64, 0>, <20, 80, 0>, Thickness }
  cylinder { <20, 80, 0>, <23, 88, 0>, Thickness }
  cylinder { <23, 88, 0>, <12, 77, 0>, Thickness }
  cylinder { <12, 77, 0>, <8, 74, 0>, Thickness }
  cylinder { <8, 74, 0>, <11, 64, 0>, Thickness }
  polygon { 6, 
    <11, 64, 0>, <20, 80, 0>, <23, 88, 0>,
    <12, 77, 0>, <8, 74, 0>, <11, 64, 0>
    texture { BlueWhite5Window }
  }
}

// Window Section 40
union {
  cylinder { <13, 63, 0>, <20, 80, 0>, Thickness }
  cylinder { <20, 80, 0>, <13, 67, 0>, Thickness }
  cylinder { <13, 67, 0>, <13, 63, 0>, Thickness }
  polygon { 4, 
    <13, 63, 0>, <20, 80, 0>, <13, 67, 0>, <13, 63, 0>
    texture { TreeBrown1Window }
  }
}

// Window Section 40.5 (okay, so I missed this one when I numbered at first.)
// (so sue me.)
union {
  cylinder { <3, 70, 0>, <12, 77, 0>, Thickness }
  cylinder { <12, 77, 0>, <3, 72, 0>, Thickness }
  cylinder { <3, 72, 0>, <3, 70, 0>, Thickness }
  polygon { 4, 
    <3, 70, 0>, <12, 77, 0>, <3, 72, 0>, <3, 70, 0>
    texture { TreeBrown2Window }
  }
}

// Window Section 41
union {
  cylinder { <15, 68, 0>, <25, 73, 0>, Thickness }
  cylinder { <25, 73, 0>, <16, 70, 0>, Thickness }
  cylinder { <16, 70, 0>, <15, 68, 0>, Thickness }
  polygon { 4, 
    <15, 68, 0>, <25, 73, 0>, <16, 70, 0>, <15, 68, 0>
    texture { TreeBrown3Window }
  }
}

// Window Section 41.5
// I got all the way to the Stained Glass before I realized I hadn't
// numbered this section.  Because all the necessary cylinders already
// exist (thanks to all this redundancy <g>) I'll just define the
// polygon.
polygon { 5,
  <16, 70, 0>, <23, 88, 0>, <25, 87, 0>, <25, 73, 0>, <16, 70, 0>
  texture { BlueWhite4Window }
}

// Window Section *42*
// Yes, 42.  The Central Part.  Misnumbered in my diagram, but I just
// couldn't resist.
union {
  torus { 2.9, Thickness rotate x*90 translate <25, 90, 0> }
  disc { 
    <25, 90, 0>, z, 3
    texture { YellowSun42Window } 
  }
}

// Window Section 43
union {
  cylinder { <38, 65, 0>, <41, 74, 0>, Thickness }
  cylinder { <41, 74, 0>, <34, 81, 0>, Thickness }
  cylinder { <34, 81, 0>, <32, 70, 0>, Thickness }
  cylinder { <32, 70, 0>, <38, 65, 0>, Thickness }
  polygon { 5, 
    <38, 65, 0>, <41, 74, 0>, <34, 81, 0>, <32, 70, 0>, <38, 65, 0>
    texture { BlueWhite4Window }
  }
}

// Window Section 44
union {
  cylinder { <3, 75, 0>, <11, 90, 0>, Thickness }
  cylinder { <11, 90, 0>, <5, 90, 0>, Thickness }
  // skip segment for arch torus
  cylinder { <1, 82, 0>, <3, 75, 0>, Thickness }
  polygon { 5, 
    <3, 75, 0>, <11, 90, 0>, <0, 90, 0>, <1, 82, 0>, <3, 75, 0>
    texture { BlueWhite5Window }
  }
}

// Window Section 44.5 -- yet another numbering problem
// what do you expect when you do all this on graph paper?
union {
  cylinder { <3, 72, 0>, <12, 77, 0>, Thickness }
  cylinder { <12, 77, 0>, <23, 88, 0>, Thickness }
  // skip segment for 42
  cylinder { <22, 90, 0>, <11, 90, 0>, Thickness }
  cylinder { <11, 90, 0>, <3, 75, 0>, Thickness }
  cylinder { <3, 75, 0>, <3, 72, 0>, Thickness }
  polygon { 7, 
    <3, 72, 0>, <12, 77, 0>, <23, 88, 0>, <22, 90, 0>, 
    <11, 90, 0>, <3, 75, 0>, <3, 72, 0>
    texture { BlueWhite5Window }
  }
}

// Window Section 45
// Not much to this one.
union {
  cylinder { <50, 75, 0>, <50, 65, 0>, Thickness }
  cylinder { <50, 65, 0>, <27, 88, 0>, Thickness }
  // allow for 42
  cylinder { <28, 90, 0>, <45, 90, 0>, Thickness }
  // allow for arch torus
  polygon { 5, 
    <50, 65, 0>, <50, 90, 0>, <28, 90, 0>, <27, 88, 0> <50, 65, 0>
    texture { BlueWhite5Window }
  }
}

// Window Section 46
// again, not much here.
union { 
  // allow for 42
  cylinder { <23, 92, 0>, <17, 98, 0>, Thickness }
  // allow for arch
  polygon { 5,
    <0, 90, 0>, <22, 90, 0>, <23, 92, 0>, 
    <15, 100, 0>, <0, 90, 0>
    texture { BlueWhite5Window }
  }
}

// Window Section 47
// ditto.
union {
  cylinder { <27, 92, 0>, <33, 98, 0>, Thickness }
  // allow for . . . you get the point
  polygon { 5, 
    <28, 90, 0>, <50, 90, 0>,
    <35, 100, 0>, <27, 92, 0>, <28, 90, 0>
    texture { BlueWhite5Window }
  }
}

// Window Sections 48 & 49
// both of which comprise of cylinders already defined,
// except one, plus the window polygon (which was consolidated)
union { 
  cylinder { <25, 93, 0>, <25, 100, 0>, Thickness }
  polygon { 6,
    <23, 92, 0>, <25, 93, 0>, <27, 92, 0>, 
    <35, 100, 0>, <15, 100, 0>, <23, 92, 0>
    texture { BlueWhite5Window }
  }
}

// The Arch that goes on top of the window
object {
  intersection {
    plane { -y, 0 }
    torus { 25, Thickness rotate x*90 }
  }
  translate <25, 75, 0>
}
} // -------------------------------------------------------------------------
  // - End TheNeatoWindow
  // -------------------------------------------------------------------------

// StoneSlab is one unit in the stone arch surrounding the window.
#declare StoneSlab = 
box {
  <-5, 0, -3>, <0, 24.8, 3>
  texture { StoneTexture2 }
} 

// StoneArch is a simple CSG difference of two cylinders.  I had originally
// intended that this arch be pointed rather than semicircular, but I
// found the latter was MUCH easier to design. :)
#declare StoneArch =
difference {
  difference {
    cylinder { <0, 0, -3>, <0, 0, 3>, 30 }
    cylinder { <0, 0, -3.1>, <0, 0, 3.1>, 25 }
  }
  plane { y, 0 }
  texture { StoneTexture2 }
}

// The combination of StoneArch and StoneSlabs
#declare StoneWindowBorder =
union {
  object { StoneSlab translate <0, 0, 0> }
  object { StoneSlab translate <0, 25, 0> }
  object { StoneSlab translate <0, 50, 0> }
  object { StoneSlab translate <55, 0, 0> }
  object { StoneSlab translate <55, 25, 0> }
  object { StoneSlab translate <55, 50, 0> }
  object { StoneArch translate <25, 75, 0> }
}

// The Floor; where the light from the window falls
#declare Floor =
intersection {
  plane { y, 0 }
  plane { z, -3 }
  texture { StoneTexture }
  translate <0, 0, 10>  
    // move it back a little to make sure there isn't a gap between
    // the Floor and the BackWall
}

// The BackWall -- where other light falls
#declare BackWall =
difference {
  box {  
    <-200, 0, -2>, <200, 200, 2>
  }
  union {
    cylinder { <25, 75, -2.1>, <25, 75, 2.1>, 30.1 }
    box { <-5, 0, -2.1>, <55, 75, 2.1> }
  }
  texture { StoneTexture }
}

// The Ceiling -- prevents random pointlight from escaping into the scene.
// It also makes me at least FEEL like I have a complete room.
#declare Ceiling = 
polygon { 5, 
  <-200, 200, 0>, <200, 200, 0>,
  <200, 200, -200>, <-200, 200, -200>, <-200, 200, 0>
  texture { StoneTexture }
}    
              
// Implementation of the Objects (which should have been in an include file
// anyway . . .)
object { TheNeatoWindow }
object { StoneWindowBorder }
object { Floor }
object { BackWall }
object { Ceiling }

// The End