//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 55 textures and 195 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/06/1997    (06.02.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

atmosphere {
  type 1    // Isotropic
  distance     25.0
  color <0.5,0.5,0.5,0.0,0.0>
  scattering   0.25
  samples      10
  jitter       0.03
  aa_threshold 0.1
  aa_level     4.0
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <13.050, -19.400, 3.100>
  direction <0.0,     0.0,  2.5650>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.200, 3.650, 1.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <0.000, -0.100, 0.000>
  direction <0.0,     0.0,  0.8662>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

*/

/*
camera {  //  Camera SpotCam002
  location  <-26.362, 17.011, 13.747> // Attached to WindowLight
  direction <0.0,     0.0,  1.3741>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-25.514, 16.705, 13.314> // Following WindowLight
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight WindowLight
  <-26.362, 17.011, 13.747>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-25.514, 16.705, 13.314>
    falloff   20.0  // outer radius (in deg)
      radius    10.0  // inner radius
  atmospheric_attenuation on
}

light_source {   // CandleLight2
  <3.539, 2.298, 4.090>
  color rgb <1.004, 0.714, 0.220>
  fade_distance  20.0
  fade_power 1.0
  atmosphere off
}

light_source {   // CandleLight
  <1.722, -4.975, 4.200>
  color rgb <1.004, 0.714, 0.220>
  fade_distance  20.0
  fade_power 1.0
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "scene7.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare legs1 = union {
  cylinder { // R_rear_leg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
  }
  cylinder { // r_front_leg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    translate  16.5*x
  }
  cylinder { // L_front_leg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    translate  <16.5, 13.0, 0.0>
  }
  cylinder { // L_rear_leg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    translate  13.0*y
  }
  scale <1.0, 1.0, 20.0>
}
#declare chairseat1 = difference {
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood3
    }
    scale <9.650387, 8.016424, 1.0>
    translate  <8.265924, 6.531627, 19.818807>
  }
  sphere { // Sphere11
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <7.253192, 3.402885, 0.878388>
    translate  <8.000879, 8.938731, 21.038833>
  }
  sphere { // Sphere12
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <7.253192, 3.402885, 0.878388>
    translate  <7.904764, 3.844616, 21.038833>
  }
  texture {
    DMFWood3
  }
  scale <1.166464, 1.0, 0.7>
  translate  <-0.724794, 0.319788, 6.311999>
}
#declare THE_SEAT1 = intersection {
  object { chairseat1 }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <14.602002, 10.148242, 3.174017>
    translate  <7.925238, 6.62044, 19.566157>
  }
  texture {
    DMFWood3
  }
}
#declare TOP_BACK1 = difference {
  box { // BACK_TOP1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood3
    }
    scale <2.505237, 11.700673, 4.963929>
    translate  <0.466587, 7.445879, 48.176188>
  }
  sphere { // BACKOTHCURV1
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <5.263309, 17.830807, 9.25572>
    rotate -270.0*y
    translate  <0.067947, 7.170717, 54.863726>
  }
  cylinder { // BACK_HOLE1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <1.562738, 4.28119, 7.181862>
    rotate -90.0*y
    translate  <4.385654, 6.925283, 46.822499>
  }
  sphere { // BACKTOPCURV1
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <5.263309, 17.830807, 9.25572>
    translate  <6.717791, 6.618306, 48.322333>
  }
  torus { // BACKBKCUT1
    1.5, 0.5  rotate -x*90
    texture {
      DMFWood3
    }
    scale <2.811993, 12.133492, 10.874012>
    translate  <2.367013, 6.052093, 46.951935>
  }
  scale 0.9
  translate  <-0.805357, 0.0, 5.190077>
}
#declare THE_BACK1 = merge {
  object { TOP_BACK1 }
  cylinder { // backrail8
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.767, 0.823, 24.65942>
    rotate 3.5*x
    translate  <1.0, 0.0, 19.822715>
  }
  cylinder { // backrail9
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate 2.5*x
    translate  <0.6, 2.0, 19.822715>
  }
  cylinder { // backrail10
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate 1.5*x
    translate  <0.2, 4.0, 19.822715>
  }
  cylinder { // backrail11
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate 0.5*x
    translate  <-0.2, 6.0, 19.822715>
  }
  cylinder { // backrail12
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate -0.5*x
    translate  <-0.2, 8.0, 19.822715>
  }
  cylinder { // backrail13
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate -1.5*x
    translate  <0.2, 10.0, 19.822715>
  }
  cylinder { // backrail14
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate -2.5*x
    translate  <0.6, 12.0, 19.822715>
  }
  cylinder { // backrail15
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.767, 0.823, 24.65942>
    rotate -3.5*x
    translate  <1.0, 14.0, 19.822715>
  }
  scale <1.0, 1.0, 0.75>
  rotate -2.525529*y
  translate  <0.0, 0.0, 5.642293>
}
union { // the_chair1
  object { legs1 }
  object { THE_SEAT1 }
  object { THE_BACK1 }
  cylinder { // rear_crossbar1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 13.0>
    rotate <0.0, -90.0, -90.0>
    translate  <-0.120131, -0.108774, 5.623311>
  }
  cylinder { // right_crossba1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 15.5>
    rotate -90.0*y
    translate  <15.931139, 0.0, 7.904764>
  }
  cylinder { // L_crossbar1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 15.5>
    rotate -90.0*y
    translate  <15.931139, 13.071693, 7.904764>
  }
  cylinder { // front_crossba1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 13.0>
    rotate <0.0, -90.0, -90.0>
    translate  <16.507831, 0.083457, 5.623311>
  }
  scale 0.2
  rotate -5.0*z
  translate  <-7.0, 0.0, -6.8>
}


union { // Wall
  box { // WallPart1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.9, 10.0, 20.0>
    rotate -20.0*z
    translate  <-13.690638, -1.284808, 4.92531>
  }
  box { // WallPart2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.9, 15.0, 20.0>
    rotate -20.0*z
    translate  <-3.009292, 28.061953, 4.92531>
  }
  box { // WallPart3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.9, 10.0, 7.0>
    rotate -20.0*z
    translate  <-9.62742, 9.878791, 18.599676>
  }
  box { // WallPart4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.9, 10.0, 7.0>
    rotate -20.0*z
    translate  <-9.62742, 9.878791, -10.400341>
  }
  texture {
    Stone13
  }
}


// Include contains 'TraSwp11'
#include "scene7.in1"

#declare TraSwp11 = object {
  TraSwp11_Raw
  texture {
    DMFLightOak6
  }
  scale <0.05, 0.05, 2.05>
  rotate <180.0, 0.0, 180.0>
  translate  2.75*z
}
// Include contains 'TraSwp12'
#include "scene7.in2"

#declare TraSwp12 = object {
  TraSwp12_Raw
  texture {
    DMFLightOak7
  }
  scale <0.05, 0.05, 1.4>
  rotate <0.0, 90.0, 0.0>
  translate  <-0.7, 0.0, 1.6>
}
// Include contains 'TraSwp13'
#include "scene7.in3"

#declare TraSwp13 = object {
  TraSwp13_Raw
  texture {
    DMFLightOak7
  }
  scale <0.05, 0.05, 1.4>
  rotate <0.0, 90.0, 0.0>
  translate  <-0.7, 0.0, -0.45>
}
// Include contains 'TraSwp14'
#include "scene7.in4"

#declare TraSwp14 = object {
  TraSwp14_Raw
  texture {
    DMFLightOak6
  }
  scale <0.05, 0.05, 1.95>
  rotate <180.0, 0.0, 180.0>
  translate  0.5*z
}
#declare BotFrame = difference {
  box { // FrameBottom
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak6
    }
    scale <1.0, 0.15, 0.15>
    translate  -1.6*z
  }
  box { // BotLftBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <1.05, 0.0, -1.45>
  }
  box { // BotRtBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <-1.05, 0.0, -1.45>
  }
  texture {
    DMFLightOak7
  }
}
#declare TopFrame = difference {
  box { // FrameTop
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak6
    }
    scale <1.0, 0.15, 0.15>
    translate  2.9*z
  }
  box { // TopLftBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <1.0, 0.0, 2.7>
  }
  box { // TopRtBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <-1.05, 0.0, 2.75>
  }
  texture {
    DMFLightOak7
  }
}
#declare LfFrame = difference {
  box { // FrameLeft
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale <0.15, 0.15, 2.4>
    translate  <0.85, 0.0, 0.65>
  }
  box { // LftBotBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <0.65, 0.0, -1.75>
  }
  box { // LftTopBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <0.65, 0.0, 3.05>
  }
  texture {
    DMFLightOak7
  }
}
#declare RtFrame = difference {
  box { // FrameRight
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale <0.15, 0.15, 2.4>
    translate  <-0.85, 0.0, 0.65>
  }
  box { // RtBotBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <-0.65, 0.0, -1.75>
  }
  box { // RtTopBev
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale 0.25
    rotate -45.0*y
    translate  <-0.7, 0.0, 3.1>
  }
  texture {
    DMFLightOak7
  }
}
#declare WindowCase = difference {
  box { // OuterStone
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone13
    }
    scale <1.25, 0.75, 3.0>
    translate  0.55*z
  }
  box { // Casement
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone13
    }
    scale <1.0, 1.0, 2.5>
    translate  0.55*z
  }
}
union { // TheWindow
  object { TraSwp11 }
  object { TraSwp12 }
  object { TraSwp13 }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale <0.05, 0.1, 0.7>
    rotate <0.0, 90.0, 0.0>
    translate  0.65*z
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak7
    }
    scale <0.05, 0.1, 0.7>
    rotate <0.0, 90.0, 0.0>
    translate  0.55*z
  }
  object { TraSwp14 }
  object { BotFrame }
  object { TopFrame }
  object { LfFrame }
  object { RtFrame }
  object { WindowCase }
  box { // LowerSill
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak9
    }
    scale <1.0, 1.0, 0.1>
    translate  -1.85*z
  }
  box { // Pane0
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass3
    }
    scale <0.7, 0.00001, 1.0>
    translate  -0.45*z
  }
  box { // Pane1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass3
    }
    scale <0.7, 0.00001, 1.05>
    translate  1.7*z
  }
  scale 2.5
  rotate 70.0*z
  translate  <-9.169526, 11.015872, 2.724659>
}




#declare Candle02Drip01 = union {
  cylinder { // Drippy2
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 3.35>
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      T_CandleWax
    }
    scale 0.1
    translate  <0.1, -0.5, 4.35>
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 2.35>
  }
  scale <1.0, 1.0, 0.65>
  translate  <0.3, 0.3, 0.35>
}
#declare Candle02Drip02 = union {
  cylinder { // Drippy3
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 3.35>
  }
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      T_CandleWax
    }
    scale 0.1
    translate  <0.1, -0.5, 4.35>
  }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 2.35>
  }
  translate  0.05*y
}
#declare CandleStick2 = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_CandleWax
    }
    scale <0.5, 0.5, 5.0>
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      T_CandleWax
    }
    scale 0.75
    translate  <0.25, 0.0, 5.05>
  }
}
#declare CSG6 = union {
  object { Candle02Drip01 }
  object { Candle02Drip02 }
  cylinder { // Wick1
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_Wick
    }
    scale <0.05, 0.05, 0.75>
    translate  4.25*z
  }
  object { CandleStick2 }
}
#declare TraSwp8 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <0.5, -0.5>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.5, 0.5>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-0.5, 0.5>,
  <-1.0, 0.5>,
  <-1.0, -0.5>,
  <-0.5, -0.5>
  rotate -x*90
  scale <1.5, 1.5, 0.25>
  translate  -1.75*z
}
#declare TraSwp9 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <0.5, -0.5>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.5, 0.5>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-0.5, 0.5>,
  <-1.0, 0.5>,
  <-1.0, -0.5>,
  <-0.5, -0.5>
  rotate -x*90
  scale <1.25, 1.25, 0.208333>
  translate  -1.5*z
}
#declare TopOfBase2 = lathe {
  linear_spline
  21  // control points
  <0.0, -1.0>,
  <0.278479, -0.998835>,
  <0.338921, -0.917814>,
  <0.293372, -0.834427>,
  <0.26864, -0.73021>,
  <0.269239, -0.597177>,
  <0.630064, -0.5>,
  <0.692589, -0.464726>,
  <0.71864, -0.431878>,
  <0.71864, 0.838674>,
  <0.736054, 0.874903>,
  <0.775407, 0.916387>,
  <0.8196, 0.945006>,
  <0.850717, 0.992242>,
  <0.83977, 1.054675>,
  <0.803107, 1.0877>,
  <0.734369, 1.099144>,
  <0.503131, 1.006348>,
  <0.500636, 0.017756>,
  <0.040685, -0.007955>,
  <0.0, -0.042074>
  rotate <90,0,90>
  translate  -0.15*z
}
#declare TraSwp10 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <0.5, -0.5>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.5, 0.5>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-0.5, 0.5>,
  <-1.0, 0.5>,
  <-1.0, -0.5>,
  <-0.5, -0.5>
  rotate -x*90
  scale <1.0, 1.0, 0.166667>
  translate  -1.3*z
}
#declare CandleHolder1 = union {
  object { TraSwp8 }
  object { TraSwp9 }
  object { TopOfBase2 }
  object { TraSwp10 }
  texture {
    T_New_Brass
  }
}
union { // WholeCandle1
  object { CSG6 }
  object { CandleHolder1 }
  sphere { // Flame1
    <0,0,0>,1
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence .75
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.75 color rgbt <1,1,0,-1>]
        [ 1.0 color rgbt <1, 0, 0,  0> ]
      }
      samples 10
    }
  hollow
    scale <0.1, 0.1, 0.65>
    translate  5.5*z
  }
  scale 0.5
  rotate -85.0*z
  translate  <3.563739, 2.300033, 0.9>
}


lathe {
  linear_spline
  24  // control points
  <0.0, 0.45>,
  <1.894358, 0.45>,
  <1.90436, 0.447436>,
  <1.913007, 0.444754>,
  <1.925028, 0.436072>,
  <1.956078, 0.435869>,
  <1.970401, 0.438298>,
  <1.98012, 0.442141>,
  <2.0, 0.45>,
  <2.406125, 0.54025>,
  <2.4275, 0.545>,
  <2.449522, 0.552389>,
  <2.4625, 0.5625>,
  <2.480255, 0.577652>,
  <2.485406, 0.58875>,
  <2.483757, 0.594745>,
  <2.475, 0.595>,
  <2.428688, 0.585738>,
  <2.021434, 0.504287>,
  <2.007791, 0.50086>,
  <1.999019, 0.502551>,
  <1.993249, 0.501759>,
  <1.991197, 0.500186>,
  <0.0, 0.5>
  rotate <90,0,90>
  texture {
    T_Silver
  }
  scale <0.5, 0.5, 1.0>
  translate  <6.03709, -4.408234, -0.385>
}


#declare TheWine1 = lathe {
  linear_spline
  14  // control points
  <0.000035, 1.927033>,
  <0.89999, 1.92715>,
  <0.89999, 0.79>,
  <0.898559, 0.662073>,
  <0.88138, 0.578526>,
  <0.836988, 0.523163>,
  <0.779712, 0.483547>,
  <0.26999, 0.18>,
  <0.18899, 0.126>,
  <0.137015, 0.074066>,
  <0.112685, 0.019996>,
  <0.082115, -0.04344>,
  <0.046094, -0.075589>,
  <0.0, -0.088179>
  rotate <90,0,90>
  texture {
    T_Wine
  }
  scale 0.999
  translate  <0.0, 0.75, 1.0>
}
#declare Goblet4 = lathe {
  linear_spline
  69  // control points
  <0.0, -0.920417>,
  <0.013419, -0.920093>,
  <0.033051, -0.921911>,
  <0.051533, -0.926339>,
  <0.065338, -0.931448>,
  <0.079675, -0.938189>,
  <0.104085, -0.95166>,
  <0.157457, -0.964669>,
  <0.214591, -0.97944>,
  <0.271074, -0.985459>,
  <0.595454, -1.0>,
  <0.99999, -1.0>,
  <0.98582, -0.959093>,
  <0.958436, -0.93696>,
  <0.913954, -0.91583>,
  <0.864129, -0.91205>,
  <0.58179, -0.843175>,
  <0.324736, -0.76161>,
  <0.267109, -0.743856>,
  <0.221685, -0.702945>,
  <0.202363, -0.654915>,
  <0.19999, -0.595>,
  <0.19999, -0.559175>,
  <0.194112, -0.543907>,
  <0.19999, -0.529826>,
  <0.19999, -0.377402>,
  <0.193032, -0.365504>,
  <0.19999, -0.352993>,
  <0.19999, -0.202213>,
  <0.194112, -0.190144>,
  <0.19999, -0.177303>,
  <0.19999, -0.119>,
  <0.19999, -0.062286>,
  <0.212647, -0.004746>,
  <0.266647, 0.04166>,
  <0.31999, 0.075>,
  <0.82999, 0.39375>,
  <0.900101, 0.438753>,
  <0.935347, 0.470122>,
  <0.978333, 0.516243>,
  <0.994576, 0.575635>,
  <0.99999, 0.645>,
  <0.99999, 0.7>,
  <0.99999, 2.41>,
  <0.999507, 2.4496>,
  <0.998782, 2.475042>,
  <0.995639, 2.489604>,
  <0.988216, 2.495406>,
  <0.975958, 2.499033>,
  <0.96149, 2.5>,
  <0.93944, 2.5>,
  <0.927089, 2.498549>,
  <0.91504, 2.495165>,
  <0.907969, 2.490329>,
  <0.901683, 2.478597>,
  <0.900232, 2.451524>,
  <0.89999, 2.4145>,
  <0.89999, 0.79>,
  <0.898559, 0.662073>,
  <0.88138, 0.578526>,
  <0.836988, 0.523163>,
  <0.779712, 0.483547>,
  <0.26999, 0.18>,
  <0.18899, 0.126>,
  <0.137015, 0.074066>,
  <0.112685, 0.019996>,
  <0.082115, -0.04344>,
  <0.046094, -0.075589>,
  <0.0, -0.088179>
  rotate <90,0,90>
  translate  <0.0, 0.75, 1.0>
}
#declare Top2 = difference {
  object { Goblet4 }
  plane { // CutBottomOff2
    z,0
    scale <2.0, 2.0, 1.0>
    translate  <0.0, 0.65, 1.5>
  }
  texture {
    T_LeadCrystal
  }
}
#declare Goblet5 = lathe {
  linear_spline
  69  // control points
  <0.0, -0.920417>,
  <0.013419, -0.920093>,
  <0.033051, -0.921911>,
  <0.051533, -0.926339>,
  <0.065338, -0.931448>,
  <0.079675, -0.938189>,
  <0.104085, -0.95166>,
  <0.157457, -0.964669>,
  <0.214591, -0.97944>,
  <0.271074, -0.985459>,
  <0.595454, -1.0>,
  <0.99999, -1.0>,
  <0.98582, -0.959093>,
  <0.958436, -0.93696>,
  <0.913954, -0.91583>,
  <0.864129, -0.91205>,
  <0.58179, -0.843175>,
  <0.324736, -0.76161>,
  <0.267109, -0.743856>,
  <0.221685, -0.702945>,
  <0.202363, -0.654915>,
  <0.19999, -0.595>,
  <0.19999, -0.559175>,
  <0.194112, -0.543907>,
  <0.19999, -0.529826>,
  <0.19999, -0.377402>,
  <0.193032, -0.365504>,
  <0.19999, -0.352993>,
  <0.19999, -0.202213>,
  <0.194112, -0.190144>,
  <0.19999, -0.177303>,
  <0.19999, -0.119>,
  <0.19999, -0.062286>,
  <0.212647, -0.004746>,
  <0.266647, 0.04166>,
  <0.31999, 0.075>,
  <0.82999, 0.39375>,
  <0.900101, 0.438753>,
  <0.935347, 0.470122>,
  <0.978333, 0.516243>,
  <0.994576, 0.575635>,
  <0.99999, 0.645>,
  <0.99999, 0.7>,
  <0.99999, 2.41>,
  <0.999507, 2.4496>,
  <0.998782, 2.475042>,
  <0.995639, 2.489604>,
  <0.988216, 2.495406>,
  <0.975958, 2.499033>,
  <0.96149, 2.5>,
  <0.93944, 2.5>,
  <0.927089, 2.498549>,
  <0.91504, 2.495165>,
  <0.907969, 2.490329>,
  <0.901683, 2.478597>,
  <0.900232, 2.451524>,
  <0.89999, 2.4145>,
  <0.89999, 0.79>,
  <0.898559, 0.662073>,
  <0.88138, 0.578526>,
  <0.836988, 0.523163>,
  <0.779712, 0.483547>,
  <0.26999, 0.18>,
  <0.18899, 0.126>,
  <0.137015, 0.074066>,
  <0.112685, 0.019996>,
  <0.082115, -0.04344>,
  <0.046094, -0.075589>,
  <0.0, -0.088179>
  rotate <90,0,90>
  translate  <0.0, 0.75, 1.0>
}
#declare Bottom2 = difference {
  object { Goblet5 }
  plane { // CutTopOff2
    z,0
    scale <2.0, 2.0, 1.0>
    rotate 180.0*x
    translate  <0.0, 0.65, 1.5>
  }
  texture {
    T_BottomGlass
  }
}
#declare WholeGoblet1 = union {
  object { Top2 }
  object { Bottom2 }
}
union { // WineGoblet1
  object { TheWine1 }
  object { WholeGoblet1 }
  scale 0.5
  translate  <7.094714, -2.32695, 0.05>
}


#declare TheWine = lathe {
  linear_spline
  14  // control points
  <0.000035, 1.927033>,
  <0.89999, 1.92715>,
  <0.89999, 0.79>,
  <0.898559, 0.662073>,
  <0.88138, 0.578526>,
  <0.836988, 0.523163>,
  <0.779712, 0.483547>,
  <0.26999, 0.18>,
  <0.18899, 0.126>,
  <0.137015, 0.074066>,
  <0.112685, 0.019996>,
  <0.082115, -0.04344>,
  <0.046094, -0.075589>,
  <0.0, -0.088179>
  rotate <90,0,90>
  texture {
    T_Wine
  }
  hollow
  translate  <0.0, 0.75, 1.0>
}
#declare Goblet2 = lathe {
  linear_spline
  69  // control points
  <0.0, -0.920417>,
  <0.013419, -0.920093>,
  <0.033051, -0.921911>,
  <0.051533, -0.926339>,
  <0.065338, -0.931448>,
  <0.079675, -0.938189>,
  <0.104085, -0.95166>,
  <0.157457, -0.964669>,
  <0.214591, -0.97944>,
  <0.271074, -0.985459>,
  <0.595454, -1.0>,
  <0.99999, -1.0>,
  <0.98582, -0.959093>,
  <0.958436, -0.93696>,
  <0.913954, -0.91583>,
  <0.864129, -0.91205>,
  <0.58179, -0.843175>,
  <0.324736, -0.76161>,
  <0.267109, -0.743856>,
  <0.221685, -0.702945>,
  <0.202363, -0.654915>,
  <0.19999, -0.595>,
  <0.19999, -0.559175>,
  <0.194112, -0.543907>,
  <0.19999, -0.529826>,
  <0.19999, -0.377402>,
  <0.193032, -0.365504>,
  <0.19999, -0.352993>,
  <0.19999, -0.202213>,
  <0.194112, -0.190144>,
  <0.19999, -0.177303>,
  <0.19999, -0.119>,
  <0.19999, -0.062286>,
  <0.212647, -0.004746>,
  <0.266647, 0.04166>,
  <0.31999, 0.075>,
  <0.82999, 0.39375>,
  <0.900101, 0.438753>,
  <0.935347, 0.470122>,
  <0.978333, 0.516243>,
  <0.994576, 0.575635>,
  <0.99999, 0.645>,
  <0.99999, 0.7>,
  <0.99999, 2.41>,
  <0.999507, 2.4496>,
  <0.998782, 2.475042>,
  <0.995639, 2.489604>,
  <0.988216, 2.495406>,
  <0.975958, 2.499033>,
  <0.96149, 2.5>,
  <0.93944, 2.5>,
  <0.927089, 2.498549>,
  <0.91504, 2.495165>,
  <0.907969, 2.490329>,
  <0.901683, 2.478597>,
  <0.900232, 2.451524>,
  <0.89999, 2.4145>,
  <0.89999, 0.79>,
  <0.898559, 0.662073>,
  <0.88138, 0.578526>,
  <0.836988, 0.523163>,
  <0.779712, 0.483547>,
  <0.26999, 0.18>,
  <0.18899, 0.126>,
  <0.137015, 0.074066>,
  <0.112685, 0.019996>,
  <0.082115, -0.04344>,
  <0.046094, -0.075589>,
  <0.0, -0.088179>
  rotate <90,0,90>
  translate  <0.0, 0.75, 1.0>
}
#declare Top1 = difference {
  object { Goblet2 }
  plane { // CutBottomOff1
    z,0
    scale <2.0, 2.0, 1.0>
    translate  <0.0, 0.65, 1.5>
  }
  texture {
    T_LeadCrystal
  }
}
#declare Goblet3 = lathe {
  linear_spline
  69  // control points
  <0.0, -0.920417>,
  <0.013419, -0.920093>,
  <0.033051, -0.921911>,
  <0.051533, -0.926339>,
  <0.065338, -0.931448>,
  <0.079675, -0.938189>,
  <0.104085, -0.95166>,
  <0.157457, -0.964669>,
  <0.214591, -0.97944>,
  <0.271074, -0.985459>,
  <0.595454, -1.0>,
  <0.99999, -1.0>,
  <0.98582, -0.959093>,
  <0.958436, -0.93696>,
  <0.913954, -0.91583>,
  <0.864129, -0.91205>,
  <0.58179, -0.843175>,
  <0.324736, -0.76161>,
  <0.267109, -0.743856>,
  <0.221685, -0.702945>,
  <0.202363, -0.654915>,
  <0.19999, -0.595>,
  <0.19999, -0.559175>,
  <0.194112, -0.543907>,
  <0.19999, -0.529826>,
  <0.19999, -0.377402>,
  <0.193032, -0.365504>,
  <0.19999, -0.352993>,
  <0.19999, -0.202213>,
  <0.194112, -0.190144>,
  <0.19999, -0.177303>,
  <0.19999, -0.119>,
  <0.19999, -0.062286>,
  <0.212647, -0.004746>,
  <0.266647, 0.04166>,
  <0.31999, 0.075>,
  <0.82999, 0.39375>,
  <0.900101, 0.438753>,
  <0.935347, 0.470122>,
  <0.978333, 0.516243>,
  <0.994576, 0.575635>,
  <0.99999, 0.645>,
  <0.99999, 0.7>,
  <0.99999, 2.41>,
  <0.999507, 2.4496>,
  <0.998782, 2.475042>,
  <0.995639, 2.489604>,
  <0.988216, 2.495406>,
  <0.975958, 2.499033>,
  <0.96149, 2.5>,
  <0.93944, 2.5>,
  <0.927089, 2.498549>,
  <0.91504, 2.495165>,
  <0.907969, 2.490329>,
  <0.901683, 2.478597>,
  <0.900232, 2.451524>,
  <0.89999, 2.4145>,
  <0.89999, 0.79>,
  <0.898559, 0.662073>,
  <0.88138, 0.578526>,
  <0.836988, 0.523163>,
  <0.779712, 0.483547>,
  <0.26999, 0.18>,
  <0.18899, 0.126>,
  <0.137015, 0.074066>,
  <0.112685, 0.019996>,
  <0.082115, -0.04344>,
  <0.046094, -0.075589>,
  <0.0, -0.088179>
  rotate <90,0,90>
  translate  <0.0, 0.75, 1.0>
}
#declare Bottom1 = difference {
  object { Goblet3 }
  plane { // CutTopOff1
    z,0
    scale <2.0, 2.0, 1.0>
    rotate 180.0*x
    translate  <0.0, 0.65, 1.5>
  }
  texture {
    T_BottomGlass
  }
}
#declare WholeGoblet = union {
  object { Top1 }
  object { Bottom1 }
}
union { // WineGoblet
  object { TheWine }
  object { WholeGoblet }
  scale 0.5
  translate  <3.25, -6.45, 0.05>
}


#declare Bottle = lathe {
  linear_spline
  60  // control points
  <0.0, -0.9>,
  <0.096128, -0.903751>,
  <0.314072, -0.936135>,
  <0.408678, -0.955886>,
  <0.486034, -0.993483>,
  <0.523567, -1.0>,
  <0.698239, -1.0>,
  <0.724904, -0.993984>,
  <0.729064, -0.957891>,
  <0.729064, 0.759379>,
  <0.712488, 0.89658>,
  <0.69315, 0.972374>,
  <0.635251, 1.034475>,
  <0.558014, 1.08>,
  <0.501955, 1.164>,
  <0.444321, 1.213813>,
  <0.401306, 1.28>,
  <0.370963, 1.392703>,
  <0.281733, 1.843513>,
  <0.257933, 2.060137>,
  <0.239979, 2.491964>,
  <0.239979, 2.804505>,
  <0.25444, 2.804554>,
  <0.256609, 2.804692>,
  <0.258695, 2.805222>,
  <0.259081, 2.807202>,
  <0.259251, 2.809435>,
  <0.259173, 2.886851>,
  <0.258917, 2.888727>,
  <0.258622, 2.890703>,
  <0.257112, 2.891515>,
  <0.255208, 2.891692>,
  <0.239979, 2.891624>,
  <0.239979, 2.974311>,
  <0.236172, 2.994622>,
  <0.219999, 2.999737>,
  <0.163912, 2.999955>,
  <0.141674, 2.998731>,
  <0.140405, 2.976842>,
  <0.140405, 2.479971>,
  <0.157203, 2.185695>,
  <0.1824, 1.868485>,
  <0.199198, 1.75>,
  <0.216859, 1.647842>,
  <0.247119, 1.495291>,
  <0.283655, 1.335378>,
  <0.350447, 1.150484>,
  <0.480316, 1.061851>,
  <0.548079, 0.973367>,
  <0.627044, 0.884861>,
  <0.645333, 0.760172>,
  <0.645159, 0.633861>,
  <0.641844, -0.648992>,
  <0.642439, -0.81772>,
  <0.630471, -0.87202>,
  <0.582218, -0.880423>,
  <0.486929, -0.870119>,
  <0.376187, -0.826095>,
  <0.087433, -0.771462>,
  <0.0, -0.763277>
  rotate <90,0,90>
  texture {
    T_WineBottleGlass
  }
  scale 1.37174
}
#declare BottleWine = lathe {
  linear_spline
  15  // control points
  <0.0, 1.1366>,
  <0.346347, 1.137025>,
  <0.474697, 1.049429>,
  <0.541667, 0.96198>,
  <0.619709, 0.874509>,
  <0.637784, 0.75128>,
  <0.637611, 0.626446>,
  <0.634336, -0.6414>,
  <0.634923, -0.808154>,
  <0.623095, -0.861818>,
  <0.575407, -0.870124>,
  <0.481233, -0.85994>,
  <0.371787, -0.816431>,
  <0.08641, -0.762437>,
  <0.0, -0.754348>
  rotate <90,0,90>
  texture {
    T_Wine
  }
  hollow
  scale 1.36
}
#declare Cork = lathe {
  linear_spline
  21  // control points
  <0.0, 3.2>,
  <0.016898, 3.218746>,
  <0.015091, 3.298587>,
  <0.018888, 3.311836>,
  <0.01665, 3.321732>,
  <0.027154, 3.32441>,
  <0.151715, 3.324357>,
  <0.158415, 3.323735>,
  <0.161179, 3.322388>,
  <0.16298, 3.319112>,
  <0.163905, 3.312073>,
  <0.163774, 3.07873>,
  <0.154096, 3.020537>,
  <0.141357, 2.993259>,
  <0.140405, 2.976842>,
  <0.133886, 2.713842>,
  <0.133697, 2.706229>,
  <0.132718, 2.701484>,
  <0.130204, 2.700165>,
  <0.126866, 2.7>,
  <0.0, 2.7>
  rotate <90,0,90>
  texture {
    T_Cork
  }
  scale 1.37174
}
union { // WineBottle
  object { Bottle }
  object { BottleWine }
  cylinder { // Label
    <0,0,1>, <0,0,0>, 1 open
    texture {
      T_BottleLabel
      rotate 70.0*z
    }
    hollow
    scale <1.001, 1.001, 1.0>
    translate  -0.5*z
  }
  object { Cork }
  scale 0.75
  translate  <4.69356, -1.082435, 1.05>
}


lathe {
  linear_spline
  24  // control points
  <0.0, 0.45>,
  <1.894358, 0.45>,
  <1.90436, 0.447436>,
  <1.913007, 0.444754>,
  <1.925028, 0.436072>,
  <1.956078, 0.435869>,
  <1.970401, 0.438298>,
  <1.98012, 0.442141>,
  <2.0, 0.45>,
  <2.406125, 0.54025>,
  <2.4275, 0.545>,
  <2.449522, 0.552389>,
  <2.4625, 0.5625>,
  <2.480255, 0.577652>,
  <2.485406, 0.58875>,
  <2.483757, 0.594745>,
  <2.475, 0.595>,
  <2.428688, 0.585738>,
  <2.021434, 0.504287>,
  <2.007791, 0.50086>,
  <1.999019, 0.502551>,
  <1.993249, 0.501759>,
  <1.991197, 0.500186>,
  <0.0, 0.5>
  rotate <90,0,90>
  texture {
    T_Silver
  }
  scale <0.6, 0.6, 1.0>
  translate  <1.782122, -1.690849, -0.385>
}


#declare Candle01Drip01 = union {
  cylinder { // Drippy
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 3.35>
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      T_CandleWax
    }
    scale 0.1
    translate  <0.1, -0.5, 4.35>
  }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 2.35>
  }
  scale <1.0, 1.0, 0.65>
  translate  <0.3, 0.3, 0.35>
}
#declare CSG002 = union {
  cylinder { // Drippy1
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 3.35>
  }
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      T_CandleWax
    }
    scale 0.1
    translate  <0.1, -0.5, 4.35>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      T_CandleWax
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.1, -0.5, 2.35>
  }
  translate  0.05*y
}
#declare Candle01Drip02 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_CandleWax
    }
    scale <0.5, 0.5, 5.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      T_CandleWax
    }
    scale 0.75
    translate  <0.25, 0.0, 5.05>
  }
}
#declare CSG003 = union {
  object { Candle01Drip01 }
  object { CSG002 }
  cylinder { // Wick
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_Wick
    }
    scale <0.05, 0.05, 0.75>
    translate  4.25*z
  }
  object { Candle01Drip02 }
}
#declare TraSwp5 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <0.5, -0.5>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.5, 0.5>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-0.5, 0.5>,
  <-1.0, 0.5>,
  <-1.0, -0.5>,
  <-0.5, -0.5>
  rotate -x*90
  scale <1.5, 1.5, 0.25>
  translate  -1.75*z
}
#declare TraSwp6 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <0.5, -0.5>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.5, 0.5>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-0.5, 0.5>,
  <-1.0, 0.5>,
  <-1.0, -0.5>,
  <-0.5, -0.5>
  rotate -x*90
  scale <1.25, 1.25, 0.208333>
  translate  -1.5*z
}
#declare TopOfHolder = lathe {
  linear_spline
  21  // control points
  <0.0, -1.0>,
  <0.278479, -0.998835>,
  <0.338921, -0.917814>,
  <0.293372, -0.834427>,
  <0.26864, -0.73021>,
  <0.269239, -0.597177>,
  <0.630064, -0.5>,
  <0.692589, -0.464726>,
  <0.71864, -0.431878>,
  <0.71864, 0.838674>,
  <0.736054, 0.874903>,
  <0.775407, 0.916387>,
  <0.8196, 0.945006>,
  <0.850717, 0.992242>,
  <0.83977, 1.054675>,
  <0.803107, 1.0877>,
  <0.734369, 1.099144>,
  <0.503131, 1.006348>,
  <0.500636, 0.017756>,
  <0.040685, -0.007955>,
  <0.0, -0.042074>
  rotate <90,0,90>
  translate  -0.15*z
}
#declare TraSwp7 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <0.5, -0.5>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.5, 0.5>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-0.5, 0.5>,
  <-1.0, 0.5>,
  <-1.0, -0.5>,
  <-0.5, -0.5>
  rotate -x*90
  scale <1.0, 1.0, 0.166667>
  translate  -1.3*z
}
#declare CandleHolder = union {
  object { TraSwp5 }
  object { TraSwp6 }
  object { TopOfHolder }
  object { TraSwp7 }
  texture {
    T_New_Brass
  }
}
union { // WholeCandle
  object { CSG003 }
  object { CandleHolder }
  sphere { // Flame
    <0,0,0>,1
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence .75
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.75 color rgbt <1,1,0,-1>]
        [ 1.0 color rgbt <1, 0, 0,  0> ]
      }
      samples 10
    }
  hollow
    scale <0.1, 0.1, 0.65>
    translate  5.5*z
  }
  scale 0.5
  rotate -55.0*z
  translate  <1.742287, -4.961093, 0.9>
}


#declare CSG2 = difference {
  torus { // Torus2
    1.0625, 0.0625  rotate -x*90
    scale <0.15, 0.25, 0.95>
    rotate <0.0, 90.0, 0.0>
    translate  <2.0, -0.25, -0.15>
  }
  plane { // Plane2
    z,0
    rotate <-90.0, 0.0, 0.0>
    translate  <1.4, -0.25, -0.15>
  }
  texture {
    T_Frame
  }
}
#declare RightNosePad = union {
  superellipsoid { // Nosepad1
    <0.1, 1.0>
    texture {
      T_NosePad
    }
    scale <0.5, 0.2, 0.05>
    rotate <88.827118, 8.027948, 74.94606>
    translate  <2.1, -0.3, -0.25>
  }
  object { CSG2 }
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      T_EarPieces
    }
    scale 0.075
    translate  <2.0, -0.25, -0.35>
  }
  translate  -1.0*x
}
#declare CSG001 = difference {
  torus { // Torus001
    1.0625, 0.0625  rotate -x*90
    scale <0.15, 0.25, 0.95>
    rotate <0.0, 90.0, 0.0>
    translate  <2.0, -0.25, -0.15>
  }
  plane { // Plane001
    z,0
    rotate <-90.0, 0.0, 0.0>
    translate  <1.4, -0.25, -0.15>
  }
  texture {
    T_Frame
  }
}
#declare LeftNosePad = union {
  superellipsoid { // Nosepad
    <0.1, 1.0>
    texture {
      T_NosePad
    }
    scale <0.5, 0.2, 0.05>
    rotate <91.049751, 9.908378, 100.127586>
    translate  <1.9, -0.3, -0.25>
  }
  object { CSG001 }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      T_EarPieces
    }
    scale 0.075
    translate  <2.0, -0.25, -0.35>
  }
  translate  0.05*x
}
#declare CurvedBar = difference {
  torus { // CurvedBarTorus
    1.0625, 0.0625  rotate -x*90
    scale <1.25, 0.7, 1.0>
    translate  <1.5, 0.45, 0.0>
  }
  plane { // CurvedBarCut
    z,0
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  <1.55, 0.85, 4.35>
  }
}
#declare FrontFrame = union {
  torus { // RightFrame
    1.0625, 0.0625  rotate -x*90
    scale <1.25, 1.0, 1.0>
    translate  -0.35*x
  }
  torus { // LeftFrame
    1.0625, 0.0625  rotate -x*90
    scale <1.25, 1.0, 1.0>
    translate  3.4*x
  }
  superellipsoid { // StraightBar
    <0.1, 0.1>
    scale <0.8, 0.1, 0.05>
    translate  <1.525, 0.6, 0.0>
  }
  object { CurvedBar }
  texture {
    T_Frame
  }
}
#declare TempleCut = difference {
  superellipsoid { // Temple
    <0.1, 0.1>
    texture {
      T_Frame
    }
    scale <0.1, 0.125, 0.25>
    rotate -2.0*x
    translate  <4.85, -0.00698, -0.199878>
  }
  superellipsoid { // SuprQ001
    <0.1, 0.1>
    texture {
      T_EarPieces
    }
    scale <-0.025, -0.025, -4.05>
    rotate <2.0, 0.0, -180.0>
    translate  <4.95, -0.025, -0.75>
  }
  rotate 2.0*x
}
#declare TempleCut2 = difference {
  superellipsoid { // Temple1
    <0.1, 0.1>
    texture {
      T_Temples
    }
    scale <0.1, 0.125, 2.0>
    rotate -2.0*x
    translate  <4.85, -0.085504, -2.448508>
  }
  superellipsoid { // SuprQ2
    <0.1, 0.1>
    texture {
      T_EarPieces
    }
    scale <-0.025, -0.025, -4.05>
    rotate <2.0, 0.0, 180.0>
    translate  <4.95, -0.025, -0.75>
  }
}
#declare CSG4 = difference {
  torus { // Torus002
    1.0625, 0.0625  rotate -x*90
    rotate <0.0, 90.0, 0.0>
    translate  <4.85, -1.0, -4.25>
  }
  plane { // Plane002
    z,0
    scale <2.0, 2.0, 1.0>
    rotate -160.0*x
    translate  <4.95, -0.9, -4.5>
  }
  texture {
    T_EarPieces
  }
  rotate -2.0*x
  translate  <0.0, -0.056949, -0.198133>
}
#declare BendyPart = union {
  object { TempleCut2 }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      T_EarPieces
    }
    scale 0.075
    rotate -2.0*x
    translate  <4.85, -2.075085, -4.980615>
  }
  object { CSG4 }
  rotate 2.0*x
}
#declare CSG004 = union {
  object { TempleCut }
  object { BendyPart }
  rotate -2.0*x
}
#declare TempleCut1 = difference {
  superellipsoid { // Temple2
    <0.1, 0.1>
    texture {
      T_Frame
    }
    scale <0.1, 0.125, 0.25>
    rotate -2.0*x
    translate  <4.85, -0.00698, -0.199878>
  }
  superellipsoid { // SuprQ3
    <0.1, 0.1>
    texture {
      T_EarPieces
    }
    scale <-0.025, -0.025, -4.05>
    rotate <2.0, 0.0, -180.0>
    translate  <4.75, -0.05, -0.75>
  }
  rotate 2.0*x
}
#declare TempleCut3 = difference {
  superellipsoid { // Temple3
    <0.1, 0.1>
    texture {
      T_Temples
    }
    scale <0.1, 0.125, 2.0>
    rotate -2.0*x
    translate  <4.85, -0.1, -2.425>
  }
  superellipsoid { // SuprQ4
    <0.1, 0.1>
    texture {
      T_EarPieces
    }
    scale <-0.025, -0.025, -4.05>
    rotate <2.0, 0.0, 180.0>
    translate  <4.75, -0.05, -0.75>
  }
}
#declare CSG5 = difference {
  torus { // Torus3
    1.0625, 0.0625  rotate -x*90
    rotate <0.0, 90.0, 0.0>
    translate  <4.85, -1.0, -4.25>
  }
  plane { // Plane3
    z,0
    scale <2.0, 2.0, 1.0>
    rotate -160.0*x
    translate  <4.95, -0.9, -4.5>
  }
  texture {
    T_EarPieces
  }
  rotate -2.0*x
  translate  <0.0, -0.056949, -0.198133>
}
#declare BendyPart1 = union {
  object { TempleCut3 }
  sphere { // Sphere8
    <0,0,0>,1
    texture {
      T_EarPieces
    }
    scale 0.075
    rotate -2.0*x
    translate  <4.85, -2.075085, -4.980615>
  }
  object { CSG5 }
  rotate <2.007633, -4.996946, -0.174941>
  translate  <-0.05, 0.025, -0.45>
}
#declare CSG7 = union {
  object { TempleCut1 }
  object { BendyPart1 }
  rotate -2.0*x
  translate  -6.65*x
}
union { // Glasses
  object { RightNosePad }
  object { LeftNosePad }
  sphere { // LeftLense
    <0,0,0>,1
    texture {
      T_Lenses
    }
    scale <1.25, 1.0, 0.1>
    translate  3.4*x
  }
  sphere { // RightLense
    <0,0,0>,1
    texture {
      T_Lenses
    }
    scale <1.25, 1.0, 0.1>
    translate  -0.35*x
  }
  object { FrontFrame }
  object { CSG004 }
  object { CSG7 }
  scale 0.25
  rotate <-75.0, 0.0, -115.0>
  translate  <4.95, -6.4, 0.325>
}


#declare legs = union {
  cylinder { // R_rear_leg
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
  }
  cylinder { // r_front_leg
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    translate  16.5*x
  }
  cylinder { // L_front_leg
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    translate  <16.5, 13.0, 0.0>
  }
  cylinder { // L_rear_leg
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    translate  13.0*y
  }
  scale <1.0, 1.0, 20.0>
}
#declare chairseat = difference {
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood3
    }
    scale <9.650387, 8.016424, 1.0>
    translate  <8.265924, 6.531627, 19.818807>
  }
  sphere { // Sphere9
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <7.253192, 3.402885, 0.878388>
    translate  <8.000879, 8.938731, 21.038833>
  }
  sphere { // Sphere10
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <7.253192, 3.402885, 0.878388>
    translate  <7.904764, 3.844616, 21.038833>
  }
  texture {
    DMFWood3
  }
  scale <1.166464, 1.0, 0.7>
  translate  <-0.724794, 0.319788, 6.311999>
}
#declare THE_SEAT = intersection {
  object { chairseat }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <14.602002, 10.148242, 3.174017>
    translate  <7.925238, 6.62044, 19.566157>
  }
  texture {
    DMFWood3
  }
}
#declare TOP_BACK = difference {
  box { // BACK_TOP
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood3
    }
    scale <2.505237, 11.700673, 4.963929>
    translate  <0.466587, 7.445879, 48.176188>
  }
  sphere { // BACKOTHCURV
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <5.263309, 17.830807, 9.25572>
    rotate -270.0*y
    translate  <0.067947, 7.170717, 54.863726>
  }
  cylinder { // BACK_HOLE
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <1.562738, 4.28119, 7.181862>
    rotate -90.0*y
    translate  <4.385654, 6.925283, 46.822499>
  }
  sphere { // BACKTOPCURV
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <5.263309, 17.830807, 9.25572>
    translate  <6.717791, 6.618306, 48.322333>
  }
  torus { // BACKBKCUT
    1.5, 0.5  rotate -x*90
    texture {
      DMFWood3
    }
    scale <2.811993, 12.133492, 10.874012>
    translate  <2.367013, 6.052093, 46.951935>
  }
  scale 0.9
  translate  <-0.805357, 0.0, 5.190077>
}
#declare THE_BACK = merge {
  object { TOP_BACK }
  cylinder { // backrail
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.767, 0.823, 24.65942>
    rotate 3.5*x
    translate  <1.0, 0.0, 19.822715>
  }
  cylinder { // backrail1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate 2.5*x
    translate  <0.6, 2.0, 19.822715>
  }
  cylinder { // backrail2
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate 1.5*x
    translate  <0.2, 4.0, 19.822715>
  }
  cylinder { // backrail3
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate 0.5*x
    translate  <-0.2, 6.0, 19.822715>
  }
  cylinder { // backrail4
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate -0.5*x
    translate  <-0.2, 8.0, 19.822715>
  }
  cylinder { // backrail5
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate -1.5*x
    translate  <0.2, 10.0, 19.822715>
  }
  cylinder { // backrail6
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.56711, 0.423308, 24.65942>
    rotate -2.5*x
    translate  <0.6, 12.0, 19.822715>
  }
  cylinder { // backrail7
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.767, 0.823, 24.65942>
    rotate -3.5*x
    translate  <1.0, 14.0, 19.822715>
  }
  scale <1.0, 1.0, 0.75>
  rotate -2.525529*y
  translate  <0.0, 0.0, 5.642293>
}
union { // the_chair
  object { legs }
  object { THE_SEAT }
  object { THE_BACK }
  cylinder { // rear_crossbar
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 13.0>
    rotate <0.0, -90.0, -90.0>
    translate  <-0.120131, -0.108774, 5.623311>
  }
  cylinder { // right_crossbar
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 15.5>
    rotate -90.0*y
    translate  <15.931139, 0.0, 7.904764>
  }
  cylinder { // L_crossbar
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 15.5>
    rotate -90.0*y
    translate  <15.931139, 13.071693, 7.904764>
  }
  cylinder { // front_crossbar
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.38702, 0.38702, 13.0>
    rotate <0.0, -90.0, -90.0>
    translate  <16.507831, 0.083457, 5.623311>
  }
  scale 0.2
  rotate -80.0*z
  translate  <-2.0, 13.0, -6.8>
}


//
// Include file contains 'RotSwp5'
//
#include "scene7.in5"
#declare RotSwp5 = object {
  RotSwp5_Raw
  texture {
    DMFLightOak1
  }
  scale 0.2
  rotate <180.0, 0.0, 180.0>
  translate  <7.85, -8.0, -0.15>
}
//
// Include file contains 'RotSwp4'
//
#include "scene7.in6"
#declare RotSwp4 = object {
  RotSwp4_Raw
  texture {
    DMFLightOak1
  }
  scale 0.2
  rotate <180.0, 0.0, 180.0>
  translate  <-0.5, -8.0, -0.15>
}
//
// Include file contains 'RotSwp3'
//
#include "scene7.in7"
#declare RotSwp3 = object {
  RotSwp3_Raw
  texture {
    DMFLightOak1
  }
  scale 0.2
  rotate <180.0, 0.0, 180.0>
  translate  <-0.5, 8.0, -0.15>
}
//
// Include file contains 'RotSwp2'
//
#include "scene7.in8"
#declare RotSwp2 = object {
  RotSwp2_Raw
  texture {
    DMFLightOak1
  }
  scale 0.2
  rotate <180.0, 0.0, 180.0>
  translate  <7.85, 8.0, -0.15>
}
#declare TraSwp4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -1.0>,
  <-0.25, -1.0>,
  <0.5, -0.25>,
  <0.5, 0.5>,
  <-0.25, 0.5>,
  <-0.75, 0.75>,
  <-1.0, 0.5>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    DMFLightOak3
  }
  scale <0.2, 0.2, 8.35>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.5, -8.2, -0.15>
}
#declare TraSwp3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -1.0>,
  <-0.25, -1.0>,
  <0.5, -0.25>,
  <0.5, 0.5>,
  <-0.25, 0.5>,
  <-0.75, 0.75>,
  <-1.0, 0.5>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    DMFLightOak2
  }
  scale <0.2, 0.2, 8.35>
  rotate <-90.0, 0.0, 90.0>
  translate  <7.85, 8.2, -0.15>
}
#declare TraSwp2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -1.0>,
  <-0.25, -1.0>,
  <0.5, -0.25>,
  <0.5, 0.5>,
  <-0.25, 0.5>,
  <-0.75, 0.75>,
  <-1.0, 0.5>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    DMFLightOak4
  }
  scale <0.2, 0.2, 16.0>
  rotate <-90.0, 0.0, 0.0>
  translate  <8.05, -8.0, -0.15>
}
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -1.0>,
  <-0.25, -1.0>,
  <0.5, -0.25>,
  <0.5, 0.5>,
  <-0.25, 0.5>,
  <-0.75, 0.75>,
  <-1.0, 0.5>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    DMFLightOak5
  }
  scale <0.2, 0.2, 16.0>
  rotate <-90.0, 0.0, 180.0>
  translate  <-0.7, 8.0, -0.15>
}
#declare Edges = union {
  object { RotSwp5 }
  object { RotSwp4 }
  object { RotSwp3 }
  object { RotSwp2 }
  object { TraSwp4 }
  object { TraSwp3 }
  object { TraSwp2 }
  object { TraSwp001 }
}
#declare TableBase = union {
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 7.5, -0.15>
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 6.5, -0.15>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -7.5, -0.15>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -6.5, -0.15>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -5.5, -0.15>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -4.5, -0.15>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -3.5, -0.15>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -2.5, -0.15>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -1.5, -0.15>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, -0.5, -0.15>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 0.5, -0.15>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 1.5, -0.15>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 2.5, -0.15>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 3.5, -0.15>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 4.5, -0.15>
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <4.175, 0.5, 0.1>
    translate  <3.65, 5.5, -0.15>
  }
  texture {
    DMFDarkOak1
  }
}
union { // WholeTable
  object { Edges }
  box { // SupPt2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak1
    }
    scale <4.175, 0.5, 0.25>
    translate  <3.65, -5.0, -0.5>
  }
  box { // SupPt1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak1
    }
    scale <4.175, 0.5, 0.25>
    translate  <3.65, 5.0, -0.5>
  }
  object { TableBase }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak8
    }
    scale <0.5, 8.0, 0.05>
    translate  7.35*x
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak7
    }
    scale <0.5, 8.0, 0.05>
    translate  6.3*x
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak6
    }
    scale <0.5, 8.0, 0.05>
    translate  5.25*x
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak5
    }
    scale <0.5, 8.0, 0.05>
    translate  4.2*x
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak4
    }
    scale <0.5, 8.0, 0.05>
    translate  3.15*x
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak3
    }
    scale <0.5, 8.0, 0.05>
    translate  2.1*x
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak2
    }
    scale <0.5, 8.0, 0.05>
    translate  1.05*x
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak1
    }
    scale <0.5, 8.0, 0.05>
  }
  box { // Leg2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak1
    }
    scale <0.3, 0.3, 3.0>
    translate  <6.9, -5.0, -3.75>
  }
  box { // Leg3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak2
    }
    scale <0.3, 0.3, 3.0>
    translate  <0.3, 5.0, -3.75>
  }
  box { // Leg4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak3
    }
    scale <0.3, 0.3, 3.0>
    translate  <6.9, 4.95, -3.75>
  }
  box { // Angled
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak4
    }
    scale <0.424, 0.3, 0.424>
    rotate 45.0*y
    translate  <0.1, -5.0, -0.75>
  }
  box { // Angled1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak5
    }
    scale <0.424, 0.3, 0.424>
    rotate 45.0*y
    translate  <7.2, -5.0, -0.75>
  }
  box { // Angled2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak6
    }
    scale <0.424, 0.3, 0.424>
    rotate 45.0*y
    translate  <0.1, 5.0, -0.75>
  }
  box { // Angled3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak7
    }
    scale <0.424, 0.3, 0.424>
    rotate 45.0*y
    translate  <7.2, 5.0, -0.75>
  }
  box { // Leg1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak8
    }
    scale <0.3, 0.3, 3.0>
    translate  <0.3, -5.0, -3.75>
  }
}


