// Persistence of Vision Raytracer
// Chope de bire.

/******************************************************************************

        Textures pour la chope

******************************************************************************/

#declare Tex_Fut=texture{
   pigment {
      color red 1.0 green 1.0 blue 1.0  filter 0.9
      }
   finish {
      specular 10.0
      roughness 0.001
      ambient 0.0
      diffuse 0.0
      reflection 0.1
      refraction 1.0
      ior 1.5
      caustics 2.0
      }
   }

#declare Couleur_Mousse = color red 1 green 0.93 blue 0.86

#declare Tex_mousseH=texture{
   pigment {
      bozo
      color_map {
         [0.00 0.25 color Clear color Clear]
         [0.25 0.35 color Clear color Clear filter 0.85]
         [0.35 0.45 color Clear filter 0.7 color Clear]
         [0.45 0.60 color Clear color Clear]
         [0.60 0.80 color Clear color Couleur_Mousse]
         [0.80 1.00 color Couleur_Mousse color Clear]
         }
      }
   finish {
      specular 10
      roughness 0.001
      ambient 0.90
      diffuse 0
      reflection 0.1
      }
   scale <1, 1, 1>
   translate <0, -0.5, 0>
   }

/******************************************************************************

        Choppe de bire relativement complique

******************************************************************************/

#declare Un_Trou = object { Ellipsoid scale <0.8, 2, 8>}

#declare Colonne_Trous = union {
      object {Un_Trou translate <20, 0, 0>}
      object {Un_Trou translate <20, 0, 0> rotate <0, 0, -10>}
      object {Un_Trou translate <20, 0, 0> rotate <0, 0, 10>}
      object {Un_Trou translate <20, 0, 0> rotate <0, 0, 20>}
      object {Un_Trou translate <20, 0, 0> rotate <0, 0, -20>}
      rotate 170*y
      }

#declare Trous = union {
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 40, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 60, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 80, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 100, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 120, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 140, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 160, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 180, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 200, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 220, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 240, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 260, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 280, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 300, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 320, 0>}
      object {Colonne_Trous scale <0.375, 1, 0.375> rotate <0, 340, 0>}
   }

/*
   Torus specs:
      Major radius: 5 Minor radius: 1
      Outer radius: 6 Inner radius: 4
*/
#declare a9=48      //2(R2-r2)
#declare a25=-52   //-2(R2+r2)
#declare a34=576   //(R2-r2)2
#declare Torus =
quartic {
   <    1.000000, 0.000000, 0.000000, 0.000000, 2.000000,
   0.000000, 0.000000, 2.000000, 0.000000, a25,
   0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
   0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
   1.000000, 0.000000, 0.000000, 2.000000, 0.000000,
   a9,       0.000000, 0.000000, 0.000000, 0.000000,
   1.000000, 0.000000, a25, 0.000000, a34 > //sturm
}

#declare Anse = object {
   Torus
   scale <1, 1, 0.6>
   rotate <90, 0, 0>
    rotate <0, 0, 90>
   rotate <0, 0, 15>
   scale <1, 1.2, 1>
   translate <-7, 0, 0>
   }

#declare Fut=object {
   merge {
      difference {
         object {Anse }
         object {Ellipsoid scale <7.5, 20, 7.5>}
         }
      torus{6.257, 0.239 translate 10*y}
      difference {
         intersection {
            object { Ellipsoid scale <7.5, 20, 7.5>}
            plane {<0, 1, 0>, 10}
            plane {<0, -1, 0>, 10}
            }
         intersection {
            object { Ellipsoid scale <7.01, 19.5, 7.01>}
            plane {<0, -1, 0>, -7.01 }
            }
         object { Trous }
         }
      }
   texture {Tex_Fut}
   //texture {pigment {color Red}}
   bounded_by {
      box { <-13, -10, -7.5>, <7.5, 10.5, 7.5> }
      }
rotate <0, 180, 0>
   }

/******************************************************************************

        Contenu de la choppe: bire et mousse

******************************************************************************/

#declare Biere = object {
   intersection {
      object { Ellipsoid scale <6.99, 19.49, 6.99>}
      plane {<0, -1, 0>, 9.5 }
      plane {<0, 1, 0>, 4}
      }
   texture {
      pigment {
         color OrangeRed filter 0.7
         }
      finish {
         specular 1.0
         roughness 0.001
         ambient 0.0
         diffuse 0.0
         reflection 0.1
         refraction 1.0
         ior 1.33
         caustics 2.0
         }
      }
   bounded_by {
      box { <-7.5, -9.5, -7.5>, <7.5, 7, 7.5> }
      }
   }

#declare Mousse_Bas = object {
   difference {
      intersection {
         object { Ellipsoid scale <7.0, 19.5, 7.0>}
         plane {<0, -1, 0>, -4 }
         plane {<0, 1, 0>, 7 }
         }
      object {Ellipsoid scale <6, 0.5, 6> translate <0, 7, 0>}
      }
   texture {
      normal {dents 1.0}
      pigment {color Couleur_Mousse}
      finish {
         specular 0.3
         roughness 0.001
         ambient 0.4
         diffuse 0.4
         reflection 0.1
         }
      scale <0.15, 0.15, 0.15>
      }
   bounded_by {
      box { <-7.5, 3.99, -7.5>, <7.5, 7.01, 7.5> }
      }
   }

#declare Mousse_Haut = object {
   intersection {
      difference {
         object { Ellipsoid scale <7.0, 19.5, 7.0>}
         object { Ellipsoid scale <6.99, 19.5, 6.99>}
      }
      union {
         intersection {
            plane {<0, -1, 0>, -7 }
            plane {<0, 1, 0>, 7.5 }
            }
         blob {
            threshold 0.6
            sphere { < 0.75, 0,   0>, 1.5, 1.5 }
            sphere { <-0.375, 0,  0.65>, 1, 1.3 }
            sphere { <-0.375, 0, -0.65>, 0.7, 2 }
            scale <7, 2.5, 7>
            rotate 180*y
            translate 7.5*y
         }
      }
   }
   texture {Tex_mousseH}
   bounded_by {
      box { <-8, 6.99, -8>, <8, 9.01, 8> }
      }
   }

#declare Mousse=union {
   object {Mousse_Bas}
   object {Mousse_Haut}
}

#declare Goutte=object {
   blob {
      threshold 0.6
      sphere { < 0.75, 0,   0>, 1.5, 1.5 }
      sphere { <-0.375, 0,  0.65>, 1, 1.3 }
      sphere { <-0.375, 0, -0.65>, 0.7, 2 }
      scale <5, .1, 3>
      rotate 45*y
      }
   texture {Tex_mousseH}
   }

#declare Chope = union {
   object {Fut}
   object {Mousse}
   object {Biere}
   }
