//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 18 textures and 43 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/16/1997    (16.02.1997)
//

global_settings
{
  #max_trace_level 10
  adc_bailout 6/255
};
//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera StdCam
  location  <-0.100, -28.800, 8.300>
  direction <0.0,     0.0,  2.1695>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, -0.400, 2.300>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <-16.700, 0.000, 12.900> // Attached to SpotL001
  direction <0.0,     0.0,  0.7250>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-15.862, 0.208, 12.396> // Following SpotL001
}

*/

// *******  L I G H T S *******
light_source { // AreaL002
  <-18.000, -24.600, 18.200>
  color  rgb<0.588, 0.588, 0.588>
  area_light <0.985, 0.352, 1.705>, <-1.174, 1.581, 0.352>, 3, 3
  adaptive 1
  jitter
}


light_source { // AreaL001
  <24.800, -25.000, 22.500>
  color  rgb<0.722, 0.722, 0.722>
  area_light <1.550, 0.964, -0.816>, <-0.816, 1.751, 0.518>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Spotlight SpotL001
  <-16.700, 0.000, 12.900>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-15.862, 0.208, 12.396>
    falloff   34.6  // outer radius (in deg)
      radius    17.7  // inner radius
}


// ********  TEXTURES  *******
//

#include "bottle.inc"



// ********  REFERENCED OBJECTS  *******

#include "bottle2.inc"

#declare BottleBody_Ref = object {
  Object1  scale <0.3, 0.3, 0.2>
  rotate -90.0*z
  translate  <-0.3, 0.0, 4.7>
  texture {
    Glass1
  }
}


#declare Cork_Ref = object {
  Object2
  scale <0.3, 0.3, 0.2>
  rotate -90.0*z
  translate  <-0.3, 0.0, 4.7>
  texture {
    Cork1
  }
}



// ********  OBJECTS  *******

#include "wetpatch.inc"

object {
  Object1
  scale <0.720505, 1.147003, 1.0>
  translate  <-6.278711, 6.569598, 0.023173>
  texture {
    Wetness
  }
}


#include "ship.inc"

#declare LeftTopRig_Ref = object {
  Object1
  texture {
    DMFDarkOak2
  }
}
#declare RightTopRig_Ref = object {
  Object2
  texture {
    DMFDarkOak2
  }
}
#declare RightBotRig_Ref = object {
  Object3
  texture {
    DMFDarkOak2
  }
}
#declare LeftBotRig_Ref = object {
  Object4
  texture {
    DMFDarkOak2
  }
}
#declare LeftSideRail_Ref = object {
  Object5
  texture {
    Yellow_Pine1
  }
}
#declare CrossBrace_Ref = object {
  Object6
  texture {
    Tan_Wood1
  }
}
#declare RightHull_Ref = object {
  Object7
  texture {
    Tan_Wood1
  }
}
#declare RightRailThing_Ref = object {
  Object8
  texture {
    Yellow_Pine1
  }
}
#declare MainBeam_Ref = object {
  Object9
  texture {
    Tan_Wood1
  }
}
#declare Sail_Ref = object {
  Object10
  texture {
    SailTx
  }
}
#declare LeftHull_Ref = object {
  Object11
  texture {
    Tan_Wood1
  }
}
#declare CenterBeam_Ref = object {
  Object12
  texture {
    Yellow_Pine1
  }
}
union { // ship_obj
  object { LeftTopRig_Ref }
  object { RightTopRig_Ref }
  object { RightBotRig_Ref }
  object { LeftBotRig_Ref }
  object { LeftSideRail_Ref }
  object { CrossBrace_Ref }
  object { RightHull_Ref }
  object { RightRailThing_Ref }
  object { MainBeam_Ref }
  object { Sail_Ref }
  object { LeftHull_Ref }
  object { CenterBeam_Ref }
  scale <0.17, 0.22, 0.17>
  rotate -90.0*z
  translate  <-1.5, 3.435195, 3.905796>
}


#include "glasses2.inc"

#declare RightEar_Ref = object {
  Object1
  texture {
    GlassesTx
  }
}
#declare LeftEar_Ref = object {
  Object2
  texture {
    GlassesTx
  }
}
#declare LeftRail_Ref = object {
  Object3
  texture {
    Silver2
  }
}
#declare RightRail_Ref = object {
  Object4
  texture {
    Silver2
  }
}
#declare LeftTop_Ref = object {
  Object5
  texture {
    GlassesTx
  }
}
#declare LeftLens_Ref = object {
  Object6
  texture {
    Glass1
  }
}
#declare Bridge_Ref = object {
  Object7
  texture {
    Silver2
  }
}
#declare RightTop_Ref = object {
  Object8
  texture {
    GlassesTx
  }
}
#declare RightLens_Ref = object {
  Object9
  texture {
    Glass1
  }
}
union { // glasses2_obj
  object { RightEar_Ref }
  object { LeftEar_Ref }
  object { LeftRail_Ref }
  object { RightRail_Ref }
  object { LeftTop_Ref }
  object { LeftLens_Ref }
  object { Bridge_Ref }
  object { RightTop_Ref }
  object { RightLens_Ref }
  scale 0.2
  rotate <-83.0, 0.0, -140.0>
  translate  <-3.0, -6.1, 0.9>
}


#include "glass3.inc"

object {
  Object1
  scale <0.6, 0.4, 0.6>
  rotate <1.570202, -0.316685, 100.001884>
  translate  <2.8, -5.2, 1.9>
  texture {
    Glass3
  }
}


box { // Back1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BackWallTX
  }
  scale <49.799999, 1.5, 16.0>
  translate  <1.6, -41.200001, 5.6>
}




box { // Cieling
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Texture01
  }
  scale <32.700001, 1.5, 37.600002>
  rotate 90.0*x
  translate  <3.1, -3.7, 30.5>
}


box { // Right
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Texture01
  }
  scale <35.200001, 1.4, 16.0>
  rotate 90.0*z
  translate  <30.9, -11.0, 5.6>
}


box { // Left
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Texture01
  }
  scale <39.799999, 2.3, 16.0>
  rotate 90.0*z
  translate  <-27.0, -2.2, 5.6>
}


object { // BottleBody1->BottleBody
  BottleBody_Ref
  scale 0.1
  rotate <-73.260414, -58.525051, 0.0>
  translate  <1.5, 1.441201, 3.470391>
  texture {
    Green_Glass1
  }
}


difference { // WaterInBottle
  cylinder { // Water
    <0,0,1>, <0,0,0>, 1 
    texture {
      WaterSmooth
    }
    scale <2.8, 3.3, 11.2>
    rotate <0.0, -90.0, 0.0>
    translate  <4.3, 3.3, 3.9>
  }
  box { // WaterTop
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 4.1, 2.0>
    translate  <-1.5, 3.2, 5.2>
    texture {
      WaterBumpy
    }
  }
}


#include "ice4.inc"

object {
  Object1
  scale 2.3
  rotate 25.0*z
  translate  <0.3, -6.9, -0.1>
  texture {
    WaterIce
  }
}


#include "ice3.inc"

object {
  Object1
  scale 2.3
  rotate -110.0*z
  translate  <-2.9, -6.0, 0.0>
  texture {
    WaterIce
  }
}




box { // Back
  <-1, -1, -1>, <1, 1, 1>
  scale <49.799999, 1.5, 16.0>
  translate  <0.0, 14.7, 5.6>
  texture {
    BackWallTX
  }
}



#declare Stand_Left = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    texture {
      DMFWood3
    }
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 2.2>
    translate  <0.0, 0.5, -1.1>
    texture {
      DMFWood3
    }
  }
  scale <4.3, 1.5, 1.0>
  rotate <90.0, 0.0, 90.0>
  translate  <-6.4, -0.1, 2.25>
}
#declare Stand_Right = difference {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood3
    }
    scale <1.0, 0.5, 1.0>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood3
    }
    scale <0.8, 0.8, 2.2>
    translate  <0.0, 0.5, -1.1>
  }
  scale <4.3, 1.5, 1.0>
  rotate <90.0, 0.0, 90.0>
  translate  <1.2, -0.1, 2.25>
}
union { // Bottle
  object { BottleBody_Ref }
  object { Cork_Ref }
  object { Stand_Left }
  object { Stand_Right }
  scale <1.0, 1.0, 1.2>
  translate  <1.3, 3.3, -1.8>
}


box { // Table
  <-1, -1, -1>, <1, 1, 1>
  scale <24.5, 10.5, 1.0>
  translate  <-0.1, -0.1, -1.0>
  texture {
    DMFDarkOak1
  }
}


