// Persistence of Vision Ray Tracer Scene Description File
// File: broke-n.pov
// Vers: 3
// Desc: Some are broke and some broken
// Date: 02-14-97
// Auth: Gregor Rudolf
//       gregor.rudolf@irts.si, PCGNet 9:538/100, Fidonet 2:380/100
//----------------------------------------------------------------------


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <64.342, -38.942, 42.177>
  direction <0.0,     0.0,  2.5650>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <102.203, 74.687, 1.000>
}

// *******  L I G H T S *******
light_source {   // Light2
  <200.000, -100.000, 100.000>
  color rgb <1.000, 1.000, 0.824>
  fade_distance  45.0
  fade_power 1.0
}

light_source {   // Light1
  <100.000, 100.000, 100.000>
  color rgb <1.000, 1.000, 0.824>
  fade_distance  30.0
  fade_power 1.0
}

light_source {   // Light001
  <-690.809, 381.517, 163.130>
  color rgb <1.000, 1.000, 1.000>
}


//-----------------------------------------------------------------
//   Textures
//-----------------------------------------------------------------

#declare Glass_Final = texture {
   pigment {
     color rgbf<0.980, 0.980, 0.980, 0.900>
   }
   finish {
     diffuse 0.100
     phong 1.000
     phong_size 400.000
     reflection 0.100
     refraction 1
     ior 1.450
     specular 0.800
     roughness 0.0003
     caustics 0.3
   }

}

#declare Glass_FinalB = texture {
   pigment {
     spotted
     color_map {
       [ 0.000  color rgbf<0.980, 0.980, 0.980, 0.9> ]
       [ 0.490  color rgbf<0.980, 0.980, 0.980, 0.9> ]
       [ 0.500  color rgbf<0.231, 0.231, 0.231, 0.1> ]
       [ 0.510  color rgbf<0.980, 0.980, 0.980, 0.9> ]
       [ 1.000  color rgbf<0.980, 0.980, 0.980, 0.9> ]
     }
     turbulence 0.500
     scale     <1.0000, 1.0000, 10.0000>
   }
   finish {
     diffuse 0.100
     phong 1.000
     phong_size 400.000
     reflection 0.100
     refraction 1
     ior 1.450
     specular 0.800
     roughness 0.0003
     caustics 0.2
   }

}

#declare tLiquid = texture {
   pigment {
     color rgbf<0.758, 0.652, 0.659, 0.85>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.100
     refraction 1
     ior 1.330
     specular 0.400
     roughness 0.0100
     caustics 0.1
   }

}

#declare tLabel = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\BRAND.TGA"
       map_type 2  // Cylindrical
       interpolate 2  // Bilinear (2)
     }
     scale <-1,1,1> rotate 90*x // align properly along +Z
   }
   finish {
     diffuse 0.360
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare tCardJack = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\JACK.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



#declare tCard10 = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\10.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



#declare tCardQueen = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\QUEEN.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



#declare tCardKing = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\KING.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



#declare tCard2 = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\2.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



#declare tCardBack = texture {
   pigment {
     image_map {
       tga "k:\user\gregor\bitmap\CARDBACK.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare tDesk = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.300, 0.100, 0.050> ]
       [ 0.100  color rgb<0.300, 0.100, 0.050> ]
       [ 0.900  color rgb<0.250, 0.070, 0.038> ]
       [ 1.000  color rgb<0.250, 0.070, 0.038> ]
     }
     turbulence 0.100
     scale     <0.0750, 0.0750, 1.0000>
     rotate    <-60.0000, -15.0000, 0.0000>
   }
   normal {
     bumps 0.2500
     scale     <0.1000, 0.0100, 0.1000>
   }
   finish {
     ambient 0.300
     phong 0.320
     reflection 0.100
   }

}


#declare tWall = texture {
   pigment {
     color rgb<0.705, 0.705, 0.705>
   }
   normal {
     wrinkles 0.1000
     omega 2.000
     lambda 0.500
//     scale     0.2000
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare tBulb = texture {
   pigment {
     color rgb<1.000, 1.000, 0.819>
   }
   finish {
     diffuse 1.000
     ambient 1.000
     specular 0.400
     roughness 0.0100
   }

}


#declare tLightCover = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgbf<0.675, 1.000, 0.684, 0.246> ]
       [ 1.000  color rgbf<0.397, 0.720, 0.400, 0.321> ]
     }
     turbulence 0.500
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare tFicheRed = texture {
   pigment {
     color rgb<0.750, 0.000, 0.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     phong 0.560
     phong_size 45.200
     specular 0.400
     roughness 0.0100
   }

}

#declare tFicheBlue = texture {
   pigment {
     color rgb<0.000, 0.000, 0.754>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     phong 0.560
     phong_size 45.200
     specular 0.400
     roughness 0.0100
   }

}

#declare tChairWood = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.400, 0.133, 0.066> ]
       [ 0.100  color rgb<0.400, 0.133, 0.066> ]
       [ 0.900  color rgb<0.200, 0.065, 0.033> ]
       [ 1.000  color rgb<0.200, 0.065, 0.033> ]
     }
     turbulence 0.050
     octaves 2
     scale     <0.0500, 0.0500, 1.0000>
   }
   finish {
     ambient 0.310
     phong 0.410
     reflection 0.1
   }

}


#declare tChairBut = texture {
   pigment {
     color rgb<0.605, 0.582, 0.577>
   }
   finish {
     ambient 0.310
     phong 0.500
     phong_size 62.200
     reflection 0.470
     specular 0.400
     roughness 0.0100
     metallic
   }

}




//-----------------------------------------------------------------
//   Ashtray&smoke definition
//-----------------------------------------------------------------
#include "ashtrayg.inc"


//-----------------------------------------------------------------
//   Declares
//-----------------------------------------------------------------
#declare Fiche = merge {
  torus { 1.75, 0.25
    rotate -x*90
    scale <1.0, 1.0, 0.8>
    translate  0.2*z
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <1.75, 1.75, 0.4>
  }
  texture { tFicheRed }
  translate  <100.0, 100.0, 0.0>
}

#declare Fiche5 = object {
  object { Fiche
    texture { tFicheBlue }
    translate  <-3.677088, 1.837221, 0.0>
  }
}

#declare Fiche7 = object {
  object { Fiche5 translate  <2.57105, -7.450951, 0.0> }
}

#declare Fiche11 = object {
  object { Fiche translate  <2.0, 0.0, 0.2> }
}

#declare Fiche17 = object {
  object { Fiche11 translate  <5.07885, 0.069573, 0.4> }
}

#declare Fiche39 = merge {
  torus { 1.75, 0.25
    rotate -x*90
    scale <1.0, 1.0, 0.8>
    translate  0.2*z
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <1.75, 1.75, 0.4>
  }
  texture { tFicheBlue }
  translate  <141.370231, 104.440109, 0.0>
}

#declare FicheStackB1 = union {
  object { Fiche39 }
  object { Fiche39 translate  0.4*z }
  object { Fiche39 translate  0.8*z }
  object { Fiche39 translate  1.2*z }
  object { Fiche39 translate  1.6*z }
  object { Fiche39 translate  2.0*z }
  object { Fiche39 translate  2.4*z }
  object { Fiche39 translate  2.8*z }
  object { Fiche39 translate  3.2*z }
  object { Fiche39 translate  3.6*z }
  object { Fiche39 translate  4.0*z }
  object { Fiche39 translate  4.4*z }
  object { Fiche39 translate  4.8*z }
  object { Fiche39 translate  5.2*z }
  object { Fiche39 translate  5.6*z }
  object { Fiche39 translate  6.0*z }
  translate  <3.407166, 0.638844, 0.0>
}

#declare FicheStackB3 = object {
  object { FicheStackB1 translate  <-11.44283, 41.888381, 0.0> }
}

#declare Fiche28 = object {
  object { Fiche translate  <27.480628, 49.42184, 0.0> }
}

#declare FicheStack1 = union {
  object { Fiche28 }
  object { Fiche28 translate  0.4*z }
  object { Fiche28 translate  <0.0, 0.0, 0.8> }
  object { Fiche28 translate  <0.0, 0.0, 1.2> }
  object { Fiche28 translate  <0.0, 0.0, 1.6> }
  object { Fiche28 translate  <0.0, 0.0, 2.0> }
  object { Fiche28 translate  <0.0, 0.0, 2.4> }
  object { Fiche28 translate  <0.0, 0.0, 2.8> }
  object { Fiche28 translate  <0.0, 0.0, 3.2> }
  object { Fiche28 translate  <0.0, 0.0, 3.6> }
  object { Fiche28 translate  <0.0, 0.0, 4.0> }
  translate  -6.601633*x
}

#declare FicheStack2 = object {
  object { FicheStack1 translate  <3.080762, -5.242286, 0.0> }
}


#declare TableTop = merge {
  cylinder {<0,0,1>, <0,0,0>, 1
    scale <50.0, 50.0, 3.0>
    translate  -3.0*z
  }
  torus { 1.975, 0.025
    rotate -x*90
    scale <25.0, 25.0, 10.0>
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <49.5, 49.5, 1.0>
    translate  -0.75*z
  }
  scale <1.5, 1.5, 1.0>
  translate  <100.0, 100.0, -0.25>
}

#declare gl2 = merge {
  cone { <0,0,0>, 0.9, <0,0,1>, 1.0
    scale <5.0, 5.0, 12.0>
  }
  torus { 0.95, 0.05
    rotate -x*90
    scale <5.0, 5.0, 2.0>
    translate  12.0*z
  }
}

#declare Sphere001 = object {
  sphere { <0,0,0>,1
    scale <2.0, 1.0, 6.34066>
    rotate 4.038617*x
    translate  <0.0, -5.573335, 6.239878>
  }
}

#declare gdiff = union {
  object { Sphere001 }
  object { Sphere001 rotate <0.0, 0.0, -30.0>  }
  object { Sphere001 rotate <0.0, 0.0, -60.0>  }
  object { Sphere001 rotate <0.0, 0.0, -90.0>  }
  object { Sphere001 rotate <0.0, 0.0, -120.0> }
  object { Sphere001 rotate <0.0, 0.0, -150.0> }
  object { Sphere001 rotate <0.0, 0.0, 180.0>  }
  object { Sphere001 rotate <0.0, 0.0, 150.0>  }
  object { Sphere001 rotate <0.0, 0.0, 120.0> }
  object { Sphere001 rotate <0.0, 0.0, 90.0> }
  object { Sphere001 rotate <0.0, 0.0, 60.0> }
  object { Sphere001 rotate <0.0, 0.0, 30.0> }
}

#declare gls = difference { // gls
  object { gl2 }
  cone { <0,0,0>, 0.9, <0,0,1>, 1.0
    scale <4.5, 4.5, 12.0>
    translate  0.6*z
  }
  sphere { <0,0,0>,1
    scale <3.5, 3.5, 0.25>
  }
  object { gdiff }
  texture {
    Glass_Final
  }
}


//-----------------------------------------------------------------
//   Define Chairs
//-----------------------------------------------------------------

#declare CSG001 = difference {
  cylinder { <0,0,1>, <0,0,0>, 1 scale <60.0, 60.0, 25.0> }
  cylinder { <0,0,1>, <0,0,0>, 1 scale <55.0, 55.0, 27.0> translate  -1.0*z }
}

#declare Naslon = intersection {
  object { CSG001 }
  sphere { <0,0,0>,1 scale <30.0, 20.0, 30.0> translate  <0.0, 52.135478, 16.230004>   }
  texture {
    tChairWood
    scale <40.0, 40.0, 20.0>
    rotate <-20.0, -30.0, 0.0>
  }
  bounded_by {
    box { <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> scale <31.0, 10.0, 20.0> translate  <0.0, 54.129408, 12.189841> }
  }
}

#declare ChBut1 = object {
  sphere { <0,0,0>,1
    texture {
      tChairBut
    }
    translate  <-19.25, 52.0, 5.0>
  }
}
#declare Chair = union {
  object { Naslon }
  superellipsoid { // SuprQ001
    <0.1, 0.1>
    texture {
      tChairWood
      scale <10.0, 10.0, 2.0>
      rotate <10.0, 20.0, 0.0>
    }
    scale <2.0, 2.0, 40.0>
    rotate <-4.0, -8.0, 0.0>
    translate  <-16.0, 55.0, -18.0>
  }
  superellipsoid { // SuprQ2
    <0.1, 0.1>
    texture {
      tChairWood
      scale <10.0, 10.0, 2.0>
      rotate <10.0, -20.0, 0.0>
    }
    scale <2.0, 2.0, 40.0>
    rotate <-4.0, 8.0, 0.0>
    translate  <16.0, 55.0, -18.0>
  }
  object { ChBut1 }
  object { ChBut1 translate  38.25*x }
  object { ChBut1 translate  <-1.5, -0.5, 10.0> }
  object { ChBut1 translate  <40.0, -0.5, 10.0> }
  translate  <100.401603, 149.77176, 0.0>
}



//-----------------------------------------------------------------
//   Define fiches
//-----------------------------------------------------------------
#declare FichesCenter = union {
  object { Fiche }
  object { Fiche translate  <2.306203, -3.470306, 0.0> }
  object { Fiche translate  <4.102068, 0.204136, 0.0> }
  object { Fiche translate  <3.805542, 4.388916, 0.0> }
  object { Fiche translate  <-0.318528, 4.235815, 0.0> }
  object { Fiche5 }
  object { Fiche5 translate  <0.315881, -4.031679, 0.0> }
  object { Fiche7 }
  object { Fiche5 translate  <-0.328205, 4.082713, 0.0> }
  object { Fiche5 translate  <9.990323, -5.001323, 0.0> }
  object { Fiche5 translate  <10.867576, 0.714475, 0.0> }
  object { Fiche11 }
  object { Fiche11 translate  <-2.797188, -3.26617, 0.0> }
  object { Fiche11
    texture {tFicheBlue}
    translate  <3.540695, 2.296526, 0.0>
  }
  object { Fiche11 translate  <-1.757155, 3.52134, 0.0> }
  object { Fiche11 translate  <-4.503308, 0.510339, 0.0> }
  object { Fiche11 translate  <3.110422, -2.704797, 0.0> }
  object { Fiche17 }
  object { Fiche17
    texture {tFicheBlue}
    translate  <-13.705937, -0.391466, 0.0>
  }
  object { Fiche17 translate  <-9.392393, 2.974026, 0.0> }
  object { Fiche17 translate  <-7.722634, 0.217069, 0.0> }
  object { Fiche17
    texture {tFicheBlue}
    translate  <-10.157699, -1.565863, 0.0>
  }
  object { Fiche17 translate  <-10.575139, 2.356215, 0.0> }
  object { Fiche7
    texture {tFicheRed}
    rotate 0.0*z
    translate  <5.28757, -1.0, 0.0>
  }
  object { Fiche7
    texture {tFicheRed}
    rotate 0.0*z
    translate  <2.156772, -3.461039, 0.0>
  }
  object { Fiche7 rotate 0.0*z   translate  <12.105751, 6.183673, 0.0> }
  object { Fiche7
    texture {tFicheRed}
    rotate 0.0*z
    translate  <11.131725, 2.122449, 0.0>
  }
  object { Fiche7 rotate 0.0*z   translate  <9.183673, -1.173469, 0.0>}
  object { FicheStackB3 translate  <-34.247434, -38.325968, 0.0> }
  object { FicheStackB3 translate  <-24.095593, -37.842542, 0.0> }
  object { FicheStackB3 translate  <-22.836862, -42.063744, 0.0> }
  object { FicheStack2 translate  <-17.563372, -38.100201, 0.0> }
  object { FicheStack2 translate  <-20.940944, -35.922862, 0.0> }
  object { FicheStack2 translate  <-28.793798, -34.421036, 0.0> }
}






//Define Table
#declare TabDesk1 = intersection {
  object { // TableTop1->TableTop
    TableTop
    rotate 0.0*z
  }
  box { // TabC01
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 90.0, 2.5>
    translate  <40.0, 100.0, -2.0>
  }
  texture {
    tDesk
    scale 20.0
  translate <0.000000, -50.000000, 50.000000>
  }
}
#declare TabDesk2 = intersection {
  object { // TableTop2->TableTop
    TableTop
    rotate 0.0*z
  }
  box { // TabC2
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 90.0, 2.5>
    translate  <80.0, 100.0, -2.0>
  }
  texture {
    tDesk
    scale 20.0
  }
}
#declare TabDesk3 = intersection {
  object { // TableTop3->TableTop
    TableTop
    rotate 0.0*z
  }
  box { // TabC3
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 90.0, 2.5>
    translate  <120.0, 100.0, -2.0>
  }
  texture {
    tDesk
    scale 20.0
  translate <0.000000, -50.000000, -50.000000>
  }
}
#declare TabDesk4 = intersection {
  object { // TableTop4->TableTop
    TableTop
    rotate 0.0*z
  }
  box { // TabC4
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 90.0, 2.5>
    translate  <160.0, 100.0, -2.0>
  }
  texture {
    tDesk
    scale 20.0
  }
}



//Define pieces of broken glass
#declare glb0 = difference {
  object { gls }
  box { // cd2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.221396, 5.0>
    rotate 22.371531*x
    translate  <-4.530496, -0.592984, 9.698291>
  }
  box { // cd3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 4.0>
    rotate <10.856175, -1.139903, 82.842087>
    translate  <-2.172351, -4.280597, 9.52866>
  }
  box { // cd4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 5.0>
    rotate <-13.178303, 2.415932, -80.747749>
    translate  <-0.851633, 4.421719, 8.086801>
  }
  sphere { // sd5
    <0,0,0>,1
    scale <1.551817, 2.139705, 5.52737>
    rotate <11.007036, -15.590827, -0.875635>
    translate  <4.580023, 0.0, 10.601905>
  }
  texture {
    Glass_FinalB
  }
  rotate 86.272865*x
  translate  <0.0, 9.07892, 4.594152>
}
#declare glb004 = intersection {
  object { // gls4->gls
    gls
  }
  sphere { // sd004
    <0,0,0>,1
    scale <1.551817, 2.139705, 5.52737>
    rotate <11.007036, -15.590827, -0.875635>
    translate  <4.580023, 0.0, 10.601905>
  }
  texture {
    Glass_FinalB
  }
  rotate <-72.935455, 83.689064, -130.221512>
  translate  <-0.414157, 2.081144, 4.59848>
}
#declare glb003 = intersection {
  object { // gls3->gls
    gls
  }
  box { // cd003
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 5.0>
    rotate <-13.178303, 2.415932, -80.747749>
    translate  <-0.851633, 4.421719, 8.086801>
  }
  texture {
    Glass_FinalB
  }
  rotate <92.534103, 9.036693, 0.0>
  translate  <3.120487, -8.943382, -3.053349>
}
#declare glb002 = intersection {
  object { // gls2->gls
    gls
  }
  box { // cd002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 4.0>
    rotate <10.856175, -1.139903, 82.842087>
    translate  <-2.172351, -4.280597, 9.52866>
  }
  texture {
    Glass_FinalB
  }
  rotate <87.646919, -17.041519, -25.028994>
  translate  <2.034499, -4.322377, 4.410392>
}
#declare glb001 = intersection {
  object { // gls1->gls
    gls
  }
  box { // cd001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.221396, 5.0>
    rotate 22.371531*x
    translate  <-4.530496, -0.592984, 9.698291>
  }
  texture {
    Glass_FinalB
  }
  rotate <47.046192, -85.891747, -18.936029>
  translate  <-0.941439, -2.374104, 4.410392>
}
#declare GlassBroken = union {
  object { glb0 }
  object { glb004 }
  object { glb003 }
  object { glb002 }
  object { glb001 }
  rotate 180.0*z
  translate  <114.029107, 52.192642, 0.0>
}
#declare Drink1 = difference {
  cone { // Cone3
    <0,0,0>, 0.9, <0,0,1>, 1.0
    scale <4.5, 4.5, 12.0>
    translate  0.516716*z
  }
  plane { // drdiffpl01
    z,0
    rotate -180.0*y
    translate  5.0*z
  }
  texture {
    tLiquid
  }
  translate  <145.0, 115.0, 0.0>
}
#declare Drink2 = difference {
  cone { // Cone4
    <0,0,0>, 0.9, <0,0,1>, 1.0
    scale <4.5, 4.5, 12.0>
    translate  0.516716*z
  }
  plane { // drdiffpl2
    z,0
    rotate -180.0*y
    translate  3.0*z
  }
  texture {
    tLiquid
  }
  translate  <85.0, 145.0, 0.0>
}
#declare Bott1 = merge {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    scale <7.0, 7.0, 25.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <7.0, 7.0, 9.0>
    translate  25.0*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    scale <2.5, 2.5, 8.0>
    translate  30.0*z
  }
  torus { // Torus004
    6.75, 0.25  rotate -x*90
  }
}
#declare Bott2 = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <7.0, 7.0, 25.0>
  }
  sphere { // Sphere13
    <0,0,0>,1
    scale <7.0, 7.0, 9.0>
    translate  25.0*z
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <2.2, 2.2, 11.0>
    translate  30.0*z
  }
  scale <0.9, 0.9, 0.95>
  translate  0.5*z
}
#declare Bottle1 = difference {
  object { Bott1 }
  object { Bott2 }
  sphere { // Sphere004
    <0,0,0>,1
    scale <6.0, 6.0, 0.3>
  }
  texture {
    Glass_Final
  }
}
#declare Label = difference {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1
    scale <7.1, 7.1, 14.2>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1
    scale <7.0, 7.0, 14.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 5.0, 7.2>
    translate  <0.0, 2.1, 7.1>
  }
  texture {
    tLabel
    scale <7.0, 7.0, 14.0>
    rotate -90.0*z
  }
  translate  5.0*z
}
#declare BotLiquid = difference {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1
    scale <7.0, 7.0, 25.0>
  }
  plane { // Plane002
    z,0
    scale 2.0
    rotate -90.0*y
    translate  -3.0*x
  }
  texture {
    tLiquid
  }
}
#declare Bottle = union {
  object { Bottle1 }
  object { Label }
  object { BotLiquid }
  rotate <40.0, -90.0, 0.0>
  translate  <78.771669, 67.565904, 7.05>
}



//-----------------------------------------------------------------
//   Define Cards
//-----------------------------------------------------------------

#declare CardsLooser = union {
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCard10 scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate 20.0*z
    translate  <92.76419, 79.48308, 0.0>
  }
  box {<-1, -1, -1>, <1, 1, 1>
    texture { tCardJack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate 10.0*z
    translate  <95.76419, 80.921953, 0.01>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardQueen scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    translate  <98.76419, 81.929165, 0.02>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardKing scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -10.0*z
    translate  <101.76419, 80.921953, 0.03>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCard2 scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -20.0*z
    translate  <104.76419, 79.48308, 0.04>
  }
  translate  <-3.945686, -30.250262, 0.0>
}

#declare Cube21 = object {
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -108.445282*z
    translate  <92.339241, 110.30074, 0.0>
  }
}

#declare CardPile = union {
  object { Cube21 }
  object { Cube21 rotate -0.5*z translate  <-1.059027, 0.810002, 0.1> }
  object { Cube21 rotate -1.0*z translate  <-2.11095, 1.628341, 0.2>  }
  object { Cube21 rotate -1.5*z translate  <-3.155694, 2.454957, 0.3> }
  object { Cube21 rotate -2.0*z translate  <-4.19319, 3.289785, 0.4>  }
  object { Cube21 rotate -2.5*z translate  <-5.223364, 4.132763, 0.5> }
  object { Cube21 rotate -3.0*z translate  <-6.246147, 4.983826, 0.6> }
  object { Cube21 rotate -3.5*z translate  <-7.261468, 5.842909, 0.7> }
  object { Cube21 rotate -4.0*z translate  <-8.269257, 6.709947, 0.8> }
  object { Cube21 rotate -4.5*z translate  <-9.269445, 7.584874, 0.9> }
  object { Cube21 rotate -5.0*z translate  <-10.261964, 8.467623, 1.0> }
  object { Cube21 rotate -5.5*z translate  <-11.246746, 9.358127, 1.1> }
  object { Cube21 rotate -6.0*z translate  <-12.223723, 10.256318, 1.2> }
  object { Cube21 rotate -6.5*z translate  <-13.192828, 11.162128, 1.3> }
  object { Cube21 rotate -7.0*z translate  <-14.153996, 12.075488, 1.4> }
  object { Cube21 rotate -7.5*z translate  <-15.107161, 12.996328, 1.5> }
  object { Cube21 rotate -8.0*z translate  <-16.052257, 13.924578, 1.6> }
  object { Cube21 rotate -8.5*z translate  <-16.989221, 14.860167, 1.7> }
  object { Cube21 rotate -9.0*z translate  <-17.917988, 15.803025, 1.8> }
  object { Cube21 rotate -9.5*z translate  <-18.838496, 16.753079, 1.9> }
  object { Cube21 rotate -10.0*z translate  <-19.750682, 17.710257, 2.0> }
  translate  <-7.219832, 6.670606, 0.0>
}

#declare Cards4 = union {
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -108.445282*z
    translate  <52.951244, 114.684836, 0.0>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -75.430099*z
    translate  <52.951244, 126.684836, 0.04>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -90.0*z
    translate  <54.638111, 125.010231, 0.03>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -88.272133*z
    translate  <55.963506, 120.805326, 0.02>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -100.98111*z
    translate  <54.638111, 117.564345, 0.01>
  }
  rotate 180.0*z
  translate  <204.733904, 212.003993, 0.01>
}

#declare Cards3 = union {
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -108.445282*z
    translate  <52.951244, 114.684836, 0.0>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -75.430099*z
    translate  <52.951244, 126.684836, 0.04>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -90.0*z
    translate  <54.638111, 125.010231, 0.03>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -88.272133*z
    translate  <55.963506, 120.805326, 0.02>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    rotate -100.98111*z
    translate  <54.638111, 117.564345, 0.01>
  }
  translate  <12.319974, -16.670766, 0.0>
}
#declare Cards2 = union {
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    translate  <102.094086, 147.032395, 0.01>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    translate  <105.094086, 147.032395, 0.02>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    translate  <108.094086, 147.032395, 0.03>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    translate  <111.094086, 147.032395, 0.04>
  }
  box { <-1, -1, -1>, <1, 1, 1>
    texture { tCardBack scale <2, 2, 1> translate <-1, -1, 0> }
    scale <3.54, 5.07, 0.1>
    translate  <114.094086, 147.032395, 0.05>
  }
  translate  <-3.507277, 3.507277, 0.0>
}



//-----------------------------------------------------------------
//   Place objects
//-----------------------------------------------------------------



//-----------------------------------------------------------------
//   Light
//-----------------------------------------------------------------
//Light bulb - could be visible in reflections
sphere { // Bulb
  <0,0,0>,1
  texture {
    tBulb
  }
  no_shadow
  hollow
  scale 3.0
  translate  <100.0, 100.0, 100.0>
}

//Light cover, translucent green
cone { // Cone002
  <0,0,0>, 0.0, <0,0,1>, 1.0
  open
  texture {
    tLightCover
  }
  hollow
  scale 25.0
  rotate <-180.0, 0.0, -180.0>
  translate  <100.0, 100.0, 115.0>
}



//-----------------------------------------------------------------
//   Room with a window
//-----------------------------------------------------------------
difference { // RoomCSG
  box { // RoomDiff
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <300.0, 300.0, 120.0>
    translate  <100.0, 100.0, 30.0>
  }
  box { // wind1
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 30.0, 40.0>
    translate  <-200.0, 269.978376, 50.0>
  }
  box { // wind2
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 30.0, 40.0>
    translate  <-200.0, 207.045692, 50.0>
  }
  box { // Room1
    <-1, -1, -1>, <1, 1, 1>
    scale <295.0, 295.0, 115.0>
    translate  <100.0, 100.0, 30.0>
  }
  texture {
    tWall
  }
}

//-----------------------------------------------------------------
//   Bars on windows
//-----------------------------------------------------------------
union { // WindBars
  cylinder { // bar01
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 100.0>
    translate  <-200.0, 200.0, 0.0>
  }
  cylinder { // bar2
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 100.0>
    translate  <-200.0, 220.0, 0.0>
  }
  cylinder { // bar4
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 100.0>
    translate  <-200.0, 260.0, 0.0>
  }
  cylinder { // bar5
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 100.0>
    translate  <-200.0, 280.0, 0.0>
  }
  texture {
    tWall
  }
}


//-----------------------------------------------------------------
//   Table
//-----------------------------------------------------------------
//union { // Table
  object { TabDesk1 }
  object { TabDesk2 }
  object { TabDesk3 }
  object { TabDesk4 }
//}

//-----------------------------------------------------------------
//   Chairs
//-----------------------------------------------------------------
  object { Chair }
  object { Chair rotate <0.0, 0.0, -90.0> translate  <-10.630221, 199.765252, 0.0> }
  object { Chair rotate <0.0, 0.0, 90.0> translate  <205.353681, 4.4708, 0.0> }
  object { Chair rotate <0.0, 0.0, -45.0> translate  <-35.658986, 109.097928, 0.0> }

//-----------------------------------------------------------------
//   Fiches
//-----------------------------------------------------------------
  object { FichesCenter }
  object { FicheStack1 }
  object { FicheStack2 }
  object { FicheStack1 translate  <5.281306, 0.51815, 0.0> }
  object { FicheStackB1 }
  object { FicheStackB1 translate  <4.531504, 1.978734, 0.0> }
  object { FicheStackB3 }
  object { FicheStackB1 translate  <9.129808, 1.692152, 0.0> }

//-----------------------------------------------------------------
//   Spilled liquid
//-----------------------------------------------------------------
blob {
  threshold 0.6
  component 1.0, 0.842519, <0.0, 0.0, 0.0>
  component 1.0, 0.842519, <0.6, 0.0, 0.4>
  component 1.0, 0.842519, <0.6, 0.0, -0.2>
  component 1.0, 0.842519, <0.2, 0.0, -0.6>
  component 1.0, 0.42126, <0.8, 0.0, -0.8>
  component 1.0, 0.42126, <0.4, 0.0, -1.0>
  component 1.0, 0.42126, <-0.2, 0.0, -1.0>
  component 1.0, 0.42126, <-0.4, 0.0, -0.6>
  component 1.0, 0.42126, <-0.6, 0.0, -0.2>
  component 1.0, 0.42126, <-0.8, 0.0, -0.6>
  component 1.0, 0.42126, <-1.0, 0.0, -1.0>
  component 1.0, 0.421259, <1.2, 0.0, 0.6>
  component 1.0, 0.421259, <1.2, 0.0, 0.2>
  component 1.0, 0.42126, <1.4, 0.0, 0.4>
  component 1.0, 0.421259, <1.6, 0.0, 0.6>
  component 1.0, 0.42126, <1.4, 0.0, 1.0>
  component 1.0, 0.842519, <0.8, 0.0, 1.2>
  component 1.0, 0.42126, <0.2, 0.0, 1.0>
  component 1.0, 0.42126, <0.0, 0.0, 0.6>
  component 1.0, 0.42126, <-0.4, 0.0, 0.4>
  component 1.0, 0.42126, <-0.6, 0.0, 0.2>
  component 1.0, 0.842519, <0.2, 0.0, 1.6>
  component 1.0, 0.42126, <-0.2, 0.0, 1.2>
  component 1.0, 0.42126, <-0.4, 0.0, 1.6>
  component 1.0, 0.842519, <1.0, 0.0, 1.8>
  component 1.0, 0.842519, <1.6, 0.0, 1.4>
  component 1.0, 0.658218, <0.3125, 0.0, 2.1875>
  component 1.0, 0.658218, <0.9375, 0.0, 2.5>
  component 1.0, 0.42126, <2.0, 0.0, 1.0>
  component 1.0, 0.421259, <2.2, 0.0, 1.6>
  component 1.0, 0.842519, <1.6, 0.0, 2.0>
  component 1.0, 0.842519, <1.4, 0.0, 2.8>
  component 1.0, 0.42126, <0.8, 0.0, 3.2>
  component 1.0, 0.42126, <0.4, 0.0, 2.8>
  component 1.0, 0.42126, <2.0, 0.0, 2.6>
  component 1.0, 0.421259, <2.2, 0.0, 2.2>
  component 1.0, 0.42126, <2.0, 0.0, 3.2>
  component 1.0, 0.42126, <1.4, 0.0, 3.4>
  component 1.0, 0.658218, <2.1875, 0.0, 0.3125>
  component 1.0, 0.658218, <2.8125, 0.0, -0.3125>
  component 1.0, 0.658218, <2.5, 0.0, -1.25>
  component 1.0, 0.658218, <3.125, 0.0, -0.9375>
  component 1.0, 0.658218, <2.8125, 0.0, 0.3125>
  component 1.0, 0.526575, <2.5, 0.0, -0.75>
  component 1.0, 0.42126, <2.4, 0.0, -0.2>
  component 1.0, 0.421259, <3.200001, 0.0, 0.0>
  component 1.0, 0.421259, <3.200001, 0.0, -0.4>
  component 1.0, 0.42126, <2.4, 0.0, 0.8>
  component 1.0, 0.337007, <2.08, 0.0, -0.16>
  component 1.0, 0.337008, <1.76, 0.0, 0.16>
  component 1.0, 0.337008, <1.92, 0.0, 0.64>
  component 1.0, 0.337007, <2.720001, 0.0, 0.8>
  texture {
    tLiquid
  }
  scale <5.0, 0.3, 5.0>
  rotate <-90.0, 0.0, -151.387421>
  translate  <112.569912, 77.034448, 0.0>
}

//-----------------------------------------------------------------
// Cards
//-----------------------------------------------------------------
  object { CardsLooser }
  object { CardPile }
  object { Cards4 }
  object { Cards3 }
  object { Cards2 }

//-----------------------------------------------------------------
//   Glasses, Bottle
//-----------------------------------------------------------------
  object { GlassBroken }
  object { gls texture {Glass_Final} translate  <51.536428, 91.562447, 0.0> }
  object { gls texture {Glass_Final} translate  <145.0, 115.0, 0.0> }
  object { gls texture {Glass_Final} translate  <85.0, 145.0, 0.0> }
  object { Drink1 }
  object { Drink2 }
  object { Bottle }

//-----------------------------------------------------------------
//   Ashtrays, Smoke
//-----------------------------------------------------------------
object {Ashtray translate <124, 136, 0>}
object {Ashtray rotate 180*z translate <58, 133, 0>}
object {Smoke translate <89, 39, 0>}
object {Smoke translate <0, 0, -50> scale 15 translate <100, 100,0>}
