//  Chest of Drawers for Persistance of Vision Raytracer for Windows v3.0

#include "cabtex.inc"

#declare DrawerHole = union {
  box { // DrwrHoleBase
    <-1, -1, -1>, <1, 1, 1>
    scale <4.8, 6.2, 1.5>
  }
  box { // DrwrHoleCutout
    <-1, -1, -1>, <1, 1, 1>
    scale <5.3, 0.4, 2.2>
    translate  -6.5*y
  }
}
#declare TopRim = difference {
  cylinder { // TopRimBase1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 13.2>
    rotate <0.0, 90.0, 0.0>
    translate  <-6.6, -6.8, 13.7>
  }
  box { // TopRimTrim1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2178, 0.455681, 0.4>
    rotate <0.0, 0.0, -45.0>
    translate  <-6.470974, -6.662958, 13.7>
  }
  box { // TopRimTrim2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2178, 0.455681, 0.4>
    rotate <0.0, 0.0, 45.0>
    translate  <6.470974, -6.662958, 13.7>
  }
  texture {
    T_Wood6     //TFront
    rotate <0.0, 85.100716, 3.611491>
  translate <0.000000, -0.274674, 12.549276>
  }
  bounded_by { // Bound00002
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <6.735804, 0.353875, 0.344813>
      translate  <0.0, -6.800573, 13.7>
    }
  }
}
#declare TopRim1 = difference {
  cylinder { // TopRimBase2
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 14.9>
    rotate <0.0, 90.0, 0.0>
    translate  <-6.6, -6.8, 13.7>
  }
  box { // TopRimTrim3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2178, 0.455681, 0.4>
    rotate <0.0, 0.0, -45.0>
    translate  <-6.470974, -6.662958, 13.7>
  }
  box { // TopRimTrim4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2178, 0.455681, 0.4>
    rotate <0.0, 0.0, 45.0>
    translate  <8.170974, -6.662958, 13.7>
  }
  texture {
    T_Wood6    //TFront
    rotate <0.0, -87.149818, 5.891665>
  translate <0.763869, 0.000000, 13.313146>
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <7.685165, 0.366756, 0.348993>
      translate  <0.85, -6.79306, 13.7>
    }
  }
  rotate 90.0*z
  translate  <-0.5, -0.5, 0.0>
}
#declare Knobby = difference {
  sphere { // KnobbyBase
    <0,0,0>,1
    scale <0.8, 0.8, 0.4>
    translate  0.8*z
  }
  torus { // KnobbyCut
    0.8, 0.15  rotate -x*90
    translate  0.8*z
  }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.980667, 0.980667, 0.430667>
      translate  0.8*z
    }
  }
}
#declare Knob = union {
  object { Knobby }
  cylinder { // KnobConnect
    <0,0,1>, <0,0,0>, 1
    scale <0.4, 0.4, 0.5>
  }
  texture {
    TKnob
  }
  rotate 90.0*x
  translate  -6.8*y
}
#declare DrawerInside = difference {
  box { // DrwrInBase
    <-1, -1, -1>, <1, 1, 1>
    scale <4.7, 6.3, 1.4>
  }
  box { // DrwrInCut
    <-1, -1, -1>, <1, 1, 1>
    scale <4.3, 5.9, 1.4>
    translate  0.3*z
  }
  box { // Runner1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.115391, 5.9, 0.187861>
    translate  <-4.610755, 0.412814, 0.0>
  }
  box { // Runner2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.115391, 5.9, 0.187861>
    translate  <4.607634, 0.417049, 0.0>
  }
  texture {
    TInDrawer
  }
}
#declare DrwrRim1 = difference {
  cylinder { // DrwrRimBase1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.1, 10.2>
    rotate <0.0, 90.0, 0.0>
    translate  <-5.1, -6.8, 1.8>
  }
  box { // DrwrRimTrim1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.234656, 0.15, 0.45881>
    rotate -45.0*y
    translate  <-4.975901, -6.798263, 1.644047>
  }
  box { // DrwrRimTrim2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.234656, 0.15, 0.45881>
    rotate 45.0*y
    translate  <4.975901, -6.798263, 1.644047>
  }
  texture {
    T_Wood6     //TFront
    scale <1.132108, 1.215494, 2.496915>
    rotate <5.0, 85.0, 0.0>
  translate <-0.600000, -5.800000, 5.100000>
  }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <5.142338, 0.141845, 0.31198>
      translate  <0.0, -6.804036, 1.799925>
    }
  }
  translate  -0.2*z
}
#declare DrwrRim2 = difference {
  cylinder { // DrwrRimBase2
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.1, 3.8>
    rotate <0.0, 90.0, 0.0>
    translate  <-5.0, -6.8, 1.8>
  }
  box { // DrwrRimTrim3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.234656, 0.15, 0.45881>
    rotate -45.0*y
    translate  <-4.850207, -6.798263, 1.618353>
  }
  box { // DrwrRimTrim4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.234656, 0.15, 0.45881>
    rotate 45.0*y
    translate  <-1.349003, -6.8, 1.619144>
  }
  texture {
    T_Wood6     //TFront
    scale <0.826398, 1.136832, 2.563993>
    rotate <2.0, 89.0, 0.0>
  translate <-3.078181, -6.978931, 4.366166>
  }
  bounded_by { // Bound00005
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.279391, 0.121939, 0.318671>
      translate  <-3.099605, -6.799132, 1.804>
    }
  }
  rotate <180.0, -90.0, 180.0>
  translate  <-3.0, 0.0, 3.1>
}
#declare DrawerFront = union {
  object { DrwrRim1 }
  box { // DrwrFrontBase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wood6     //TFront
      rotate <159.938843, 81.240814, 172.403168>
  translate <0.028626, -0.791094, 2.776025>
    }
    scale <5.1, 0.3, 2.0>
    translate  -6.5*y
  }
  object { // DrwrRim3->DrwrRim1
    DrwrRim1
    rotate -180.0*y
  }
  object { DrwrRim2 }
  object { // DrwrRim4->DrwrRim2
    DrwrRim2
    rotate -180.0*y
  }
}
#declare Drawer = union {
  object { Knob }
  object { DrawerInside }
  object { DrawerFront }
}

#declare Casing = difference {
  box { // CaseBase
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 7.0, 8.5>
    translate  <0.0, 0.2, 5.0>
  }
  object { DrawerHole }
  object { // DrawerHole1->DrawerHole
    DrawerHole
    translate  5.0*z
  }
  object { // DrawerHole2->DrawerHole
    DrawerHole
    translate  10.0*z
  }
  texture {
    T_Wood6     //TFront
  translate <-10.300000, -0.400000, 0.000000>
  }
}
#declare TopBoard = union {
  box { // TopBase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wood6     //TFront
      scale <8.078265, 0.475087, 1.356196>
      rotate <180.0, 85.950928, 176.918945>
  translate <0.000000, 1.998958, -9.251261>
    }
    scale <6.3, 7.15, 0.2>
    translate  <0.0, 0.35, 13.8>
  }
  object { TopRim }
  object { TopRim1 }
  object { // TopRim3->TopRim
    TopRim
    rotate -180.0*z
    translate  0.7*y
  }
  object { // TopRim2->TopRim1
    TopRim1
    rotate -180.0*z
    translate  <0.0, 0.7, 0.0>
  }
  translate  -0.1*z
}

#declare Cabinet = union { // Case
  object { Casing }
  object { TopBoard }
  object { Drawer }
  object { // Drawer1->Drawer
    Drawer
    translate  5.0*z
  }
  object { // Drawer2->Drawer
    Drawer
    translate  10.0*z
  }
  translate  3.5*z
}
