//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 3 textures and 35 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/27/1997    (27.02.1997)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//


#declare DETAIL=0


camera {  //  Camera StdCam
//  location  <13, -17, 10>
	location  <13, -8, 7.5>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
//  look_at   <7.100, -1.400, 8.000>
	look_at   <9, -2, 7>

}

// *******  L I G H T S *******
light_source {   // Light1
  <-40, -40, 40>
  color rgb <1.000, 1.000, 1.000>
}
light_source {   // Light1
  <40, -20, 20>
  color rgb <.8, .8, .8>
}

light_source {   // Light1
  <40, 10, 20>
  color rgb <.8, .8, .8>
}



// Set a color of the background (sky)
background { color red 0.1 green 0.3 blue 0.8 }

// ********  TEXTURES  *******
//

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

// *******  T E X T U R E S  *******
#declare txtPlateau = texture {
#if (DETAIL=1)
	pigment {
		granite
		color_map {
			[ 0.000  color rgb<0.574, 0.246, 0.273> ]
			[ 1.000  color rgb<0.875, 0.629, 0.423> ]
			}
		turbulence 1.000
		octaves 1
		}
#else
	pigment { color Pink }
#end
	finish {
		diffuse 0.400
		ambient 0.200
		phong 0.500
		phong_size 10.000
		reflection 0.100
		specular 0.400
		roughness 0.0200
		}
	}

#declare txtPlateau1 = texture {
#if (DETAIL=1)
	pigment{
		granite
		color_map {
			[ 0.000  color rgb<0.501, 0.503, 0.497> ]
			[ 0.622  color rgb<0.250, 0.252, 0.248> ]
			[ 0.651  color rgb<0.097, 0.097, 0.101> ]
			[ 0.680  color rgb<0.398, 0.400, 0.398> ]
			[ 1.000  color rgb<0.797, 0.800, 0.797> ]
			}
		turbulence 1.000
		octaves 1
		}
#else
	pigment {color Grey}
#end
	finish {
		diffuse		0.4
		ambient		0.2
		phong		0.5
		phong_size	10
		reflection	0.1
		specular	0.4
		roughness	0.02
		}
	}

#declare New_Brass = texture {
	pigment { color rgb<0.700, 0.560, 0.370> }
	finish {
		diffuse		1.00
		ambient		0.35
		phong		0.41
		phong_size	5.00
		roughness	0.05
		brilliance	15.0
		reflection	0.3
		}
	}
#declare Huile = texture
{
  pigment
  {
    colour rgbf<0.710,0.647,0.259,0.949>
  }
  finish {
    ambient 0.0
    diffuse 0.0
    specular 1.0    metallic
    reflection 0.4
    refraction 1.0    ior 1.61
  }
}

// ********  REFERENCED OBJECTS  *******
#include "pilier.inc"



// ********  V E R R E   A   F A C E T T E S *******
#if (DETAIL=1)
	#declare Facette01=
	intersection{
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <1.4,2,2>
			translate<0,-1,0>
			}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,22.5>
			}
		plane{z,0
			}
		}

	#declare Facette02_01=
	difference{
		box{
			<0,-.25, -.5>, <.5, .25, .5>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.2,1.2,.2>
			translate<.5,-.6,.5>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.2,1.2,.2>
			translate<.5,-.6,-.5>
			}
		}

		#declare Facette02=
		intersection{
			object{
				Facette02_01
				}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,+22.5>
			}
		}

	#declare Facette03_01=
	difference{
		box{
			<0,-.25, -1>, <.5, .25, 1>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.3,1.2,.2>
			translate<.5,-.6,1>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.25,1.2,2>
			translate<.5,-.6,-1>
			}
		}

	#declare Facette03=
	intersection{
		object{
			Facette03_01
			}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,+22.5>
			}
		}

	#declare Facette04_01=
	difference{
		box{
			<0,-.5, 0>, <1, .5, .5>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.8,1.2,.4>
			translate<1,-.6,.45>
			}
		}

	#declare Facette04=
	intersection{
		object{
			Facette04_01
			}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,+22.5>
			}
		}
#end

#declare VERRE01_SUB=	// ** Vasque pleine
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette01
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	intersection{
		sphere{
			<0, 0, 0>,1
			scale <1.4,1.4,2>
			//translate<0,-1,0>
			}
		plane{z,0
			}
		}
#end


#declare VERRE02_SUB= // ** Base/Pied
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette02
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	box{
		<-.5,-.5, -.5>, <.5, .5, .5>
		}
#end

#declare VERRE03_SUB= // ** Pied
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette03
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	box{
		<-.25,-.25, -1>, <.25, .25, 1>
		}
#end

#declare VERRE04_SUB= // ** Base
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette04
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	cylinder{
		<0,0,1>, <0, 0,0>,1
		scale <1,1,.5>
		}
#end

#declare VERRE01=	// ** Vasque du verre
object{	VERRE01_SUB
	clipped_by{
		object{
			VERRE01_SUB inverse
			translate <0,0,0.1>
			}
		}
	}

#declare VERRE= // ** Assemblage du verre
merge{
	object {
		VERRE03_SUB
		scale <.7,.7,.7>
		translate <0,0,1.4>
		}
	object {
		VERRE04_SUB
		}
	object {
		VERRE01
		scale <.9,.9,.9>
		translate <0,0,3.9>
		}
	object {VERRE02_SUB  // Facette02
		scale <.6,.6,.6>
		translate <0,0,.7>
		}
//		texture{T_Glass3}
		texture{pigment{color Yellow}}
	}

// ********  O B J E T S  *******
#declare Corniche1=
merge {
	cylinder { // Largueurs
		<0,0,1>, <0,0,0>, 1
		scale <0.1, 0.2, 10.4>
		rotate -90.0*x
		translate  <10.2, -5.2, 1.0>
		}
	cylinder {
		<0,0,1>, <0,0,0>, 1
		scale <0.1, 0.2, 10.4>
		rotate -90.0*x
		translate  <-10.2, -5.2, 1.0>
		}
	cylinder { // Longueurs
		<0,0,1>, <0,0,0>, 1
		scale <0.1, 0.2, 20.4>
		rotate <-90.0, 0.0, -90.0>
		translate  <-10.2, 5.2, 1.0>
		}
	cylinder {
		<0,0,1>, <0,0,0>, 1
		scale <0.1, 0.2, 20.4>
		rotate <-90.0, 0.0, -90.0>
		translate  <-10.2, -5.2, 1.0>
		}
	sphere { // Coins
		<0,0,0>,1
		scale <0.1, 0.1, 0.2>
		translate  <-10.2, 5.2, 1.0>
		}
	sphere {
		<0,0,0>,1
		scale <0.1, 0.1, 0.2>
		translate  <10.2, 5.2, 1.0>
		}
	sphere {
		<0,0,0>,1
		scale <0.1, 0.1, 0.2>
		translate  <10.2, -5.2, 1.0>
		}
	sphere {
		<0,0,0>,1
		scale <0.1, 0.1, 0.2>
		translate  <-10.2, -5.2, 1.0>
		}
	translate  -1.5*z
	}

#declare Corniche2=
merge {
	cylinder { // Largeurs
		<0,0,1>, <0,0,0>, 1
		scale <0.05, 0.1, 10.4>
		rotate -90.0*x
		translate  <10.2, -5.2, 0.0>
		}
	cylinder {
		<0,0,1>, <0,0,0>, 1
		scale <0.05, 0.1, 10.4>
		rotate -90.0*x
		translate  <-10.2, -5.2, 0.0>
		}
	cylinder { // Longueurs
		<0,0,1>, <0,0,0>, 1
		scale <0.05, 0.1, 20.4>
		rotate <-90.0, 0.0, -90.0>
		translate  <-10.2, 5.2, 0.0>
		}
	cylinder {
		<0,0,1>, <0,0,0>, 1
		scale <0.05, 0.1, 20.4>
		rotate <-90.0, 0.0, -90.0>
		translate  <-10.2, -5.2, 0.0>
		}
	sphere { // Coins
		<0,0,0>,1
		scale <0.05, 0.05, 0.1>
		translate  <-10.2, 5.2, 0.0>
		}
	sphere {
		<0,0,0>,1
		scale <0.05, 0.05, 0.1>
		translate  <10.2, 5.2, 0.0>
		}
	sphere {
		<0,0,0>,1
		scale <0.05, 0.05, 0.1>
		translate  <10.2, -5.2, 0.0>
		}
	sphere {
		<0,0,0>,1
		scale <0.05, 0.05, 0.1>
		translate  <-10.2, -5.2, 0.0>
		}
	translate  0.6*z
	}


#declare PlateauPlus = merge {
  box { // PlateauSuperieur
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 5.0, 1.0>
  }
  cylinder { // Arrondis
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 10.0>
    rotate -90.0*x
    translate  <10.0, -5.0, 0.8>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 10.0>
    rotate -90.0*x
    translate  <-10.0, -5.0, 0.8>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 20.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-10.0, 5.0, 0.8>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 20.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-10.0, -5.0, 0.8>
  }
  sphere { // Coins Arrondis
    <0,0,0>,1
    scale 0.1
    translate  <-10.0, 5.0, 0.8>
  }
  sphere {
    <0,0,0>,1
    scale 0.1
    translate  <10.0, 5.0, 0.8>
  }
  sphere {
    <0,0,0>,1
    scale 0.1
    translate  <-10.0, -5.0, 0.8>
  }
  sphere {
    <0,0,0>,1
    scale 0.1
    translate  <10.0, -5.0, 0.8>
  }
  box { // Plateau Inferieur (+ Large)
    <-1, -1, -1>, <1, 1, 1>
    scale <10.2, 5.2, 0.8>
  }
}

#declare PlateauMoins = union {		// ** Arrondis Concaves
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 11.0>
    rotate <-90.0, 20.0, 0.0>
    translate  <-10.0, -5.5, 1.0>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 11.0>
    rotate -90.0*x
    translate  <10.0, -5.5, 1.0>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 21.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-10.5, -5.0, 1.0>
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 21.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-10.5, 5.0, 1.0>
  }
}

	#declare ElementPied=		// ** Declaration Element Pied
	union{
		object {PiedDroit scale<1,1,1>}
		object {Pilier scale<1,1,.5>}
		object {
			ChapeauDorique
			translate <0,0,5>
			}
		}

	#declare PiedTable=
	union{
		object {
		ElementPied
		translate <0,-3.8,-6.8>
		}
	object {
		ElementPied
		translate <0,-2.8,-6.8>
		}
	object {
		ElementPied
		translate <0,-1.8,-6.8>
		}
	object {
		ElementPied
		translate <0,-.8,-6.8>
		}
	object {
		ElementPied
		translate <0,0,-6.8>
		}
	object {
		ElementPied
		translate <0,.8,-6.8>
		}
	object {
		ElementPied
		translate <0,1.8,-6.8>
		}
	object {
		ElementPied
		translate <0,2.8,-6.8>
		}
	object {
		ElementPied
		translate <0,3.8,-6.8>
		}
	}


// ********  A S S E M B L A G E  *******
#declare AUTEL=
union{
	difference { // PlateauPrinc		// ** Plateau Principal
		object { PlateauPlus }
		object { PlateauMoins }
		texture { txtPlateau1 }
		}

	object {
		Corniche1
		texture { txtPlateau }
		}
	object {
		Corniche2
		texture { txtPlateau }
		}
											// ** Gravures Tranche
	text {ttf "angerth.ttf", "`lord.of.`riNs.translatd.fro.", 1, 0
		texture { New_Brass }
		scale <1, .7, 1>
		translate  <-9.8, -.25, -0.5>
		rotate x*90
		translate  <0.0, -5.5+.8, 0.1>
		}
	text {ttf "angerth.ttf", "`lord.of.`riNs.translatd.fro.", 1, 0
		texture{ New_Brass }
		scale <1, .7, 1>
		translate  <-9.8, -.25, -0.5>
		rotate x*90
		rotate 180*z
		translate  <0.0, 5.5-.8, 0.1>
		}
	text {ttf "angerth.ttf", "`lord.of.`riN", 1, 0
		texture{ New_Brass }
		scale <1, .7, 1>
		translate  <-4.8, -.25, -0.5>
		rotate x*90
		rotate 90.0*z
		translate  <10.5-.8, 0.0, 0.1>
		}
	text {ttf "angerth.ttf", "`lord.of.`riN", 1, 0
		texture{ New_Brass }
		scale <1, .7, 1>
		translate  <-4.8, -.25, -0.5>
		rotate x*90
		rotate -90.0*z
		translate  <-10+.8, 0.0, 0.1>
		}

	#declare LNCarreau=1			// ** Motif Central
	#declare LRCarreau=1
	#declare EpCarreau=1
	#include "marqueterie.inc"
	object{
		CARREAU
		translate <0,0,0.001>
		texture {Gold_Metal}
		}
	#declare LNCarreau=8.5*2		// ** Motif Bord
	#declare LRCarreau=4.25*2
	#declare EpCarreau=.5
	#include "marqueterie.inc"
	object{
		CARREAU
		translate <0,0,0.001>
		texture {Gold_Metal}
		}
/*	object {
		PiedTable
		translate<7.5,0,0>
		texture { txtPlateau }
		}
	object {
		PiedTable
		translate<-7.5,0,0>
		texture { txtPlateau }
		}*/
	scale<1,1,.5>
	translate <0,0,6.8> // ** Pose sur le sol
	}

union{
	object {
		PiedTable
		translate<7.5,0,0>
		texture { txtPlateau }
		}
	object {
		PiedTable
		translate<-7.5,0,0>
		texture { txtPlateau }
		}
	translate <0,0,6.8> // ** Pose sur le sol
	}
#include "axes.inc"




#declare VERRES=
union{
	object {VERRE} 					// ** Verre debout
	object {VERRE					// ** Verre Renvers
		rotate <86,0,-45>
		translate <4,-2,1>
		}

	// ********** FLAQUE
	blob {
    	threshold 0.6
		sphere { <0, -4, 0>, 1.2, 1 }
		sphere { <0, -5, 0>, 1.5, 1 }
		sphere { <.5, -6, 0>, 2, 1 }
		sphere { <-1, -6.5, 0>, 1, 1 }
		scale <1,1,.2>
		texture {Huile}
/*		pigment{color Blue}
		finish { ambient 0.3 diffuse 0.7 phong 1.0 phong_size 90 }*/
		}

	blob {
		threshold 0.6
		sphere { <0, -4, 0>, 1.1, 1 }
		sphere { <0, -5, 0>, 1.2, 1 }
		sphere { <-1, -6.5, 0>, 1, 1 }
		scale <1,1,.2>
		texture {Huile}
/*		pigment{color Blue}
		finish { ambient 0.3 diffuse 0.7 phong 1.0 phong_size 90 }*/
		translate <-3,-2,0>
		}
	}

object{AUTEL
	translate <0,0,-.5>}
object{VERRES
	rotate <0,0,40>
	scale <.6,.6,.6>
	translate <6.7,0,6.8>
	}

object {COLONNE_DORIQUE
	scale 3
	translate <-6,50,0>
	texture{T_Stone22}
	}

object {COLONNE_DORIQUE
	scale 3
	translate <-26,50,0>
	texture{T_Stone22}
	}

object {COLONNE_DORIQUE
	scale 3
	translate <-46,50,0>
	texture{T_Stone22}
	}










