//  Persistance of Vision Raytracer V2.2
//  World definition file.
//

//  Date : 02/24/1997    (24.02.1997)
//

//#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//


#include "colors.inc"
#include "textures.inc"

//  $MRY$: 'Sapphire_Agat1'
#declare Sapphire_Agat1 = texture {
   pigment {
     agate
     color_map {
       [ 0.000  color rgb<0.000, 0.000, 0.900> ]
       [ 0.300  color rgb<0.000, 0.000, 0.800> ]
       [ 1.000  color rgb<0.000, 0.000, 0.400> ]
     }
   }
   finish {
     roughness 0.0500
   }

}
//  $MRY$: 'Red_Marble1'
#declare Red_Marble1 = texture {
   pigment {
     marble
     color_map {
       [ 0.000  color rgb<0.800, 0.800, 0.600> ]
       [ 0.800  color rgb<0.800, 0.400, 0.400> ]
       [ 1.000  color rgb<0.800, 0.200, 0.200> ]
     }
     turbulence 1.000
   }
   finish {
     roughness 0.0500
   }

}



//  $MRY$: 'Cork1'
#declare Cork1 = texture {
   pigment {
     granite
     color_map {
       [ 0.000  color rgb<0.930, 0.710, 0.532> ]
       [ 0.600  color rgb<0.980, 0.810, 0.600> ]
       [ 0.600  color rgb<0.500, 0.300, 0.200> ]
       [ 0.650  color rgb<0.500, 0.300, 0.200> ]
       [ 0.650  color rgb<0.800, 0.530, 0.460> ]
       [ 1.000  color rgb<0.850, 0.750, 0.350> ]
     }
     scale     <0.2500, 0.2500, 0.2500>
   }
   finish {
     specular 0.100
     roughness 0.5000
   }

}



//  $MRY$: 'Blood_Marble1'
#declare Blood_Marble1 = texture {
   pigment {
     marble
     color_map {
       [ 0.000  color rgb<0.000, 0.000, 0.000> ]
       [ 0.800  color rgb<0.000, 0.600, 0.600> ]
       [ 0.900  color rgb<0.600, 0.000, 0.000> ]
       [ 1.000  color rgb<0.000, 0.000, 0.000> ]
     }
     turbulence 2.300
   }
   finish {
     roughness 0.0500
   }

}





// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

// ***** P I L I E R   D R O I T *****
#declare Pilier=
union {
	#declare NbColonnade=12
	#while (NbColonnade >= 0 )
		cylinder { // 12 COLONNADES
			<0,0,1>, <0,0,0>, 1
			scale <0.2, 0.2, 10.0>
			translate  <-0.6, 0.0, 1.0>
			rotate <0,0, NbColonnade*30>
		}
    	#declare NbColonnade=NbColonnade-1
	#end
	}

// *****  C H A P E A U   D R O I T  *****
#declare PiedDroit=
merge{
	torus { // HautBase
		0.8, 0.2
		rotate -x*90
		translate  1.0*z
		}
	cylinder { // Base
		<0,0,1>, <0,0,0>, 1
		}
	}

#declare ChapeauDroit=
object{
	PiedDroit
	rotate <180,0,0>
	translate <0,0,1>
	}

// ***** P I E D    C A N N E L E *****
#declare PiedCannele=
union {
	#declare NbColonnade=12
	#while (NbColonnade >= 0 )
		cylinder { // 12 COLONNADES
			<0,0,1>, <0,0,0>, 1
			scale <0.25, 0.25, 2.0>
			translate  <-0.7, 0, 0>
			rotate <0,0, NbColonnade*30>
			}
		sphere { // 12 COLONNADES
			<0,0,0>,  1
			scale <0.25, 0.25, 0.25>
			translate  <-0.7, 0, 2.0>
			rotate <0,0, NbColonnade*30>
			}
    	#declare NbColonnade=NbColonnade-1
	#end

	cylinder {
			<0,0,1>, <0,0,0>, 1
			scale <1,1, .5>
			translate  <0, 0, 0>
			}
	}
#declare ChapeauCannele=
object{
	PiedCannele
	rotate <180,0,0>
	}

// *****  C H A P E A U   D O R I Q U E  *****
#declare ChapeauDorique1=
merge{
	box {  // o-o
		<-1, -.9, 0>, <1, .9, .8>
		scale <1, 1, 1>
		}
	cylinder {
		<0,1,0>, <0,0,0>, 1
		scale <.6,1.8,.6>
		translate <-1,-.9,.2>
		}
	cylinder { // Base
		<0,1,0>, <0,0,0>, 1
		scale <.6,1.8,.6>
		translate <1,-.9,.2>
		}
	}

#declare ChapeauDorique2=
merge{
	box {  // o-o
		<-1, -.9, 0>, <1, .9, .6>
		scale <1, 1, 1>
		translate<0,0,.1>
		}
	cylinder {
		<0,1,0>, <0,0,0>, 1
		scale <.5,1.8,.5>
		translate <-1,-.9,.2>
		}
	cylinder { // Base
		<0,1,0>, <0,0,0>, 1
		scale <.5,1.8,.5>
		translate <1,-.9,.2>
		}
	}

#declare ChapeauDorique=
union{
	difference{
		object { ChapeauDorique1 }
		object { ChapeauDorique2
			translate<0,-1.5,0>
			}
		object { ChapeauDorique2
			translate<0,1,0>
			}
		}
	box {  // o-o
		<-1, -.8, 0>, <1, .8, .2>
		scale <1, 1, 1>
		translate<0,0,.3>
		}
	cylinder { // Base
		<0,1,0>, <0,0,0>, 1
		scale <.3,1.6,.3>
		translate <1,-.8,.2>
		}
	cylinder { // Base
		<0,1,0>, <0,0,0>, 1
		scale <.3,1.6,.3>
		translate <-1,-.8,.2>
		}

}

// *****  A S S E M B L A G E   D E S   C O L O N N E S  *****
#declare COLONNE_DORIQUE=
union{
	object {PiedDroit}
	object {Pilier}
	object {
		ChapeauDorique
		translate <0,0,11>
		}
	}

#declare COLONNE_DROITE=
union{
	object {PiedDroit}
	object {Pilier}
	object {
		ChapeauDroit
		translate <0,0,10.8>
		}
	}


