
#include "colors.inc"
#include "textures.inc"
/*
#declare DETAIL=0

camera {  //  Camera camera1
location <0,-1,300>
//  location  <-45, -35, 20>
  direction <0.0,     0.0,  5.9980>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
//  look_at   <15, 5.000, 0>
look_at <0,0,0>
}

// *******  L I G H T S *******
  light_source {
    <16.107, -3.188, 9.122>
    color  red 1.000 green 1.000 blue 1.000
  }

  light_source {
    <18.500, 39.000, 14.000>
    color  red 1.000 green 1.000 blue 1.000
  }

  light_source {
    <-20, -20, 20>
    color  White
  }
*/
// *******  T E X T U R E S *******
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#if (DETAIL=1)
	#declare txtCarreBlanc=texture{T_Stone8}
	#declare txtCarreNoir=texture{T_Stone16}
	#declare txtLosange=texture{T_Stone5}
	#declare txtRectBord=texture{T_Stone12}
	#declare txtCarreBord=texture{T_Stone14}
	#declare txtCarreBord=texture{ pigment{ color rgb <.4,.4,.4> } 	finish { crand 0.1 ambient .4 diffuse .7 }}
#else
	#declare txtCarreBlanc=texture{ pigment{ color White } }
	#declare txtCarreNoir=texture{ pigment{ color Black } }
	#declare txtLosange=texture{ pigment{ color Red } }
	#declare txtRectBord=texture{ pigment{ color Pink } }
	#declare txtCarreBord=texture{ pigment{ color Orange } }
	#declare txtCarreBord=texture{ pigment{ color rgb <.4,.4,.4> } }
#end


// *******  O B J E T S *******
#declare CarreCarreau=
merge{
	box { // Cube5
		<-1, -1, -1>, <1, 1, 1>
		scale <2.0, 0.25, 0.5>
		rotate -270.0*z
		translate  <-4.8, 2.5, 0.5>
		}
	box { // Cube4
		<-1, -1, -1>, <1, 1, 1>
		scale <2.0, 0.25, 0.5>
		rotate -180.0*z
		translate  <-2.5, 4.8, 0.5>
		}
	box { // Cube3
		<-1, -1, -1>, <1, 1, 1>
		scale <2.0, 0.25, 0.5>
		rotate -90.0*z
		translate  <-0.25, 2.5, 0.5>
		}
	box { // Cube002
		<-1, -1, -1>, <1, 1, 1>
		scale <2.0, 0.25, 0.5>
		translate  <-2.5, 0.25, 0.5>
		}
	}

#declare CoinCarreau=
intersection{
	difference{
		cylinder { // Cylndr001
			<0,0,1>, <0,0,0>, 1
			}
		cylinder { // Cylndr002
			<0,0,1>, <0,0,0>, 1
			scale <0.5, 0.5, 1.2>
			translate<0,0,-.1>
			}

		}
	box { // Cube001
		<-1, -1, -1>, <1, 1, 1>
		translate  <-1.0, 1.0, 0.5>
		}
	}

// ****** DESSIN SUR CARREAUX **********
#declare CARREAU=
merge{
	object{	CarreCarreau}
	object{
		CoinCarreau
		}
	object{
		CoinCarreau
		rotate<0,0,90>
		translate<0,5,0>
		}
	object{
		CoinCarreau
		rotate<0,0,180>
		translate<-5,5,0>
		}
	object{
		CoinCarreau
		rotate<0,0,270>
		translate<-5,0,0>
		}
	}






// ****** CARREAUX DE BASE **********
#declare Tile =
merge{
//	box {
//		<-1, -1, -1>, <1, 1, 1>
//		translate  <-1.0, 1.0, 0.5>
//		}
	superellipsoid {
		<0.1, 0.2>
		scale <2.4, 2.4, .5>
		}
	object {
		CARREAU
		scale <4/5,4/5,.5>
		translate<2,-2,.00001>
		texture{Gold_Metal}
		}
	scale<1/2.5,1/2.5,1>
	}

// ****** CARREAUX HEXAGONAUX**********
#declare TileHEX =		// *** HEXAGONE
#if (DETAIL=1)
intersection{
	superellipsoid {
		<0.1, 0.2>
		scale <5, sqrt(2), .5>
		}
	superellipsoid {
		<0.1, 0.2>
		#declare DimDiag=2-(cos(radians(45))*((2*sqrt(2))-2))/2
		scale <DimDiag, DimDiag, .5>
		rotate<0,0,45>
		}
	}
#else
union{
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1, 1, .5>
		rotate<0,0,45>
		translate<1,0,0>
		}
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1, 1, .5>
		rotate<0,0,45>
		translate<-1,0,0>
		}
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1,sqrt(2), .5>
		}
	}
#end

#declare TileHEXsub =		// ** CARRE DE JONCTION
#if (DETAIL=1)
	superellipsoid {
		<0.1, 0.2>
		scale <1,1, .5>
		rotate<0,0,45>
		}
#else
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1, 1, .5>
		rotate<0,0,45>
		}
#end

#declare TileHEXRectTour =		// ** RECTANGLE DE TOUR
#if (DETAIL=1)
	superellipsoid {
		<0.1, 0.2>
		scale <1+sqrt(2),1, .5>
		}
#else
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1+sqrt(2), 1, .5>
		}
#end

#declare TileHEXCarreTour =		// ** CARRE DE TOUR
#if (DETAIL=1)
	superellipsoid {
		<0.1, 0.2>
		scale <1,1, .5>
		}
#else
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1, 1, .5>
		}
#end


#declare TileHEXDemi =		// ** Demi Hexa
#if (DETAIL=1)
intersection{
	object{TileHEX}
	superellipsoid {
		<0.1, 0.2>
		scale <5,1, .5>
		translate<0,1,0>
		}
	}
#else
intersection{
	object{TileHEX}
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <5, 1, .5>
		translate<0,1,0>
		}
	}
#end

#declare TileHEXsubDemi =		// ** Demi Carre de jonction
#if (DETAIL=1)
intersection{
	object{TileHEXsub}
	superellipsoid {
		<0.1, 0.2>
		scale <5,1, .5>
		translate<0,1,0>
		}
	}
#else
intersection{
	object{TileHEXsub}
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <5, 1, .5>
		translate<0,1,0>
		}
	}
#end

#declare TileHEXsubQuart =		// ** Quart de Carre de jonction
#if (DETAIL=1)
intersection{
	object{TileHEXsub}
	superellipsoid {
		<0.1, 0.2>
		scale <1,1, .5>
		translate<1,1,0>
		}
	}
#else
intersection{
	object{TileHEXsub}
	box {
		<-1, -1, -1>, <1, 1, 1>
		scale <1, 1, .5>
		translate<1,1,0>
		}
	}
#end



// ****** ASSEMBLAGE CARRELAGE **********
#declare ETile = 0   // EspacementCarreaux
#declare YOff = 2*sqrt(2)+ETile
#declare OffLC= 1+sqrt(2)+ETile/2 // Offset entre un Losange et un Carr
#declare OffLL= 2 * OffLC 			//Offset entre 2 Losange sur mme Ligne
#declare OffLbLH= OffLC+1 // Offset entre LosageBas et LosangeHaut


#declare Row = union {
	object { TileHEX	translate <0,						0,0> }
	object { TileHEX	translate <2*OffLC,					0,0> }
	object { TileHEXsub	translate <3*OffLC + 1*OffLbLH,		0,0> texture{txtCarreNoir}}
	object { TileHEX	translate <4*OffLC + 2*OffLbLH,		0,0> }
	object { TileHEX	translate <6*OffLC + 2*OffLbLH,		0,0> }
	object { TileHEXsub	translate <7*OffLC + 3*OffLbLH,		0,0> texture{txtCarreNoir}}
	object { TileHEXsubDemi rotate z*90
						translate <9*OffLC + 3*OffLbLH ,	0,0> }

	object { TileHEXsubDemi rotate -z*90
						translate <-1*OffLC,				YOff*.5,0> }
	object { TileHEXsub	translate <1*OffLC,					YOff*.5,0> texture{txtCarreBlanc}}
	object { TileHEX	translate <2*OffLC + 1*OffLbLH,		YOff*.5,0> }
	object { TileHEX	translate <4*OffLC + 1*OffLbLH,		YOff*.5,0> }
	object { TileHEXsub	translate <5*OffLC + 2*OffLbLH,		YOff*.5,0> texture{txtCarreBlanc}}
	object { TileHEX	translate <6*OffLC + 3*OffLbLH,		YOff*.5,0> }
	object { TileHEX	translate <8*OffLC + 3*OffLbLH,		YOff*.5,0> }
	}

#declare RowBas = union {
	object { TileHEXsubQuart translate <-1*OffLC,			YOff*.5,0> }
	object { TileHEXsubDemi	translate <1*OffLC,				YOff*.5,0> texture{txtCarreBlanc}}
	object { TileHEXDemi	translate <2*OffLC + 1*OffLbLH,	YOff*.5,0> }
	object { TileHEXDemi	translate <4*OffLC + 1*OffLbLH,	YOff*.5,0> }
	object { TileHEXsubDemi	translate <5*OffLC + 2*OffLbLH,	YOff*.5,0> texture{txtCarreBlanc}}
	object { TileHEXDemi	translate <6*OffLC + 3*OffLbLH,	YOff*.5,0> }
	object { TileHEXDemi	translate <8*OffLC + 3*OffLbLH,	YOff*.5,0> }
	}

#declare RowHaut = union {
	object { TileHEX	translate <0,						0,0> }
	object { TileHEX	translate <2*OffLC,					0,0> }
	object { TileHEXsub	translate <3*OffLC + 1*OffLbLH,		0,0> texture{txtCarreNoir}}
	object { TileHEX	translate <4*OffLC + 2*OffLbLH,		0,0> }
	object { TileHEX	translate <6*OffLC + 2*OffLbLH,		0,0> }
	object { TileHEXsub	translate <7*OffLC + 3*OffLbLH,		0,0> texture{txtCarreNoir}}
	object { TileHEXsubDemi rotate z*90
						translate <9*OffLC + 3*OffLbLH ,	0,0> }

	object { TileHEXsubQuart rotate -z*90	translate <-1*OffLC,			YOff*.5,0> }
	object { TileHEXsubDemi	rotate -z*180	translate <1*OffLC,				YOff*.5,0> texture{txtCarreBlanc}}
	object { TileHEXDemi	rotate -z*180	translate <2*OffLC + 1*OffLbLH,	YOff*.5,0> }
	object { TileHEXDemi	rotate -z*180	translate <4*OffLC + 1*OffLbLH,	YOff*.5,0> }
	object { TileHEXsubDemi	rotate -z*180	translate <5*OffLC + 2*OffLbLH,	YOff*.5,0> texture{txtCarreBlanc}}
	object { TileHEXDemi	rotate -z*180	translate <6*OffLC + 3*OffLbLH,	YOff*.5,0> }
	object { TileHEXDemi	rotate -z*180	translate <8*OffLC + 3*OffLbLH,	YOff*.5,0> }
	}



#declare EHoriz=.08
#declare RowTourHoriz = union {
	object { TileHEXCarreTour	translate <-OffLC-1-ETile,0,0>		texture{txtCarreBord}}
	object { TileHEXRectTour	translate <0,		0,0> }
	object { TileHEXRectTour	translate <1*(OffLL+EHoriz),	0,0> }
	object { TileHEXRectTour	translate <2*(OffLL+EHoriz),	0,0> }
	object { TileHEXRectTour	translate <3*(OffLL+EHoriz),	0,0> }
	object { TileHEXRectTour	translate <4*(OffLL+EHoriz),	0,0> }
	object { TileHEXRectTour	translate <5*(OffLL+EHoriz),	0,0> }
	object { TileHEXRectTour	translate <6*(OffLL+EHoriz),	0,0> }
	object { TileHEXCarreTour	translate <6*(OffLL+EHoriz)+1+OffLC+ETile,	0,0> 	texture{txtCarreBord}}
	texture{txtRectBord}
	}

#declare RowTourVert = union {
	object { TileHEXRectTour	translate <0,					0,0> }
	object { TileHEXRectTour	translate <1*(OffLL+EHoriz),	0,0> }
	object { TileHEXRectTour	translate <2*(OffLL+EHoriz),	0,0> }
	texture{txtRectBord}
	}



#declare carrelage= union{
	object { RowTourVert	rotate z*90	translate <-OffLC-EHoriz-1-ETile/2,(1+sqrt(2))/3+ETile,0> }
	object { RowTourHoriz 	translate <0,-OffLC-ETile,0> }
	object { RowBas			translate <0,-YOff,0> }
	object { Row			translate y*YOff*0 }
	object { Row			translate y*YOff*1 }
	object { Row			translate y*YOff*2 }
	object { Row			translate y*YOff*3 }
	object { RowHaut		translate y*YOff*4 }
	object { RowTourHoriz	translate <0,YOff*4+OffLC+ETile,0> }
	object { RowTourVert	rotate z*90	translate <6*(OffLL+EHoriz)+1+OffLC+ETile,(1+sqrt(2))/3+ETile,0> }
//	pigment { White_Marble }
//	finish { phong 1 phong_size 50 reflection .35 }
}

/*
object {
	carrelage
	texture{txtLosange}
//	rotate <0,0,45>
	}
object {
	carrelage
	texture{txtLosange}
//	rotate <0,0,45>
	}
*/

box { <-.5,-.5,0>,<.5,.5,.45>
	pigment { color Blue}//rgb <.6,.6,.6> }
	translate <0,0,.2>
	}
