#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "chars.inc"
#include "crystal.inc"

camera {
   location  <0, 10,-35>
   look_at   <0, 6, 0>
//location <10, 40, 5>
//look_at <10, 0, 5.1>
}

// Bright light to left and above main screen
light_source {<-30, 25, -10> color White}

// Bright light to right and above main screen
light_source {<30, 25, -10> color White}


background { colour rgb <0.9, 0.9, 0.7> }


// ---------------------------------------

object {Baby_Bird
       rotate <0, 25, 0>
       translate <-11, 0, 0>}

object {Pig
       rotate <0, -15, 0>
       translate <10, -2, 0> }

object {Crystal_Sphere
       rotate <0, 5, 0>
       translate <0, 11.7, 10>
}
object {Hedgehog
       rotate <0, 70, 0>
       translate <20, 7, 10>
}
object {Bell
       scale 1.2
       translate <-20, 9.7, 10>
}       

// cabinet
box {<-55, -5, -8>, <55, -20, 15>
    texture {Red_Velvet} }
box {<-5, -5, -5>, <5, 7, 5>
    rotate <0, 45, 0>
    translate <0, 0, 10>
    texture {Red_Velvet} }
box {<-5, -5, -5>, <5, 7, 5>
    rotate <0, 45, 0>
    translate <-20, 0, 10>
    texture {Red_Velvet} }
box {<-5, -5, -5>, <5, 7, 5>
    rotate <0, 45, 0>
    translate <20, 0, 10>
    texture {Red_Velvet} }

object {Plaque
       translate <-3.5, -8, -8 >}

// cabinet back mirror
box {<-45, -6, 15>, <45, 30, 16>
    texture {
    pigment {
            hexagon color Gray20, color Gray30, color Gray40
            rotate <-90,0, 0>
            scale 0.5}
    finish {
        ambient 0.1
        diffuse 0.7
        brilliance 2.0
        reflection 0.8
        phong 0.8
        phong_size 120
        metallic
        }
     } // end texture
} // end mirror


// Scenary - out of main scene, but reflected in mirror

// Lighting rail
cone {<-30, 25, -9>, 2.5
      <-30, 32, -13>, 2
     open
     pigment {color Black}
}
cone {<30, 25, -9>, 2.5
      <30, 32, -13>, 2
      open
     pigment {color Black}
}
cylinder {<-35, 32, -13>, <35, 32, -13>, 1
         pigment {color Black}
}


