// IRTC Feb 97 - ELECPANL.INC (Electrical panel to hold various voltages)

#declare label_p12v =
union {
  box { <0, 0, -0.0625> <2, 1, 0>
    texture { pigment { White } finish { ambient 0.8 }  }
  }
  difference {
    box { <0, 0, -0.07> <2, 1, -0.0675> }
    text { ttf "crystal.ttf", "+12V", 1, 0 scale 0.8 translate <0.2, 0.2, -0.2> }
    texture { pigment { Black } }
  }
}

#declare label_m12v =
union {
  box { <0, 0, -0.0625> <2, 1, 0>
    texture { pigment { White } finish { ambient 0.8 }  }
  }
  difference {
    box { <0, 0, -0.07> <2, 1, -0.0675> }
    text { ttf "crystal.ttf", "-12V", 1, 0 scale 0.8 translate <0.2, 0.2, -0.2> }
    texture { pigment { Black } }
  }
}

#declare label_GND =
union {
  box { <0, 0, -0.0625> <1.5, 1, 0>
    texture { pigment { White } finish { ambient 0.8 }  }
  }
  difference {
    box { <0, 0, -0.07> <1.5, 1, -0.0675> }
    text { ttf "crystal.ttf", "GND", 1, 0 scale 0.8 translate <0.2, 0.2, -0.2> }
    texture { pigment { Black } }
  }
}

#declare voltage_plug =
difference {
  cylinder { <0, 0, -0.5> <0, 0, 0>, 0.25 }
  cylinder { <0, 0, -0.6> <0, 0, 0.1>, 0.09375 }
}

#declare socket_hole =
difference {
  cylinder { <0, 0, -0.125> <0, 0, 0.125>, 0.6875 }
  plane { y, 0 translate <0, -0.5625, 0> }
  plane { -y, 0 translate <0, 0.5625, 0> }
}

#declare socket =
difference {
  object { socket_hole }
  sphere { <0, 0, 0>, 0.1875 scale <0.5, 1, 2> translate <-0.1875, 0.125, 0> }
  sphere { <0, 0, 0>, 0.1875 scale <0.5, 1, 2> translate <0.1875, 0.125, 0> }
  difference {
    cylinder { <0, 0, -1> <0, 0, 2>, 0.09375 scale <1, 1.5, 1> }
    plane { y, 0 }
    translate <0, -0.4375, 0>
  }
  translate <0, 0, -0.125>
}

#declare socket_plate =
difference {
  box { <-1.375, -2.5, -0.125> <1.375, 2.5, -0> }
  object { socket_hole scale <1.05, 1.01, 2> translate <0, 0.8125, 0> }
  object { socket_hole scale <1.05, 1.01, 2> translate <0, -0.8125, 0> }
}

#declare sockets_and_plate =
union {
  object { socket_plate }
  object { socket translate 0.8125 * y }
  object { socket translate -0.8125 * y }
}

#declare Electrical_panel =
union {
  difference {
    box { <-50, 0.75, 12> <50, 8.75, 18> }
    box { <-1.3, -2.4, -1> <1.3, 2.4, 3> translate <0, 5, 12> }
    box { <-1.3, -2.4, -1> <1.3, 2.4, 3> translate <-24, 5, 12> }
    box { <-1.3, -2.4, -1> <1.3, 2.4, 3> translate <24, 5, 12> }
      texture { pigment { Blue } }
      texture { Glass2  finish { reflection 0.2 } }
  }
  box { <-50, 8.75, 11.75> <50, 9, 12.5>
      texture { pigment { Blue } }
      texture { Glass2  finish { reflection 0.2 } }
  }
  object { sockets_and_plate translate <0, 5, 12>
    texture { pigment { DarkBrown } finish { Glossy } }
  }
  object { sockets_and_plate translate <-24, 5, 12>
    texture { pigment { DarkBrown } finish { Glossy } }
  }
  object { sockets_and_plate translate <24, 5, 12>
    texture { pigment { DarkBrown } finish { Glossy } }
  }
  object { voltage_plug translate <-18, 6.5, 12>
    texture { pigment { Red } finish { ambient 0.8 } }
  }
  object { voltage_plug translate <-18, 5, 12>
    texture { pigment { Green } finish { ambient 0.8 } }
  }
  object { voltage_plug translate <-18, 3.5, 12>
    texture { pigment { Black } finish { ambient 0.8 } }
  }

  object { label_p12v translate <-17, 6, 12> }
  object { label_GND translate <-17, 4.5, 12> }
  object { label_m12v translate <-17, 3, 12> }

  object { voltage_plug translate <6, 6.5, 12>
    texture { pigment { Red } finish { ambient 0.8 } }
  }
  object { voltage_plug translate <6, 5, 12>
    texture { pigment { Green } finish { ambient 0.8 } }
  }
  object { voltage_plug translate <6, 3.5, 12>
    texture { pigment { Black } finish { ambient 0.8 } }
  }

  object { label_p12v translate <7, 6, 12> }
  object { label_GND translate <7, 4.5, 12> }
  object { label_m12v translate <7, 3, 12> }

  object { voltage_plug translate <30, 6.5, 12>
    texture { pigment { Red } finish { ambient 0.8 } }
  }
  object { voltage_plug translate <30, 5, 12>
    texture { pigment { Green } finish { ambient 0.8 } }
  }
  object { voltage_plug translate <30, 3.5, 12>
    texture { pigment { Black } finish { ambient 0.8 } }
  }

  object { label_p12v translate <31, 6, 12> }
  object { label_GND translate <31, 4.5, 12> }
  object { label_m12v translate <31, 3, 12> }
}

