// IRTC Textures - Taken from POV-Ray Standard colors and textures include files

#declare White = pigment { color rgb <1,1,1> }
#declare Blue = pigment { color rgb <0,0,1> }
#declare Black = pigment { color rgb <0,0,0> }
#declare Red = pigment { color rgb <1,0,0> }
#declare Green = pigment { color rgb <0,1,0> }
#declare Yellow = pigment { color rgb <1,1,0> }
#declare Clear = rgbf 1 
#declare Brown = pigment { color rgb <0.647059, 0.164706, 0.164706> }
#declare VeryDarkBrown = color red 0.35 green 0.16 blue 0.14
#declare DarkBrown = color red 0.36 green 0.25 blue 0.20

// Dull creates a large, soft highlight on the object's surface
#declare Dull = finish {specular 0.5 roughness 0.15}

// Shiny creates a small, tight highlight on the object's surface
#declare Shiny = finish {specular 1 roughness 0.001}

// Phong highlights are less "realistic" than specular, but useful
// for different effects.
// Dull creates a large, soft highlight on the object's surface
#declare Phong_Dull = finish {phong 0.5  phong_size 1}

// Shiny creates a small, tight highlight on the object's surface
#declare Phong_Shiny = finish {phong 1  phong_size 200}

// Very shiny with very tight highlights and a fair amount of reflection
#declare Glossy = finish {specular 1 roughness 0.0001 reflection 0.13}
#declare Phong_Glossy = finish {phong 1 phong_size 300 reflection 0.13}

// Probably more of a "Plexiglas" than glass
#declare Glass2 = 
texture {
    pigment { color Clear }
    finish {
        ambient 0
        diffuse 0
        reflection 0.5
        refraction 0.85
        ior 1.5
        phong 0.3
        phong_size 60
    }
}

// Light tan wood with brown rings.
#declare Tan_Wood = 
pigment {
    wood
    turbulence 0.1
    color_map {
        [0.0, 0.8 color rgb <0.88, 0.60, 0.30>
                  color rgb <0.88, 0.60, 0.30>]
        [0.8, 1.0 color rgb <0.60, 0.40, 0.20>
                  color rgb <0.40, 0.30, 0.20>]
    }
}

#declare Texture0 = /* Planar image map */
texture {pigment{image_map { tga "lbimage.tga" map_type 0 once interpolate 2 } } }

#declare Texture1 = /* Planar image map */
texture {pigment{image_map { tga "pcimage.tga" map_type 0 once interpolate 2 } }
  finish { ambient 0.2 }
}

#declare Texture2 = /* Planar image map */
texture {pigment{image_map { gif "radelec2.gif" map_type 0 once interpolate 2 } } }

#declare Texture3 = /* Planar image map */
texture {pigment{image_map { tga "esimage.tga" map_type 0 once interpolate 2 } } }

#declare Tex =
texture { pigment { Blue } finish { ambient 0.6 } }

#declare Tex2 =
texture { pigment { White } finish { ambient 0.6 } }

#declare Tex3 =
texture { pigment { Black } finish { ambient 0.6 } }


