// Persistence of Vision Ray Tracer Scene Description File
// File: fairytal.pov
// Vers: 3.00e Watcom Win32
// Desc: Fairy Tale
// Date: February 8, 1997
// Auth: Sonya Roberts
// Note: Some classic imagery from fairy tales


// ==== Standard Includes ====
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "METALS.inc"
#include "SHAPES.inc"
#include "STONES.inc"
#include "STONES2.inc"
#include "WOODMAPS.inc"
#include "WOODS.inc"
#include "GLASS.inc"
#include "CUSTOM.inc"
#include "JEWELS.inc"

camera {
	location	<0,10,-120>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,12,0>
}

light_source {
	<0,30,-175>,
	color Gray20
//	color White
}

object {
	plane {<0,1,0>,0}
	texture {T_Dark_Green_Glass}
	normal {bumps .2}
	translate <-100,0,-200>
}

object {
	difference {
		union {
			box {<-600,-100,-600>,<600,.5,600>	pigment {color Tan}}
			box {<-600,.4,-600>,<600,1,0>		pigment {color SpringGreen}	finish {crand .4}}
			box {<-600,.4,0>,<600,1,600>		pigment {color SpringGreen}}
		}
		sphere {<0,0,0>,1	scale <100,20,100>}
	}
}

#declare Cavern=
object {
	height_field {
		pot "cavern.pot"
		hollow
		translate <-.5,-.01,-.5>
		scale <500,800,500>
	}
	pigment {color Tan}
	finish {
		ambient .2
		reflection 0
		phong 0
	}
}

#declare Staircutter=
object {
	difference {
		box {<-2.5,0,0>,<2.5,4,7>}
		box {<-2.6,-.1,-.1>,<2.6,.75,7.1>}
		box {<-2.61,.49,1.25>,<2.61,1,7.11>}
		box {<-2.62,.99,2.5>,<2.62,1.5,7.12>}
		box {<-2.63,1.49,3.75>,<2.63,2,7.13>}
		box {<-2.64,1.99,5>,<2.64,2.5,7.14>}
		box {<-2.65,2.49,6.25>,<2.65,3.1,7.15>}
	}
}

#declare Island=
object {
	difference {
		cone {<0,-21,0>,50,<0,3,0>,50}
		object {Staircutter	translate <0,0,-50>}
	}
	texture {T_Stone9	scale <5,5,5>}
}

#declare Forest=
union {
	#debug "Planting a forest full of trees...\n"
	#declare R4=seed(3)
	#declare Count=1
	#while (Count<=400)
		object {
			union {
				cone {
					<0,0,0>,1,<0,10,0>,.75
					pigment {color SemiSweetChoc*(.5+(rand(R4)*.7))}
				}
				sphere {
					#declare Size=7+(rand(R4)*6)
					<0,Size,0>,Size
					scale <1,.8+(rand(R4)*.6),1>
					translate <0,9,0>
				}
				#declare Size=(.8+(rand(R4)*.4))*.25
				scale <Size,Size*.3+(rand(R4)*.4),Size>
				pigment {color PaleGreen*(.4+(rand(R4)*1.6))}
				finish {crand .5}
			}
		translate <-(110+(rand(R4)*50)),0,0>
		rotate y*(10+(rand(R4)*340))
		}
		#declare Count=Count+1
	#end
}

#declare Spindle=
object {
	union {
		difference {
			intersection {
				box {<-.3,0,-.3>,<.3,2,.3>}
				box {<-.3,-.01,-.3>,<.3,2.01,.3>	rotate y*45}
			}
			#declare C1=1
			#while (C1<=8)
				box {
					<-.4,-.1,-.4>,<.4,2.1,0>
					rotate x*-10
					translate <0,0,-.1>
					rotate y*(22.25+(45*C1))
				}
				box {
					<-.4,-2.1,-.4>,<.4,.1,0>
					rotate x*20
					translate <0,2,-.1>
					rotate y*(22.25+(45*C1))
				}
				#declare C1=C1+1
			#end
		texture {Diamond}
		}
		cylinder {<0,0,0>,<0,.1,0>,.3	texture {Obsidian}}
		sphere {<0,2.2,0>,.25		texture {T_Gold_5C}}
	}
}

#declare Railing1=
object {
	#declare A1=1
	union {
		#while (A1<=178)
			object {
				Spindle
				translate <0,0,-100.5>
				rotate y*(3+((A1-1)*2))
			}
			#declare A1=A1+1
		#end
		difference {
			torus {100.5,.225	translate <0,2.2,0>}
			box {<-5,1.75,-105>,<5,4,-90>}
			texture {Obsidian}
		}
		translate <0,1,0>
	}
}

#declare Railing2=
object {
	#declare A1=1
	union {
		#while (A1<=69)
			object {
				Spindle
				translate <0,0,-49.5>
				rotate y*(10+((A1-1)*5))
			}
			#declare A1=A1+1
		#end
		difference {
			torus {49.5,.225	translate <0,2.2,0>}
			box {<-3.75,1.75,-51>,<3.75,4,-30>}
			texture {Obsidian}
		}
		union {
			sphere {<-3.75,2.2,-50>,.4}
			sphere {<3.75,2.2,-50>,.4}
			texture {T_Gold_5C}
		}
		translate <0,3,0>
	}
}

#declare CrystalLight=
union {
	object {
		union {
			difference {
				sphere {<0,1,0>,1}
				scale <1,1.5,1>
				texture {T_Glass2}
			}
			difference {
				union {
					torus {.8,.2	rotate x*90	translate <0,.8,0>}
					torus {.8,.2	rotate z*90	translate <0,.8,0>}
				}
				sphere {<0,1,0>,1}
				scale <1,1.5,1>
			}
			torus {.25,.2	texture {T_Gold_5D}	translate <0,-.1,0>}
			torus {.15,.1	texture {T_Gold_5D}	translate <0,-.35,0>}
			cylinder {<0,-10.1,0>,<0,0,0>,.15}
			texture {T_Chrome_3B}
		}
	}
	light_source {
		<0,1.5,0>,
		color White
		fade_distance 2
		fade_power 1
	}
	translate <0,10,0>
}

#declare Palace=
object {
	union {
		julia_fractal {
			<-0.1,-0.053,-0.83,-0.025>
			quaternion
			sqr
			max_iteration 9
			precision 18
			rotate x*90
			translate <1.25,1,0>
			rotate y*-90
		}
		julia_fractal {
			<-0.1,-0.053,-0.83,-0.025>
			quaternion
			sqr
			max_iteration 9
			precision 18
			rotate x*90
			translate <1.25,1,0>
			rotate y*-210
		}
		julia_fractal {
			<-0.1,-0.053,-0.83,-0.025>
			quaternion
			sqr
			max_iteration 9
			precision 18
			rotate x*90
			rotate y*30
			translate <1.25,1,0>
		}
	}
	texture {T_Glass1}
//	pigment {color Gray50}
	scale <15,30,15>
}

#declare Bonfire=
union {
	object {
		sphere {
			<0,0,0>, 1
			pigment {color rgbt <1,1,1,1>}
			halo {
				emitting
				spherical_mapping
				linear
				turbulence .91
				color_map {
					[ 0.0 color rgbt <1,0,0,1>]
					[ 0.5 color rgbt <1,1,0,-1>]
					[ 1.0 color rgbt <1,0,0,1>]
				}
				frequency 2
				samples 20
				scale 0.5
			}
			hollow
			scale <7,16,7>
		}
	}
	object {
		intersection {
			difference {
				sphere {<0,6,0>,9.1}
				sphere {<0,6.1,0>,9}
			}
			box {<-5.2,0,-5.2>,<5.2,1.25,5.2>}
			hollow
		}
		texture {T_Stone10}
	}
	light_source {
		<0,9,0>,
		color Yellow
		fade_distance 4.5
		fade_power 1
	}
}

// ---- INCLUDE ADDITIONAL OBJECT ----
#declare True=1
#declare False=0
#declare Huh=seed(40)
#include "tree1.pov"
#include "tree2.pov"
#include "tree3.pov"
#include "tree4.pov"
#include "swan.pov"

// ---- ASSEMBLE SCENE ELEMENTS ----
#debug "Assembling scene elements...\n"
object {Cavern}
object {Island}
object {Forest}
object {Railing1}
object {Railing2}
object {CrystalLight	rotate y*(rand(Huh)*360)	translate <-3.75,1,-49.5>}
object {CrystalLight	rotate y*(rand(Huh)*360)	translate <3.75,1,-49.5>}
object {CrystalLight	rotate y*(rand(Huh)*360)	translate <-5.5,1,-104.5>}
object {CrystalLight	rotate y*(rand(Huh)*360)	translate <5.5,1,-104.5>}
object {CrystalLight	rotate y*(rand(Huh)*360)	translate <-10,1,-130>}
object {CrystalLight	rotate y*(rand(Huh)*360)	translate <10,1,-130>}
object {TopazTree	translate <8.5,.9,-105>}
object {AmethystTree	rotate y*-30	translate <-11,.9,-102>}
object {RubyTree	translate <7.5,.9,-110>}
object {AmberTree	translate <-8,.9,-108>}
object {Swan		texture {WhiteOpal	scale <.75,.75,.75>}	rotate y*35	translate <-4,3,-93>}
object {Swan		texture {WhiteOpal	scale <.5,.5,.5>}	rotate y*-95	translate <9,3,-55>}
object {Palace		translate <0,3,0>}
object {Bonfire		translate <0,3,0>}

fog {
	fog_type 2
	distance 150
	color Gray60
	turbulence .75
	fog_offset .25
	fog_alt 4.5
}

fog {
	fog_type 2
	distance 50
	color Gray90
	turbulence .75
	fog_offset .001
	fog_alt .75
}
