/*                    Units are expressed in centimeters          */

#include "colors.inc"
#include "golds.inc"
#include "woods.inc"
/*-------------------------------------------------CAMERA--------------*/
camera {
   location <110,130,-60>
   look_at <45,100,50>
}
/*-------------------------------------------------BACKGROUNT---------*/
background {color Cyan}
/*-------------------------------------------------LIGHT--------------*/
light_source {<-10,200,-200> color White}           /* Internal light */
light_source {<-700,210,40> color rgb<1,1,0.3>}     /* External light */
/*-------------------------------------------------WOOD---------------*/
#declare legno = 
   texture {
      T_Wood35 
      finish { specular 0.15 roughness 0.025 ambient 0.25 reflection 0.05}
      rotate y*90 
      rotate <10, 0, 15> 
      scale <2,1,1> 
      translate -3*x
   }
/*-------------------------------------------------TABLE--------------*/
box {
   <0,95,0>,<100,100,100>
   texture {legno}
}
/*-------------------------------------------------HALF LINE----------*/
box {
   <-0.1,97.4,-0.1>,<100.1,97.6,100.1>
   texture {
      pigment {color Black}
      finish {phong 1 ambient 0.4 diffuse 0.8}
   }
}

/*-------------------------------------------------HIGH FOOT 1--------*/
box {
   <5,80,5>,<15,95,15>
   texture {legno}
}
/*-------------------------------------------------HIGH FOOT 2--------*/
box {
   <85,80,5>,<95,95,15>
   texture {legno}
}
/*-------------------------------------------------HIGH FOOT 3--------*/
box {
   <5,80,85>,<15,95,95>
   texture {legno}
}
/*-------------------------------------------------HIGH FOOT 4--------*/
box {
   <85,80,85>,<95,95,95>
   texture {legno}
}
/*--------------------------------------------------LOW FOOT 1--------*/
cylinder {
   <10,0,10>,<10,80,10>,4.5
   texture {legno}
}
/*--------------------------------------------------LOW FOOT 2--------*/
cylinder {
   <90,0,10>,<90,80,10>,4.5
   texture {legno}
}
/*--------------------------------------------------LOW FOOT 3--------*/
cylinder {
   <10,0,90>,<10,80,90>,4.5
   texture {legno}
}
/*--------------------------------------------------LOW FOOT 4--------*/
cylinder {
   <90,0,90>,<90,80,90>,4.5
   texture {legno}
}
/*--------------------------------------------------CERNIGLIA---------*/
#declare cerniglia=union {
   cylinder {
      <0,97.5,0>,<5,97.5,0>,0.3
      texture {T_Gold_1A}
   }
   box {
      <0,97.5,-0.1>,<5,99,0>
      texture {T_Gold_1B}
   }
   box {
      <0,96,-0.1>,<5,97.5,0>
      texture {T_Gold_1B}
   }
}
object {
   cerniglia
   translate <20,0,0>
}
object {
   cerniglia
   translate <75,0,0>
}
/*--------------------------------------------------FLOOR-------------*/
box {
   <-400,-10,-500>,<500,0,600>
   texture {
      pigment {checker color White color Black}
      finish {phong 1 ambient 0.4 diffuse 0.7 reflection 0.08}
      scale <20,1,20>
   }
}
/*--------------------------------------------------WALL 1------------*/
difference {
   box {
      <-300,0,-500>,<-280,500,500>
      texture {
         pigment {color rgb <1,1,0.7>}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   box {                                          /* WINDOWS */
      <-350,100,200>,<-250,200,300>
      texture {legno}
   }
   cylinder {
      <-350,200,250>,<-250,200,250>,50
      texture {legno}
   }
}
/*--------------------------------------------------WALL 2------------*/
box {
   <-500,0,500>,<500,500,520>
   texture {
      pigment {color rgb <1,1,0.7>}
      finish {ambient 0.4 diffuse 0.7}
   }
}
/*--------------------------------------------------COLONNA-----------*/
box {
   <-280,0,450>,<-190,500,500>
   texture {
      pigment {color rgb <1,1,0.7>}
      finish {ambient 0.4 diffuse 0.7}
   }
}
/*--------------------------------------------------ZOCCOLETTO 1------*/
box {
   <-280,0,-500>,<-279,10,500>
   texture {legno}
}
/*--------------------------------------------------ZOCCOLETTO 2------*/
box {
   <-500,0,499>,<500,10,500>
   texture {legno}
}
/*--------------------------------------------------QUADRO------------*/
box {
   <0,0,0>,<150,70,1>
   texture {
      pigment {
         image_map {
            gif "tramonto.gif"
         }
         scale <150,70,1>
      }
   }
   translate <-50,150,499>
}
cylinder {
   <-50,150,499>,<100,150,499>,2                         /* Cornice */
   texture {legno}
}
cylinder {
   <-50,220,499>,<100,220,499>,2                         /* Cornice */
   texture {legno}
}
cylinder {
   <-50,220,499>,<-50,150,499>,2                         /* Cornice */
   texture {legno}
}
cylinder {
   <100,220,499>,<100,150,499>,2                         /* Cornice */
   texture {legno}
}
/*--------------------------------------------------BICCHIERE---------*/
#declare bicchiere=
union {
   cylinder {
      <0,0,0>,<0,2,0>,4
      texture {
         pigment {color rgbf<1,1,1,0.8>}
         finish {reflection 0.1 refraction 1 ior 1.5 phong 1}
      }
   }
   cylinder {
      <0,2,0>,<0,12,0>,4
      open
      texture {
         pigment {color rgbf<1,1,1,0.8>}
         finish {reflection 0.1 refraction 1 ior 1 phong 1}
      }
   }
}
/*------------------------------------------DISPONI BICCHIERI--------*/
object {
   bicchiere
   translate <15,100,20>
}
object {
   bicchiere
   translate <25,100,35>
}
object {
   bicchiere
   translate <45,100,35>
}
object {
   bicchiere
   translate <75,100,40>
}
/*--------------------------------------------------BOTTIGLIA---------*/
declare bottiglia=
union {
   sor {
      33,
      <0,0>,<4.5,0>,<4.5,1>,<4.5,2>,<4.5,3>,<4.6,4>,<4.6,5>,<4.6,6>,<4.6,7>,
      <4.7,8>,<4.8,9>,<4.8,10>,<4.8,11>,<4.8,12>,<4.9,13>,<4.9,14>,<4.9,15>,
      <5.0,16>,<4.7,17>,<4.45,18>,<4,19>,<3.6,20>,<3.1,21>,<2.8,22>,<2.5,23>,
      <2.3,24>,<2.2,25>,<2.4,26>,<2.2,27>,<2.1,28>,<2,29>,<2,30>,<0,30>
      texture {
         pigment {color rgbf<1,1,1,0.8>}
         finish {refraction 1 ior 1 phong 1}
      }
   }
   cylinder {
      <0,29,0>,<0,34,0>,1.8
      texture {
         pigment {
            wood
            color_map {
               [0.8 color rgb<0.98,0.71,0.42>]
               [1.0 color rgb<0.40,0.21,0.01>]
            }
            turbulence 0.2
         }
      }
   }
}
/*------------------------------------------DISPONI BOTTIGLIE--------*/
object {
   bottiglia
   translate <30,100,50>
}
/*--------LIMONCELLO----*/
object {
   bottiglia
   translate <70,100,60>
}
cylinder {
   <70,100,60>,<70,110,60>,5
   texture {
      pigment {color rgbf <0.91,0.99,0.38,0.7>}
   }
}
/*--------VINO----*/
object {
   bottiglia
   translate <88,100,80>
}
cylinder {
   <88,100,80>,<88,106,80>,5
   texture {
      pigment {color rgbf <0.71,0.17,0.22,0.7>}
   }
}
