/*                    Units are expressed in centimeters          */

#include "colors.inc"
#include "golds.inc"
#include "woods.inc"
/*-------------------------------------------------CAMERA--------------*/
camera {
   location <0,2,-20>
   look_at <0,0,0>
}
/*-------------------------------------------------BACKGROUNT---------*/
background {color Cyan}
/*-------------------------------------------------LIGHT--------------*/
light_source {<30,10,-50> color White}           
/*-------------------------------------------------PIANO--------------*/
plane {
   y,0
   texture {
      pigment {color rgb<0.7,1.0,0.7>}
      finish {ambient 0.3 diffuse 0.8 crand 0.3}
   }
}
/*-------------------------------------------------STRADA-------------*/
box {
   <0,0,0>,<10,1000,0.1>
   texture {
      pigment {image_map {gif "strada.gif"}}
      finish {ambient 0.3 diffuse 0.8 crand 0.1}
      scale <10,10,1>
   }
   rotate <90,0,0>
   translate <-5,0.5,-20>
}
/*-------------------------------------------------DICHIARA VETRO-----*/
#declare vetro=
texture {
   pigment {color rgbf<1,1,1,0.80>}
   finish {ambient 0.3 diffuse 0.8 phong 1}
}
/*-------------------------------------------------DICHIARA PONTE VETR*/
#declare ponte=
merge {
   cylinder {                             /* |     */
      <-2,0,0>,<-2,5,0>,0.5
      texture {vetro}
   }
   sphere {                               /* /     */
      <-2,5,0>,0.5
      texture {vetro}
   }
   cylinder {                             /* ----  */
      <-2,5,0>,<12,5,0>,0.5
      texture {vetro}
   }
   sphere {                               /*    \  */
      <12,5,0>,0.5
      texture {vetro}
   }
   cylinder {                             /*     | */
      <12,0,0>,<12,5,0>,0.5
      texture {vetro}
   }
}
/*-------------------------------------------------METTI PONTI--------*/
#declare kk=-35
#while (kk<50)
   object {
      ponte
      translate <-5,0,kk>
   }
   #declare kk=kk+4
#end
/*-------------------------------------------------ARGENTO------------*/
#declare argento=      
texture {
   pigment {color rgb<0.7,0.7,0.7>}
   finish {
      phong 1 
      ambient 0.3 
      diffuse 0.8 
      reflection 0.1 
      metallic 
      brilliance 4
   }
}
