// Blobby Snowman
// ==============

#declare snowman = union {
	blob {
  	 threshold 0.250000
   	 component 1.250000, 0.710845, <-0.077670, -0.014409, 0.000000>
   	 component 1.250000, 0.444345, <-0.078896, 0.552061, -0.005761>
   	 component 1.250000, 0.311151, <-0.065721, 0.960668, 0.000000>
   	 component 1.000000, 0.106223, <0.434928, 0.677279, 0.000000>
   	 component 1.000000, 0.162711, <0.309766, 0.637737, 0.000000>
   	 component 1.000000, 0.167949, <-0.493908, 0.670689, 0.000000>
   	 component 1.000000, 0.104202, <-0.625657, 0.723412, 0.000000>
	 component -1.000000, 0.525069, <-0.069015, -0.452980, 0.000000>
	 texture { pigment { color rgb <1,1,1>} finish { ambient 0.5 diffuse 0.5}}
	}
	sphere {<-0.13, 1.03, -0.3> 0.03 pigment {color Black}} //Eyes
	sphere {<0.01, 1.02, -0.3> 0.03 pigment {color Black}}
	cone {<-0.065, 0.96, -0.3> 0.045, <-0.065, 0.96, -0.6>, 0 pigment {color Orange}}
	sphere {<-0.18, 0.93, -0.3> 0.022 pigment {color Black}}
	sphere {<0.05, 0.92, -0.3> 0.022 pigment {color Black}}
	sphere {<-0.12, 0.88, -0.3> 0.024 pigment {color Black}}
	sphere {<0.01, 0.89, -0.3> 0.023 pigment {color Black}}
	sphere {<-0.02, 0.875, -0.23> 0.022 pigment {color Black}}
}

// Lego Style Tree
// ===============

#declare Edge = 0.125
#declare tree =
union {
	difference {
		union {
	  	sphere { <0, 0, 6.34>, 0.24 }
	  	cylinder { <0, 0, 6.09> <0, 0, 6.34>, 0.24 }
	  	cone { <0, 0, 1.6>, 1.804, <0, 0, 5.85>, 0.424 }
		}
		box { <-0.2, -0.106, 1>, <-2, 0.106, 6.5> }
		box { <-0.2, -0.742, 1>, <-2, -0.531, 6.5> }
		box { <-0.2, -1.380, 1>, <-2, -1.167, 6.5> }
		box { <-0.2, 0.742, 1>, <-2, 0.531, 6.5> }
		box { <-0.2, 1.380, 1>, <-2, 1.167, 6.5> }
		box { <0.2, -0.106, 1>, <2, 0.106, 6.5> }
		box { <0.2, -0.742, 1>, <2, -0.531, 6.5> }
		box { <0.2, -1.380, 1>, <2, -1.167, 6.5> }
		box { <0.2, 0.742, 1>, <2, 0.531, 6.5> }
		box { <0.2, 1.380, 1>, <2, 1.167, 6.5> }
		cylinder { <0, 0, 1.85>, <0, 0, 2.1>, 1.75 }
		cylinder { <0, 0, 2.35>, <0, 0, 2.6>, 1.75 }
		cylinder { <0, 0, 2.85>, <0, 0, 3.1>, 1.75 }
		cylinder { <0, 0, 3.35>, <0, 0, 3.6>, 1.75 }
		cylinder { <0, 0, 3.85>, <0, 0, 4.1>, 1.75 }
		cylinder { <0, 0, 4.35>, <0, 0, 4.6>, 1.75 }
		cylinder { <0, 0, 4.85>, <0, 0, 5.1>, 1.75 }
		cylinder { <0, 0, 5.35>, <0, 0, 5.6>, 1.75 }
		box { <-0.2, -0.74, 4.5>, <-2, -0.8, 5.2> }
		box { <-0.2, 0.74, 4.5>, <-2, 0.8, 5.2> }
		box { <0.2, -0.74, 4.5>, <2, -0.8, 5.2> }
		box { <0.2, 0.74, 4.5>, <2, 0.8, 5.2> }
		box { <-0.2, -1.37, 2.45>, <-2, -1.5, 2.9> }
		box { <-0.2, 1.37, 2.45>, <-2, 1.5, 2.9> }
		box { <0.2, -1.37, 2.45>, <2, -1.5, 2.9> }
		box { <0.2, 1.37, 2.45>, <2, 1.5, 2.9> }
  }
  difference {
		cone { <0, 0, 0>, 0.375, <0, 0, 6.08>, 0.16 }
		cylinder { <0, 0, -Edge>, <0, 0, 0.16>, 0.24 }
		cylinder { <0, 0, -Edge>, <0, 0, 1>, 0.16 }
  }
	difference {
		union {
	   torus { 0.775, 0.125 rotate 90*x translate 0.2*z }
	   cylinder { <0, 0, 0.2>, <0, 0, 0.325>, 0.775 }
	   cylinder { <0, 0, 0>, <0, 0, 0.2>, 0.9 }
		}
		cylinder { <0, 0, -0.125>, <0, 0, 0.2>, 0.775 }
  }
}

// Table
// =====

#declare leg = union {
	difference {
		torus{5, 0.45}
		box{<4, 1, 0> <-6, -1, -6>}
	}
	difference {
		torus{5, 0.45}
		box{<4, 1, 0> <-6, -1, -6>}
		rotate <0, 180, 0>
		translate <-15, 0, -35>
	}
	cylinder {<4.3,0,-2.5 > <-19.3, 0, -32.5>, 0.45}
	sphere {<-5, 0, 0>, 0.45}
	rotate x*-90
	texture{pigment {color Black} finish {phong 1 phong_size 300 reflection 0.13}}
	translate x*7.5
}

#declare table = union {
	object {leg rotate y*15 translate y*-6.45}
	object {leg rotate y*135 translate y*-6.45}
	object {leg rotate y*255 translate y*-6.45}
	cylinder {<0, -0.5, 0>, <0, -1, 0>, 20 texture {TableGlass}}
	torus{20, 0.6 translate y*-0.75 texture{pigment {color Black} finish {phong 1 phong_size 300 reflection 0.13}}}
}

// Bricks definition
// =================

#declare height=5
#declare one_brick =	// First make one brick...
  blob{ threshold 0.8
   #while (height>=0)
    #declare length=22
    #while (length >= 0)
     sphere{<length,height,0> 1,1 }
     #declare length=length-0.5
    #end
    #declare height=height-0.5
   #end
}

#declare counter=0
#declare bricks = union{	//...then make one row...
  #while (counter<=5)
   object{one_brick texture {t_brick} translate <-33+24*counter,0,0>}
   #declare counter=counter+1
  #end
}

#declare counter = 0
#declare wall = union {	//...and then add several rows to make a wall.
	#while (counter <= 20)
		#if (mod(counter,2) = 0)
			object{bricks translate <0, -40 + 7*counter, 0>}
		#else
			object{bricks translate <-11, -40 + 7*counter, 0>}
		#end
		#declare counter = counter + 1
	#end
}

// Snow Globe Definitions
// ======================

#declare snow = union {#include "snow2.inc" rotate x*90}

#declare ground = intersection {
	sphere {0, 9.75}
	height_field {
		gif "snowhill.gif" smooth scale <26, 2.5, 26> translate <-13, -5.5, -13>
	}
	texture {	pigment { color rgb <1,1,1>} finish { ambient 0.5 diffuse 0.5}}
}

#declare counter = 1
#declare rot_angle = 45
#declare stand = union {
	difference {
		cylinder {<0, 0, 0>, <0, 5.375, 0>, 11}
		sphere {y*9, 10.25}
		torus {12, 1.5 scale <1, 1.5, 1> translate y*2.5}
	}
	torus {10.625, 0.375 translate y*5.375}
	#while (counter <= 4)
	union {
		intersection {box {<0, 0, -0.75>, <1, 1, 0.75>} cylinder {<0, 0, -0.8>, <0, 0, 0.8>, 1 scale <1, 0.5, 1>}}
		box {<0, 0, -0.75> <-0.5, 0.5, 0.75>}
		scale <1, 1.5, 2> translate <11, -0.5, 0> rotate y*rot_angle
	}
	#declare counter = counter + 1
	#declare rot_angle = rot_angle + 90
	#end
	texture {DMFDarkOak scale 2 rotate <90, 0, 45> rotate y*65}
}

#declare globe = union {
	difference { sphere {0, 10.25} sphere {0, 9.75} texture {DomeGlass} rotate y*90 translate y*9}
	object {snow rotate y*100 translate y*9}
	object {ground translate y*9}
	object {stand}
	object {snowman rotate y*-25 scale 4 translate <-3.5, 5.5, 0>}
	object {tree texture {Lego_Green} scale 1.5 rotate <-90, 80, 0> translate <3, 4.5, 0.5>}
}
