#include "colors.inc"
#include "textures.inc"
#include "gt.inc"

global_settings { assumed_gamma 1.5 }

#declare SKY =
texture {
	pigment { bozo
	color_map
	{
    [0.1 color rgbf<0.518 0.518 0.714 0.0>]
    [0.2 color rgbf<0.536 0.536 0.727 0.0>]
    [0.3 color rgbf<0.555 0.555 0.741 0.0>]
    [0.4 color rgbf<0.573 0.573 0.755 0.0>]
    [0.5 color rgbf<0.591 0.591 0.768 0.0>]
    [0.6 color rgbf<0.609 0.609 0.782 0.0>]
    [0.7 color rgbf<0.627 0.627 0.795 0.0>]
    [0.8 color rgbf<0.645 0.645 0.809 0.0>]
    [0.9 color rgbf<0.664 0.664 0.823 0.0>]
    [1.0 color rgbf<0.682 0.682 0.836 0.0>]
	}
    turbulence .34262
    scale 55.626246 
	}
    finish { ambient .5 }
}

#declare BALL = texture {
    pigment { color rgbf<1.05 1.05 1.07 .885> }
    finish  { phong 1.1 phong_size 218 metallic reflection 0.108
                ambient .7 }

}

    plane { y, 0.0
        texture { SKY scale 100}
        translate <0, -1000, 0>
    }

    light_source {  <-150, 150, -150>
        color rgb<1.754, 0, 0>
        spotlight
        point_at <0, 0, 0>
        radius 188
        falloff 200
        tightness 15
        shadowless
    }

    light_source {  <150, 150, 150>
        color rgb<0, 1.53, 0>
        spotlight
        point_at <0, 0, 0>
        radius 188
        falloff 200
        tightness 15
        shadowless
    }

    light_source {  <150, 150, -150>
        color rgb<0, 0, 1.54>
        spotlight
        point_at <0, 0, 0>
        radius 188
        falloff 188
        tightness 15
        shadowless
    }

    light_source {  <150, -150, 150>
        color rgb<.9, .9, .9>
        spotlight
        point_at <0, 0, 0>
        radius 18
        falloff 20
        tightness 15
    }

/*---------------------------------------------------------------------------
Dream -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/
