//**************************************************************************
// Title                : Glass Primitives
// Author               : Gautam N. Lad
// E-Mail Address       : gautam@interlog.com
// Website              : http://www.interlog.com/~gautam
// Date Rendered        : February 16-18, 1997
// Total Rendering Time : 3 hours  29 minutes  14.0 seconds (12554 seconds)
// Renderer             : POV-Ray v3.01.msdos.wat-cwa
//**************************************************************************

global_settings { assumed_gamma 1.5 }

camera {
    location <15, 15, -15>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <0, 0, 0>
}


#declare FINISH =
    finish {
        brilliance .6
        reflection 0.20
        phong 1  phong_size 300
        specular 0.1824 
        refraction 1  ior 1.378
        metallic
    }

#declare RED = texture {
    pigment { color rgbf<1 .75 .75 .9>  }
    finish { FINISH }
}

#declare GREEN = texture {
    pigment { color rgbf<.75 1 .75 .9>  }
    finish { FINISH }
}

#declare BLUE = texture {
    pigment { color rgbf<.75 .75 1 .9>  }
    finish { FINISH }
}

#declare CYAN = texture {
    pigment { color rgbf<.75 1 1 .9>  }
    finish { FINISH }
}

#declare MAGENTA = texture {
    pigment { color rgbf<1 .75 1 .9>  }
    finish { FINISH }
}

#declare FLOOR = texture {
    pigment { checker color rgbf<.8 .8 .8 0>,
    color rgbf<.81 .81 .81 0> scale 2.5}
    finish { FINISH ambient .65 reflection 0.37 }
}




//****************** ACTION **********************


    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 11, 0.0>, 0
        texture { CYAN }
        rotate <260, .0, .0>
        rotate <.0, 240, .0>
        translate <3, 0.5, -6.5>
        // no_shadow
    }
    cylinder { <0.0, 0.0, 0.0>, <0.0, 11, 0.0>, 2.5
        texture { BLUE }
        rotate <.0, .0, -90>
        rotate <.0, 45, .0>
        translate <-7.5, 0.5, -1>
        // no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3 
        translate <0, 6, 0>
        texture { RED }
        // no_shadow
    }
    box { <0.0, 0.0, 0.0>, <5, 5, 5> 
        translate <-2.5, -2, -2.5>
        texture { GREEN }
        // no_shadow
    }
    torus { 5, 1 
        rotate <15, .0, .0>
        rotate <.0, .0, 315>
        translate <6, 2.5, 3.5>
        texture { MAGENTA }
        // no_shadow
    }
    plane { y, 0.0 
        scale <8, 8, 8>
        translate <0, -2, 0>
        texture { FLOOR }
        // no_shadow
    }
    light_source {  <-50, 50, -50>
        color rgb<.91, .91, .91>   
        spotlight
        point_at <0, 0, 0>
        radius 100
        falloff 105
        tightness 10
    }

/*---------------------------------------------------------------------------
Glass Primitives -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/
