global_settings {
  adc_bailout 0.004
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

fog {
  fog_type 1    // Constant
  turbulence .2
  turb_depth .1
  distance 300.0
  color rgbt <0.736,0.8,0.861,0.8>
}

camera {  //  Camera Camera01
  location  <700.000, -600.000, 0.770>
  direction <0.0,     0.0,  2.7062>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <100.000, -400.000, 2.000>
}

// *******  L I G H T S *******
light_source {   // Light001
  <850.674, -279.774, 134.752>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light2
  <173.426, -118.966, 192.084>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "ijs.inc"



// ********  REFERENCED OBJECTS  *******

#declare TraSwp4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, 0.0>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.0>,
  <-0.5, -1.0>
  rotate -x*90
  scale 0.6
  rotate -90.0*y
  translate  0.6*x
}
#declare Schroefenbou12 = union {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 3.3>
    rotate -90.0*y
  }
  object { TraSwp4 }
  scale <0.5, 0.5, 0.75>
  translate  6.7*y
}
object { TraSwp4 }
#declare Schroefenbou15 = object {
  object { // Schroefenbou15->Schroefenbou12
    Schroefenbou12
    rotate -0.00003*x
    translate  <0.0, -6.7, -6.699996>
  }
}
#declare Schroefenbou21 = object {
  object { // Schroefenbou21->Schroefenbou12
    Schroefenbou12
    rotate -0.00009*x
    translate  <0.0, -6.7, 6.700011>
  }
}
#declare CSG6 = union {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 7.5, 1.0>
    rotate 90.0*y
    translate  <52.4, 5.0, 80.0>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 5.0>
    translate  <52.9, 0.0, 80.0>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 7.5, 1.0>
    rotate 90.0*y
    translate  <52.4, -5.0, 80.0>
  }
}
#declare CSG005 = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 5.5, 2.0>
    rotate 90.0*y
    translate  <51.5, 5.0, 80.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 3.0>
    translate  <52.9, 0.0, 80.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 5.0, 2.0>
    rotate 90.0*y
    translate  <51.5, -5.0, 80.0>
  }
}
#declare CSG006 = difference {
  object { CSG6 }
  object { CSG005 }
  texture {
    IJzer
  }
  translate  -4.0*z
}
#declare TraSwp2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, 0.0>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.0>,
  <-0.5, -1.0>
  rotate -x*90
  scale 0.6
  translate  <-21.2, 0.0, -2.6>
}
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, 0.0>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.0>,
  <-0.5, -1.0>
  rotate -x*90
  scale 0.6
  translate  <-21.2, 0.0, 0.4>
}
#declare Schroefenbout = union {
  object { TraSwp2 }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 3.3>
    translate  <-21.2, 0.0, -2.9>
  }
  object { TraSwp001 }
}
#declare Schroeven1 = union {
  object { Schroefenbout }
  object { // Schroefenbout1->Schroefenbout
    Schroefenbout
    rotate -30.0*z
  }
  object { // Schroefenbout2->Schroefenbout
    Schroefenbout
    rotate -60.0*z
  }
  object { // Schroefenbout3->Schroefenbout
    Schroefenbout
    rotate -90.0*z
  }
  object { // Schroefenbout4->Schroefenbout
    Schroefenbout
    rotate -120.0*z
  }
  object { // Schroefenbout5->Schroefenbout
    Schroefenbout
    rotate -150.0*z
  }
  object { // Schroefenbout6->Schroefenbout
    Schroefenbout
    rotate -180.0*z
  }
  object { // Schroefenbout7->Schroefenbout
    Schroefenbout
    rotate 150.0*z
  }
  object { // Schroefenbout8->Schroefenbout
    Schroefenbout
    rotate 120.0*z
  }
  object { // Schroefenbout9->Schroefenbout
    Schroefenbout
    rotate 90.0*z
  }
  object { // Schroefenbou10->Schroefenbout
    Schroefenbout
    rotate 60.0*z
  }
  object { // Schroefenbou11->Schroefenbout
    Schroefenbout
    rotate 30.0*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <22.0, 22.0, 1.0>
    translate  -2.0*z
  }
  torus { // Torus002
    20.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  -0.8*z
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <22.0, 22.0, 1.0>
    translate  -0.6*z
  }
  texture {
    IJzer
  }
  scale <1.0, 1.1, 1.0>
  translate  50.0*z
}
object { TraSwp2 }
object { TraSwp001 }




// ********  OBJECTS  *******

plane { // Plane001
  z,0
  texture {
    Water1
  }
  hollow
}


object {   // HgtFld001
  height_field {
    gif "ijshfld.GIF"
    water_level 0.05
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    IJS
  }
  scale <384.0, 384.0, 10.0>
  translate  <384.0, -384.0, 9.0>
  hollow
}




#declare Group003 = union {
  object { // Schroefenbou16->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    rotate -0.000027*x
    translate  <0.0, -10.05, -3.868243>
  }
  object { // Schroefenbou17->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    rotate -0.000033*x
    translate  <0.0, -12.50237, -2.233329>
  }
  object { // Schroefenbou18->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    rotate -0.00004*x
    translate  <0.0, -13.4, 0.000005>
  }
  object { // Schroefenbou19->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    rotate -0.000047*x
    translate  <0.0, -12.50237, 2.233339>
  }
  object { // Schroefenbou20->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    rotate -0.000053*x
    translate  <0.0, -10.05, 3.868253>
  }
  object { // Schroefenbou24->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    translate  <0.0, -6.7, 4.466667>
  }
  object { // Schroefenbou25->Schroefenbou12
    Schroefenbou12
    scale <1.0, 1.0, 0.666667>
    translate  <0.0, -6.7, -4.466667>
  }
  texture {
    IJzer
  }
  translate  <54.6, -5.0, 76.0>
}
#declare Group002 = union {
  object { Schroefenbou12 }
  object { // Schroefenbou13->Schroefenbou12
    Schroefenbou12
    rotate -0.00001*x
    translate  <0.0, -0.89763, -3.349999>
  }
  object { // Schroefenbou14->Schroefenbou12
    Schroefenbou12
    rotate -0.00002*x
    translate  <0.0, -3.35, -5.802368>
  }
  object { Schroefenbou15 }
  object { Schroefenbou21 }
  object { // Schroefenbou22->Schroefenbou12
    Schroefenbou12
    rotate -0.0001*x
    translate  <0.0, -3.35, 5.802382>
  }
  object { // Schroefenbou23->Schroefenbou12
    Schroefenbou12
    rotate -0.00011*x
    translate  <0.0, -0.89763, 3.350013>
  }
  object { // Schroefenbou26->Schroefenbou15
    Schroefenbou15
    rotate 0.0*x
    translate  <0.0, -3.333333, 0.0>
  }
  object { // Schroefenbou27->Schroefenbou15
    Schroefenbou15
    rotate 0.0*x
    translate  <0.0, -6.666667, 0.0>
  }
  object { // Schroefenbou28->Schroefenbou21
    Schroefenbou21
    rotate 0.0*x
    translate  -3.333333*y
  }
  object { // Schroefenbou29->Schroefenbou21
    Schroefenbou21
    rotate 0.0*x
    translate  -6.666667*y
  }
  texture {
    IJzer
  }
  scale <1.0, 1.0, 0.666667>
  translate  <54.6, 5.0, 76.0>
}
#declare CSG008 = intersection {
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 10.0>
    rotate -90.0*x
    translate  <19.691369, -5.0, 0.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 10.0>
    rotate -90.0*x
    translate  <-19.691369, -5.0, 0.0>
  }
  scale <10.0, 1.010101, 1.010101>
  translate  -529.999992*x
}
#declare CSG009 = intersection {
  sphere { // Sphere001
    <0,0,0>,1
    scale <200.0, 20.202021, 20.202021>
    translate  <-333.086305, 5.050505, 0.0>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale <200.0, 20.202021, 20.202021>
    translate  <-726.913679, 5.050505, 0.0>
  }
}
#declare CSG10 = intersection {
  sphere { // Sphere3
    <0,0,0>,1
    scale <200.0, 20.202021, 20.202021>
    translate  <-333.086305, 5.050505, 0.0>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <200.0, 20.202021, 20.202021>
    translate  <-726.913679, 5.050505, 0.0>
  }
  translate  -10.0*y
}
#declare Glasinperiscoop = merge {
  object { CSG008 }
  object { CSG009 }
  object { CSG10 }
  texture {
    Glass
  }
  scale <0.1, 0.99, 0.99>
  translate  <106.5, 0.0, 76.0>
}
#declare Plaatje = union {
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 7.5, 1.0>
    rotate 90.0*y
    translate  <52.4, 5.0, 80.0>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 5.0>
    translate  <52.9, 0.0, 80.0>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 7.5, 1.0>
    rotate 90.0*y
    translate  <52.4, -5.0, 80.0>
  }
  texture {
    Binnenindeonderzeeboot
  }
  scale <0.1, 0.99, 0.99>
  translate  <38.0, 0.0, -4.0>
}
#declare CSG007 = difference {
  torus { // Torus003
    3.75, 0.25  rotate -x*90
    scale <1.0, 1.6, 0.5>
    rotate -90.0*y
    translate  <53.5, -5.0, 80.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 5.0>
    translate  <53.5, 0.0, 80.0>
  }
}
#declare CSG8 = difference {
  torus { // Torus4
    3.75, 0.25  rotate -x*90
    scale <1.0, 1.6, 0.5>
    rotate -90.0*y
    translate  <53.5, 5.0, 80.0>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 5.0>
    translate  <53.5, 0.0, 80.0>
  }
}
#declare Group001 = union {
  object { CSG007 }
  object { CSG8 }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.25, 10.0>
    rotate -90.0*x
    translate  <53.5, -5.0, 76.25>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.25, 10.0>
    rotate -90.0*x
    translate  <53.5, -5.0, 83.75>
  }
  texture {
    Rubber
  }
  translate  -4.0*z
}
#declare CSG002 = intersection {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <20.615528, 5.0, 10.0>
    rotate -14.036243*y
    translate  <49.974644, 0.0, 84.701425>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <20.615528, 5.0, 10.0>
    rotate 14.036243*y
    translate  <49.974644, 0.0, 75.298575>
  }
}
#declare CSG003 = union {
  object { CSG002 }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <10.0, 15.0, 40.0>
    rotate -90.0*y
    translate  <72.4, -5.0, 80.0>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <10.0, 15.0, 40.0>
    rotate -90.0*y
    translate  <72.4, 5.0, 80.0>
  }
}
#declare CSG004 = difference {
  object { CSG003 }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <72.4, 0.0, 80.0>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 5.0, 3.0>
    translate  <52.9, 0.0, 80.0>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 5.0, 10.0>
    rotate -90.0*y
    translate  <52.5, -5.0, 80.0>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 5.0, 10.0>
    rotate -90.0*y
    translate  <52.5, 5.0, 80.0>
  }
  texture {
    IJzer
  }
  translate  -4.0*z
}
#declare CSG001 = intersection {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  76.0*z
  }
  torus { // Torus001
    20.0, 20.0  rotate -x*90
    scale <1.0, 0.8, 1.0>
    rotate -90.0*x
    translate  <20.0, 0.0, 60.0>
  }
  texture {
    IJzer
  }
  scale <1.0, 1.1, 1.0>
}
union { // Periscoop
  object { Group003 }
  object { Group002 }
  object { Glasinperiscoop }
  object { Plaatje }
  object { Group001 }
  object { CSG006 }
  object { // Schroeven2->Schroeven1
    Schroeven1
    texture {
      IJzer
    }
    scale <0.8, 1.0, 1.0>
    rotate -90.0*y
    translate  <80.4, 0.0, 76.0>
  }
  object { Schroeven1 }
  object { CSG004 }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    texture {
      IJzer
    }
    scale <16.0, 22.0, 10.0>
    rotate 90.0*y
    translate  <20.0, 0.0, 76.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    texture {
      IJzer
    }
    scale <20.0, 22.0, 260.0>
    translate  -200.0*z
  }
  object { CSG001 }
  object { // CSG7->CSG006
    CSG006
    translate  1.2*x
  }
  scale 0.01
  rotate -60.0*z
  translate  <695.0, -597.8, -0.2>
  hollow
}




